/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.stats;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import net.opentsdb.stats.Histogram;
import net.opentsdb.utils.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StatsCollector {
    private static final Logger LOG = LoggerFactory.getLogger(StatsCollector.class);
    private static Map<String, String> global_tags;
    protected final String prefix;
    protected HashMap<String, String> extratags;
    private final StringBuilder buf = new StringBuilder();

    public StatsCollector(String prefix) {
        this.prefix = prefix;
        if (global_tags != null && !global_tags.isEmpty()) {
            for (Map.Entry<String, String> entry : global_tags.entrySet()) {
                this.addExtraTag(entry.getKey(), entry.getValue());
            }
        }
    }

    public void emit(String datapoint) {
        throw new IllegalStateException("Emitter has not been implemented");
    }

    public final void record(String name, long value) {
        this.record(name, value, (String)null);
    }

    public final void record(String name, Number value) {
        this.record(name, value.longValue(), (String)null);
    }

    public final void record(String name, Number value, String xtratag) {
        this.record(name, value.longValue(), xtratag);
    }

    public final void record(String name, Histogram histo, String xtratag) {
        this.record(name + "_50pct", histo.percentile(50), xtratag);
        this.record(name + "_75pct", histo.percentile(75), xtratag);
        this.record(name + "_90pct", histo.percentile(90), xtratag);
        this.record(name + "_95pct", histo.percentile(95), xtratag);
    }

    public void record(String name, long value, String xtratag) {
        this.buf.setLength(0);
        this.buf.append(this.prefix).append(".").append(name).append(' ').append(System.currentTimeMillis() / 1000L).append(' ').append(value);
        if (xtratag != null) {
            if (xtratag.indexOf(61) != xtratag.lastIndexOf(61)) {
                throw new IllegalArgumentException("invalid xtratag: " + xtratag + " (multiple '=' signs), name=" + name + ", value=" + value);
            }
            if (xtratag.indexOf(61) < 0) {
                throw new IllegalArgumentException("invalid xtratag: " + xtratag + " (missing '=' signs), name=" + name + ", value=" + value);
            }
            this.buf.append(' ').append(xtratag);
        }
        if (this.extratags != null) {
            for (Map.Entry<String, String> entry : this.extratags.entrySet()) {
                this.buf.append(' ').append(entry.getKey()).append('=').append(entry.getValue());
            }
        }
        this.buf.append('\n');
        this.emit(this.buf.toString());
    }

    public final void addExtraTag(String name, String value) {
        if (name.length() <= 0) {
            throw new IllegalArgumentException("empty tag name, value=" + value);
        }
        if (value.length() <= 0) {
            throw new IllegalArgumentException("empty value, tag name=" + name);
        }
        if (name.indexOf(61) != -1) {
            throw new IllegalArgumentException("tag name contains `=': " + name + " (value = " + value + ')');
        }
        if (value.indexOf(61) != -1) {
            throw new IllegalArgumentException("tag value contains `=': " + value + " (name = " + name + ')');
        }
        if (this.extratags == null) {
            this.extratags = new HashMap();
        }
        this.extratags.put(name, value);
    }

    public final void addHostTag() {
        this.addHostTag(false);
    }

    public final void addHostTag(boolean canonical) {
        try {
            if (canonical) {
                this.addExtraTag("fqdn", InetAddress.getLocalHost().getCanonicalHostName());
            } else {
                this.addExtraTag("host", InetAddress.getLocalHost().getHostName());
            }
        }
        catch (UnknownHostException x) {
            LOG.error("WTF?  Can't find hostname for localhost!", (Throwable)x);
            this.addExtraTag("host", "(unknown)");
        }
    }

    public final void clearExtraTag(String name) {
        if (this.extratags == null) {
            throw new IllegalStateException("no extra tags added");
        }
        if (this.extratags.get(name) == null) {
            throw new IllegalArgumentException("tag '" + name + "' not in" + this.extratags);
        }
        this.extratags.remove(name);
    }

    public static final void setGlobalTags(Config config) {
        if (config == null) {
            throw new IllegalArgumentException("Configuration cannot be null.");
        }
        if (config.getBoolean("tsd.core.stats_with_port")) {
            global_tags = new HashMap<String, String>(1);
            global_tags.put("port", config.getString("tsd.network.port"));
        }
    }
}

