/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public final class ArgP {
    private final HashMap<String, String[]> options = new HashMap();
    private HashMap<String, String> parsed;

    public void addOption(String name, String meta, String help) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("empty name");
        }
        if (name.charAt(0) != '-') {
            throw new IllegalArgumentException("name must start with a `-': " + name);
        }
        if (meta != null && meta.isEmpty()) {
            throw new IllegalArgumentException("empty meta");
        }
        if (help.isEmpty()) {
            throw new IllegalArgumentException("empty help");
        }
        String[] prev = this.options.put(name, new String[]{meta, help});
        if (prev != null) {
            this.options.put(name, prev);
            throw new IllegalArgumentException("Option " + name + " already defined in " + this);
        }
    }

    public void addOption(String name, String help) {
        this.addOption(name, null, help);
    }

    public boolean optionExists(String name) {
        return this.options.containsKey(name);
    }

    public String[] parse(String[] args) {
        this.parsed = new HashMap(this.options.size());
        ArrayList<String> unparsed = null;
        for (int i = 0; i < args.length; ++i) {
            String name;
            String arg = args[i];
            String[] opt = this.options.get(arg);
            if (opt != null) {
                if (opt[0] != null) {
                    if (++i < args.length) {
                        this.parsed.put(arg, args[i]);
                        continue;
                    }
                    throw new IllegalArgumentException("Missing argument for " + arg);
                }
                this.parsed.put(arg, null);
                continue;
            }
            int equal = arg.indexOf(61, 1);
            if (equal > 0 && (opt = this.options.get(name = arg.substring(0, equal))) != null) {
                this.parsed.put(name, arg.substring(equal + 1, arg.length()));
                continue;
            }
            if (unparsed == null) {
                unparsed = new ArrayList<String>(args.length - i);
            }
            if (!arg.isEmpty() && arg.charAt(0) == '-') {
                if (arg.length() == 2 && arg.charAt(1) == '-') {
                    ++i;
                    while (i < args.length) {
                        unparsed.add(args[i]);
                        ++i;
                    }
                    break;
                }
                throw new IllegalArgumentException("Unrecognized option " + arg);
            }
            unparsed.add(arg);
        }
        if (unparsed != null) {
            return unparsed.toArray(new String[unparsed.size()]);
        }
        return new String[0];
    }

    public String get(String name) {
        if (!this.options.containsKey(name)) {
            throw new IllegalArgumentException("Unknown option " + name);
        }
        if (this.parsed == null) {
            throw new IllegalStateException("parse() wasn't called");
        }
        return this.parsed.get(name);
    }

    public String get(String name, String defaultv) {
        String value = this.get(name);
        return value == null ? defaultv : value;
    }

    public boolean has(String name) {
        if (!this.options.containsKey(name)) {
            throw new IllegalArgumentException("Unknown option " + name);
        }
        if (this.parsed == null) {
            throw new IllegalStateException("parse() wasn't called");
        }
        return this.parsed.containsKey(name);
    }

    public void addUsageTo(StringBuilder buf) {
        int length;
        String[] opt;
        ArrayList<String> names = new ArrayList<String>(this.options.keySet());
        Collections.sort(names);
        int max_length = 0;
        for (String name : names) {
            opt = this.options.get(name);
            length = name.length() + (opt[0] == null ? 0 : opt[0].length() + 1);
            if (length <= max_length) continue;
            max_length = length;
        }
        for (String name : names) {
            opt = this.options.get(name);
            length = name.length();
            buf.append("  ").append(name);
            if (opt[0] != null) {
                length += opt[0].length() + 1;
                buf.append('=').append(opt[0]);
            }
            for (int i = length; i <= max_length; ++i) {
                buf.append(' ');
            }
            buf.append(opt[1]).append('\n');
        }
    }

    public HashMap<String, String> getParsed() {
        return this.parsed;
    }

    public String usage() {
        StringBuilder buf = new StringBuilder(16 * this.options.size());
        this.addUsageTo(buf);
        return buf.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(16 * this.options.size());
        buf.append("ArgP(");
        for (String name : this.options.keySet()) {
            String[] opt = this.options.get(name);
            buf.append(name).append("=(").append(opt[0]).append(", ").append(opt[1]).append(')').append(", ");
        }
        buf.setLength(buf.length() - 2);
        buf.append(')');
        return buf.toString();
    }
}

