/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tools;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.io.IOException;
import java.util.Map;
import net.opentsdb.tools.ArgP;
import net.opentsdb.utils.Config;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.Slf4JLoggerFactory;
import org.slf4j.LoggerFactory;

final class CliOptions {
    CliOptions() {
    }

    static void addCommon(ArgP argp) {
        argp.addOption("--table", "TABLE", "Name of the HBase table where to store the time series (default: tsdb).");
        argp.addOption("--uidtable", "TABLE", "Name of the HBase table to use for Unique IDs (default: tsdb-uid).");
        argp.addOption("--zkquorum", "SPEC", "Specification of the ZooKeeper quorum to use (default: localhost).");
        argp.addOption("--zkbasedir", "PATH", "Path under which is the znode for the -ROOT- region (default: /hbase).");
        argp.addOption("--config", "PATH", "Path to a configuration file (default: Searches for file see docs).");
    }

    static void addVerbose(ArgP argp) {
        argp.addOption("--verbose", "Print more logging messages and not just errors.");
        argp.addOption("-v", "Short for --verbose.");
    }

    static void addAutoMetricFlag(ArgP argp) {
        argp.addOption("--auto-metric", "Automatically add metrics to tsdb as they are inserted.  Warning: this may cause unexpected metrics to be tracked");
    }

    static String[] parse(ArgP argp, String[] args) {
        try {
            args = argp.parse(args);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Invalid usage.  " + e.getMessage());
            System.exit(2);
        }
        CliOptions.honorVerboseFlag(argp);
        return args;
    }

    static final Config getConfig(ArgP argp) throws IOException {
        String config_file = argp.get("--config", "");
        Config config = !config_file.isEmpty() ? new Config(config_file) : new Config(true);
        CliOptions.overloadConfig(argp, config);
        config.setAutoMetric(config.getBoolean("tsd.core.auto_create_metrics"));
        return config;
    }

    static void overloadConfig(ArgP argp, Config config) {
        for (Map.Entry<String, String> entry : argp.getParsed().entrySet()) {
            if (entry.getKey().toLowerCase().equals("--auto-metric")) {
                config.overrideConfig("tsd.core.auto_create_metrics", "true");
                continue;
            }
            if (entry.getKey().toLowerCase().equals("--disable-ui")) {
                config.overrideConfig("tsd.core.enable_ui", "false");
                continue;
            }
            if (entry.getKey().toLowerCase().equals("--disable-api")) {
                config.overrideConfig("tsd.core.enable_api", "false");
                continue;
            }
            if (entry.getKey().toLowerCase().equals("--table")) {
                config.overrideConfig("tsd.storage.hbase.data_table", entry.getValue());
                continue;
            }
            if (entry.getKey().toLowerCase().equals("--uidtable")) {
                config.overrideConfig("tsd.storage.hbase.uid_table", entry.getValue());
                continue;
            }
            if (entry.getKey().toLowerCase().equals("--zkquorum")) {
                config.overrideConfig("tsd.storage.hbase.zk_quorum", entry.getValue());
                continue;
            }
            if (entry.getKey().toLowerCase().equals("--zkbasedir")) {
                config.overrideConfig("tsd.storage.hbase.zk_basedir", entry.getValue());
                continue;
            }
            if (entry.getKey().toLowerCase().equals("--port")) {
                config.overrideConfig("tsd.network.port", entry.getValue());
                continue;
            }
            if (entry.getKey().toLowerCase().equals("--staticroot")) {
                config.overrideConfig("tsd.http.staticroot", entry.getValue());
                continue;
            }
            if (entry.getKey().toLowerCase().equals("--cachedir")) {
                config.overrideConfig("tsd.http.cachedir", entry.getValue());
                continue;
            }
            if (entry.getKey().toLowerCase().equals("--flush-interval")) {
                config.overrideConfig("tsd.core.flushinterval", entry.getValue());
                continue;
            }
            if (entry.getKey().toLowerCase().equals("--backlog")) {
                config.overrideConfig("tsd.network.backlog", entry.getValue());
                continue;
            }
            if (entry.getKey().toLowerCase().equals("--read-only")) {
                config.overrideConfig("tsd.mode", "ro");
                continue;
            }
            if (entry.getKey().toLowerCase().equals("--bind")) {
                config.overrideConfig("tsd.network.bind", entry.getValue());
                continue;
            }
            if (entry.getKey().toLowerCase().equals("--async-io")) {
                config.overrideConfig("tsd.network.async_io", entry.getValue());
                continue;
            }
            if (!entry.getKey().toLowerCase().equals("--worker-threads")) continue;
            config.overrideConfig("tsd.network.worker_threads", entry.getValue());
        }
    }

    private static void honorVerboseFlag(ArgP argp) {
        if (argp.optionExists("--verbose") && !argp.has("--verbose") && !argp.has("-v")) {
            for (Logger logger : ((Logger)LoggerFactory.getLogger((String)"ROOT")).getLoggerContext().getLoggerList()) {
                logger.setLevel(Level.WARN);
            }
        }
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Slf4JLoggerFactory());
    }
}

