/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.opentsdb.core.Aggregator;
import net.opentsdb.core.Aggregators;
import net.opentsdb.core.DataPoint;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.Query;
import net.opentsdb.core.RateOptions;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.Tags;
import net.opentsdb.graph.Plot;
import net.opentsdb.tools.ArgP;
import net.opentsdb.tools.CliOptions;
import net.opentsdb.utils.Config;
import net.opentsdb.utils.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CliQuery {
    private static final Logger LOG = LoggerFactory.getLogger(CliQuery.class);

    CliQuery() {
    }

    private static void usage(ArgP argp, String errmsg, int retval) {
        System.err.println(errmsg);
        System.err.println("Usage: query [Gnuplot opts] START-DATE [END-DATE] <query> [queries...]\nA query has the form:\n  FUNC [rate] [counter,max,reset] [downsample N FUNC] SERIES [TAGS]\nFor example:\n 2010/03/11-20:57 sum my.awsum.metric host=blah sum some.other.metric host=blah state=foo\nDates must follow this format: YYYY/MM/DD-HH:MM[:SS] or Unix Epoch\n or relative time such as 1y-ago, 2d-ago, etc.\nSupported values for FUNC: " + Aggregators.set() + "\nGnuplot options are of the form: +option=value");
        if (argp != null) {
            System.err.print(argp.usage());
        }
        System.exit(retval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ArgP argp = new ArgP();
        CliOptions.addCommon(argp);
        CliOptions.addVerbose(argp);
        argp.addOption("--graph", "BASEPATH", "Output data points to a set of files for gnuplot.  The path of the output files will start with BASEPATH.");
        args = CliOptions.parse(argp, args);
        if (args == null) {
            CliQuery.usage(argp, "Invalid usage.", 1);
        } else if (args.length < 3) {
            CliQuery.usage(argp, "Not enough arguments.", 2);
        }
        Config config = CliOptions.getConfig(argp);
        TSDB tsdb = new TSDB(config);
        tsdb.checkNecessaryTablesExist().joinUninterruptibly();
        String basepath = argp.get("--graph");
        argp = null;
        Plot plot = null;
        try {
            plot = CliQuery.doQuery(tsdb, args, basepath != null);
        }
        finally {
            try {
                tsdb.shutdown().joinUninterruptibly();
            }
            catch (Exception e) {
                LOG.error("Unexpected exception", (Throwable)e);
                System.exit(1);
            }
        }
        if (plot != null) {
            try {
                int npoints = plot.dumpToFiles(basepath);
                LOG.info("Wrote " + npoints + " for Gnuplot");
            }
            catch (IOException e) {
                LOG.error("Failed to write the Gnuplot file under " + basepath, (Throwable)e);
                System.exit(1);
            }
        }
    }

    private static Plot doQuery(TSDB tsdb, String[] args, boolean want_plot) {
        Plot plot;
        ArrayList<String> plotparams = new ArrayList<String>();
        ArrayList<Query> queries = new ArrayList<Query>();
        ArrayList<String> plotoptions = new ArrayList<String>();
        CliQuery.parseCommandLineQuery(args, tsdb, queries, plotparams, plotoptions);
        if (queries.isEmpty()) {
            CliQuery.usage(null, "Not enough arguments, need at least one query.", 2);
        }
        Plot plot2 = plot = want_plot ? new Plot(queries.get(0).getStartTime(), queries.get(0).getEndTime()) : null;
        if (want_plot) {
            plot.setParams(CliQuery.parsePlotParams(plotparams));
        }
        int nqueries = queries.size();
        for (int i = 0; i < nqueries; ++i) {
            StringBuilder buf = want_plot ? null : new StringBuilder();
            for (DataPoints datapoints : queries.get(i).run()) {
                if (want_plot) {
                    plot.add(datapoints, plotoptions.get(i));
                    continue;
                }
                String metric = datapoints.metricName();
                String tagz = datapoints.getTags().toString();
                for (DataPoint datapoint : datapoints) {
                    buf.append(metric).append(' ').append(datapoint.timestamp()).append(' ');
                    if (datapoint.isInteger()) {
                        buf.append(datapoint.longValue());
                    } else {
                        buf.append(String.format("%f", datapoint.doubleValue()));
                    }
                    buf.append(' ').append(tagz).append('\n');
                    System.out.print(buf);
                    buf.delete(0, buf.length());
                }
            }
        }
        return plot;
    }

    static void parseCommandLineQuery(String[] args, TSDB tsdb, ArrayList<Query> queries, ArrayList<String> plotparams, ArrayList<String> plotoptions) {
        int i;
        long start_ts = DateTime.parseDateTimeString(args[0], null);
        if (start_ts >= 0L) {
            start_ts /= 1000L;
        }
        long end_ts = -1L;
        if (args.length > 3) {
            try {
                if (args[1].charAt(0) != '+' && (args[1].indexOf(58) >= 0 || args[1].indexOf(47) >= 0 || args[1].indexOf(45) >= 0 || Long.parseLong(args[1]) > 0L)) {
                    end_ts = DateTime.parseDateTimeString(args[1], null);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (end_ts >= 0L) {
            end_ts /= 1000L;
        }
        int n = i = end_ts < 0L ? 1 : 2;
        while (i < args.length && args[i].charAt(0) == '+') {
            if (plotparams != null) {
                plotparams.add(args[i]);
            }
            ++i;
        }
        while (i < args.length) {
            boolean downsample;
            Aggregator agg = Aggregators.get(args[i++]);
            boolean rate = args[i].equals("rate");
            RateOptions rate_options = new RateOptions(false, Long.MAX_VALUE, 0L);
            if (rate) {
                long counterMax = Long.MAX_VALUE;
                long resetValue = 0L;
                if (args[++i].startsWith("counter")) {
                    String[] parts = Tags.splitString(args[i], ',');
                    if (parts.length >= 2 && parts[1].length() > 0) {
                        counterMax = Long.parseLong(parts[1]);
                    }
                    if (parts.length >= 3 && parts[2].length() > 0) {
                        resetValue = Long.parseLong(parts[2]);
                    }
                    rate_options = new RateOptions(true, counterMax, resetValue);
                    ++i;
                }
            }
            if (downsample = args[i].equals("downsample")) {
                ++i;
            }
            long interval = downsample ? Long.parseLong(args[i++]) : 0L;
            Aggregator sampler = downsample ? Aggregators.get(args[i++]) : null;
            String metric = args[i++];
            HashMap<String, String> tags = new HashMap<String, String>();
            while (i < args.length && args[i].indexOf(32, 1) < 0 && args[i].indexOf(61, 1) > 0) {
                Tags.parse(tags, args[i++]);
            }
            if (i < args.length && args[i].indexOf(32, 1) > 0) {
                plotoptions.add(args[i++]);
            }
            Query query = tsdb.newQuery();
            query.setStartTime(start_ts);
            if (end_ts > 0L) {
                query.setEndTime(end_ts);
            }
            query.setTimeSeries(metric, tags, agg, rate, rate_options);
            if (downsample) {
                query.downsample(interval, sampler);
            }
            queries.add(query);
        }
    }

    private static HashMap<String, String> parsePlotParams(ArrayList<String> params) {
        HashMap<String, String> result = new HashMap<String, String>(params.size());
        for (String param : params) {
            Tags.parse(result, param.substring(1));
        }
        return result;
    }
}

