/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tools;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.opentsdb.core.Const;
import net.opentsdb.core.Internal;
import net.opentsdb.core.RowKey;
import net.opentsdb.core.TSDB;
import net.opentsdb.uid.UniqueId;
import org.hbase.async.Bytes;
import org.hbase.async.GetRequest;
import org.hbase.async.HBaseClient;
import org.hbase.async.HBaseException;
import org.hbase.async.KeyValue;
import org.hbase.async.Scanner;

final class CliUtils {
    static final Method toBytes;
    static final Method fromBytes;
    static final Charset CHARSET;
    static final byte[] ID_FAMILY;
    static final byte[] NAME_FAMILY;
    static final byte[] MAXID_ROW;
    static final byte[] METRICS_META;
    static final byte[] TAGK_META;
    static final byte[] TAGV_META;
    static final byte[] METRICS;
    static final byte[] TAGK;
    static final byte[] TAGV;

    CliUtils() {
    }

    static long getMaxMetricID(TSDB tsdb) {
        GetRequest get = new GetRequest(tsdb.uidTable(), new byte[]{0});
        get.family("id".getBytes(CHARSET));
        get.qualifier("metrics".getBytes(CHARSET));
        try {
            ArrayList row = (ArrayList)tsdb.getClient().get(get).joinUninterruptibly();
            if (row == null || row.isEmpty()) {
                return 0L;
            }
            byte[] id_bytes = ((KeyValue)row.get(0)).value();
            if (id_bytes.length != 8) {
                throw new IllegalStateException("Invalid metric max UID, wrong # of bytes");
            }
            return Bytes.getLong((byte[])id_bytes);
        }
        catch (Exception e) {
            throw new RuntimeException("Shouldn't be here", e);
        }
    }

    static final Scanner getDataTableScanner(TSDB tsdb, long start_id, long end_id) throws HBaseException {
        short metric_width = TSDB.metrics_width();
        byte[] start_row = Arrays.copyOfRange(Bytes.fromLong((long)start_id), 8 - metric_width, 8);
        byte[] end_row = Arrays.copyOfRange(Bytes.fromLong((long)end_id), 8 - metric_width, 8);
        Scanner scanner = tsdb.getClient().newScanner(tsdb.dataTable());
        scanner.setStartKey(start_row);
        scanner.setStopKey(end_row);
        scanner.setFamily(TSDB.FAMILY());
        return scanner;
    }

    static final List<Scanner> getDataTableScanners(TSDB tsdb, int num_scanners) {
        if (num_scanners < 1) {
            throw new IllegalArgumentException("Number of scanners must be 1 or more: " + num_scanners);
        }
        short metric_width = TSDB.metrics_width();
        ArrayList<Scanner> scanners = new ArrayList<Scanner>();
        if (Const.SALT_WIDTH() > 0) {
            byte[] start_key = HBaseClient.EMPTY_ARRAY;
            byte[] stop_key = HBaseClient.EMPTY_ARRAY;
            for (int i = 1; i < Const.SALT_BUCKETS() + 1; ++i) {
                if (i > 1) {
                    start_key = Arrays.copyOf(stop_key, stop_key.length);
                }
                stop_key = i >= Const.SALT_BUCKETS() ? HBaseClient.EMPTY_ARRAY : RowKey.getSaltBytes(i);
                Scanner scanner = tsdb.getClient().newScanner(tsdb.dataTable());
                scanner.setStartKey(Arrays.copyOf(start_key, start_key.length));
                scanner.setStopKey(Arrays.copyOf(stop_key, stop_key.length));
                scanner.setFamily(TSDB.FAMILY());
                scanners.add(scanner);
            }
        } else {
            long max_id = CliUtils.getMaxMetricID(tsdb);
            if (max_id < 1L) {
                max_id = Internal.getMaxUnsignedValueOnBytes(metric_width);
            }
            long quotient = max_id % (long)num_scanners == 0L ? max_id / (long)num_scanners : max_id / (long)num_scanners + 1L;
            byte[] start_key = HBaseClient.EMPTY_ARRAY;
            byte[] stop_key = new byte[metric_width];
            for (int i = 0; i < num_scanners; ++i) {
                if (i > 0) {
                    start_key = Arrays.copyOf(stop_key, stop_key.length);
                }
                byte[] stop_id = (long)(i + 1) * quotient > max_id ? null : Bytes.fromLong((long)((long)(i + 1) * quotient));
                if ((long)(i + 1) * quotient >= max_id) {
                    stop_key = HBaseClient.EMPTY_ARRAY;
                } else {
                    System.arraycopy(stop_id, stop_id.length - metric_width, stop_key, 0, metric_width);
                }
                Scanner scanner = tsdb.getClient().newScanner(tsdb.dataTable());
                scanner.setStartKey(Arrays.copyOf(start_key, start_key.length));
                if (stop_key != null) {
                    scanner.setStopKey(Arrays.copyOf(stop_key, stop_key.length));
                }
                scanner.setFamily(TSDB.FAMILY());
                scanners.add(scanner);
            }
        }
        return scanners;
    }

    static byte[] toBytes(String s) {
        try {
            return (byte[])toBytes.invoke(null, s);
        }
        catch (Exception e) {
            throw new RuntimeException("toBytes=" + toBytes, e);
        }
    }

    static String fromBytes(byte[] b) {
        try {
            return (String)fromBytes.invoke(null, new Object[]{b});
        }
        catch (Exception e) {
            throw new RuntimeException("fromBytes=" + fromBytes, e);
        }
    }

    static {
        Class<UniqueId> uidclass = UniqueId.class;
        try {
            Field f = uidclass.getDeclaredField("CHARSET");
            f.setAccessible(true);
            CHARSET = (Charset)f.get(null);
            f = uidclass.getDeclaredField("ID_FAMILY");
            f.setAccessible(true);
            ID_FAMILY = (byte[])f.get(null);
            f = uidclass.getDeclaredField("NAME_FAMILY");
            f.setAccessible(true);
            NAME_FAMILY = (byte[])f.get(null);
            f = uidclass.getDeclaredField("MAXID_ROW");
            f.setAccessible(true);
            MAXID_ROW = (byte[])f.get(null);
            toBytes = uidclass.getDeclaredMethod("toBytes", String.class);
            toBytes.setAccessible(true);
            fromBytes = uidclass.getDeclaredMethod("fromBytes", byte[].class);
            fromBytes.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("static initializer failed", e);
        }
        METRICS_META = "metric_meta".getBytes(CHARSET);
        TAGK_META = "tagk_meta".getBytes(CHARSET);
        TAGV_META = "tagv_meta".getBytes(CHARSET);
        METRICS = "metrics".getBytes(CHARSET);
        TAGK = "tagk".getBytes(CHARSET);
        TAGV = "tagv".getBytes(CHARSET);
    }
}

