/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tools;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.opentsdb.core.AppendDataPoints;
import net.opentsdb.core.IllegalDataException;
import net.opentsdb.core.Internal;
import net.opentsdb.core.Query;
import net.opentsdb.core.TSDB;
import net.opentsdb.meta.Annotation;
import net.opentsdb.tools.ArgP;
import net.opentsdb.tools.CliOptions;
import net.opentsdb.tools.CliQuery;
import net.opentsdb.utils.Config;
import org.hbase.async.DeleteRequest;
import org.hbase.async.HBaseClient;
import org.hbase.async.KeyValue;
import org.hbase.async.Scanner;

final class DumpSeries {
    DumpSeries() {
    }

    private static void usage(ArgP argp, String errmsg, int retval) {
        System.err.println(errmsg);
        System.err.println("Usage: scan [--delete|--import] START-DATE [END-DATE] query [queries...]\nTo see the format in which queries should be written, see the help of the 'query' command.\nThe --import flag changes the format in which the output is printed to use a format suiteable for the 'import' command instead of the default output format, which better represents how the data is stored in HBase.\nThe --delete flag will delete every row matched by the query.  This flag implies --import.");
        System.err.print(argp.usage());
        System.exit(retval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ArgP argp = new ArgP();
        CliOptions.addCommon(argp);
        argp.addOption("--import", "Prints the rows in a format suitable for the 'import' command.");
        argp.addOption("--delete", "Deletes rows as they are scanned.");
        args = CliOptions.parse(argp, args);
        if (args == null) {
            DumpSeries.usage(argp, "Invalid usage.", 1);
        } else if (args.length < 3) {
            DumpSeries.usage(argp, "Not enough arguments.", 2);
        }
        Config config = CliOptions.getConfig(argp);
        TSDB tsdb = new TSDB(config);
        tsdb.checkNecessaryTablesExist().joinUninterruptibly();
        byte[] table = config.getString("tsd.storage.hbase.data_table").getBytes();
        boolean delete = argp.has("--delete");
        boolean importformat = delete || argp.has("--import");
        argp = null;
        try {
            DumpSeries.doDump(tsdb, tsdb.getClient(), table, delete, importformat, args);
        }
        finally {
            tsdb.shutdown().joinUninterruptibly();
        }
    }

    private static void doDump(TSDB tsdb, HBaseClient client, byte[] table, boolean delete, boolean importformat, String[] args) throws Exception {
        ArrayList<Query> queries = new ArrayList<Query>();
        CliQuery.parseCommandLineQuery(args, tsdb, queries, null, null);
        StringBuilder buf = new StringBuilder();
        for (Query query : queries) {
            List<Scanner> scanners = Internal.getScanners(query);
            for (Scanner scanner : scanners) {
                ArrayList rows;
                while ((rows = (ArrayList)scanner.nextRows().joinUninterruptibly()) != null) {
                    for (ArrayList row : rows) {
                        buf.setLength(0);
                        byte[] key = ((KeyValue)row.get(0)).key();
                        long base_time = Internal.baseTime(tsdb, key);
                        String metric = Internal.metricName(tsdb, key);
                        if (!importformat) {
                            buf.append(Arrays.toString(key)).append(' ').append(metric).append(' ').append(base_time).append(" (").append(DumpSeries.date(base_time)).append(") ");
                            try {
                                buf.append(Internal.getTags(tsdb, key));
                            }
                            catch (RuntimeException e) {
                                buf.append(e.getClass().getName() + ": " + e.getMessage());
                            }
                            buf.append('\n');
                            System.out.print(buf);
                        }
                        buf.setLength(0);
                        if (!importformat) {
                            buf.append("  ");
                        }
                        for (KeyValue kv : row) {
                            buf.setLength(importformat ? 0 : 2);
                            DumpSeries.formatKeyValue(buf, tsdb, importformat, kv, base_time, metric);
                            if (buf.length() <= 0) continue;
                            buf.append('\n');
                            System.out.print(buf);
                        }
                        if (!delete) continue;
                        DeleteRequest del = new DeleteRequest(table, key);
                        client.delete(del);
                    }
                }
            }
        }
    }

    static void formatKeyValue(StringBuilder buf, TSDB tsdb, KeyValue kv, long base_time) {
        DumpSeries.formatKeyValue(buf, tsdb, true, kv, base_time, Internal.metricName(tsdb, kv.key()));
    }

    private static void formatKeyValue(StringBuilder buf, TSDB tsdb, boolean importformat, KeyValue kv, long base_time, String metric) {
        String tags;
        if (importformat) {
            StringBuilder tagsbuf = new StringBuilder();
            for (Map.Entry<String, String> tag : Internal.getTags(tsdb, kv.key()).entrySet()) {
                tagsbuf.append(' ').append(tag.getKey()).append('=').append(tag.getValue());
            }
            tags = tagsbuf.toString();
        } else {
            tags = null;
        }
        byte[] qualifier = kv.qualifier();
        byte[] value = kv.value();
        int q_len = qualifier.length;
        if (!AppendDataPoints.isAppendDataPoints(qualifier) && q_len % 2 != 0) {
            if (!importformat) {
                if (kv.qualifier()[0] == Annotation.PREFIX()) {
                    DumpSeries.appendAnnotation(buf, kv, base_time);
                } else {
                    buf.append(Arrays.toString(value)).append("\t[Not a data point]");
                }
            }
        } else if (q_len == 2 || q_len == 4 && Internal.inMilliseconds(qualifier)) {
            Internal.Cell cell = Internal.parseSingleValue(kv);
            if (cell == null) {
                throw new IllegalDataException("Unable to parse row: " + kv);
            }
            if (!importformat) {
                DumpSeries.appendRawCell(buf, cell, base_time);
            } else {
                buf.append(metric).append(' ');
                DumpSeries.appendImportCell(buf, cell, base_time, tags);
            }
        } else {
            Collection<Internal.Cell> cells;
            if (q_len == 3) {
                AppendDataPoints adps = new AppendDataPoints();
                cells = adps.parseKeyValue(tsdb, kv);
            } else {
                cells = Internal.extractDataPoints(kv);
            }
            if (!importformat) {
                buf.append(Arrays.toString(kv.qualifier())).append('\t').append(Arrays.toString(kv.value())).append(" = ").append(cells.size()).append(" values:");
            }
            int i = 0;
            for (Internal.Cell cell : cells) {
                if (!importformat) {
                    buf.append("\n    ");
                    DumpSeries.appendRawCell(buf, cell, base_time);
                } else {
                    buf.append(metric).append(' ');
                    DumpSeries.appendImportCell(buf, cell, base_time, tags);
                    if (i < cells.size() - 1) {
                        buf.append("\n");
                    }
                }
                ++i;
            }
        }
    }

    static void appendRawCell(StringBuilder buf, Internal.Cell cell, long base_time) {
        long timestamp = cell.absoluteTimestamp(base_time);
        buf.append(Arrays.toString(cell.qualifier())).append("\t").append(Arrays.toString(cell.value())).append("\t");
        if ((timestamp & 0xFFFFFFFF00000000L) != 0L) {
            buf.append(Internal.getOffsetFromQualifier(cell.qualifier()));
        } else {
            buf.append(Internal.getOffsetFromQualifier(cell.qualifier()) / 1000);
        }
        buf.append("\t").append(cell.isInteger() ? "l" : "f").append("\t").append(timestamp).append("\t").append("(").append(DumpSeries.date(timestamp)).append(")");
    }

    static void appendImportCell(StringBuilder buf, Internal.Cell cell, long base_time, String tags) {
        buf.append(cell.absoluteTimestamp(base_time)).append(" ").append(cell.parseValue()).append(tags);
    }

    static void appendAnnotation(StringBuilder buf, KeyValue kv, long base_time) {
        long timestamp = Internal.getTimestampFromQualifier(kv.qualifier(), base_time);
        buf.append(Arrays.toString(kv.qualifier())).append("\t").append(Arrays.toString(kv.value())).append("\t").append(Internal.getOffsetFromQualifier(kv.qualifier(), 1) / 1000).append("\t").append(new String(kv.value(), Charset.forName("ISO-8859-1"))).append("\t").append(timestamp).append("\t").append("(").append(DumpSeries.date(timestamp)).append(")");
    }

    static String date(long timestamp) {
        if ((timestamp & 0xFFFFFFFF00000000L) != 0L) {
            return new Date(timestamp).toString();
        }
        return new Date(timestamp * 1000L).toString();
    }
}

