/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tools;

import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import net.opentsdb.core.AppendDataPoints;
import net.opentsdb.core.Const;
import net.opentsdb.core.IllegalDataException;
import net.opentsdb.core.Internal;
import net.opentsdb.core.Query;
import net.opentsdb.core.RowKey;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.Tags;
import net.opentsdb.meta.Annotation;
import net.opentsdb.tools.ArgP;
import net.opentsdb.tools.CliOptions;
import net.opentsdb.tools.CliQuery;
import net.opentsdb.tools.CliUtils;
import net.opentsdb.tools.FsckOptions;
import net.opentsdb.uid.NoSuchUniqueId;
import net.opentsdb.uid.UniqueId;
import net.opentsdb.utils.Config;
import org.hbase.async.Bytes;
import org.hbase.async.DeleteRequest;
import org.hbase.async.KeyValue;
import org.hbase.async.PutRequest;
import org.hbase.async.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Fsck {
    private static final Logger LOG = LoggerFactory.getLogger(Fsck.class);
    private final TSDB tsdb;
    private final FsckOptions options;
    final AtomicLong kvs_processed = new AtomicLong();
    final AtomicLong rows_processed = new AtomicLong();
    final AtomicLong valid_datapoints = new AtomicLong();
    final AtomicLong annotations = new AtomicLong();
    final AtomicLong append_dps = new AtomicLong();
    final AtomicLong append_dps_fixed = new AtomicLong();
    final AtomicLong bad_key = new AtomicLong();
    final AtomicLong bad_key_fixed = new AtomicLong();
    final AtomicLong duplicates = new AtomicLong();
    final AtomicLong duplicates_fixed = new AtomicLong();
    final AtomicLong duplicates_fixed_comp = new AtomicLong();
    final AtomicLong orphans = new AtomicLong();
    final AtomicLong orphans_fixed = new AtomicLong();
    final AtomicLong future = new AtomicLong();
    final AtomicLong unknown = new AtomicLong();
    final AtomicLong unknown_fixed = new AtomicLong();
    final AtomicLong bad_values = new AtomicLong();
    final AtomicLong bad_values_deleted = new AtomicLong();
    final AtomicLong value_encoding = new AtomicLong();
    final AtomicLong value_encoding_fixed = new AtomicLong();
    final AtomicLong fixable_compacted_columns = new AtomicLong();
    final AtomicLong bad_compacted_columns = new AtomicLong();
    final AtomicLong bad_compacted_columns_deleted = new AtomicLong();
    final AtomicLong vle = new AtomicLong();
    final AtomicLong vle_bytes = new AtomicLong();
    final AtomicLong vle_fixed = new AtomicLong();
    private int key_prefix_length = Const.SALT_WIDTH() + TSDB.metrics_width() + 4;
    private int key_tags_length = TSDB.tagk_width() + TSDB.tagv_width();
    private static long report_rows = 10000L;

    public Fsck(TSDB tsdb, FsckOptions options) {
        this.tsdb = tsdb;
        this.options = options;
    }

    public void runFullTable() throws Exception {
        LOG.info("Starting full table scan");
        long start_time = System.currentTimeMillis() / 1000L;
        int workers = this.options.threads() > 0 ? this.options.threads() : Runtime.getRuntime().availableProcessors() * 2;
        List<Scanner> scanners = CliUtils.getDataTableScanners(this.tsdb, workers);
        LOG.info("Spooling up [" + scanners.size() + "] worker threads");
        ArrayList<FsckWorker> threads = new ArrayList<FsckWorker>(scanners.size());
        int i = 0;
        for (Scanner scanner : scanners) {
            FsckWorker fsckWorker = new FsckWorker(scanner, i++);
            fsckWorker.setName("Fsck #" + i);
            fsckWorker.start();
            threads.add(fsckWorker);
        }
        ProgressReporter reporter = new ProgressReporter();
        reporter.start();
        for (Thread thread : threads) {
            thread.join();
            LOG.info("Thread [" + thread + "] Finished");
        }
        reporter.interrupt();
        this.logResults();
        long l = System.currentTimeMillis() / 1000L - start_time;
        LOG.info("Completed fsck in [" + l + "] seconds");
    }

    public void runQueries(List<Query> queries) throws Exception {
        long start_time = System.currentTimeMillis() / 1000L;
        ProgressReporter reporter = new ProgressReporter();
        reporter.start();
        for (Query query : queries) {
            List<Scanner> scanners = Internal.getScanners(query);
            ArrayList<FsckWorker> threads = new ArrayList<FsckWorker>(scanners.size());
            int i = 0;
            for (Scanner scanner : scanners) {
                FsckWorker worker = new FsckWorker(scanner, i++);
                worker.setName("Fsck #" + i);
                worker.start();
                threads.add(worker);
            }
            for (Thread thread : threads) {
                thread.join();
                LOG.info("Thread [" + thread + "] Finished");
            }
        }
        reporter.interrupt();
        this.logResults();
        long duration = System.currentTimeMillis() / 1000L - start_time;
        LOG.info("Completed fsck in [" + duration + "] seconds");
    }

    long totalErrors() {
        return this.bad_key.get() + this.duplicates.get() + this.orphans.get() + this.unknown.get() + this.bad_values.get() + this.bad_compacted_columns.get() + this.fixable_compacted_columns.get() + this.value_encoding.get();
    }

    long totalFixed() {
        return this.bad_key_fixed.get() + this.duplicates_fixed.get() + this.orphans_fixed.get() + this.unknown_fixed.get() + this.value_encoding_fixed.get() + this.bad_values_deleted.get();
    }

    long correctable() {
        return this.bad_key.get() + this.duplicates.get() + this.orphans.get() + this.unknown.get() + this.bad_values.get() + this.bad_compacted_columns.get() + this.fixable_compacted_columns.get() + this.value_encoding.get();
    }

    private static void usage(ArgP argp, String errmsg, int retval) {
        System.err.println(errmsg);
        System.err.println("Usage: fsck [flags] [START-DATE [END-DATE] query [queries...]] \nScans the OpenTSDB data table for errors. Use the --full-scan flag\nto scan the entire data table or specify a command line query to scan a subset.\nTo see the format in which queries should be written, see the help of the 'query' command.\nThe --fix or --fix-all flags will attempt to fix errors, but be careful when using them.\n");
        System.err.print(argp.usage());
        System.exit(retval);
    }

    private void logResults() {
        LOG.info("Key Values Processed: " + this.kvs_processed.get());
        LOG.info("Rows Processed: " + this.rows_processed.get());
        LOG.info("Valid Datapoints: " + this.valid_datapoints.get());
        LOG.info("Annotations: " + this.annotations.get());
        LOG.info("Invalid Row Keys Found: " + this.bad_key.get());
        LOG.info("Invalid Rows Deleted: " + this.bad_key_fixed.get());
        LOG.info("Duplicate Datapoints: " + this.duplicates.get());
        LOG.info("Duplicate Datapoints Resolved: " + this.duplicates_fixed.get());
        LOG.info("Orphaned UID Rows: " + this.orphans.get());
        LOG.info("Orphaned UID Rows Deleted: " + this.orphans_fixed.get());
        LOG.info("Possible Future Objects: " + this.future.get());
        LOG.info("Unknown Objects: " + this.unknown.get());
        LOG.info("Unknown Objects Deleted: " + this.unknown_fixed.get());
        LOG.info("Unparseable Datapoint Values: " + this.bad_values.get());
        LOG.info("Unparseable Datapoint Values Deleted: " + this.bad_values_deleted.get());
        LOG.info("Improperly Encoded Floating Point Values: " + this.value_encoding.get());
        LOG.info("Improperly Encoded Floating Point Values Fixed: " + this.value_encoding_fixed.get());
        LOG.info("Unparseable Compacted Columns: " + this.bad_compacted_columns.get());
        LOG.info("Unparseable Compacted Columns Deleted: " + this.bad_compacted_columns_deleted.get());
        LOG.info("Datapoints Qualified for VLE : " + this.vle.get());
        LOG.info("Datapoints Compressed with VLE: " + this.vle_fixed.get());
        LOG.info("Bytes Saved with VLE: " + this.vle_bytes.get());
        LOG.info("Total Errors: " + this.totalErrors());
        LOG.info("Total Correctable Errors: " + this.correctable());
        LOG.info("Total Errors Fixed: " + this.totalFixed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ArgP argp = new ArgP();
        argp.addOption("--help", "Print help information.");
        CliOptions.addCommon(argp);
        FsckOptions.addDataOptions(argp);
        args = CliOptions.parse(argp, args);
        if (argp.has("--help")) {
            Fsck.usage(argp, "", 0);
        }
        Config config = CliOptions.getConfig(argp);
        FsckOptions options = new FsckOptions(argp, config);
        TSDB tsdb = new TSDB(config);
        ArrayList<Query> queries = new ArrayList<Query>();
        if (args != null && args.length > 0) {
            CliQuery.parseCommandLineQuery(args, tsdb, queries, null, null);
        }
        if (queries.isEmpty() && !argp.has("--full-scan")) {
            Fsck.usage(argp, "Must supply a query or use the '--full-scan' flag", 1);
        }
        tsdb.checkNecessaryTablesExist().joinUninterruptibly();
        argp = null;
        Fsck fsck = new Fsck(tsdb, options);
        try {
            if (!queries.isEmpty()) {
                fsck.runQueries(queries);
            } else {
                fsck.runFullTable();
            }
        }
        finally {
            tsdb.shutdown().joinUninterruptibly();
        }
        System.exit(fsck.totalErrors() == 0L ? 0 : 1);
    }

    final class ProgressReporter
    extends Thread {
        ProgressReporter() {
            super("Progress");
        }

        @Override
        public void run() {
            long last_progress = 0L;
            while (true) {
                try {
                    while (true) {
                        long processed_rows = Fsck.this.rows_processed.get();
                        if ((processed_rows -= processed_rows % report_rows) - last_progress >= report_rows) {
                            last_progress = processed_rows;
                            LOG.info("Processed " + processed_rows + " rows, " + Fsck.this.valid_datapoints.get() + " valid datapoints");
                        }
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    final class FsckWorker
    extends Thread {
        final int thread_id;
        final Query query;
        final Scanner scanner;
        final Set<String> tsuids = new HashSet<String>();
        byte[] compact_qualifier = null;
        int qualifier_index = 0;
        byte[] compact_value = null;
        int value_index = 0;
        boolean compact_row = false;
        int qualifier_bytes = 0;
        int value_bytes = 0;

        FsckWorker(Scanner scanner, int thread_id) {
            this.scanner = scanner;
            this.thread_id = thread_id;
            this.query = null;
        }

        @Override
        public void run() {
            TreeMap<Long, ArrayList<DP>> datapoints = new TreeMap<Long, ArrayList<DP>>();
            byte[] last_key = null;
            try {
                ArrayList rows;
                while ((rows = (ArrayList)this.scanner.nextRows().joinUninterruptibly()) != null) {
                    for (ArrayList row : rows) {
                        if (last_key != null && Bytes.memcmp((byte[])((KeyValue)row.get(0)).key(), (byte[])last_key) != 0) {
                            Fsck.this.rows_processed.getAndIncrement();
                            if (!datapoints.isEmpty()) {
                                this.compact_qualifier = new byte[this.qualifier_bytes];
                                this.compact_value = new byte[this.value_bytes + 1];
                                this.fsckDataPoints(datapoints);
                                this.resetCompaction();
                                datapoints.clear();
                            }
                        }
                        last_key = ((KeyValue)row.get(0)).key();
                        this.fsckRow(row, datapoints);
                    }
                }
                if (!datapoints.isEmpty()) {
                    Fsck.this.rows_processed.getAndIncrement();
                    this.compact_qualifier = new byte[this.qualifier_bytes];
                    this.compact_value = new byte[this.value_bytes + 1];
                    this.fsckDataPoints(datapoints);
                }
            }
            catch (Exception e) {
                LOG.error("Shouldn't be here", (Throwable)e);
            }
        }

        private void fsckRow(ArrayList<KeyValue> row, TreeMap<Long, ArrayList<DP>> datapoints) throws Exception {
            if (!this.fsckKey(row.get(0).key())) {
                return;
            }
            long base_time = Bytes.getUnsignedInt((byte[])row.get(0).key(), (int)(Const.SALT_WIDTH() + TSDB.metrics_width()));
            for (KeyValue kv : row) {
                Fsck.this.kvs_processed.getAndIncrement();
                byte[] value = kv.value();
                byte[] qual = kv.qualifier();
                if (qual.length < 2) {
                    Fsck.this.unknown.getAndIncrement();
                    LOG.error("Invalid qualifier, must be on 2 bytes or more.\n\t" + kv);
                    if (!Fsck.this.options.fix() || !Fsck.this.options.deleteUnknownColumns()) continue;
                    DeleteRequest delete = new DeleteRequest(Fsck.this.tsdb.dataTable(), kv);
                    Fsck.this.tsdb.getClient().delete(delete);
                    Fsck.this.unknown_fixed.getAndIncrement();
                    continue;
                }
                if (qual.length % 2 != 0) {
                    if (qual.length != 3 && qual.length != 5) {
                        Fsck.this.unknown.getAndIncrement();
                        LOG.error("Unknown qualifier, must be 2, 3, 5 or an even number of bytes.\n\t" + kv);
                        if (!Fsck.this.options.fix() || !Fsck.this.options.deleteUnknownColumns()) continue;
                        DeleteRequest delete = new DeleteRequest(Fsck.this.tsdb.dataTable(), kv);
                        Fsck.this.tsdb.getClient().delete(delete);
                        Fsck.this.unknown_fixed.getAndIncrement();
                        continue;
                    }
                    if (qual[0] == Annotation.PREFIX()) {
                        Fsck.this.annotations.getAndIncrement();
                        continue;
                    }
                    if (qual[0] == 5) {
                        Fsck.this.append_dps.getAndIncrement();
                        try {
                            AppendDataPoints adps = new AppendDataPoints();
                            adps.parseKeyValue(Fsck.this.tsdb, kv);
                            if (adps.repairedDeferred() == null) continue;
                            Fsck.this.append_dps_fixed.incrementAndGet();
                        }
                        catch (RuntimeException e) {
                            LOG.error("Unexpected exception processing append data point: " + kv, (Throwable)e);
                        }
                        continue;
                    }
                    LOG.warn("Found an object possibly from a future version of OpenTSDB\n\t" + kv);
                    Fsck.this.future.getAndIncrement();
                    continue;
                }
                if (qual.length == 4 && !Internal.inMilliseconds(qual[0]) || qual.length > 4) {
                    if (value[value.length - 1] > 1) {
                        Fsck.this.bad_compacted_columns.getAndIncrement();
                        LOG.error("The last byte of a compacted should be 0 or 1. Either this value is corrupted or it was written by a future version of OpenTSDB.\n\t" + kv);
                        continue;
                    }
                    try {
                        ArrayList<Internal.Cell> cells = Internal.extractDataPoints(kv);
                        byte[] recompacted_qualifier = new byte[kv.qualifier().length];
                        int qualifier_index = 0;
                        for (Internal.Cell cell : cells) {
                            long ts = cell.timestamp(base_time);
                            ArrayList<DP> dps = datapoints.get(ts);
                            if (dps == null) {
                                dps = new ArrayList(1);
                                datapoints.put(ts, dps);
                            }
                            dps.add(new DP(kv, cell));
                            this.qualifier_bytes += cell.qualifier().length;
                            this.value_bytes += cell.value().length;
                            System.arraycopy(cell.qualifier(), 0, recompacted_qualifier, qualifier_index, cell.qualifier().length);
                            qualifier_index += cell.qualifier().length;
                        }
                        if (Bytes.memcmp((byte[])recompacted_qualifier, (byte[])kv.qualifier()) != 0) {
                            LOG.error("Compacted column was out of order or requires a fixup: " + kv);
                            Fsck.this.fixable_compacted_columns.getAndIncrement();
                        }
                        this.compact_row = true;
                    }
                    catch (IllegalDataException e) {
                        Fsck.this.bad_compacted_columns.getAndIncrement();
                        LOG.error(e.getMessage());
                        if (!Fsck.this.options.fix() || !Fsck.this.options.deleteBadCompacts()) continue;
                        DeleteRequest delete = new DeleteRequest(Fsck.this.tsdb.dataTable(), kv);
                        Fsck.this.tsdb.getClient().delete(delete);
                        Fsck.this.bad_compacted_columns_deleted.getAndIncrement();
                    }
                    continue;
                }
                long timestamp = Internal.getTimestampFromQualifier(qual, base_time);
                ArrayList<DP> dps = datapoints.get(timestamp);
                if (dps == null) {
                    dps = new ArrayList(1);
                    datapoints.put(timestamp, dps);
                }
                dps.add(new DP(kv));
                this.qualifier_bytes += kv.qualifier().length;
                this.value_bytes += kv.value().length;
            }
        }

        private boolean fsckKey(byte[] key) throws Exception {
            if (key.length < Fsck.this.key_prefix_length || (key.length - Fsck.this.key_prefix_length) % Fsck.this.key_tags_length != 0) {
                LOG.error("Invalid row key.\n\tKey: " + UniqueId.uidToString(key));
                Fsck.this.bad_key.getAndIncrement();
                if (Fsck.this.options.fix() && Fsck.this.options.deleteBadRows()) {
                    DeleteRequest delete = new DeleteRequest(Fsck.this.tsdb.dataTable(), key);
                    Fsck.this.tsdb.getClient().delete(delete);
                    Fsck.this.bad_key_fixed.getAndIncrement();
                }
                return false;
            }
            byte[] tsuid = UniqueId.getTSUIDFromKey(key, TSDB.metrics_width(), (short)4);
            if (!this.tsuids.contains(tsuid)) {
                try {
                    RowKey.metricNameAsync(Fsck.this.tsdb, key).joinUninterruptibly();
                }
                catch (NoSuchUniqueId nsui) {
                    LOG.error("Unable to resolve the metric from the row key.\n\tKey: " + UniqueId.uidToString(key) + "\n\t" + nsui.getMessage());
                    Fsck.this.orphans.getAndIncrement();
                    if (Fsck.this.options.fix() && Fsck.this.options.deleteOrphans()) {
                        DeleteRequest delete = new DeleteRequest(Fsck.this.tsdb.dataTable(), key);
                        Fsck.this.tsdb.getClient().delete(delete);
                        Fsck.this.orphans_fixed.getAndIncrement();
                    }
                    return false;
                }
                try {
                    Tags.resolveIds(Fsck.this.tsdb, (ArrayList)UniqueId.getTagPairsFromTSUID(tsuid));
                }
                catch (NoSuchUniqueId nsui) {
                    LOG.error("Unable to resolve the a tagk or tagv from the row key.\n\tKey: " + UniqueId.uidToString(key) + "\n\t" + nsui.getMessage());
                    Fsck.this.orphans.getAndIncrement();
                    if (Fsck.this.options.fix() && Fsck.this.options.deleteOrphans()) {
                        DeleteRequest delete = new DeleteRequest(Fsck.this.tsdb.dataTable(), key);
                        Fsck.this.tsdb.getClient().delete(delete);
                        Fsck.this.orphans_fixed.getAndIncrement();
                    }
                    return false;
                }
            }
            return true;
        }

        private void fsckDataPoints(Map<Long, ArrayList<DP>> datapoints) throws Exception {
            Bytes.ByteMap unique_columns = new Bytes.ByteMap();
            byte[] key = null;
            boolean has_seconds = false;
            boolean has_milliseconds = false;
            boolean has_duplicates = false;
            boolean has_uncorrected_value_error = false;
            for (Map.Entry<Long, ArrayList<DP>> time_map : datapoints.entrySet()) {
                DP dp_to_keep;
                int delete_range_stop;
                int delete_range_start;
                if (key == null) {
                    key = time_map.getValue().get((int)0).kv.key();
                }
                if (time_map.getValue().size() < 2) {
                    DP dp = time_map.getValue().get(0);
                    Fsck.this.valid_datapoints.getAndIncrement();
                    has_uncorrected_value_error |= Internal.isFloat(dp.qualifier()) ? this.fsckFloat(dp) : this.fsckInteger(dp);
                    if (Internal.inMilliseconds(dp.qualifier())) {
                        has_milliseconds = true;
                    } else {
                        has_seconds = true;
                    }
                    unique_columns.put((Object)dp.kv.qualifier(), (Object)dp.kv.value());
                    continue;
                }
                Collections.sort((List)time_map.getValue());
                has_duplicates = true;
                StringBuilder buf = new StringBuilder();
                buf.append("More than one column had a value for the same timestamp: ").append("(").append(time_map.getKey()).append(" - ").append(new Date(time_map.getKey())).append(")\n    row key: (").append(UniqueId.uidToString(key)).append(")\n");
                int num_dupes = time_map.getValue().size();
                if (Fsck.this.options.lastWriteWins()) {
                    delete_range_start = 0;
                    delete_range_stop = num_dupes - 1;
                    dp_to_keep = time_map.getValue().get(num_dupes - 1);
                } else {
                    delete_range_start = 1;
                    delete_range_stop = num_dupes;
                    dp_to_keep = time_map.getValue().get(0);
                    this.appendDatapointInfo(buf, dp_to_keep, " <--- keep oldest").append("\n");
                }
                unique_columns.put((Object)dp_to_keep.kv.qualifier(), (Object)dp_to_keep.kv.value());
                Fsck.this.valid_datapoints.getAndIncrement();
                has_uncorrected_value_error |= Internal.isFloat(dp_to_keep.qualifier()) ? this.fsckFloat(dp_to_keep) : this.fsckInteger(dp_to_keep);
                if (Internal.inMilliseconds(dp_to_keep.qualifier())) {
                    has_milliseconds = true;
                } else {
                    has_seconds = true;
                }
                for (int dp_index = delete_range_start; dp_index < delete_range_stop; ++dp_index) {
                    Fsck.this.duplicates.getAndIncrement();
                    DP dp = time_map.getValue().get(dp_index);
                    try {
                        byte flags = (byte)Internal.getFlagsFromQualifier(dp.kv.qualifier());
                        buf.append("    ").append("write time: (").append(dp.kv.timestamp()).append(" - ").append(new Date(dp.kv.timestamp())).append(") ").append(" compacted: (").append(dp.compacted).append(")  qualifier: ").append(Arrays.toString(dp.kv.qualifier())).append(" value: ").append(Internal.isFloat(dp.kv.qualifier()) ? Internal.extractFloatingPointValue(dp.value(), 0, flags) : (double)Internal.extractIntegerValue(dp.value(), 0, flags)).append("\n");
                        unique_columns.put((Object)dp.kv.qualifier(), (Object)dp.kv.value());
                        if (!Fsck.this.options.fix() || !Fsck.this.options.resolveDupes()) continue;
                        if (this.compact_row) {
                            Fsck.this.duplicates_fixed_comp.getAndIncrement();
                            continue;
                        }
                        if (dp.compacted) continue;
                        LOG.debug("Removing duplicate data point: " + dp.kv);
                        Fsck.this.tsdb.getClient().delete(new DeleteRequest(Fsck.this.tsdb.dataTable(), dp.kv.key(), dp.kv.family(), dp.qualifier()));
                        Fsck.this.duplicates_fixed.getAndIncrement();
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error("Unexpected exception processing DP: " + dp);
                    }
                }
                if (Fsck.this.options.lastWriteWins()) {
                    this.appendDatapointInfo(buf, dp_to_keep, " <--- keep latest").append("\n");
                }
                LOG.info(buf.toString());
            }
            if (has_duplicates && !Fsck.this.options.resolveDupes() || has_uncorrected_value_error && !Fsck.this.options.deleteBadValues()) {
                LOG.warn("One or more errors found in row that were not marked for repair");
                return;
            }
            if ((Fsck.this.options.compact() || this.compact_row) && Fsck.this.options.fix() && this.qualifier_index > 0) {
                if (this.qualifier_index == 2 || this.qualifier_index == 4 && Internal.inMilliseconds(this.compact_qualifier)) {
                    --this.value_index;
                } else if (has_seconds && has_milliseconds) {
                    this.compact_value[this.value_index] = 1;
                }
                ++this.value_index;
                byte[] new_qualifier = Arrays.copyOfRange(this.compact_qualifier, 0, this.qualifier_index);
                byte[] new_value = Arrays.copyOfRange(this.compact_value, 0, this.value_index);
                PutRequest put = new PutRequest(Fsck.this.tsdb.dataTable(), key, TSDB.FAMILY(), new_qualifier, new_value);
                if (unique_columns.containsKey((Object)new_qualifier)) {
                    if (Bytes.memcmp((byte[])((byte[])unique_columns.get((Object)new_qualifier)), (byte[])new_value) != 0) {
                        StringBuilder buf = new StringBuilder();
                        buf.append("Overwriting compacted column with new value: ").append("\n    row key: (").append(UniqueId.uidToString(key)).append(")\n    qualifier: ").append(Bytes.pretty((byte[])new_qualifier)).append("\n    value: ").append(Bytes.pretty((byte[])new_value));
                        LOG.info(buf.toString());
                        Fsck.this.tsdb.getClient().put(put).joinUninterruptibly();
                    } else if (has_duplicates && LOG.isDebugEnabled()) {
                        StringBuilder buf = new StringBuilder();
                        buf.append("Re-compacted column is the same as the existing column: ").append("\n    row key: (").append(UniqueId.uidToString(key)).append(")\n    qualifier: ").append(Bytes.pretty((byte[])new_qualifier)).append("\n    value: ").append(Bytes.pretty((byte[])new_value));
                        LOG.debug(buf.toString());
                    }
                    unique_columns.remove((Object)new_qualifier);
                } else {
                    Fsck.this.tsdb.getClient().put(put).joinUninterruptibly();
                }
                ArrayList<Deferred> deletes = new ArrayList<Deferred>(unique_columns.size());
                for (byte[] qualifier : unique_columns.keySet()) {
                    DeleteRequest delete = new DeleteRequest(Fsck.this.tsdb.dataTable(), key, TSDB.FAMILY(), qualifier);
                    if (LOG.isDebugEnabled()) {
                        StringBuilder buf = new StringBuilder();
                        buf.append("Deleting column: ").append("\n    row key: (").append(UniqueId.uidToString(key)).append(")\n    qualifier: ").append(Bytes.pretty((byte[])qualifier));
                        LOG.debug(buf.toString());
                    }
                    deletes.add(Fsck.this.tsdb.getClient().delete(delete));
                }
                Deferred.group(deletes).joinUninterruptibly();
                Fsck.this.duplicates_fixed.getAndAdd(Fsck.this.duplicates_fixed_comp.longValue());
                Fsck.this.duplicates_fixed_comp.set(0L);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean fsckFloat(DP dp) throws Exception {
            byte[] qual = dp.qualifier();
            byte[] value = dp.value();
            byte length = Internal.getValueLengthFromQualifier(qual);
            if (length == 4 && value.length == 8) {
                if (value[0] == -1 && value[1] == -1 && value[2] == -1 && value[3] == -1 && qual.length == 2) {
                    Fsck.this.value_encoding.getAndIncrement();
                    LOG.error("Floating point value with 0xFF most significant bytes, probably caused by sign extension bug present in revisions [96908436..607256fc].\n\t" + dp.kv);
                    if (!Fsck.this.options.fix()) return true;
                    float value_as_float = Float.intBitsToFloat(Bytes.getInt((byte[])value, (int)4));
                    value = Bytes.fromInt((int)Float.floatToRawIntBits(value_as_float));
                    if (this.compact_row || Fsck.this.options.compact()) {
                        this.appendDP(qual, value, 4);
                    } else if (!dp.compacted) {
                        PutRequest put = new PutRequest(Fsck.this.tsdb.dataTable(), dp.kv.key(), dp.kv.family(), qual, value);
                        Fsck.this.tsdb.getClient().put(put);
                    } else {
                        LOG.error("SHOULDN'T be here as we didn't compact or fix a single value");
                    }
                    Fsck.this.value_encoding_fixed.getAndIncrement();
                    return false;
                }
                if (value[0] != 0 || value[1] != 0 || value[2] != 0 || value[3] != 0) {
                    LOG.error("Floating point value was marked as 4 bytes long but was actually 8 bytes long and the first four bytes were not zeroed\n\t" + dp);
                    Fsck.this.bad_values.getAndIncrement();
                    if (Fsck.this.options.fix() && Fsck.this.options.deleteBadValues() && !dp.compacted) {
                        DeleteRequest delete = new DeleteRequest(Fsck.this.tsdb.dataTable(), dp.kv);
                        Fsck.this.tsdb.getClient().delete(delete);
                        Fsck.this.bad_values_deleted.getAndIncrement();
                        return false;
                    }
                    if (!dp.compacted) return true;
                    LOG.error("The value was in a compacted column. This should not be possible\n\t" + dp);
                    Fsck.this.bad_compacted_columns.getAndIncrement();
                    return true;
                }
                LOG.warn("Floating point value was marked as 4 bytes long but was actually 8 bytes long\n\t" + dp.kv);
                Fsck.this.value_encoding.getAndIncrement();
                if (!Fsck.this.options.fix()) return true;
                if (dp.compacted) return true;
                float value_as_float = Float.intBitsToFloat(Bytes.getInt((byte[])value, (int)4));
                value = Bytes.fromInt((int)Float.floatToRawIntBits(value_as_float));
                if (this.compact_row || Fsck.this.options.compact()) {
                    this.appendDP(qual, value, 4);
                } else if (!dp.compacted) {
                    PutRequest put = new PutRequest(Fsck.this.tsdb.dataTable(), dp.kv.key(), dp.kv.family(), qual, value);
                    Fsck.this.tsdb.getClient().put(put);
                } else {
                    LOG.error("SHOULDN'T be here as we didn't compact or fix a single value");
                }
                Fsck.this.value_encoding_fixed.getAndIncrement();
                return false;
            }
            if (length == 8 && value.length == 4) {
                Fsck.this.bad_values.getAndIncrement();
                LOG.error("This floating point value was marked as 8 bytes long but was only " + value.length + " bytes.\n\t" + dp.kv);
                if (Fsck.this.options.fix() && Fsck.this.options.deleteBadValues() && !dp.compacted) {
                    DeleteRequest delete = new DeleteRequest(Fsck.this.tsdb.dataTable(), dp.kv);
                    Fsck.this.tsdb.getClient().delete(delete);
                    Fsck.this.bad_values_deleted.getAndIncrement();
                    return false;
                }
                if (!dp.compacted) return true;
                LOG.error("The previous value was in a compacted column. This should not be possible.");
                Fsck.this.bad_compacted_columns.getAndIncrement();
                return false;
            }
            if (value.length != 4 && value.length != 8) {
                Fsck.this.bad_values.getAndIncrement();
                LOG.error("This floating point value must be encoded either on 4 or 8 bytes, but it's on " + value.length + " bytes.\n\t" + dp.kv);
                if (Fsck.this.options.fix() && Fsck.this.options.deleteBadValues() && !dp.compacted) {
                    DeleteRequest delete = new DeleteRequest(Fsck.this.tsdb.dataTable(), dp.kv);
                    Fsck.this.tsdb.getClient().delete(delete);
                    Fsck.this.bad_values_deleted.getAndIncrement();
                    return false;
                }
                if (!dp.compacted) return true;
                LOG.error("The previous value was in a compacted column. This should not be possible.");
                Fsck.this.bad_compacted_columns.getAndIncrement();
                return true;
            }
            if (!this.compact_row) {
                if (!Fsck.this.options.compact()) return false;
            }
            this.appendDP(qual, value, value.length);
            return false;
        }

        private boolean fsckInteger(DP dp) throws Exception {
            byte length;
            byte[] qual = dp.qualifier();
            byte[] value = dp.value();
            if (value.length != (length = Internal.getValueLengthFromQualifier(qual))) {
                Fsck.this.bad_values.getAndIncrement();
                LOG.error("The integer value is " + value.length + " bytes long but should be " + length + " bytes.\n\t" + dp.kv);
                if (Fsck.this.options.fix() && Fsck.this.options.deleteBadValues()) {
                    DeleteRequest delete = new DeleteRequest(Fsck.this.tsdb.dataTable(), dp.kv);
                    Fsck.this.tsdb.getClient().delete(delete);
                    Fsck.this.bad_values_deleted.getAndIncrement();
                } else if (dp.compacted) {
                    LOG.error("The previous value was in a compacted column. This should not be possible.");
                    Fsck.this.bad_compacted_columns.getAndIncrement();
                } else {
                    return true;
                }
                return false;
            }
            if (length == 8) {
                long decoded = Bytes.getLong((byte[])value);
                if (-128L <= decoded && decoded <= 127L) {
                    Fsck.this.vle.getAndIncrement();
                    Fsck.this.vle_bytes.addAndGet(7L);
                    value = new byte[]{(byte)decoded};
                } else if (-32768L <= decoded && decoded <= 32767L) {
                    Fsck.this.vle.getAndIncrement();
                    Fsck.this.vle_bytes.addAndGet(6L);
                    value = Bytes.fromShort((short)((short)decoded));
                } else if (Integer.MIN_VALUE <= decoded && decoded <= Integer.MAX_VALUE) {
                    Fsck.this.vle.getAndIncrement();
                    Fsck.this.vle_bytes.addAndGet(4L);
                    value = Bytes.fromInt((int)((int)decoded));
                }
                if (length != value.length && Fsck.this.options.fix()) {
                    byte[] new_qualifier = Arrays.copyOf(qual, qual.length);
                    int n = new_qualifier.length - 1;
                    new_qualifier[n] = (byte)(new_qualifier[n] & (0xF0 | value.length - 1));
                    if (this.compact_row || Fsck.this.options.compact()) {
                        this.appendDP(new_qualifier, value, value.length);
                    } else {
                        PutRequest put = new PutRequest(Fsck.this.tsdb.dataTable(), dp.kv.key(), dp.kv.family(), new_qualifier, value);
                        Fsck.this.tsdb.getClient().put(put).joinUninterruptibly();
                        DeleteRequest delete = new DeleteRequest(Fsck.this.tsdb.dataTable(), dp.kv.key(), dp.kv.family(), qual);
                        Fsck.this.tsdb.getClient().delete(delete);
                    }
                    Fsck.this.vle_fixed.getAndIncrement();
                }
            } else if (this.compact_row || Fsck.this.options.compact()) {
                this.appendDP(qual, value, value.length);
            }
            return false;
        }

        private void appendDP(byte[] new_qual, byte[] new_value, int value_length) {
            System.arraycopy(new_qual, 0, this.compact_qualifier, this.qualifier_index, new_qual.length);
            this.qualifier_index += new_qual.length;
            System.arraycopy(new_value, 0, this.compact_value, this.value_index, value_length);
            this.value_index += value_length;
        }

        private StringBuilder appendDatapointInfo(StringBuilder buf, DP dp, String msg) {
            buf.append("    ").append("write time: (").append(dp.kv.timestamp()).append(") ").append(" compacted: (").append(dp.compacted).append(")  qualifier: ").append(Arrays.toString(dp.kv.qualifier())).append(msg);
            return buf;
        }

        private void resetCompaction() {
            this.compact_qualifier = null;
            this.qualifier_index = 0;
            this.compact_value = null;
            this.value_index = 0;
            this.qualifier_bytes = 0;
            this.value_bytes = 0;
            this.compact_row = false;
        }

        final class DP
        implements Comparable<DP> {
            KeyValue kv;
            boolean compacted;
            Internal.Cell cell;

            DP(KeyValue kv) {
                this.kv = kv;
                this.compacted = false;
            }

            DP(KeyValue kv, Internal.Cell cell) {
                this.kv = kv;
                this.cell = cell;
                this.compacted = true;
            }

            @Override
            public int compareTo(DP dp) {
                if (this.kv.timestamp() == dp.kv.timestamp()) {
                    return 0;
                }
                return this.kv.timestamp() < dp.kv.timestamp() ? -1 : 1;
            }

            public byte[] qualifier() {
                return this.compacted ? this.cell.qualifier() : this.kv.qualifier();
            }

            public byte[] value() {
                return this.compacted ? this.cell.value() : this.kv.value();
            }

            public String toString() {
                return this.compacted ? this.cell.toString() : this.kv.toString();
            }
        }
    }
}

