/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tools;

import net.opentsdb.tools.ArgP;
import net.opentsdb.utils.Config;

final class FsckOptions {
    private boolean fix;
    private boolean compact;
    private boolean resolve_dupes;
    private boolean last_write_wins;
    private boolean delete_orphans;
    private boolean delete_unknown_columns;
    private boolean delete_bad_values;
    private boolean delete_bad_rows;
    private boolean delete_bad_compacts;
    private int threads;

    public FsckOptions(ArgP argp, Config config) {
        this.fix = argp.has("--fix") || argp.has("--fix-all");
        this.compact = argp.has("--compact") || argp.has("--fix-all");
        this.resolve_dupes = argp.has("--resolve-duplicates") || argp.has("--fix-all");
        this.last_write_wins = argp.has("--last-write-wins") || config.getBoolean("tsd.storage.fix_duplicates");
        this.delete_orphans = argp.has("--delete-orphans") || argp.has("--fix-all");
        this.delete_unknown_columns = argp.has("--delete-unknown-columns") || argp.has("--fix-all");
        this.delete_bad_values = argp.has("--delete-bad-values") || argp.has("--fix-all");
        this.delete_bad_rows = argp.has("--delete-bad-rows") || argp.has("--fix-all");
        boolean bl = this.delete_bad_compacts = argp.has("--delete-bad-compacts") || argp.has("--fix-all");
        if (argp.has("--threads")) {
            this.threads = Integer.parseInt(argp.get("--threads"));
            if (this.threads < 1) {
                throw new IllegalArgumentException("Must have at least one thread");
            }
            if (this.threads > Runtime.getRuntime().availableProcessors() * 4) {
                throw new IllegalArgumentException("Not allowed to run more than 4 threads per core");
            }
        } else {
            this.threads = 0;
        }
    }

    public static void addDataOptions(ArgP argp) {
        argp.addOption("--full-scan", "Scan the entire data table.");
        argp.addOption("--fix", "Fix errors as they're found. Use in combination with other flags.");
        argp.addOption("--fix-all", "Set all flags and fix errors as they're found.");
        argp.addOption("--compact", "Compacts rows after parsing.");
        argp.addOption("--resolve-duplicates", "Keeps the oldest (default) or newest duplicates. See --last-write-wins");
        argp.addOption("--last-write-wins", "Last data point written will be kept when fixing duplicates.\n            May be set via config file and the 'tsd.storage.fix_duplicates' option.");
        argp.addOption("--delete-orphans", "Delete any time series rows where one or more UIDs fail resolution.");
        argp.addOption("--delete-unknown-columns", "Delete any unrecognized column that doesn't belong to OpenTSDB.");
        argp.addOption("--delete-bad-values", "Delete single column datapoints with bad values.");
        argp.addOption("--delete-bad-rows", "Delete rows with invalid keys.");
        argp.addOption("--delete-bad-compacts", "Delete compacted columns that cannot be parsed.");
        argp.addOption("--threads", "NUMBER", "Number of threads to use when executing a full table scan.");
    }

    public boolean fix() {
        return this.fix;
    }

    public boolean compact() {
        return this.compact;
    }

    public boolean resolveDupes() {
        return this.resolve_dupes;
    }

    public boolean lastWriteWins() {
        return this.last_write_wins;
    }

    public boolean deleteOrphans() {
        return this.delete_orphans;
    }

    public boolean deleteUnknownColumns() {
        return this.delete_unknown_columns;
    }

    public boolean deleteBadValues() {
        return this.delete_bad_values;
    }

    public boolean deleteBadRows() {
        return this.delete_bad_rows;
    }

    public boolean deleteBadCompacts() {
        return this.delete_bad_compacts;
    }

    public int threads() {
        return this.threads;
    }

    public void setFix(boolean fix) {
        this.fix = fix;
    }

    public void setCompact(boolean compact) {
        this.compact = compact;
    }

    public void setResolveDupes(boolean fix_dupes) {
        this.resolve_dupes = fix_dupes;
    }

    public void setLastWriteWins(boolean last_write_wins) {
        this.last_write_wins = last_write_wins;
    }

    public void setDeleteOrphans(boolean delete_orphans) {
        this.delete_orphans = delete_orphans;
    }

    public void setDeleteUnknownColumns(boolean delete_unknown_columns) {
        this.delete_unknown_columns = delete_unknown_columns;
    }

    public void setDeleteBadValues(boolean delete_bad_values) {
        this.delete_bad_values = delete_bad_values;
    }

    public void setDeleteBadRows(boolean delete_bad_rows) {
        this.delete_bad_rows = delete_bad_rows;
    }

    public void setDeleteBadCompacts(boolean delete_bad_compacts) {
        this.delete_bad_compacts = delete_bad_compacts;
    }

    public void setThreads(int threads) {
        if (threads < 1) {
            throw new IllegalArgumentException("Must have at least one thread");
        }
        if (threads > Runtime.getRuntime().availableProcessors() * 4) {
            throw new IllegalArgumentException("Not allowed to run more than 4 threads per core");
        }
        this.threads = threads;
    }
}

