/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tools;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.opentsdb.core.TSDB;
import net.opentsdb.meta.TSMeta;
import org.hbase.async.Bytes;
import org.hbase.async.DeleteRequest;
import org.hbase.async.HBaseException;
import org.hbase.async.KeyValue;
import org.hbase.async.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MetaPurge
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(MetaPurge.class);
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private static final byte[] NAME_FAMILY = "name".getBytes(CHARSET);
    private final TSDB tsdb;
    private long columns;
    final long start_id;
    final long end_id;
    final int thread_id;

    public MetaPurge(TSDB tsdb, long start_id, double quotient, int thread_id) {
        this.tsdb = tsdb;
        this.start_id = start_id;
        this.end_id = start_id + (long)quotient + 1L;
        this.thread_id = thread_id;
    }

    @Override
    public void run() {
        try {
            long purged_columns = (Long)this.purgeUIDMeta().joinUninterruptibly();
            LOG.info("Thread [" + this.thread_id + "] finished. Purged [" + purged_columns + "] UIDMeta columns from storage");
            purged_columns = (Long)this.purgeTSMeta().joinUninterruptibly();
            LOG.info("Thread [" + this.thread_id + "] finished. Purged [" + purged_columns + "] TSMeta columns from storage");
        }
        catch (Exception e) {
            LOG.error("Unexpected exception", (Throwable)e);
        }
    }

    public Deferred<Long> purgeUIDMeta() {
        final ArrayList delete_calls = new ArrayList();
        final Deferred result = new Deferred();
        final class MetaScanner
        implements Callback<Deferred<Long>, ArrayList<ArrayList<KeyValue>>> {
            final Scanner scanner;

            public MetaScanner() {
                this.scanner = MetaPurge.this.getScanner(MetaPurge.this.tsdb.uidTable());
            }

            public Deferred<Long> scan() {
                return this.scanner.nextRows().addCallbackDeferring((Callback)this);
            }

            public Deferred<Long> call(ArrayList<ArrayList<KeyValue>> rows) throws Exception {
                if (rows == null) {
                    result.callback((Object)MetaPurge.this.columns);
                    return null;
                }
                for (ArrayList<KeyValue> row : rows) {
                    ArrayList<byte[]> qualifiers = new ArrayList<byte[]>(row.size());
                    for (KeyValue column : row) {
                        if (Bytes.equals((byte[])TSMeta.META_QUALIFIER(), (byte[])column.qualifier())) {
                            qualifiers.add(column.qualifier());
                            continue;
                        }
                        if (Bytes.equals((byte[])"metric_meta".getBytes(CHARSET), (byte[])column.qualifier())) {
                            qualifiers.add(column.qualifier());
                            continue;
                        }
                        if (Bytes.equals((byte[])"tagk_meta".getBytes(CHARSET), (byte[])column.qualifier())) {
                            qualifiers.add(column.qualifier());
                            continue;
                        }
                        if (!Bytes.equals((byte[])"tagv_meta".getBytes(CHARSET), (byte[])column.qualifier())) continue;
                        qualifiers.add(column.qualifier());
                    }
                    if (qualifiers.size() <= 0) continue;
                    MetaPurge.this.columns = MetaPurge.this.columns + (long)qualifiers.size();
                    DeleteRequest delete = new DeleteRequest(MetaPurge.this.tsdb.uidTable(), row.get(0).key(), NAME_FAMILY, (byte[][])qualifiers.toArray((T[])new byte[qualifiers.size()][]));
                    delete_calls.add(MetaPurge.this.tsdb.getClient().delete(delete));
                }
                final class ContinueCB
                implements Callback<Deferred<Long>, ArrayList<Object>> {
                    ContinueCB() {
                    }

                    public Deferred<Long> call(ArrayList<Object> deletes) throws Exception {
                        LOG.debug("[" + MetaPurge.this.thread_id + "] Processed [" + deletes.size() + "] delete calls");
                        delete_calls.clear();
                        return this.scan();
                    }
                }
                Deferred.group((Collection)delete_calls).addCallbackDeferring((Callback)new ContinueCB());
                return null;
            }
        }
        new MetaScanner().scan();
        return result;
    }

    public Deferred<Long> purgeTSMeta() {
        final ArrayList delete_calls = new ArrayList();
        final Deferred result = new Deferred();
        final class MetaScanner
        implements Callback<Deferred<Long>, ArrayList<ArrayList<KeyValue>>> {
            final Scanner scanner;

            public MetaScanner() {
                this.scanner = MetaPurge.this.getScanner(MetaPurge.this.tsdb.metaTable());
            }

            public Deferred<Long> scan() {
                return this.scanner.nextRows().addCallbackDeferring((Callback)this);
            }

            public Deferred<Long> call(ArrayList<ArrayList<KeyValue>> rows) throws Exception {
                if (rows == null) {
                    result.callback((Object)MetaPurge.this.columns);
                    return null;
                }
                for (ArrayList<KeyValue> row : rows) {
                    ArrayList<byte[]> qualifiers = new ArrayList<byte[]>(row.size());
                    for (KeyValue column : row) {
                        if (Bytes.equals((byte[])TSMeta.META_QUALIFIER(), (byte[])column.qualifier())) {
                            qualifiers.add(column.qualifier());
                            continue;
                        }
                        if (!Bytes.equals((byte[])TSMeta.COUNTER_QUALIFIER(), (byte[])column.qualifier())) continue;
                        qualifiers.add(column.qualifier());
                    }
                    if (qualifiers.size() <= 0) continue;
                    MetaPurge.this.columns = MetaPurge.this.columns + (long)qualifiers.size();
                    DeleteRequest delete = new DeleteRequest(MetaPurge.this.tsdb.metaTable(), row.get(0).key(), NAME_FAMILY, (byte[][])qualifiers.toArray((T[])new byte[qualifiers.size()][]));
                    delete_calls.add(MetaPurge.this.tsdb.getClient().delete(delete));
                }
                final class ContinueCB
                implements Callback<Deferred<Long>, ArrayList<Object>> {
                    ContinueCB() {
                    }

                    public Deferred<Long> call(ArrayList<Object> deletes) throws Exception {
                        LOG.debug("[" + MetaPurge.this.thread_id + "] Processed [" + deletes.size() + "] delete calls");
                        delete_calls.clear();
                        return this.scan();
                    }
                }
                Deferred.group((Collection)delete_calls).addCallbackDeferring((Callback)new ContinueCB());
                return null;
            }
        }
        new MetaScanner().scan();
        return result;
    }

    private Scanner getScanner(byte[] table) throws HBaseException {
        short metric_width = TSDB.metrics_width();
        byte[] start_row = Arrays.copyOfRange(Bytes.fromLong((long)this.start_id), 8 - metric_width, 8);
        byte[] end_row = Arrays.copyOfRange(Bytes.fromLong((long)this.end_id), 8 - metric_width, 8);
        Scanner scanner = this.tsdb.getClient().newScanner(table);
        scanner.setStartKey(start_row);
        scanner.setStopKey(end_row);
        scanner.setFamily(NAME_FAMILY);
        return scanner;
    }
}

