/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tools;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import com.stumbleupon.async.DeferredGroupException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.opentsdb.core.Const;
import net.opentsdb.core.TSDB;
import net.opentsdb.meta.TSMeta;
import net.opentsdb.meta.UIDMeta;
import net.opentsdb.uid.NoSuchUniqueId;
import net.opentsdb.uid.UniqueId;
import org.hbase.async.Bytes;
import org.hbase.async.KeyValue;
import org.hbase.async.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MetaSync
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(MetaSync.class);
    final TSDB tsdb;
    final Set<Integer> processed_tsuids;
    final ConcurrentHashMap<String, Long> metric_uids;
    final ConcurrentHashMap<String, Long> tagk_uids;
    final ConcurrentHashMap<String, Long> tagv_uids;
    final int thread_id;
    final Scanner scanner;

    public MetaSync(TSDB tsdb, Scanner scanner, Set<Integer> processed_tsuids, ConcurrentHashMap<String, Long> metric_uids, ConcurrentHashMap<String, Long> tagk_uids, ConcurrentHashMap<String, Long> tagv_uids, int thread_id) {
        this.tsdb = tsdb;
        this.scanner = scanner;
        this.processed_tsuids = processed_tsuids;
        this.metric_uids = metric_uids;
        this.tagk_uids = tagk_uids;
        this.tagv_uids = tagv_uids;
        this.thread_id = thread_id;
    }

    @Override
    public void run() {
        final ArrayList storage_calls = new ArrayList();
        final Deferred result = new Deferred();
        final class ErrBack
        implements Callback<Object, Exception> {
            ErrBack() {
            }

            public Object call(Exception e) throws Exception {
                Throwable ex = e;
                while (ex.getClass().equals(DeferredGroupException.class)) {
                    if (ex.getCause() == null) {
                        LOG.warn("Unable to get to the root cause of the DGE");
                        break;
                    }
                    ex = ex.getCause();
                }
                LOG.error("Sync thread failed with exception", ex);
                result.callback(null);
                return null;
            }
        }
        final ErrBack err_back = new ErrBack();
        final class MetaScanner
        implements Callback<Object, ArrayList<ArrayList<KeyValue>>> {
            private byte[] last_tsuid = null;
            private String tsuid_string = "";

            MetaScanner() {
            }

            public Object scan() {
                return MetaSync.this.scanner.nextRows().addCallback((Callback)this).addErrback((Callback)err_back);
            }

            public Object call(ArrayList<ArrayList<KeyValue>> rows) throws Exception {
                if (rows == null) {
                    result.callback(null);
                    return null;
                }
                for (final ArrayList<KeyValue> row : rows) {
                    try {
                        final class RowErrBack
                        implements Callback<Object, Exception> {
                            RowErrBack() {
                            }

                            public Object call(Exception e) throws Exception {
                                Throwable ex = e;
                                while (ex.getClass().equals(DeferredGroupException.class)) {
                                    if (ex.getCause() == null) {
                                        LOG.warn("Unable to get to the root cause of the DGE");
                                        break;
                                    }
                                    ex = ex.getCause();
                                }
                                if (ex.getClass().equals(IllegalStateException.class)) {
                                    LOG.error("Invalid data when processing TSUID [" + tsuid_string + "]: " + ex.getMessage());
                                } else if (ex.getClass().equals(IllegalArgumentException.class)) {
                                    LOG.error("Invalid data when processing TSUID [" + tsuid_string + "]: " + ex.getMessage());
                                } else if (ex.getClass().equals(NoSuchUniqueId.class)) {
                                    LOG.warn("Timeseries [" + tsuid_string + "] includes a non-existant UID: " + ex.getMessage());
                                } else {
                                    LOG.error("Unknown exception processing row: " + row, ex);
                                }
                                return null;
                            }
                        }
                        final class UidCB
                        implements Callback<Deferred<Boolean>, UIDMeta> {
                            private final UniqueId.UniqueIdType type;
                            private final byte[] uid;
                            private final long timestamp;

                            public UidCB(UniqueId.UniqueIdType type, byte[] uid, long timestamp) {
                                this.type = type;
                                this.uid = uid;
                                this.timestamp = timestamp;
                            }

                            public Deferred<Boolean> call(UIDMeta meta) throws Exception {
                                if (meta.getCreated() > this.timestamp + 3600L || meta.getCreated() == 0L) {
                                    LOG.info("Updating UID [" + UniqueId.uidToString(this.uid) + "] of type [" + (Object)((Object)this.type) + "]");
                                    meta.setCreated(this.timestamp);
                                    if (meta.getUID() == null || meta.getUID().isEmpty() || meta.getType() == null) {
                                        return MetaSync.this.tsdb.getUidName(this.type, this.uid).addCallbackDeferring((Callback)new 1UidCB.UidNameCB());
                                    }
                                    MetaSync.this.tsdb.indexUIDMeta(meta);
                                    LOG.info("Syncing valid UID [" + UniqueId.uidToString(this.uid) + "] of type [" + (Object)((Object)this.type) + "]");
                                    return meta.syncToStorage(MetaSync.this.tsdb, false);
                                }
                                LOG.debug("UID [" + UniqueId.uidToString(this.uid) + "] of type [" + (Object)((Object)this.type) + "] is up to date in storage");
                                return Deferred.fromResult((Object)true);
                            }

                            final class 1UidCB.UidNameCB
                            implements Callback<Deferred<Boolean>, String> {
                                1UidCB.UidNameCB() {
                                }

                                public Deferred<Boolean> call(String name) throws Exception {
                                    UIDMeta new_meta = new UIDMeta(type, uid, name);
                                    new_meta.setCreated(timestamp);
                                    MetaSync.this.tsdb.indexUIDMeta(new_meta);
                                    LOG.info("Replacing corrupt UID [" + UniqueId.uidToString(uid) + "] of type [" + (Object)((Object)type) + "]");
                                    return new_meta.syncToStorage(MetaSync.this.tsdb, true);
                                }
                            }
                        }
                        byte[] tsuid = UniqueId.getTSUIDFromKey(row.get(0).key(), TSDB.metrics_width(), (short)4);
                        if (this.last_tsuid != null && Arrays.equals(this.last_tsuid, tsuid)) continue;
                        this.last_tsuid = tsuid;
                        if (MetaSync.this.processed_tsuids.contains(Arrays.hashCode(tsuid))) continue;
                        this.tsuid_string = UniqueId.uidToString(tsuid);
                        MetaSync.this.processed_tsuids.add(Arrays.hashCode(tsuid));
                        long timestamp = Bytes.getUnsignedInt((byte[])row.get(0).key(), (int)(Const.SALT_WIDTH() + TSDB.metrics_width()));
                        LOG.debug("[" + MetaSync.this.thread_id + "] Processing TSUID: " + this.tsuid_string + "  row timestamp: " + timestamp);
                        byte[] metric_uid_bytes = Arrays.copyOfRange(tsuid, 0, (int)TSDB.metrics_width());
                        String metric_uid = UniqueId.uidToString(metric_uid_bytes);
                        Long last_get = MetaSync.this.metric_uids.get(metric_uid);
                        if (last_get == null || last_get == 0L || timestamp < last_get) {
                            UidCB cb = new UidCB(UniqueId.UniqueIdType.METRIC, metric_uid_bytes, timestamp);
                            Deferred process_uid = UIDMeta.getUIDMeta(MetaSync.this.tsdb, UniqueId.UniqueIdType.METRIC, metric_uid_bytes).addCallbackDeferring((Callback)cb).addErrback((Callback)new RowErrBack());
                            storage_calls.add(process_uid);
                            MetaSync.this.metric_uids.put(metric_uid, timestamp);
                        }
                        List<byte[]> tags = UniqueId.getTagsFromTSUID(this.tsuid_string);
                        int idx = 0;
                        for (byte[] tag : tags) {
                            UniqueId.UniqueIdType type = idx % 2 == 0 ? UniqueId.UniqueIdType.TAGK : UniqueId.UniqueIdType.TAGV;
                            ++idx;
                            String uid = UniqueId.uidToString(tag);
                            last_get = type == UniqueId.UniqueIdType.TAGK ? MetaSync.this.tagk_uids.get(uid) : MetaSync.this.tagv_uids.get(uid);
                            if (last_get != null && last_get != 0L && last_get <= timestamp) continue;
                            UidCB cb = new UidCB(type, tag, timestamp);
                            Deferred process_uid = UIDMeta.getUIDMeta(MetaSync.this.tsdb, type, tag).addCallbackDeferring((Callback)cb).addErrback((Callback)new RowErrBack());
                            storage_calls.add(process_uid);
                            if (type == UniqueId.UniqueIdType.TAGK) {
                                MetaSync.this.tagk_uids.put(uid, timestamp);
                                continue;
                            }
                            MetaSync.this.tagv_uids.put(uid, timestamp);
                        }
                        final class TSMetaCB
                        implements Callback<Deferred<Boolean>, TSMeta> {
                            private final String tsuid_string;
                            private final byte[] tsuid;
                            private final long timestamp;

                            public TSMetaCB(byte[] tsuid, long timestamp) {
                                this.tsuid = tsuid;
                                this.tsuid_string = UniqueId.uidToString(tsuid);
                                this.timestamp = timestamp;
                            }

                            public Deferred<Boolean> call(TSMeta meta) throws Exception {
                                if (meta == null) {
                                    final class CounterCB
                                    implements Callback<Deferred<Boolean>, Boolean> {
                                        CounterCB() {
                                        }

                                        public Deferred<Boolean> call(Boolean exists) throws Exception {
                                            if (!exists.booleanValue()) {
                                                final class CreatedCB
                                                implements Callback<Deferred<Boolean>, Long> {
                                                    CreatedCB() {
                                                    }

                                                    public Deferred<Boolean> call(Long value) throws Exception {
                                                        LOG.info("Created counter and meta for timeseries [" + tsuid_string + "]");
                                                        return Deferred.fromResult((Object)true);
                                                    }
                                                }
                                                return TSMeta.incrementAndGetCounter(MetaSync.this.tsdb, tsuid).addCallbackDeferring((Callback)new CreatedCB());
                                            }
                                            TSMeta new_meta = new TSMeta(tsuid, timestamp);
                                            MetaSync.this.tsdb.indexTSMeta(new_meta);
                                            LOG.info("Counter exists but meta was null, creating meta data for timeseries [" + tsuid_string + "]");
                                            final class GetCB
                                            implements Callback<Deferred<Boolean>, Boolean> {
                                                GetCB() {
                                                }

                                                public final Deferred<Boolean> call(Boolean exists) throws Exception {
                                                    if (exists.booleanValue()) {
                                                        final class IndexCB
                                                        implements Callback<Deferred<Boolean>, TSMeta> {
                                                            IndexCB() {
                                                            }

                                                            public Deferred<Boolean> call(TSMeta new_meta) throws Exception {
                                                                MetaSync.this.tsdb.indexTSMeta(new_meta);
                                                                return MetaSync.this.tsdb.processTSMetaThroughTrees(new_meta);
                                                            }
                                                        }
                                                        return TSMeta.getTSMeta(MetaSync.this.tsdb, tsuid_string).addCallbackDeferring((Callback)new IndexCB());
                                                    }
                                                    return Deferred.fromResult((Object)false);
                                                }
                                            }
                                            class ErrBack
                                            implements Callback<Object, Exception> {
                                                ErrBack() {
                                                }

                                                public Object call(Exception e) throws Exception {
                                                    LOG.warn("Failed creating meta for: " + tsuid + " with exception: ", (Throwable)e);
                                                    return null;
                                                }
                                            }
                                            return new_meta.storeNew(MetaSync.this.tsdb).addCallbackDeferring((Callback)new GetCB()).addErrback((Callback)new ErrBack());
                                        }
                                    }
                                    return TSMeta.counterExistsInStorage(MetaSync.this.tsdb, this.tsuid).addCallbackDeferring((Callback)new CounterCB());
                                }
                                if (meta.getTSUID() == null || meta.getTSUID().isEmpty()) {
                                    LOG.warn("Replacing corrupt meta data for timeseries [" + this.tsuid_string + "]");
                                    TSMeta new_meta = new TSMeta(this.tsuid, this.timestamp);
                                    MetaSync.this.tsdb.indexTSMeta(new_meta);
                                    return new_meta.storeNew(MetaSync.this.tsdb).addCallbackDeferring((Callback)new GetCB()).addErrback((Callback)new ErrBack());
                                }
                                if (meta.getCreated() > this.timestamp + 3600L || meta.getCreated() == 0L) {
                                    meta.setCreated(this.timestamp);
                                    MetaSync.this.tsdb.indexTSMeta(meta);
                                    LOG.info("Updated created timestamp for timeseries [" + this.tsuid_string + "]");
                                    return meta.syncToStorage(MetaSync.this.tsdb, false);
                                }
                                LOG.debug("TSUID [" + this.tsuid_string + "] is up to date in storage");
                                return Deferred.fromResult((Object)false);
                            }
                        }
                        Deferred process_tsmeta = TSMeta.getTSMeta(MetaSync.this.tsdb, this.tsuid_string).addCallbackDeferring((Callback)new TSMetaCB(tsuid, timestamp)).addErrback((Callback)new RowErrBack());
                        storage_calls.add(process_tsmeta);
                    }
                    catch (RuntimeException e) {
                        LOG.error("Processing row " + row + " failed with exception: " + e.getMessage());
                        LOG.debug("Row: " + row + " stack trace: ", (Throwable)e);
                    }
                }
                final class ContinueCB
                implements Callback<Object, ArrayList<Boolean>> {
                    ContinueCB() {
                    }

                    public Object call(ArrayList<Boolean> puts) throws Exception {
                        storage_calls.clear();
                        return this.scan();
                    }
                }
                final class ContinueEB
                implements Callback<Object, Exception> {
                    ContinueEB() {
                    }

                    public Object call(Exception e) throws Exception {
                        Throwable ex = e;
                        while (ex.getClass().equals(DeferredGroupException.class)) {
                            if (ex.getCause() == null) {
                                LOG.warn("Unable to get to the root cause of the DGE");
                                break;
                            }
                            ex = ex.getCause();
                        }
                        LOG.error("[" + MetaSync.this.thread_id + "] Upstream Exception: ", ex);
                        return this.scan();
                    }
                }
                Deferred.group((Collection)storage_calls).addCallback((Callback)new ContinueCB()).addErrback((Callback)new ContinueEB());
                return null;
            }
        }
        MetaScanner scanner = new MetaScanner();
        try {
            scanner.scan();
            result.joinUninterruptibly();
            LOG.info("[" + this.thread_id + "] Complete");
        }
        catch (Exception e) {
            LOG.error("[" + this.thread_id + "] Scanner Exception", (Throwable)e);
            throw new RuntimeException("[" + this.thread_id + "] Scanner exception", e);
        }
    }
}

