/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tools;

import java.util.ArrayList;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.Tags;
import net.opentsdb.search.SearchQuery;
import net.opentsdb.search.TimeSeriesLookup;
import net.opentsdb.tools.ArgP;
import net.opentsdb.tools.CliOptions;
import net.opentsdb.utils.Config;
import net.opentsdb.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Search {
    private static final Logger LOG = LoggerFactory.getLogger(Search.class);

    Search() {
    }

    static void usage(ArgP argp, String errmsg) {
        System.err.println(errmsg);
        System.err.println("Usage: search <subcommand> args\nSub commands:\n  lookup <query>: Retreives a list of time series with the given\n                  metric, tagk, tagv or any combination thereof.\n");
        if (argp != null) {
            System.err.print(argp.usage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int rc;
        ArgP argp = new ArgP();
        CliOptions.addCommon(argp);
        argp.addOption("--use-data-table", "Scan against the raw data table instead of the meta data table.");
        args = CliOptions.parse(argp, args);
        if (args == null) {
            Search.usage(argp, "Invalid usage");
            System.exit(2);
        } else if (args.length < 1) {
            Search.usage(argp, "Not enough arguments");
            System.exit(2);
        }
        boolean use_data_table = argp.has("--use-data-table");
        Config config = CliOptions.getConfig(argp);
        TSDB tsdb = new TSDB(config);
        tsdb.checkNecessaryTablesExist().joinUninterruptibly();
        try {
            rc = Search.runCommand(tsdb, use_data_table, args);
        }
        finally {
            try {
                tsdb.getClient().shutdown().joinUninterruptibly();
                LOG.info("Gracefully shutdown the TSD");
            }
            catch (Exception e) {
                LOG.error("Unexpected exception while shutting down", (Throwable)e);
                rc = 42;
            }
        }
        System.exit(rc);
    }

    private static int runCommand(TSDB tsdb, boolean use_data_table, String[] args) throws Exception {
        int nargs = args.length;
        if (args[0].equals("lookup")) {
            if (nargs < 2) {
                Search.usage(null, "Not enough arguments");
                return 2;
            }
            return Search.lookup(tsdb, use_data_table, args);
        }
        Search.usage(null, "Unknown sub command: " + args[0]);
        return 2;
    }

    private static int lookup(TSDB tsdb, boolean use_data_table, String[] args) throws Exception {
        if (!use_data_table) {
            tsdb.getClient().ensureTableExists(tsdb.getConfig().getString("tsd.storage.hbase.meta_table")).joinUninterruptibly();
        }
        SearchQuery query = new SearchQuery();
        query.setType(SearchQuery.SearchType.LOOKUP);
        int index = 1;
        if (!args[index].contains("=")) {
            query.setMetric(args[index++]);
        }
        ArrayList<Pair<String, String>> tags = new ArrayList<Pair<String, String>>(args.length - index);
        while (index < args.length) {
            Tags.parse(tags, args[index]);
            ++index;
        }
        query.setTags(tags);
        if (use_data_table) {
            query.setUseMeta(false);
            LOG.warn("NOTE: Scanning the full data table may take a long time");
        }
        TimeSeriesLookup lookup = new TimeSeriesLookup(tsdb, query);
        lookup.setToStdout(true);
        lookup.lookup();
        return 0;
    }
}

