/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tools;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.opentsdb.core.TSDB;
import net.opentsdb.tools.ArgP;
import net.opentsdb.tools.BuildData;
import net.opentsdb.tools.CliOptions;
import net.opentsdb.tools.StartupPlugin;
import net.opentsdb.tsd.PipelineFactory;
import net.opentsdb.tsd.RpcManager;
import net.opentsdb.utils.Config;
import net.opentsdb.utils.FileSystem;
import net.opentsdb.utils.Pair;
import net.opentsdb.utils.PluginLoader;
import net.opentsdb.utils.Threads;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.BossPool;
import org.jboss.netty.channel.socket.nio.NioServerBossPool;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.channel.socket.oio.OioServerSocketChannelFactory;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TSDMain {
    private static Map<String, Pair<Class<?>, Constructor<? extends StartupPlugin>>> startupPlugin_filter_map = new HashMap();
    private static final short DEFAULT_FLUSH_INTERVAL = 1000;
    private static TSDB tsdb = null;

    TSDMain() {
    }

    static void usage(ArgP argp, String errmsg, int retval) {
        System.err.println(errmsg);
        System.err.println("Usage: tsd --port=PORT --staticroot=PATH --cachedir=PATH\nStarts the TSD, the Time Series Daemon");
        if (argp != null) {
            System.err.print(argp.usage());
        }
        System.exit(retval);
    }

    public static void main(String[] args) throws IOException {
        OioServerSocketChannelFactory factory;
        Logger log = LoggerFactory.getLogger(TSDMain.class);
        log.info("Starting.");
        log.info(BuildData.revisionString());
        log.info(BuildData.buildString());
        try {
            System.in.close();
        }
        catch (Exception e) {
            log.warn("Failed to close stdin", (Throwable)e);
        }
        ArgP argp = new ArgP();
        CliOptions.addCommon(argp);
        argp.addOption("--port", "NUM", "TCP port to listen on.");
        argp.addOption("--bind", "ADDR", "Address to bind to (default: 0.0.0.0).");
        argp.addOption("--staticroot", "PATH", "Web root from which to serve static files (/s URLs).");
        argp.addOption("--cachedir", "PATH", "Directory under which to cache result of requests.");
        argp.addOption("--worker-threads", "NUM", "Number for async io workers (default: cpu * 2).");
        argp.addOption("--async-io", "true|false", "Use async NIO (default true) or traditional blocking io");
        argp.addOption("--read-only", "true|false", "Set tsd.mode to ro (default false)");
        argp.addOption("--disable-ui", "true|false", "Set tsd.core.enable_ui to false (default true)");
        argp.addOption("--disable-api", "true|false", "Set tsd.core.enable_api to false (default true)");
        argp.addOption("--backlog", "NUM", "Size of connection attempt queue (default: 3072 or kernel somaxconn.");
        argp.addOption("--max-connections", "NUM", "Maximum number of connections to accept");
        argp.addOption("--flush-interval", "MSEC", "Maximum time for which a new data point can be buffered (default: 1000).");
        argp.addOption("--statswport", "Force all stats to include the port");
        CliOptions.addAutoMetricFlag(argp);
        args = CliOptions.parse(argp, args);
        args = null;
        Config config = CliOptions.getConfig(argp);
        try {
            if (config.getString("tsd.http.staticroot").isEmpty()) {
                TSDMain.usage(argp, "Missing static root directory", 1);
            }
        }
        catch (NullPointerException npe) {
            TSDMain.usage(argp, "Missing static root directory", 1);
        }
        try {
            if (config.getString("tsd.http.cachedir").isEmpty()) {
                TSDMain.usage(argp, "Missing cache directory", 1);
            }
        }
        catch (NullPointerException npe) {
            TSDMain.usage(argp, "Missing cache directory", 1);
        }
        try {
            if (!config.hasProperty("tsd.network.port")) {
                TSDMain.usage(argp, "Missing network port", 1);
            }
            config.getInt("tsd.network.port");
        }
        catch (NumberFormatException nfe) {
            TSDMain.usage(argp, "Invalid network port setting", 1);
        }
        try {
            FileSystem.checkDirectory(config.getString("tsd.http.staticroot"), false, false);
            FileSystem.checkDirectory(config.getString("tsd.http.cachedir"), true, true);
        }
        catch (IllegalArgumentException e) {
            TSDMain.usage(argp, e.getMessage(), 3);
        }
        int connections_limit = 0;
        try {
            connections_limit = config.getInt("tsd.core.connections.limit");
        }
        catch (NumberFormatException nfe) {
            TSDMain.usage(argp, "Invalid connections limit", 1);
        }
        if (config.getBoolean("tsd.network.async_io")) {
            int workers = Runtime.getRuntime().availableProcessors() * 2;
            if (config.hasProperty("tsd.network.worker_threads")) {
                try {
                    workers = config.getInt("tsd.network.worker_threads");
                }
                catch (NumberFormatException nfe) {
                    TSDMain.usage(argp, "Invalid worker thread count", 1);
                }
            }
            ExecutorService executor = Executors.newCachedThreadPool();
            NioServerBossPool boss_pool = new NioServerBossPool((Executor)executor, 1, (ThreadNameDeterminer)new Threads.BossThreadNamer());
            NioWorkerPool worker_pool = new NioWorkerPool((Executor)executor, workers, (ThreadNameDeterminer)new Threads.WorkerThreadNamer());
            factory = new NioServerSocketChannelFactory((BossPool)boss_pool, (WorkerPool)worker_pool);
        } else {
            factory = new OioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool(), (ThreadNameDeterminer)new Threads.PrependThreadNamer());
        }
        StartupPlugin startup = null;
        try {
            startup = TSDMain.loadStartupPlugins(config);
        }
        catch (IllegalArgumentException e) {
            TSDMain.usage(argp, e.getMessage(), 3);
        }
        catch (Exception e) {
            throw new RuntimeException("Initialization failed", e);
        }
        try {
            tsdb = new TSDB(config);
            if (startup != null) {
                tsdb.setStartupPlugin(startup);
            }
            tsdb.initializePlugins(true);
            if (config.getBoolean("tsd.storage.hbase.prefetch_meta")) {
                tsdb.preFetchHBaseMeta();
            }
            tsdb.checkNecessaryTablesExist().joinUninterruptibly();
            TSDMain.registerShutdownHook();
            ServerBootstrap server = new ServerBootstrap((ChannelFactory)factory);
            RpcManager manager = RpcManager.instance(tsdb);
            server.setPipelineFactory((ChannelPipelineFactory)new PipelineFactory(tsdb, manager, connections_limit));
            if (config.hasProperty("tsd.network.backlog")) {
                server.setOption("backlog", (Object)config.getInt("tsd.network.backlog"));
            }
            server.setOption("child.tcpNoDelay", (Object)config.getBoolean("tsd.network.tcp_no_delay"));
            server.setOption("child.keepAlive", (Object)config.getBoolean("tsd.network.keep_alive"));
            server.setOption("reuseAddress", (Object)config.getBoolean("tsd.network.reuse_address"));
            InetAddress bindAddress = null;
            if (config.hasProperty("tsd.network.bind")) {
                bindAddress = InetAddress.getByName(config.getString("tsd.network.bind"));
            }
            InetSocketAddress addr = new InetSocketAddress(bindAddress, config.getInt("tsd.network.port"));
            server.bind((SocketAddress)addr);
            if (startup != null) {
                startup.setReady(tsdb);
            }
            log.info("Ready to serve on " + addr);
        }
        catch (Throwable e) {
            factory.releaseExternalResources();
            try {
                if (tsdb != null) {
                    tsdb.shutdown().joinUninterruptibly();
                }
            }
            catch (Exception e2) {
                log.error("Failed to shutdown HBase client", (Throwable)e2);
            }
            throw new RuntimeException("Initialization failed", e);
        }
    }

    private static StartupPlugin loadStartupPlugins(Config config) {
        Logger log = LoggerFactory.getLogger(TSDMain.class);
        StartupPlugin startup = null;
        if (config.getBoolean("tsd.startup.enable")) {
            log.debug("Startup Plugin is Enabled");
            String plugin_path = config.getString("tsd.core.plugin_path");
            String plugin_class = config.getString("tsd.startup.plugin");
            log.debug("Plugin Path: " + plugin_path);
            try {
                TSDB.loadPluginPath(plugin_path);
            }
            catch (Exception e) {
                log.error("Error loading plugins from plugin path: " + plugin_path, (Throwable)e);
            }
            log.debug("Attempt to Load: " + plugin_class);
            startup = PluginLoader.loadSpecificPlugin(plugin_class, StartupPlugin.class);
            if (startup == null) {
                throw new IllegalArgumentException("Unable to locate startup plugin: " + config.getString("tsd.startup.plugin"));
            }
            try {
                startup.initialize(config);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize startup plugin", e);
            }
            log.info("Successfully initialized startup plugin [" + startup.getClass().getCanonicalName() + "] version: " + startup.version());
        } else {
            startup = null;
        }
        return startup;
    }

    private static void registerShutdownHook() {
        final class TSDBShutdown
        extends Thread {
            public TSDBShutdown() {
                super("TSDBShutdown");
            }

            @Override
            public void run() {
                try {
                    if (RpcManager.isInitialized()) {
                        RpcManager.instance(tsdb).shutdown().join();
                    }
                    if (tsdb != null) {
                        tsdb.shutdown().join();
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(TSDBShutdown.class).error("Uncaught exception during shutdown", (Throwable)e);
                }
            }
        }
        Runtime.getRuntime().addShutdownHook(new TSDBShutdown());
    }
}

