/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tools;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.WritableDataPoints;
import net.opentsdb.stats.StatsCollector;
import net.opentsdb.tools.ArgP;
import net.opentsdb.tools.CliOptions;
import net.opentsdb.utils.Config;
import org.hbase.async.HBaseClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TextImporter {
    private static final Logger LOG = LoggerFactory.getLogger(TextImporter.class);
    static volatile boolean throttle = false;
    private static final HashMap<String, WritableDataPoints> datapoints = new HashMap();

    TextImporter() {
    }

    static void usage(ArgP argp, int retval) {
        System.err.println("Usage: import path [more paths]");
        System.err.print(argp.usage());
        System.err.println("This tool can directly read gzip'ed input files.");
        System.exit(retval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ArgP argp = new ArgP();
        CliOptions.addCommon(argp);
        CliOptions.addAutoMetricFlag(argp);
        argp.addOption("--skip-errors", "Whether or not to skip exceptions during processing");
        args = CliOptions.parse(argp, args);
        if (args == null) {
            TextImporter.usage(argp, 1);
        } else if (args.length < 1) {
            TextImporter.usage(argp, 2);
        }
        Config config = CliOptions.getConfig(argp);
        TSDB tsdb = new TSDB(config);
        boolean skip_errors = argp.has("--skip-errors");
        tsdb.checkNecessaryTablesExist().joinUninterruptibly();
        argp = null;
        try {
            int points = 0;
            long start_time = System.nanoTime();
            for (String path : args) {
                points += TextImporter.importFile(tsdb.getClient(), tsdb, path, skip_errors);
            }
            double time_delta = (double)(System.nanoTime() - start_time) / 1.0E9;
            LOG.info(String.format("Total: imported %d data points in %.3fs (%.1f points/s)", points, time_delta, (double)points / time_delta));
            tsdb.collectStats(new StatsCollector("tsd"){

                @Override
                public final void emit(String line) {
                    System.err.print(line);
                }
            });
        }
        finally {
            try {
                tsdb.shutdown().joinUninterruptibly();
            }
            catch (Exception e) {
                LOG.error("Unexpected exception", (Throwable)e);
                System.exit(1);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static int importFile(HBaseClient client, TSDB tsdb, String path, boolean skip_errors) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static BufferedReader open(String path) throws IOException {
        if (path.equals("-")) {
            return new BufferedReader(new InputStreamReader(System.in));
        }
        InputStream is = new FileInputStream(path);
        if (path.endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        return new BufferedReader(new InputStreamReader(is));
    }

    private static WritableDataPoints getDataPoints(TSDB tsdb, String metric, HashMap<String, String> tags) {
        String key = metric + tags;
        WritableDataPoints dp = datapoints.get(key);
        if (dp != null) {
            return dp;
        }
        dp = tsdb.newDataPoints();
        dp.setSeries(metric, tags);
        dp.setBatchImport(true);
        datapoints.put(key, dp);
        return dp;
    }
}

