/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tools;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.opentsdb.core.TSDB;
import net.opentsdb.meta.TSMeta;
import net.opentsdb.tree.Tree;
import net.opentsdb.tree.TreeBuilder;
import net.opentsdb.uid.NoSuchUniqueId;
import net.opentsdb.uid.UniqueId;
import net.opentsdb.utils.JSON;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseException;
import org.hbase.async.KeyValue;
import org.hbase.async.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TreeSync
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(TreeSync.class);
    private static final Charset CHARSET;
    final TSDB tsdb;
    final long start_id;
    final long end_id;
    final int thread_id;

    public TreeSync(TSDB tsdb, long start_id, double quotient, int thread_id) {
        this.tsdb = tsdb;
        this.start_id = start_id;
        this.end_id = start_id + (long)quotient + 1L;
        this.thread_id = thread_id;
    }

    @Override
    public void run() {
        List trees;
        final Scanner scanner = this.getScanner();
        try {
            trees = (List)Tree.fetchAllTrees(this.tsdb).joinUninterruptibly();
            LOG.info("[" + this.thread_id + "] Complete");
        }
        catch (Exception e) {
            LOG.error("[" + this.thread_id + "] Unexpected Exception", (Throwable)e);
            throw new RuntimeException("[" + this.thread_id + "] Unexpected exception", e);
        }
        if (trees == null) {
            LOG.warn("No tree definitions were found");
            return;
        }
        boolean has_enabled_tree = false;
        for (Tree tree : trees) {
            if (!tree.getEnabled()) continue;
            has_enabled_tree = true;
            break;
        }
        if (!has_enabled_tree) {
            LOG.warn("No enabled trees were found");
            return;
        }
        LOG.info("Found [" + trees.size() + "] trees");
        final ArrayList tree_calls = new ArrayList();
        final Deferred completed = new Deferred();
        final class TsuidScanner
        implements Callback<Deferred<Boolean>, ArrayList<ArrayList<KeyValue>>> {
            TsuidScanner() {
            }

            public Deferred<Boolean> scan() {
                return scanner.nextRows().addCallbackDeferring((Callback)this);
            }

            public Deferred<Boolean> call(ArrayList<ArrayList<KeyValue>> rows) throws Exception {
                if (rows == null) {
                    completed.callback((Object)true);
                    return null;
                }
                for (ArrayList<KeyValue> row : rows) {
                    final String tsuid = UniqueId.uidToString(row.get(0).key());
                    final class ParseCB
                    implements Callback<Deferred<Boolean>, TSMeta> {
                        final ArrayList<Deferred<ArrayList<Boolean>>> builder_calls = new ArrayList();

                        ParseCB() {
                        }

                        public Deferred<Boolean> call(TSMeta meta) throws Exception {
                            if (meta != null) {
                                LOG.debug("Processing TSMeta: " + meta + " w value: " + JSON.serializeToString(meta));
                                ArrayList<TreeBuilder> tree_builders = new ArrayList<TreeBuilder>(trees.size());
                                for (Tree tree : trees) {
                                    if (!tree.getEnabled()) continue;
                                    TreeBuilder builder = new TreeBuilder(TreeSync.this.tsdb, tree);
                                    tree_builders.add(builder);
                                }
                                for (TreeBuilder builder : tree_builders) {
                                    this.builder_calls.add(builder.processTimeseriesMeta(meta));
                                }
                                final class TreeBuilderBufferCB
                                implements Callback<Boolean, ArrayList<ArrayList<Boolean>>> {
                                    TreeBuilderBufferCB() {
                                    }

                                    public Boolean call(ArrayList<ArrayList<Boolean>> builder_calls) throws Exception {
                                        return true;
                                    }
                                }
                                return Deferred.group(this.builder_calls).addCallback((Callback)new TreeBuilderBufferCB());
                            }
                            return Deferred.fromResult((Object)false);
                        }
                    }
                    Deferred process_tsmeta = TSMeta.parseFromColumn(TreeSync.this.tsdb, row.get(0), true).addCallbackDeferring((Callback)new ParseCB());
                    final class ErrBack
                    implements Callback<Deferred<Boolean>, Exception> {
                        ErrBack() {
                        }

                        public Deferred<Boolean> call(Exception e) throws Exception {
                            if (e.getClass().equals(IllegalStateException.class)) {
                                LOG.error("Invalid data when processing TSUID [" + tsuid + "]", (Throwable)e);
                            } else if (e.getClass().equals(IllegalArgumentException.class)) {
                                LOG.error("Invalid data when processing TSUID [" + tsuid + "]", (Throwable)e);
                            } else if (e.getClass().equals(NoSuchUniqueId.class)) {
                                LOG.warn("Timeseries [" + tsuid + "] includes a non-existant UID: " + e.getMessage());
                            } else {
                                LOG.error("[" + TreeSync.this.thread_id + "] Exception while processing TSUID [" + tsuid + "]", (Throwable)e);
                            }
                            return Deferred.fromResult((Object)false);
                        }
                    }
                    process_tsmeta.addErrback((Callback)new ErrBack());
                    tree_calls.add(process_tsmeta);
                }
                final class ContinueCB
                implements Callback<Deferred<Boolean>, ArrayList<Boolean>> {
                    ContinueCB() {
                    }

                    public Deferred<Boolean> call(ArrayList<Boolean> tsuids) throws Exception {
                        LOG.debug("Processed [" + tsuids.size() + "] tree_calls, continuing");
                        tree_calls.clear();
                        return this.scan();
                    }
                }
                Deferred.group((Collection)tree_calls).addCallback((Callback)new ContinueCB());
                return Deferred.fromResult(null);
            }
        }
        TsuidScanner tree_scanner = new TsuidScanner();
        final class ErrBack
        implements Callback<Deferred<Boolean>, Exception> {
            ErrBack() {
            }

            public Deferred<Boolean> call(Exception e) throws Exception {
                LOG.error("Unexpected exception", (Throwable)e);
                completed.callback((Object)false);
                return Deferred.fromResult((Object)false);
            }
        }
        tree_scanner.scan().addErrback((Callback)new ErrBack());
        try {
            completed.joinUninterruptibly();
            LOG.info("[" + this.thread_id + "] Complete");
        }
        catch (Exception e) {
            LOG.error("[" + this.thread_id + "] Scanner Exception", (Throwable)e);
            throw new RuntimeException("[" + this.thread_id + "] Scanner exception", e);
        }
    }

    public int purgeTree(int tree_id, boolean delete_definition) throws Exception {
        if (delete_definition) {
            LOG.info("Deleting tree branches and definition for: " + tree_id);
        } else {
            LOG.info("Deleting tree branches for: " + tree_id);
        }
        Tree.deleteTree(this.tsdb, tree_id, delete_definition).joinUninterruptibly();
        LOG.info("Completed tree deletion for: " + tree_id);
        return 0;
    }

    private Scanner getScanner() throws HBaseException {
        short metric_width = TSDB.metrics_width();
        byte[] start_row = Arrays.copyOfRange(Bytes.fromLong((long)this.start_id), 8 - metric_width, 8);
        byte[] end_row = Arrays.copyOfRange(Bytes.fromLong((long)this.end_id), 8 - metric_width, 8);
        LOG.debug("[" + this.thread_id + "] Start row: " + UniqueId.uidToString(start_row));
        LOG.debug("[" + this.thread_id + "] End row: " + UniqueId.uidToString(end_row));
        Scanner scanner = this.tsdb.getClient().newScanner(this.tsdb.metaTable());
        scanner.setStartKey(start_row);
        scanner.setStopKey(end_row);
        scanner.setFamily("name".getBytes(CHARSET));
        scanner.setQualifier("ts_meta".getBytes(CHARSET));
        return scanner;
    }

    static {
        Class<UniqueId> uidclass = UniqueId.class;
        try {
            Field f = uidclass.getDeclaredField("CHARSET");
            f.setAccessible(true);
            CHARSET = (Charset)f.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("static initializer failed", e);
        }
    }
}

