/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tree;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonGenerator;
import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import com.stumbleupon.async.DeferredGroupException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.bind.DatatypeConverter;
import net.opentsdb.core.TSDB;
import net.opentsdb.tree.Leaf;
import net.opentsdb.tree.Tree;
import net.opentsdb.uid.NoSuchUniqueId;
import net.opentsdb.uid.UniqueId;
import net.opentsdb.utils.JSON;
import org.hbase.async.Bytes;
import org.hbase.async.GetRequest;
import org.hbase.async.KeyValue;
import org.hbase.async.PutRequest;
import org.hbase.async.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
public final class Branch
implements Comparable<Branch> {
    private static final Logger LOG = LoggerFactory.getLogger(Branch.class);
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private static final short INT_WIDTH = 4;
    private static final byte[] BRANCH_QUALIFIER = "branch".getBytes(CHARSET);
    private int tree_id;
    private String display_name = "";
    private HashMap<Integer, Leaf> leaves;
    private TreeSet<Branch> branches;
    private TreeMap<Integer, String> path;

    public Branch() {
    }

    public Branch(int tree_id) {
        this.tree_id = tree_id;
    }

    public Branch(Branch original) {
        this.tree_id = original.tree_id;
        this.display_name = original.display_name;
        if (original.leaves != null) {
            this.leaves = new HashMap<Integer, Leaf>(original.leaves);
        }
        if (original.branches != null) {
            this.branches = new TreeSet<Branch>((SortedSet<Branch>)original.branches);
        }
        if (original.path != null) {
            this.path = new TreeMap<Integer, String>((SortedMap<Integer, String>)original.path);
        }
    }

    public int hashCode() {
        if (this.display_name == null || this.display_name.isEmpty()) {
            return 0;
        }
        return this.display_name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Branch branch = (Branch)obj;
        return this.display_name.equals(branch.display_name);
    }

    @Override
    public int compareTo(Branch branch) {
        return this.display_name.compareToIgnoreCase(branch.display_name);
    }

    public String toString() {
        if (this.path == null) {
            return "Name: [" + this.display_name + "]";
        }
        return "ID: [" + this.getBranchId() + "] Name: [" + this.display_name + "]";
    }

    public boolean addChild(Branch branch) {
        if (branch == null) {
            throw new IllegalArgumentException("Null branches are not allowed");
        }
        if (this.branches == null) {
            this.branches = new TreeSet();
            this.branches.add(branch);
            return true;
        }
        if (this.branches.contains(branch)) {
            return false;
        }
        this.branches.add(branch);
        return true;
    }

    public boolean addLeaf(Leaf leaf, Tree tree) {
        if (leaf == null) {
            throw new IllegalArgumentException("Null leaves are not allowed");
        }
        if (this.leaves == null) {
            this.leaves = new HashMap();
            this.leaves.put(leaf.hashCode(), leaf);
            return true;
        }
        if (this.leaves.containsKey(leaf.hashCode())) {
            if (!this.leaves.get(leaf.hashCode()).getTsuid().equals(leaf.getTsuid())) {
                Leaf collision = this.leaves.get(leaf.hashCode());
                if (tree != null) {
                    tree.addCollision(leaf.getTsuid(), collision.getTsuid());
                }
                LOG.warn("Incoming TSUID [" + leaf.getTsuid() + "] collided with existing TSUID [" + collision.getTsuid() + "] on display name [" + collision.getDisplayName() + "]");
            }
            return false;
        }
        this.leaves.put(leaf.hashCode(), leaf);
        return true;
    }

    public byte[] compileBranchId() {
        if (this.tree_id < 1 || this.tree_id > 65535) {
            throw new IllegalArgumentException("Missing or invalid tree ID");
        }
        if (this.path == null) {
            throw new IllegalArgumentException("Missing branch path");
        }
        if (this.display_name == null || this.display_name.isEmpty()) {
            throw new IllegalArgumentException("Missing display name");
        }
        if (this.path.isEmpty()) {
            this.path.put(0, this.display_name);
        } else if (!this.path.lastEntry().getValue().equals(this.display_name)) {
            int depth = this.path.lastEntry().getKey() + 1;
            this.path.put(depth, this.display_name);
        }
        byte[] branch_id = new byte[Tree.TREE_ID_WIDTH() + (this.path.size() - 1) * 4];
        int index = 0;
        byte[] tree_bytes = Tree.idToBytes(this.tree_id);
        System.arraycopy(tree_bytes, 0, branch_id, index, tree_bytes.length);
        index += tree_bytes.length;
        for (Map.Entry<Integer, String> entry : this.path.entrySet()) {
            if (entry.getKey() == 0) continue;
            byte[] hash = Bytes.fromInt((int)entry.getValue().hashCode());
            System.arraycopy(hash, 0, branch_id, index, hash.length);
            index += hash.length;
        }
        return branch_id;
    }

    public void prependParentPath(Map<Integer, String> parent_path) {
        if (parent_path == null) {
            throw new IllegalArgumentException("Parent path was null");
        }
        this.path = new TreeMap();
        this.path.putAll(parent_path);
    }

    public Deferred<ArrayList<Boolean>> storeBranch(TSDB tsdb, Tree tree, boolean store_leaves) {
        if (this.tree_id < 1 || this.tree_id > 65535) {
            throw new IllegalArgumentException("Missing or invalid tree ID");
        }
        ArrayList<Object> storage_results = new ArrayList<Object>(this.leaves != null ? this.leaves.size() + 1 : 1);
        byte[] row = this.compileBranchId();
        byte[] storage_data = this.toStorageJson();
        PutRequest put = new PutRequest(tsdb.treeTable(), row, Tree.TREE_FAMILY(), BRANCH_QUALIFIER, storage_data);
        put.setBufferable(true);
        storage_results.add(tsdb.getClient().compareAndSet(put, new byte[0]));
        if (store_leaves && this.leaves != null && !this.leaves.isEmpty()) {
            for (Leaf leaf : this.leaves.values()) {
                storage_results.add(leaf.storeLeaf(tsdb, row, tree));
            }
        }
        return Deferred.group(storage_results);
    }

    public static Deferred<Branch> fetchBranchOnly(TSDB tsdb, byte[] branch_id) {
        GetRequest get = new GetRequest(tsdb.treeTable(), branch_id);
        get.family(Tree.TREE_FAMILY());
        get.qualifier(BRANCH_QUALIFIER);
        final class GetCB
        implements Callback<Deferred<Branch>, ArrayList<KeyValue>> {
            GetCB() {
            }

            public Deferred<Branch> call(ArrayList<KeyValue> row) throws Exception {
                if (row == null || row.isEmpty()) {
                    return Deferred.fromResult(null);
                }
                Branch branch = JSON.parseToObject(row.get(0).value(), Branch.class);
                branch.tree_id = Tree.bytesToId(row.get(0).key());
                return Deferred.fromResult((Object)branch);
            }
        }
        return tsdb.getClient().get(get).addCallbackDeferring((Callback)new GetCB());
    }

    public static Deferred<Branch> fetchBranch(final TSDB tsdb, final byte[] branch_id, final boolean load_leaf_uids) {
        final Deferred result = new Deferred();
        final Scanner scanner = Branch.setupBranchScanner(tsdb, branch_id);
        final Branch branch = new Branch();
        final ArrayList leaf_group = new ArrayList();
        final class FetchBranchCB
        implements Callback<Object, ArrayList<ArrayList<KeyValue>>> {
            FetchBranchCB() {
            }

            public Object fetchBranch() {
                return scanner.nextRows().addCallback((Callback)this);
            }

            public Object call(ArrayList<ArrayList<KeyValue>> rows) throws Exception {
                if (rows == null) {
                    if (branch.tree_id < 1 || branch.path == null) {
                        result.callback(null);
                    } else {
                        result.callback((Object)branch);
                    }
                    return null;
                }
                for (ArrayList<KeyValue> row : rows) {
                    for (KeyValue column : row) {
                        if (Bytes.equals((byte[])BRANCH_QUALIFIER, (byte[])column.qualifier())) {
                            if (Bytes.equals((byte[])branch_id, (byte[])column.key())) {
                                Branch local_branch = JSON.parseToObject(column.value(), Branch.class);
                                branch.path = local_branch.path;
                                branch.display_name = local_branch.display_name;
                                branch.tree_id = Tree.bytesToId(column.key());
                                continue;
                            }
                            Branch child = JSON.parseToObject(column.value(), Branch.class);
                            child.tree_id = Tree.bytesToId(column.key());
                            branch.addChild(child);
                            continue;
                        }
                        if (Bytes.memcmp((byte[])Leaf.LEAF_PREFIX(), (byte[])column.qualifier(), (int)0, (int)Leaf.LEAF_PREFIX().length) != 0 || !Bytes.equals((byte[])branch_id, (byte[])column.key())) continue;
                        final class LeafCB
                        implements Callback<Object, Leaf> {
                            LeafCB() {
                            }

                            public Object call(Leaf leaf) throws Exception {
                                if (leaf != null) {
                                    if (Branch.this.leaves == null) {
                                        Branch.this.leaves = new HashMap();
                                    }
                                    Branch.this.leaves.put(leaf.hashCode(), leaf);
                                }
                                return null;
                            }
                        }
                        final class LeafErrBack
                        implements Callback<Object, Exception> {
                            final byte[] qualifier;
                            final /* synthetic */ byte[] val$branch_id;

                            public LeafErrBack(byte[] qualifier, byte[] byArray) {
                                this.val$branch_id = byArray;
                                this.qualifier = qualifier;
                            }

                            public Object call(Exception e) throws Exception {
                                Throwable ex = e;
                                while (ex.getClass().equals(DeferredGroupException.class)) {
                                    ex = ex.getCause();
                                }
                                if (!ex.getClass().equals(NoSuchUniqueId.class)) {
                                    throw ex;
                                }
                                LOG.debug("Invalid UID for leaf: " + Branch.idToString(this.qualifier) + " in branch: " + Branch.idToString(this.val$branch_id), ex);
                                return null;
                            }
                        }
                        leaf_group.add(Leaf.parseFromStorage(tsdb, column, load_leaf_uids).addCallbacks((Callback)new LeafCB(), (Callback)new LeafErrBack(column.qualifier(), branch_id)));
                    }
                }
                return this.fetchBranch();
            }
        }
        new FetchBranchCB().fetchBranch();
        return result;
    }

    public static String idToString(byte[] branch_id) {
        return DatatypeConverter.printHexBinary((byte[])branch_id);
    }

    public static byte[] stringToId(String branch_id) {
        if (branch_id == null || branch_id.isEmpty()) {
            throw new IllegalArgumentException("Branch ID was empty");
        }
        if (branch_id.length() < 4) {
            throw new IllegalArgumentException("Branch ID was too short");
        }
        String id = branch_id;
        if (id.length() % 2 != 0) {
            id = "0" + id;
        }
        return DatatypeConverter.parseHexBinary((String)id);
    }

    public static byte[] BRANCH_QUALIFIER() {
        return BRANCH_QUALIFIER;
    }

    private byte[] toStorageJson() {
        ByteArrayOutputStream output = new ByteArrayOutputStream(this.display_name.length() * 2 + this.path.size() * 128);
        try {
            JsonGenerator json = JSON.getFactory().createGenerator((OutputStream)output);
            json.writeStartObject();
            json.writeObjectField("path", this.path);
            json.writeStringField("displayName", this.display_name);
            json.writeEndObject();
            json.close();
            return output.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Scanner setupBranchScanner(TSDB tsdb, byte[] branch_id) {
        byte[] start = branch_id;
        byte[] end = Arrays.copyOf(branch_id, branch_id.length);
        Scanner scanner = tsdb.getClient().newScanner(tsdb.treeTable());
        scanner.setStartKey(start);
        byte[] tree_id = new byte[4];
        for (int i = 0; i < Tree.TREE_ID_WIDTH(); ++i) {
            tree_id[i + (4 - Tree.TREE_ID_WIDTH())] = end[i];
        }
        int id = Bytes.getInt((byte[])tree_id) + 1;
        tree_id = Bytes.fromInt((int)id);
        for (int i = 0; i < Tree.TREE_ID_WIDTH(); ++i) {
            end[i] = tree_id[i + (4 - Tree.TREE_ID_WIDTH())];
        }
        scanner.setStopKey(end);
        scanner.setFamily(Tree.TREE_FAMILY());
        StringBuilder buf = new StringBuilder(start.length * 6 + 20);
        buf.append("(?s)^\\Q");
        for (byte b : start) {
            buf.append((char)(b & 0xFF));
        }
        buf.append("\\E(?:.{").append(4).append("})?$");
        scanner.setKeyRegexp(buf.toString(), CHARSET);
        return scanner;
    }

    public int getTreeId() {
        return this.tree_id;
    }

    public String getBranchId() {
        byte[] id = this.compileBranchId();
        if (id == null) {
            return null;
        }
        return UniqueId.uidToString(id);
    }

    public Map<Integer, String> getPath() {
        this.compileBranchId();
        return this.path;
    }

    public int getDepth() {
        return this.path.lastKey();
    }

    public String getDisplayName() {
        return this.display_name;
    }

    public TreeSet<Leaf> getLeaves() {
        if (this.leaves == null) {
            return null;
        }
        return new TreeSet<Leaf>(this.leaves.values());
    }

    public TreeSet<Branch> getBranches() {
        return this.branches;
    }

    public void setTreeId(int tree_id) {
        this.tree_id = tree_id;
    }

    public void setDisplayName(String display_name) {
        this.display_name = display_name;
    }
}

