/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tree;

import com.fasterxml.jackson.core.JsonGenerator;
import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.opentsdb.core.TSDB;
import net.opentsdb.tree.Branch;
import net.opentsdb.tree.Tree;
import net.opentsdb.uid.UniqueId;
import net.opentsdb.utils.JSON;
import org.hbase.async.Bytes;
import org.hbase.async.GetRequest;
import org.hbase.async.KeyValue;
import org.hbase.async.PutRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Leaf
implements Comparable<Leaf> {
    private static final Logger LOG = LoggerFactory.getLogger(Leaf.class);
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private static final byte[] LEAF_PREFIX = "leaf:".getBytes(CHARSET);
    private String metric = "";
    private HashMap<String, String> tags = null;
    private String display_name = "";
    private String tsuid = "";

    public Leaf() {
    }

    public Leaf(String display_name, String tsuid) {
        this.display_name = display_name;
        this.tsuid = tsuid;
    }

    public int hashCode() {
        return this.display_name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Leaf leaf = (Leaf)obj;
        return this.tsuid.equals(leaf.tsuid);
    }

    @Override
    public int compareTo(Leaf leaf) {
        return this.display_name.compareToIgnoreCase(leaf.display_name);
    }

    public String toString() {
        return "name: " + this.display_name + " tsuid: " + this.tsuid;
    }

    public byte[] columnQualifier() {
        if (this.display_name == null || this.display_name.isEmpty()) {
            throw new IllegalArgumentException("Missing display name");
        }
        byte[] qualifier = new byte[LEAF_PREFIX.length + 4];
        System.arraycopy(LEAF_PREFIX, 0, qualifier, 0, LEAF_PREFIX.length);
        System.arraycopy(Bytes.fromInt((int)this.hashCode()), 0, qualifier, LEAF_PREFIX.length, 4);
        return qualifier;
    }

    public Deferred<Boolean> storeLeaf(final TSDB tsdb, final byte[] branch_id, final Tree tree) {
        PutRequest put = new PutRequest(tsdb.treeTable(), branch_id, Tree.TREE_FAMILY(), this.columnQualifier(), this.toStorageJson());
        final class LeafStoreCB
        implements Callback<Deferred<Boolean>, Boolean> {
            final Leaf local_leaf;

            public LeafStoreCB() {
                this.local_leaf = local_leaf;
            }

            public Deferred<Boolean> call(Boolean success) throws Exception {
                if (success.booleanValue()) {
                    return Deferred.fromResult((Object)success);
                }
                final class LeafFetchCB
                implements Callback<Deferred<Boolean>, Leaf> {
                    LeafFetchCB() {
                    }

                    public Deferred<Boolean> call(Leaf existing_leaf) throws Exception {
                        if (existing_leaf == null) {
                            LOG.error("Returned leaf was null, stored data may be corrupt for leaf: " + Branch.idToString(Leaf.this.columnQualifier()) + " on branch: " + Branch.idToString(branch_id));
                            return Deferred.fromResult((Object)false);
                        }
                        if (existing_leaf.tsuid.equals(Leaf.this.tsuid)) {
                            LOG.debug("Leaf already exists: " + local_leaf);
                            return Deferred.fromResult((Object)true);
                        }
                        tree.addCollision(Leaf.this.tsuid, existing_leaf.tsuid);
                        LOG.warn("Branch ID: [" + Branch.idToString(branch_id) + "] Leaf collision with [" + Leaf.this.tsuid + "] on existing leaf [" + existing_leaf.tsuid + "] named [" + Leaf.this.display_name + "]");
                        return Deferred.fromResult((Object)false);
                    }
                }
                return Leaf.getFromStorage(tsdb, branch_id, Leaf.this.display_name).addCallbackDeferring((Callback)new LeafFetchCB());
            }
        }
        return tsdb.getClient().compareAndSet(put, new byte[0]).addCallbackDeferring((Callback)new LeafStoreCB());
    }

    public static Deferred<Leaf> parseFromStorage(TSDB tsdb, KeyValue column, boolean load_uids) {
        if (column.value() == null) {
            throw new IllegalArgumentException("Leaf column value was null");
        }
        final Leaf leaf = JSON.parseToObject(column.value(), Leaf.class);
        if (leaf.tsuid == null || leaf.tsuid.isEmpty()) {
            LOG.warn("Invalid leaf object in row: " + Branch.idToString(column.key()));
            return Deferred.fromResult(null);
        }
        if (!load_uids) {
            return Deferred.fromResult((Object)leaf);
        }
        List<byte[]> parsed_tags = UniqueId.getTagsFromTSUID(leaf.tsuid);
        final ArrayList<String> tags = new ArrayList<String>(parsed_tags.size());
        for (int i = 0; i < parsed_tags.size(); ++i) {
            tags.add("");
        }
        ArrayList<Deferred> uid_group = new ArrayList<Deferred>(parsed_tags.size() + 1);
        byte[] metric_uid = UniqueId.stringToUid(leaf.tsuid.substring(0, TSDB.metrics_width() * 2));
        final class UIDNameCB
        implements Callback<Object, String> {
            final int index;

            public UIDNameCB(int index) {
                this.index = index;
            }

            public Object call(String name) throws Exception {
                if (this.index < 0) {
                    leaf.metric = name;
                } else {
                    tags.set(this.index, name);
                }
                return null;
            }
        }
        uid_group.add(tsdb.getUidName(UniqueId.UniqueIdType.METRIC, metric_uid).addCallback((Callback)new UIDNameCB(-1)));
        int idx = 0;
        for (byte[] tag : parsed_tags) {
            if (idx % 2 == 0) {
                uid_group.add(tsdb.getUidName(UniqueId.UniqueIdType.TAGK, tag).addCallback((Callback)new UIDNameCB(idx)));
            } else {
                uid_group.add(tsdb.getUidName(UniqueId.UniqueIdType.TAGV, tag).addCallback((Callback)new UIDNameCB(idx)));
            }
            ++idx;
        }
        final class CollateUIDsCB
        implements Callback<Deferred<Leaf>, ArrayList<Object>> {
            CollateUIDsCB() {
            }

            public Deferred<Leaf> call(ArrayList<Object> name_calls) throws Exception {
                int idx = 0;
                String tagk = "";
                Leaf.this.tags = new HashMap(tags.size() / 2);
                for (String name : tags) {
                    if (idx % 2 == 0) {
                        tagk = name;
                    } else {
                        Leaf.this.tags.put(tagk, name);
                    }
                    ++idx;
                }
                return Deferred.fromResult((Object)Leaf.this);
            }
        }
        return Deferred.group(uid_group).addCallbackDeferring((Callback)leaf.new CollateUIDsCB());
    }

    public static byte[] LEAF_PREFIX() {
        return LEAF_PREFIX;
    }

    private byte[] toStorageJson() {
        ByteArrayOutputStream output = new ByteArrayOutputStream(this.display_name.length() + this.tsuid.length() + 30);
        try {
            JsonGenerator json = JSON.getFactory().createGenerator((OutputStream)output);
            json.writeStartObject();
            json.writeObjectField("displayName", (Object)this.display_name);
            json.writeObjectField("tsuid", (Object)this.tsuid);
            json.writeEndObject();
            json.close();
            return output.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Deferred<Leaf> getFromStorage(TSDB tsdb, byte[] branch_id, String display_name) {
        Leaf leaf = new Leaf();
        leaf.setDisplayName(display_name);
        GetRequest get = new GetRequest(tsdb.treeTable(), branch_id);
        get.family(Tree.TREE_FAMILY());
        get.qualifier(leaf.columnQualifier());
        final class GetCB
        implements Callback<Deferred<Leaf>, ArrayList<KeyValue>> {
            GetCB() {
            }

            public Deferred<Leaf> call(ArrayList<KeyValue> row) throws Exception {
                if (row == null || row.isEmpty()) {
                    return Deferred.fromResult(null);
                }
                Leaf leaf = JSON.parseToObject(row.get(0).value(), Leaf.class);
                return Deferred.fromResult((Object)leaf);
            }
        }
        return tsdb.getClient().get(get).addCallbackDeferring((Callback)new GetCB());
    }

    public String getMetric() {
        return this.metric;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String getDisplayName() {
        return this.display_name;
    }

    public String getTsuid() {
        return this.tsuid;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public void setTags(HashMap<String, String> tags) {
        this.tags = tags;
    }

    public void setDisplayName(String display_name) {
        this.display_name = display_name;
    }

    public void setTsuid(String tsuid) {
        this.tsuid = tsuid;
    }
}

