/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tree;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonGenerator;
import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.opentsdb.core.TSDB;
import net.opentsdb.tree.Branch;
import net.opentsdb.tree.Leaf;
import net.opentsdb.tree.TreeRule;
import net.opentsdb.uid.UniqueId;
import net.opentsdb.utils.JSON;
import org.hbase.async.Bytes;
import org.hbase.async.DeleteRequest;
import org.hbase.async.GetRequest;
import org.hbase.async.KeyValue;
import org.hbase.async.PutRequest;
import org.hbase.async.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
public final class Tree {
    private static final Logger LOG = LoggerFactory.getLogger(Tree.class);
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private static final short TREE_ID_WIDTH = 2;
    private static final byte[] TREE_FAMILY = "t".getBytes(CHARSET);
    private static final byte[] TREE_QUALIFIER = "tree".getBytes(CHARSET);
    private static final short INT_WIDTH = 4;
    private static byte COLLISION_ROW_SUFFIX = 1;
    private static byte[] COLLISION_PREFIX = "tree_collision:".getBytes(CHARSET);
    private static byte NOT_MATCHED_ROW_SUFFIX = (byte)2;
    private static byte[] NOT_MATCHED_PREFIX = "tree_not_matched:".getBytes(CHARSET);
    private int tree_id;
    private String name = "";
    private String description = "";
    private String notes = "";
    private boolean strict_match;
    private boolean enabled;
    private boolean store_failures;
    private TreeMap<Integer, TreeMap<Integer, TreeRule>> rules;
    private HashMap<String, String> not_matched;
    private HashMap<String, String> collisions;
    private long created;
    private final HashMap<String, Boolean> changed = new HashMap();

    public Tree() {
        this.initializeChangedMap();
    }

    public Tree(int tree_id) {
        this.tree_id = tree_id;
        this.created = System.currentTimeMillis() / 1000L;
        this.initializeChangedMap();
    }

    public Tree(Tree original) {
        this.created = original.created;
        this.description = original.description;
        this.enabled = original.enabled;
        this.store_failures = original.store_failures;
        this.name = original.name;
        this.notes = original.notes;
        this.strict_match = original.strict_match;
        this.tree_id = original.tree_id;
        this.rules = new TreeMap();
        for (Map.Entry<Integer, TreeMap<Integer, TreeRule>> level : original.rules.entrySet()) {
            TreeMap<Integer, TreeRule> orders = new TreeMap<Integer, TreeRule>();
            for (TreeRule rule : level.getValue().values()) {
                orders.put(rule.getOrder(), new TreeRule(rule));
            }
            this.rules.put(level.getKey(), orders);
        }
        if (original.collisions != null) {
            this.collisions = new HashMap<String, String>(original.collisions);
        }
        if (original.not_matched != null) {
            this.not_matched = new HashMap<String, String>(original.not_matched);
        }
    }

    public String toString() {
        return "treeId: " + this.tree_id + " name: " + this.name;
    }

    public boolean copyChanges(Tree tree, boolean overwrite) {
        if (tree == null) {
            throw new IllegalArgumentException("Cannot copy a null tree");
        }
        if (this.tree_id != tree.tree_id) {
            throw new IllegalArgumentException("Tree IDs do not match");
        }
        if (overwrite || tree.changed.get("name").booleanValue()) {
            this.name = tree.name;
            this.changed.put("name", true);
        }
        if (overwrite || tree.changed.get("description").booleanValue()) {
            this.description = tree.description;
            this.changed.put("description", true);
        }
        if (overwrite || tree.changed.get("notes").booleanValue()) {
            this.notes = tree.notes;
            this.changed.put("notes", true);
        }
        if (overwrite || tree.changed.get("strict_match").booleanValue()) {
            this.strict_match = tree.strict_match;
            this.changed.put("strict_match", true);
        }
        if (overwrite || tree.changed.get("enabled").booleanValue()) {
            this.enabled = tree.enabled;
            this.changed.put("enabled", true);
        }
        if (overwrite || tree.changed.get("store_failures").booleanValue()) {
            this.store_failures = tree.store_failures;
            this.changed.put("store_failures", true);
        }
        for (boolean has_changes : this.changed.values()) {
            if (!has_changes) continue;
            return true;
        }
        return false;
    }

    public void addRule(TreeRule rule) {
        TreeMap<Integer, TreeRule> level;
        if (rule == null) {
            throw new IllegalArgumentException("Null rules are not accepted");
        }
        if (this.rules == null) {
            this.rules = new TreeMap();
        }
        if ((level = this.rules.get(rule.getLevel())) == null) {
            level = new TreeMap();
            level.put(rule.getOrder(), rule);
            this.rules.put(rule.getLevel(), level);
        } else {
            level.put(rule.getOrder(), rule);
        }
        this.changed.put("rules", true);
    }

    public void addCollision(String tsuid, String existing_tsuid) {
        if (tsuid == null || tsuid.isEmpty()) {
            throw new IllegalArgumentException("Empty or null collisions not allowed");
        }
        if (this.collisions == null) {
            this.collisions = new HashMap();
        }
        if (!this.collisions.containsKey(tsuid)) {
            this.collisions.put(tsuid, existing_tsuid);
            this.changed.put("collisions", true);
        }
    }

    public void addNotMatched(String tsuid, String message) {
        if (tsuid == null || tsuid.isEmpty()) {
            throw new IllegalArgumentException("Empty or null non matches not allowed");
        }
        if (this.not_matched == null) {
            this.not_matched = new HashMap();
        }
        if (!this.not_matched.containsKey(tsuid)) {
            this.not_matched.put(tsuid, message);
            this.changed.put("not_matched", true);
        }
    }

    public Deferred<Boolean> storeTree(final TSDB tsdb, final boolean overwrite) {
        if (this.tree_id < 1 || this.tree_id > 65535) {
            throw new IllegalArgumentException("Invalid Tree ID");
        }
        boolean has_changes = false;
        for (Map.Entry<String, Boolean> entry : this.changed.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            has_changes = true;
            break;
        }
        if (!has_changes) {
            LOG.debug(this + " does not have changes, skipping sync to storage");
            throw new IllegalStateException("No changes detected in the tree");
        }
        final class StoreTreeCB
        implements Callback<Deferred<Boolean>, Tree> {
            private final Tree local_tree;

            public StoreTreeCB() {
                this.local_tree = local_tree;
            }

            public Deferred<Boolean> call(Tree fetched_tree) throws Exception {
                byte[] original_tree;
                Tree stored_tree = fetched_tree;
                byte[] byArray = original_tree = stored_tree == null ? new byte[]{} : stored_tree.toStorageJson();
                if (stored_tree == null) {
                    stored_tree = this.local_tree;
                } else {
                    stored_tree.copyChanges(this.local_tree, overwrite);
                }
                Tree.this.initializeChangedMap();
                PutRequest put = new PutRequest(tsdb.treeTable(), Tree.idToBytes(Tree.this.tree_id), TREE_FAMILY, TREE_QUALIFIER, stored_tree.toStorageJson());
                return tsdb.getClient().compareAndSet(put, original_tree);
            }
        }
        return Tree.fetchTree(tsdb, this.tree_id).addCallbackDeferring((Callback)new StoreTreeCB());
    }

    public TreeRule getRule(int level, int order) {
        if (this.rules == null || this.rules.isEmpty()) {
            return null;
        }
        TreeMap<Integer, TreeRule> rule_level = this.rules.get(level);
        if (rule_level == null || rule_level.isEmpty()) {
            return null;
        }
        return rule_level.get(order);
    }

    public Deferred<Integer> createNewTree(final TSDB tsdb) {
        if (this.tree_id > 0) {
            throw new IllegalArgumentException("Tree ID has already been set");
        }
        if (this.name == null || this.name.isEmpty()) {
            throw new IllegalArgumentException("Tree was missing the name");
        }
        final class CreateNewCB
        implements Callback<Deferred<Integer>, List<Tree>> {
            CreateNewCB() {
            }

            public Deferred<Integer> call(List<Tree> trees) throws Exception {
                int max_id = 0;
                if (trees != null) {
                    for (Tree tree : trees) {
                        if (tree.tree_id <= max_id) continue;
                        max_id = tree.tree_id;
                    }
                }
                Tree.this.tree_id = max_id + 1;
                if (Tree.this.tree_id > 65535) {
                    throw new IllegalStateException("Exhausted all Tree IDs");
                }
                final class CreatedCB
                implements Callback<Deferred<Integer>, Boolean> {
                    CreatedCB() {
                    }

                    public Deferred<Integer> call(Boolean cas_success) throws Exception {
                        return Deferred.fromResult((Object)Tree.this.tree_id);
                    }
                }
                return Tree.this.storeTree(tsdb, true).addCallbackDeferring((Callback)new CreatedCB());
            }
        }
        return Tree.fetchAllTrees(tsdb).addCallbackDeferring((Callback)new CreateNewCB());
    }

    public static Deferred<Tree> fetchTree(TSDB tsdb, int tree_id) {
        if (tree_id < 1 || tree_id > 65535) {
            throw new IllegalArgumentException("Invalid Tree ID");
        }
        GetRequest get = new GetRequest(tsdb.treeTable(), Tree.idToBytes(tree_id));
        get.family(TREE_FAMILY);
        final class FetchTreeCB
        implements Callback<Deferred<Tree>, ArrayList<KeyValue>> {
            FetchTreeCB() {
            }

            public Deferred<Tree> call(ArrayList<KeyValue> row) throws Exception {
                if (row == null || row.isEmpty()) {
                    return Deferred.fromResult(null);
                }
                Tree tree = new Tree();
                tree.setTreeId(Tree.bytesToId(row.get(0).key()));
                for (KeyValue column : row) {
                    if (Bytes.memcmp((byte[])TREE_QUALIFIER, (byte[])column.qualifier()) == 0) {
                        Tree local_tree = JSON.parseToObject(column.value(), Tree.class);
                        tree.created = local_tree.created;
                        tree.description = local_tree.description;
                        tree.name = local_tree.name;
                        tree.notes = local_tree.notes;
                        tree.strict_match = local_tree.strict_match;
                        tree.enabled = local_tree.enabled;
                        tree.store_failures = local_tree.store_failures;
                        continue;
                    }
                    if (Bytes.memcmp((byte[])TreeRule.RULE_PREFIX(), (byte[])column.qualifier(), (int)0, (int)TreeRule.RULE_PREFIX().length) != 0) continue;
                    TreeRule rule = TreeRule.parseFromStorage(column);
                    tree.addRule(rule);
                }
                return Deferred.fromResult((Object)tree);
            }
        }
        return tsdb.getClient().get(get).addCallbackDeferring((Callback)new FetchTreeCB());
    }

    public static Deferred<List<Tree>> fetchAllTrees(final TSDB tsdb) {
        final Deferred result = new Deferred();
        final class AllTreeScanner
        implements Callback<Object, ArrayList<ArrayList<KeyValue>>> {
            private final List<Tree> trees = new ArrayList<Tree>();
            private final Scanner scanner = Tree.access$1200(tsdb);

            public Object fetchTrees() {
                return this.scanner.nextRows().addCallback((Callback)this);
            }

            public Object call(ArrayList<ArrayList<KeyValue>> rows) throws Exception {
                if (rows == null) {
                    result.callback(this.trees);
                    return null;
                }
                for (ArrayList<KeyValue> row : rows) {
                    Tree tree = new Tree();
                    for (KeyValue column : row) {
                        if (column.qualifier().length >= TREE_QUALIFIER.length && Bytes.memcmp((byte[])TREE_QUALIFIER, (byte[])column.qualifier()) == 0) {
                            Tree local_tree = JSON.parseToObject(column.value(), Tree.class);
                            tree.created = local_tree.created;
                            tree.description = local_tree.description;
                            tree.name = local_tree.name;
                            tree.notes = local_tree.notes;
                            tree.strict_match = local_tree.strict_match;
                            tree.enabled = local_tree.enabled;
                            tree.store_failures = local_tree.store_failures;
                            tree.setTreeId(Tree.bytesToId(row.get(0).key()));
                            continue;
                        }
                        if (column.qualifier().length <= TreeRule.RULE_PREFIX().length || Bytes.memcmp((byte[])TreeRule.RULE_PREFIX(), (byte[])column.qualifier(), (int)0, (int)TreeRule.RULE_PREFIX().length) != 0) continue;
                        TreeRule rule = TreeRule.parseFromStorage(column);
                        tree.addRule(rule);
                    }
                    if (tree.tree_id <= 0) continue;
                    this.trees.add(tree);
                }
                return this.fetchTrees();
            }
        }
        new AllTreeScanner().fetchTrees();
        return result;
    }

    public static Deferred<Map<String, String>> fetchCollisions(TSDB tsdb, int tree_id, List<String> tsuids) {
        if (tree_id < 1 || tree_id > 65535) {
            throw new IllegalArgumentException("Invalid Tree ID");
        }
        byte[] row_key = new byte[3];
        System.arraycopy(Tree.idToBytes(tree_id), 0, row_key, 0, 2);
        row_key[2] = COLLISION_ROW_SUFFIX;
        GetRequest get = new GetRequest(tsdb.treeTable(), row_key);
        get.family(TREE_FAMILY);
        if (tsuids != null && !tsuids.isEmpty()) {
            byte[][] qualifiers = new byte[tsuids.size()][];
            int index = 0;
            for (String tsuid : tsuids) {
                byte[] qualifier = new byte[COLLISION_PREFIX.length + tsuid.length() / 2];
                System.arraycopy(COLLISION_PREFIX, 0, qualifier, 0, COLLISION_PREFIX.length);
                byte[] tsuid_bytes = UniqueId.stringToUid(tsuid);
                System.arraycopy(tsuid_bytes, 0, qualifier, COLLISION_PREFIX.length, tsuid_bytes.length);
                qualifiers[index] = qualifier;
                ++index;
            }
            get.qualifiers((byte[][])qualifiers);
        }
        final class GetCB
        implements Callback<Deferred<Map<String, String>>, ArrayList<KeyValue>> {
            GetCB() {
            }

            public Deferred<Map<String, String>> call(ArrayList<KeyValue> row) throws Exception {
                if (row == null || row.isEmpty()) {
                    HashMap empty = new HashMap(0);
                    return Deferred.fromResult(empty);
                }
                HashMap<String, String> collisions = new HashMap<String, String>(row.size());
                for (KeyValue column : row) {
                    if (column.qualifier().length <= COLLISION_PREFIX.length || Bytes.memcmp((byte[])COLLISION_PREFIX, (byte[])column.qualifier(), (int)0, (int)COLLISION_PREFIX.length) != 0) continue;
                    byte[] parsed_tsuid = Arrays.copyOfRange(column.qualifier(), COLLISION_PREFIX.length, column.qualifier().length);
                    collisions.put(UniqueId.uidToString(parsed_tsuid), new String(column.value(), CHARSET));
                }
                return Deferred.fromResult(collisions);
            }
        }
        return tsdb.getClient().get(get).addCallbackDeferring((Callback)new GetCB());
    }

    public static Deferred<Map<String, String>> fetchNotMatched(TSDB tsdb, int tree_id, List<String> tsuids) {
        if (tree_id < 1 || tree_id > 65535) {
            throw new IllegalArgumentException("Invalid Tree ID");
        }
        byte[] row_key = new byte[3];
        System.arraycopy(Tree.idToBytes(tree_id), 0, row_key, 0, 2);
        row_key[2] = NOT_MATCHED_ROW_SUFFIX;
        GetRequest get = new GetRequest(tsdb.treeTable(), row_key);
        get.family(TREE_FAMILY);
        if (tsuids != null && !tsuids.isEmpty()) {
            byte[][] qualifiers = new byte[tsuids.size()][];
            int index = 0;
            for (String tsuid : tsuids) {
                byte[] qualifier = new byte[NOT_MATCHED_PREFIX.length + tsuid.length() / 2];
                System.arraycopy(NOT_MATCHED_PREFIX, 0, qualifier, 0, NOT_MATCHED_PREFIX.length);
                byte[] tsuid_bytes = UniqueId.stringToUid(tsuid);
                System.arraycopy(tsuid_bytes, 0, qualifier, NOT_MATCHED_PREFIX.length, tsuid_bytes.length);
                qualifiers[index] = qualifier;
                ++index;
            }
            get.qualifiers((byte[][])qualifiers);
        }
        final class GetCB
        implements Callback<Deferred<Map<String, String>>, ArrayList<KeyValue>> {
            GetCB() {
            }

            public Deferred<Map<String, String>> call(ArrayList<KeyValue> row) throws Exception {
                if (row == null || row.isEmpty()) {
                    HashMap empty = new HashMap(0);
                    return Deferred.fromResult(empty);
                }
                HashMap<String, String> not_matched = new HashMap<String, String>(row.size());
                for (KeyValue column : row) {
                    byte[] parsed_tsuid = Arrays.copyOfRange(column.qualifier(), NOT_MATCHED_PREFIX.length, column.qualifier().length);
                    not_matched.put(UniqueId.uidToString(parsed_tsuid), new String(column.value(), CHARSET));
                }
                return Deferred.fromResult(not_matched);
            }
        }
        return tsdb.getClient().get(get).addCallbackDeferring((Callback)new GetCB());
    }

    public static Deferred<Boolean> deleteTree(final TSDB tsdb, int tree_id, final boolean delete_definition) {
        if (tree_id < 1 || tree_id > 65535) {
            throw new IllegalArgumentException("Invalid Tree ID");
        }
        byte[] start = Tree.idToBytes(tree_id);
        byte[] end = Tree.idToBytes(tree_id + 1);
        final Scanner scanner = tsdb.getClient().newScanner(tsdb.treeTable());
        scanner.setStartKey(start);
        scanner.setStopKey(end);
        scanner.setFamily(TREE_FAMILY);
        final Deferred completed = new Deferred();
        final class DeleteTreeScanner
        implements Callback<Deferred<Boolean>, ArrayList<ArrayList<KeyValue>>> {
            private final ArrayList<Deferred<Object>> delete_deferreds = new ArrayList();

            DeleteTreeScanner() {
            }

            public Deferred<Boolean> deleteTree() {
                return scanner.nextRows().addCallbackDeferring((Callback)this);
            }

            public Deferred<Boolean> call(ArrayList<ArrayList<KeyValue>> rows) throws Exception {
                if (rows == null) {
                    completed.callback((Object)true);
                    return null;
                }
                for (ArrayList<KeyValue> row : rows) {
                    ArrayList<byte[]> qualifiers = new ArrayList<byte[]>(row.size());
                    for (KeyValue column : row) {
                        if (delete_definition && Bytes.equals((byte[])TREE_QUALIFIER, (byte[])column.qualifier())) {
                            LOG.trace("Deleting tree defnition in row: " + Branch.idToString(column.key()));
                            qualifiers.add(column.qualifier());
                            continue;
                        }
                        if (Bytes.equals((byte[])Branch.BRANCH_QUALIFIER(), (byte[])column.qualifier())) {
                            LOG.trace("Deleting branch in row: " + Branch.idToString(column.key()));
                            qualifiers.add(column.qualifier());
                            continue;
                        }
                        if (column.qualifier().length > Leaf.LEAF_PREFIX().length && Bytes.memcmp((byte[])Leaf.LEAF_PREFIX(), (byte[])column.qualifier(), (int)0, (int)Leaf.LEAF_PREFIX().length) == 0) {
                            LOG.trace("Deleting leaf in row: " + Branch.idToString(column.key()));
                            qualifiers.add(column.qualifier());
                            continue;
                        }
                        if (column.qualifier().length > COLLISION_PREFIX.length && Bytes.memcmp((byte[])COLLISION_PREFIX, (byte[])column.qualifier(), (int)0, (int)COLLISION_PREFIX.length) == 0) {
                            LOG.trace("Deleting collision in row: " + Branch.idToString(column.key()));
                            qualifiers.add(column.qualifier());
                            continue;
                        }
                        if (column.qualifier().length > NOT_MATCHED_PREFIX.length && Bytes.memcmp((byte[])NOT_MATCHED_PREFIX, (byte[])column.qualifier(), (int)0, (int)NOT_MATCHED_PREFIX.length) == 0) {
                            LOG.trace("Deleting not matched in row: " + Branch.idToString(column.key()));
                            qualifiers.add(column.qualifier());
                            continue;
                        }
                        if (!delete_definition || column.qualifier().length <= TreeRule.RULE_PREFIX().length || Bytes.memcmp((byte[])TreeRule.RULE_PREFIX(), (byte[])column.qualifier(), (int)0, (int)TreeRule.RULE_PREFIX().length) != 0) continue;
                        LOG.trace("Deleting tree rule in row: " + Branch.idToString(column.key()));
                        qualifiers.add(column.qualifier());
                    }
                    if (qualifiers.size() <= 0) continue;
                    DeleteRequest delete = new DeleteRequest(tsdb.treeTable(), row.get(0).key(), TREE_FAMILY, (byte[][])qualifiers.toArray((T[])new byte[qualifiers.size()][]));
                    this.delete_deferreds.add((Deferred<Object>)tsdb.getClient().delete(delete));
                }
                final class ContinueCB
                implements Callback<Deferred<Boolean>, ArrayList<Object>> {
                    ContinueCB() {
                    }

                    public Deferred<Boolean> call(ArrayList<Object> objects) {
                        LOG.debug("Purged [" + objects.size() + "] columns, continuing");
                        delete_deferreds.clear();
                        return this.deleteTree();
                    }
                }
                Deferred.group(this.delete_deferreds).addCallbackDeferring((Callback)new ContinueCB());
                return null;
            }
        }
        new DeleteTreeScanner().deleteTree();
        return completed;
    }

    public static byte[] idToBytes(int tree_id) {
        if (tree_id < 1 || tree_id > 65535) {
            throw new IllegalArgumentException("Missing or invalid tree ID");
        }
        byte[] id = Bytes.fromInt((int)tree_id);
        return Arrays.copyOfRange(id, id.length - 2, id.length);
    }

    public static int bytesToId(byte[] row_key) {
        if (row_key.length < 2) {
            throw new IllegalArgumentException("Row key was less than 2 in length");
        }
        byte[] tree_id = new byte[4];
        System.arraycopy(row_key, 0, tree_id, 4 - Tree.TREE_ID_WIDTH(), Tree.TREE_ID_WIDTH());
        return Bytes.getInt((byte[])tree_id);
    }

    public static byte[] COLLISION_PREFIX() {
        return COLLISION_PREFIX;
    }

    public static byte[] NOT_MATCHED_PREFIX() {
        return NOT_MATCHED_PREFIX;
    }

    public static byte[] TREE_FAMILY() {
        return TREE_FAMILY;
    }

    private void initializeChangedMap() {
        this.changed.put("name", false);
        this.changed.put("field", false);
        this.changed.put("description", false);
        this.changed.put("notes", false);
        this.changed.put("strict_match", false);
        this.changed.put("rules", false);
        this.changed.put("not_matched", false);
        this.changed.put("collisions", false);
        this.changed.put("created", false);
        this.changed.put("last_update", false);
        this.changed.put("version", false);
        this.changed.put("node_separator", false);
        this.changed.put("enabled", false);
        this.changed.put("store_failures", false);
    }

    private byte[] toStorageJson() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            JsonGenerator json = JSON.getFactory().createGenerator((OutputStream)output);
            json.writeStartObject();
            json.writeStringField("name", this.name);
            json.writeStringField("description", this.description);
            json.writeStringField("notes", this.notes);
            json.writeBooleanField("strictMatch", this.strict_match);
            json.writeNumberField("created", this.created);
            json.writeBooleanField("enabled", this.enabled);
            json.writeBooleanField("storeFailures", this.store_failures);
            json.writeEndObject();
            json.close();
            return output.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Scanner setupAllTreeScanner(TSDB tsdb) {
        byte[] start = new byte[2];
        byte[] end = new byte[2];
        Arrays.fill(end, (byte)-1);
        Scanner scanner = tsdb.getClient().newScanner(tsdb.treeTable());
        scanner.setStartKey(start);
        scanner.setStopKey(end);
        scanner.setFamily(TREE_FAMILY);
        StringBuilder buf = new StringBuilder(20);
        buf.append("(?s)^\\Q");
        buf.append("\\E(?:.{").append(2).append("})$");
        scanner.setKeyRegexp(buf.toString(), CHARSET);
        return scanner;
    }

    public Deferred<Boolean> flushCollisions(TSDB tsdb) {
        if (!this.store_failures) {
            this.collisions.clear();
            return Deferred.fromResult((Object)true);
        }
        byte[] row_key = new byte[3];
        System.arraycopy(Tree.idToBytes(this.tree_id), 0, row_key, 0, 2);
        row_key[2] = COLLISION_ROW_SUFFIX;
        byte[][] qualifiers = new byte[this.collisions.size()][];
        byte[][] values = new byte[this.collisions.size()][];
        int index = 0;
        for (Map.Entry<String, String> entry : this.collisions.entrySet()) {
            qualifiers[index] = new byte[COLLISION_PREFIX.length + entry.getKey().length() / 2];
            System.arraycopy(COLLISION_PREFIX, 0, qualifiers[index], 0, COLLISION_PREFIX.length);
            byte[] tsuid = UniqueId.stringToUid(entry.getKey());
            System.arraycopy(tsuid, 0, qualifiers[index], COLLISION_PREFIX.length, tsuid.length);
            values[index] = entry.getValue().getBytes(CHARSET);
            ++index;
        }
        PutRequest put = new PutRequest(tsdb.treeTable(), row_key, TREE_FAMILY, (byte[][])qualifiers, (byte[][])values);
        this.collisions.clear();
        final class PutCB
        implements Callback<Deferred<Boolean>, Object> {
            PutCB() {
            }

            public Deferred<Boolean> call(Object result) throws Exception {
                return Deferred.fromResult((Object)true);
            }
        }
        return tsdb.getClient().put(put).addCallbackDeferring((Callback)new PutCB());
    }

    public Deferred<Boolean> flushNotMatched(TSDB tsdb) {
        if (!this.store_failures) {
            this.not_matched.clear();
            return Deferred.fromResult((Object)true);
        }
        byte[] row_key = new byte[3];
        System.arraycopy(Tree.idToBytes(this.tree_id), 0, row_key, 0, 2);
        row_key[2] = NOT_MATCHED_ROW_SUFFIX;
        byte[][] qualifiers = new byte[this.not_matched.size()][];
        byte[][] values = new byte[this.not_matched.size()][];
        int index = 0;
        for (Map.Entry<String, String> entry : this.not_matched.entrySet()) {
            qualifiers[index] = new byte[NOT_MATCHED_PREFIX.length + entry.getKey().length() / 2];
            System.arraycopy(NOT_MATCHED_PREFIX, 0, qualifiers[index], 0, NOT_MATCHED_PREFIX.length);
            byte[] tsuid = UniqueId.stringToUid(entry.getKey());
            System.arraycopy(tsuid, 0, qualifiers[index], NOT_MATCHED_PREFIX.length, tsuid.length);
            values[index] = entry.getValue().getBytes(CHARSET);
            ++index;
        }
        PutRequest put = new PutRequest(tsdb.treeTable(), row_key, TREE_FAMILY, (byte[][])qualifiers, (byte[][])values);
        this.not_matched.clear();
        final class PutCB
        implements Callback<Deferred<Boolean>, Object> {
            PutCB() {
            }

            public Deferred<Boolean> call(Object result) throws Exception {
                return Deferred.fromResult((Object)true);
            }
        }
        return tsdb.getClient().put(put).addCallbackDeferring((Callback)new PutCB());
    }

    public static int TREE_ID_WIDTH() {
        return 2;
    }

    public int getTreeId() {
        return this.tree_id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNotes() {
        return this.notes;
    }

    public boolean getStrictMatch() {
        return this.strict_match;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean getStoreFailures() {
        return this.store_failures;
    }

    public Map<Integer, TreeMap<Integer, TreeRule>> getRules() {
        return this.rules;
    }

    @JsonIgnore
    public Map<String, String> getNotMatched() {
        return this.not_matched;
    }

    @JsonIgnore
    public Map<String, String> getCollisions() {
        return this.collisions;
    }

    public long getCreated() {
        return this.created;
    }

    public void setName(String name) {
        if (!this.name.equals(name)) {
            this.changed.put("name", true);
            this.name = name;
        }
    }

    public void setDescription(String description) {
        if (!this.description.equals(description)) {
            this.changed.put("description", true);
            this.description = description;
        }
    }

    public void setNotes(String notes) {
        if (!this.notes.equals(notes)) {
            this.changed.put("notes", true);
            this.notes = notes;
        }
    }

    public void setStrictMatch(boolean strict_match) {
        this.changed.put("strict_match", true);
        this.strict_match = strict_match;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.changed.put("enabled", true);
    }

    public void setStoreFailures(boolean store_failures) {
        this.store_failures = store_failures;
        this.changed.put("store_failures", true);
    }

    public void setTreeId(int treeId) {
        this.tree_id = treeId;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    static /* synthetic */ Scanner access$1200(TSDB x0) {
        return Tree.setupAllTreeScanner(x0);
    }
}

