/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tree;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import net.opentsdb.core.TSDB;
import net.opentsdb.meta.TSMeta;
import net.opentsdb.meta.UIDMeta;
import net.opentsdb.tree.Branch;
import net.opentsdb.tree.Leaf;
import net.opentsdb.tree.Tree;
import net.opentsdb.tree.TreeRule;
import net.opentsdb.uid.UniqueId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TreeBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(TreeBuilder.class);
    private static final List<Tree> trees = new ArrayList<Tree>();
    private static final ConcurrentHashMap<Integer, Branch> tree_roots = new ConcurrentHashMap();
    private static long last_tree_load;
    private static final Lock trees_lock;
    private final TSDB tsdb;
    private Branch root;
    private int max_rule_level;
    private ArrayList<String> test_messages;
    private Tree tree;
    private TSMeta meta;
    private String[] splits;
    private int rule_idx;
    private int split_idx;
    private Branch current_branch;
    private TreeRule rule;
    private String not_matched;
    private final HashMap<String, Boolean> processed_branches = new HashMap();

    public TreeBuilder(TSDB tsdb, Tree tree) {
        this.tsdb = tsdb;
        this.tree = tree;
        this.calculateMaxLevel();
    }

    public Deferred<ArrayList<Boolean>> processTimeseriesMeta(TSMeta meta) {
        if (this.tree == null || this.tree.getTreeId() < 1) {
            throw new IllegalArgumentException("The tree has not been set or is invalid");
        }
        return this.processTimeseriesMeta(meta, false);
    }

    public Deferred<ArrayList<Boolean>> processTimeseriesMeta(final TSMeta meta, final boolean is_testing) {
        if (this.tree == null || this.tree.getTreeId() < 1) {
            throw new IllegalArgumentException("The tree has not been set or is invalid");
        }
        if (meta == null || meta.getTSUID() == null || meta.getTSUID().isEmpty()) {
            throw new IllegalArgumentException("Missing TSUID");
        }
        this.resetState();
        this.meta = meta;
        final ArrayList storage_calls = new ArrayList();
        LOG.debug("Processing meta [" + meta + "] through tree: " + this.tree.getTreeId());
        if (this.root == null) {
            LOG.debug("Fetching root branch for tree: " + this.tree.getTreeId());
            final class LoadRootCB
            implements Callback<Deferred<ArrayList<Boolean>>, Branch> {
                LoadRootCB() {
                }

                public Deferred<ArrayList<Boolean>> call(Branch root) throws Exception {
                    TreeBuilder.this.root = root;
                    final class ProcessCB
                    implements Callback<Deferred<ArrayList<Boolean>>, Branch> {
                        final /* synthetic */ TSMeta val$meta;
                        final /* synthetic */ boolean val$is_testing;
                        final /* synthetic */ ArrayList val$storage_calls;

                        ProcessCB() {
                            this.val$meta = tSMeta;
                            this.val$is_testing = bl;
                            this.val$storage_calls = arrayList;
                        }

                        public Deferred<ArrayList<Boolean>> call(Branch branch) throws Exception {
                            TreeBuilder.this.processRuleset(branch, 1);
                            if (TreeBuilder.this.not_matched != null && !TreeBuilder.this.not_matched.isEmpty() && TreeBuilder.this.tree.getStrictMatch()) {
                                TreeBuilder.this.testMessage("TSUID failed to match one or more rule levels, will not add: " + this.val$meta);
                                if (!this.val$is_testing && TreeBuilder.this.tree.getNotMatched() != null && !TreeBuilder.this.tree.getNotMatched().isEmpty()) {
                                    TreeBuilder.this.tree.addNotMatched(this.val$meta.getTSUID(), TreeBuilder.this.not_matched);
                                    this.val$storage_calls.add(TreeBuilder.this.tree.flushNotMatched(TreeBuilder.this.tsdb));
                                }
                            } else if (TreeBuilder.this.current_branch == null) {
                                LOG.warn("Processed TSUID [" + this.val$meta + "] resulted in a null branch on tree: " + TreeBuilder.this.tree.getTreeId());
                            } else if (!this.val$is_testing) {
                                Branch cb = TreeBuilder.this.current_branch;
                                Map<Integer, String> path = branch.getPath();
                                cb.prependParentPath(path);
                                while (cb != null) {
                                    if (cb.getLeaves() != null || !TreeBuilder.this.processed_branches.containsKey(cb.getBranchId())) {
                                        LOG.debug("Flushing branch to storage: " + cb);
                                        final class BranchCB
                                        implements Callback<Deferred<Boolean>, ArrayList<Boolean>> {
                                            BranchCB() {
                                            }

                                            public Deferred<Boolean> call(ArrayList<Boolean> deferreds) throws Exception {
                                                for (Boolean success : deferreds) {
                                                    if (success.booleanValue()) continue;
                                                    return Deferred.fromResult((Object)false);
                                                }
                                                return Deferred.fromResult((Object)true);
                                            }
                                        }
                                        Deferred deferred = cb.storeBranch(TreeBuilder.this.tsdb, TreeBuilder.this.tree, true).addCallbackDeferring((Callback)new BranchCB());
                                        this.val$storage_calls.add(deferred);
                                        TreeBuilder.this.processed_branches.put(cb.getBranchId(), true);
                                    }
                                    if (cb.getBranches() == null) {
                                        cb = null;
                                        continue;
                                    }
                                    path = cb.getPath();
                                    cb = cb.getBranches().first();
                                    cb.prependParentPath(path);
                                }
                                if (TreeBuilder.this.tree.getCollisions() != null && !TreeBuilder.this.tree.getCollisions().isEmpty()) {
                                    this.val$storage_calls.add(TreeBuilder.this.tree.flushCollisions(TreeBuilder.this.tsdb));
                                }
                            } else {
                                Branch cb = TreeBuilder.this.current_branch;
                                branch.addChild(cb);
                                Map<Integer, String> path = branch.getPath();
                                cb.prependParentPath(path);
                                while (cb != null) {
                                    if (cb.getBranches() == null) {
                                        cb = null;
                                        continue;
                                    }
                                    path = cb.getPath();
                                    cb = cb.getBranches().first();
                                    cb.prependParentPath(path);
                                }
                            }
                            LOG.debug("Completed processing meta [" + this.val$meta + "] through tree: " + TreeBuilder.this.tree.getTreeId());
                            return Deferred.group((Collection)this.val$storage_calls);
                        }
                    }
                    return new ProcessCB(TreeBuilder.this, meta, is_testing, storage_calls).call(root);
                }
            }
            return TreeBuilder.loadOrInitializeRoot(this.tsdb, this.tree.getTreeId(), is_testing).addCallbackDeferring((Callback)new LoadRootCB());
        }
        try {
            return new ProcessCB().call(this.root);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initiate processing", e);
        }
    }

    public static Deferred<Branch> loadOrInitializeRoot(final TSDB tsdb, final int tree_id, final boolean is_testing) {
        Branch cached = tree_roots.get(tree_id);
        if (cached != null) {
            LOG.debug("Loaded cached root for tree: " + tree_id);
            return Deferred.fromResult((Object)new Branch(cached));
        }
        LOG.debug("Loading or initializing root for tree: " + tree_id);
        final class RootCB
        implements Callback<Deferred<Branch>, Branch> {
            RootCB() {
            }

            public Deferred<Branch> call(Branch branch) throws Exception {
                if (branch == null) {
                    LOG.info("Couldn't find the root branch, initializing");
                    Branch root = new Branch(tree_id);
                    root.setDisplayName("ROOT");
                    TreeMap<Integer, String> root_path = new TreeMap<Integer, String>();
                    root_path.put(0, "ROOT");
                    root.prependParentPath(root_path);
                    if (is_testing) {
                        return Deferred.fromResult((Object)root);
                    }
                    final class NewRootCB
                    implements Callback<Deferred<Branch>, ArrayList<Boolean>> {
                        final Branch root;
                        final /* synthetic */ int val$tree_id;

                        public NewRootCB(Branch root) {
                            this.val$tree_id = n;
                            this.root = root;
                        }

                        public Deferred<Branch> call(ArrayList<Boolean> storage_call) throws Exception {
                            LOG.info("Initialized root branch for tree: " + this.val$tree_id);
                            tree_roots.put(this.val$tree_id, this.root);
                            return Deferred.fromResult((Object)new Branch(this.root));
                        }
                    }
                    return root.storeBranch(tsdb, null, true).addCallbackDeferring((Callback)new NewRootCB(root, tree_id));
                }
                return Deferred.fromResult((Object)branch);
            }
        }
        return Branch.fetchBranchOnly(tsdb, Tree.idToBytes(tree_id)).addCallbackDeferring((Callback)new RootCB());
    }

    public static Deferred<Boolean> processAllTrees(final TSDB tsdb, final TSMeta meta) {
        final class ProcessTreesCB
        implements Callback<Deferred<Boolean>, List<Tree>> {
            ArrayList<Deferred<ArrayList<Boolean>>> processed_trees;

            ProcessTreesCB() {
            }

            public Deferred<Boolean> call(List<Tree> trees) throws Exception {
                if (trees == null || trees.isEmpty()) {
                    LOG.debug("No trees found to process meta through");
                    return Deferred.fromResult((Object)false);
                }
                LOG.debug("Loaded [" + trees.size() + "] trees");
                this.processed_trees = new ArrayList(trees.size());
                for (Tree tree : trees) {
                    if (!tree.getEnabled()) continue;
                    TreeBuilder builder = new TreeBuilder(tsdb, new Tree(tree));
                    this.processed_trees.add(builder.processTimeseriesMeta(meta, false));
                }
                final class FinalCB
                implements Callback<Boolean, ArrayList<ArrayList<Boolean>>> {
                    FinalCB() {
                    }

                    public Boolean call(ArrayList<ArrayList<Boolean>> groups) throws Exception {
                        return true;
                    }
                }
                return Deferred.group(this.processed_trees).addCallback((Callback)new FinalCB());
            }
        }
        trees_lock.lock();
        if (System.currentTimeMillis() / 1000L - last_tree_load > 300L) {
            final class FetchedTreesCB
            implements Callback<List<Tree>, List<Tree>> {
                FetchedTreesCB() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public List<Tree> call(List<Tree> loaded_trees) throws Exception {
                    ArrayList<Tree> local_trees;
                    List list = trees;
                    synchronized (list) {
                        trees.clear();
                        for (Tree tree : loaded_trees) {
                            if (!tree.getEnabled()) continue;
                            trees.add(tree);
                        }
                        local_trees = new ArrayList<Tree>(trees.size());
                        local_trees.addAll(trees);
                    }
                    trees_lock.unlock();
                    return local_trees;
                }
            }
            final class ErrorCB
            implements Callback<Object, Exception> {
                ErrorCB() {
                }

                public Object call(Exception e) throws Exception {
                    trees_lock.unlock();
                    throw e;
                }
            }
            Deferred load_deferred = Tree.fetchAllTrees(tsdb).addCallback((Callback)new FetchedTreesCB()).addErrback((Callback)new ErrorCB());
            last_tree_load = System.currentTimeMillis() / 1000L;
            return load_deferred.addCallbackDeferring((Callback)new ProcessTreesCB());
        }
        if (trees.isEmpty()) {
            LOG.debug("No trees were found to process the meta through");
            trees_lock.unlock();
            return Deferred.fromResult((Object)true);
        }
        ArrayList<Tree> local_trees = new ArrayList<Tree>(trees.size());
        local_trees.addAll(trees);
        trees_lock.unlock();
        try {
            return new ProcessTreesCB().call(local_trees);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process trees", e);
        }
    }

    private boolean processRuleset(Branch parent_branch, int depth) {
        if (this.rule_idx > this.max_rule_level) {
            return true;
        }
        Branch previous_branch = this.current_branch;
        this.current_branch = new Branch(this.tree.getTreeId());
        TreeMap<Integer, TreeRule> rule_level = this.fetchRuleLevel();
        if (rule_level == null) {
            return true;
        }
        for (Map.Entry<Integer, TreeRule> entry : rule_level.entrySet()) {
            this.rule = entry.getValue();
            this.testMessage("Processing rule: " + this.rule);
            if (this.rule.getType() == TreeRule.TreeRuleType.METRIC) {
                this.parseMetricRule();
            } else if (this.rule.getType() == TreeRule.TreeRuleType.TAGK) {
                this.parseTagkRule();
            } else if (this.rule.getType() == TreeRule.TreeRuleType.METRIC_CUSTOM) {
                this.parseMetricCustomRule();
            } else if (this.rule.getType() == TreeRule.TreeRuleType.TAGK_CUSTOM) {
                this.parseTagkCustomRule();
            } else if (this.rule.getType() == TreeRule.TreeRuleType.TAGV_CUSTOM) {
                this.parseTagvRule();
            } else {
                throw new IllegalArgumentException("Unkown rule type: " + (Object)((Object)this.rule.getType()));
            }
            if (this.current_branch.getDisplayName() == null || this.current_branch.getDisplayName().isEmpty()) continue;
            break;
        }
        if (this.current_branch.getDisplayName() == null || this.current_branch.getDisplayName().isEmpty()) {
            this.not_matched = this.not_matched == null ? new String(this.rule.toString()) : this.not_matched + " " + this.rule;
        }
        if (this.splits != null && this.split_idx >= this.splits.length) {
            this.splits = null;
            this.split_idx = 0;
            ++this.rule_idx;
        } else if (this.splits == null) {
            ++this.rule_idx;
        }
        boolean complete = this.processRuleset(this.current_branch, ++depth);
        if (complete) {
            if (this.current_branch == null || this.current_branch.getDisplayName() == null || this.current_branch.getDisplayName().isEmpty()) {
                LOG.trace("Got to a null branch");
                this.current_branch = previous_branch;
                return true;
            }
            if (parent_branch.getDisplayName() == null || parent_branch.getDisplayName().isEmpty()) {
                this.testMessage("Depth [" + depth + "] Parent branch was empty, rolling back");
                return true;
            }
            Leaf leaf = new Leaf(this.current_branch.getDisplayName(), this.meta.getTSUID());
            parent_branch.addLeaf(leaf, this.tree);
            this.testMessage("Depth [" + depth + "] Adding leaf [" + leaf + "] to parent branch [" + parent_branch + "]");
            this.current_branch = previous_branch;
            return false;
        }
        if ((previous_branch == null || previous_branch.getDisplayName().isEmpty()) && !this.current_branch.getDisplayName().isEmpty()) {
            if (depth > 2) {
                this.testMessage("Depth [" + depth + "] Skipping a non-matched branch, returning: " + this.current_branch);
            }
            return false;
        }
        if (this.current_branch.getDisplayName() == null || this.current_branch.getDisplayName().isEmpty()) {
            this.testMessage("Depth [" + depth + "] Branch was empty");
            this.current_branch = previous_branch;
            return false;
        }
        if (this.current_branch.getDisplayName().equals(previous_branch.getDisplayName())) {
            this.testMessage("Depth [" + depth + "] Current was the same as previous");
            return false;
        }
        parent_branch.addChild(this.current_branch);
        this.testMessage("Depth [" + depth + "] Adding branch: " + this.current_branch + " to parent: " + parent_branch);
        this.current_branch = previous_branch;
        return false;
    }

    private void parseMetricRule() {
        if (this.meta.getMetric() == null) {
            throw new IllegalStateException("Timeseries metric UID object was null");
        }
        String metric = this.meta.getMetric().getName();
        if (metric == null || metric.isEmpty()) {
            throw new IllegalStateException("Timeseries metric name was null or empty");
        }
        this.processParsedValue(metric);
    }

    private void parseTagkRule() {
        List<UIDMeta> tags = this.meta.getTags();
        if (tags == null || tags.isEmpty()) {
            throw new IllegalStateException("Tags for the timeseries meta were null");
        }
        String tag_name = "";
        boolean found = false;
        for (UIDMeta uidmeta : tags) {
            if (uidmeta.getType() == UniqueId.UniqueIdType.TAGK && uidmeta.getName().equals(this.rule.getField())) {
                found = true;
                continue;
            }
            if (uidmeta.getType() != UniqueId.UniqueIdType.TAGV || !found) continue;
            tag_name = uidmeta.getName();
            break;
        }
        if (!found || tag_name.isEmpty()) {
            this.testMessage("No match on tagk [" + this.rule.getField() + "] for rule: " + this.rule);
            return;
        }
        this.testMessage("Matched tagk [" + this.rule.getField() + "] for rule: " + this.rule);
        this.processParsedValue(tag_name);
    }

    private void parseMetricCustomRule() {
        if (this.meta.getMetric() == null) {
            throw new IllegalStateException("Timeseries metric UID object was null");
        }
        Map<String, String> custom = this.meta.getMetric().getCustom();
        if (custom != null && custom.containsKey(this.rule.getCustomField())) {
            if (custom.get(this.rule.getCustomField()) == null) {
                throw new IllegalStateException("Value for custom metric field [" + this.rule.getCustomField() + "] was null");
            }
            this.processParsedValue(custom.get(this.rule.getCustomField()));
            this.testMessage("Matched custom tag [" + this.rule.getCustomField() + "] for rule: " + this.rule);
        } else {
            this.testMessage("No match on custom tag [" + this.rule.getCustomField() + "] for rule: " + this.rule);
        }
    }

    private void parseTagkCustomRule() {
        if (this.meta.getTags() == null || this.meta.getTags().isEmpty()) {
            throw new IllegalStateException("Timeseries meta data was missing tags");
        }
        UIDMeta tagk = null;
        for (UIDMeta tag : this.meta.getTags()) {
            if (tag.getType() != UniqueId.UniqueIdType.TAGK || !tag.getName().equals(this.rule.getField())) continue;
            tagk = tag;
            break;
        }
        if (tagk == null) {
            this.testMessage("No match on tagk [" + this.rule.getField() + "] for rule: " + this.rule);
            return;
        }
        this.testMessage("Matched tagk [" + this.rule.getField() + "] for rule: " + this.rule);
        Map<String, String> custom = tagk.getCustom();
        if (custom != null && custom.containsKey(this.rule.getCustomField())) {
            if (custom.get(this.rule.getCustomField()) == null) {
                throw new IllegalStateException("Value for custom tagk field [" + this.rule.getCustomField() + "] was null");
            }
        } else {
            this.testMessage("No match on custom tag [" + this.rule.getCustomField() + "] for rule: " + this.rule);
            return;
        }
        this.processParsedValue(custom.get(this.rule.getCustomField()));
        this.testMessage("Matched custom tag [" + this.rule.getCustomField() + "] for rule: " + this.rule);
    }

    private void parseTagvRule() {
        if (this.meta.getTags() == null || this.meta.getTags().isEmpty()) {
            throw new IllegalStateException("Timeseries meta data was missing tags");
        }
        UIDMeta tagv = null;
        for (UIDMeta tag : this.meta.getTags()) {
            if (tag.getType() != UniqueId.UniqueIdType.TAGV || !tag.getName().equals(this.rule.getField())) continue;
            tagv = tag;
            break;
        }
        if (tagv == null) {
            this.testMessage("No match on tagv [" + this.rule.getField() + "] for rule: " + this.rule);
            return;
        }
        this.testMessage("Matched tagv [" + this.rule.getField() + "] for rule: " + this.rule);
        Map<String, String> custom = tagv.getCustom();
        if (custom != null && custom.containsKey(this.rule.getCustomField())) {
            if (custom.get(this.rule.getCustomField()) == null) {
                throw new IllegalStateException("Value for custom tagv field [" + this.rule.getCustomField() + "] was null");
            }
        } else {
            this.testMessage("No match on custom tag [" + this.rule.getCustomField() + "] for rule: " + this.rule);
            return;
        }
        this.processParsedValue(custom.get(this.rule.getCustomField()));
        this.testMessage("Matched custom tag [" + this.rule.getCustomField() + "] for rule: " + this.rule);
    }

    private void processParsedValue(String parsed_value) {
        if (this.rule.getCompiledRegex() == null && (this.rule.getSeparator() == null || this.rule.getSeparator().isEmpty())) {
            this.setCurrentName(parsed_value, parsed_value);
        } else if (this.rule.getCompiledRegex() != null) {
            this.processRegexRule(parsed_value);
        } else if (this.rule.getSeparator() != null && !this.rule.getSeparator().isEmpty()) {
            this.processSplit(parsed_value);
        } else {
            throw new IllegalStateException("Unable to find a processor for rule: " + this.rule);
        }
    }

    private void processSplit(String parsed_value) {
        if (this.splits == null) {
            if (parsed_value == null || parsed_value.isEmpty()) {
                throw new IllegalArgumentException("Value was empty for rule: " + this.rule);
            }
            if (this.rule.getSeparator() == null || this.rule.getSeparator().isEmpty()) {
                throw new IllegalArgumentException("Separator was empty for rule: " + this.rule);
            }
            this.splits = parsed_value.split(this.rule.getSeparator());
            if (this.splits.length < 1) {
                this.testMessage("Separator did not match, created an empty list on rule: " + this.rule);
                this.split_idx = 1;
                return;
            }
            this.split_idx = 0;
            this.setCurrentName(parsed_value, this.splits[this.split_idx]);
            ++this.split_idx;
        } else {
            this.setCurrentName(parsed_value, this.splits[this.split_idx]);
            ++this.split_idx;
        }
    }

    private void processRegexRule(String parsed_value) {
        if (this.rule.getCompiledRegex() == null) {
            throw new IllegalArgumentException("Regex was null for rule: " + this.rule);
        }
        Matcher matcher = this.rule.getCompiledRegex().matcher(parsed_value);
        if (matcher.find()) {
            if (matcher.groupCount() >= this.rule.getRegexGroupIdx() + 1) {
                String extracted = matcher.group(this.rule.getRegexGroupIdx() + 1);
                if (extracted == null || extracted.isEmpty()) {
                    this.testMessage("Extracted value for rule " + this.rule + " was null or empty");
                } else {
                    this.setCurrentName(parsed_value, extracted);
                }
            } else {
                this.testMessage("Regex group index [" + this.rule.getRegexGroupIdx() + "] for rule " + this.rule + " was out of bounds [" + matcher.groupCount() + "]");
            }
        }
    }

    private void setCurrentName(String original_value, String extracted_value) {
        String format = this.rule.getDisplayFormat();
        if (format == null || format.isEmpty()) {
            this.current_branch.setDisplayName(extracted_value);
            return;
        }
        if (format.contains("{ovalue}")) {
            format = format.replace("{ovalue}", original_value);
        }
        if (format.contains("{value}")) {
            format = format.replace("{value}", extracted_value);
        }
        if (format.contains("{tsuid}")) {
            format = format.replace("{tsuid}", this.meta.getTSUID());
        }
        if (format.contains("{tag_name}")) {
            TreeRule.TreeRuleType type = this.rule.getType();
            if (type == TreeRule.TreeRuleType.TAGK) {
                format = format.replace("{tag_name}", this.rule.getField());
            } else if (type == TreeRule.TreeRuleType.METRIC_CUSTOM || type == TreeRule.TreeRuleType.TAGK_CUSTOM || type == TreeRule.TreeRuleType.TAGV_CUSTOM) {
                format = format.replace("{tag_name}", this.rule.getCustomField());
            } else {
                format = format.replace("{tag_name}", "");
                LOG.warn("Display rule " + this.rule + " was of the wrong type to match on {tag_name}");
                if (this.test_messages != null) {
                    this.test_messages.add("Display rule " + this.rule + " was of the wrong type to match on {tag_name}");
                }
            }
        }
        this.current_branch.setDisplayName(format);
    }

    private void calculateMaxLevel() {
        if (this.tree.getRules() == null) {
            LOG.debug("No rules set for this tree");
            return;
        }
        for (Integer level : this.tree.getRules().keySet()) {
            if (level <= this.max_rule_level) continue;
            this.max_rule_level = level;
        }
    }

    private void testMessage(String message) {
        if (this.test_messages != null) {
            this.test_messages.add(message);
        }
        LOG.trace(message);
    }

    private TreeMap<Integer, TreeRule> fetchRuleLevel() {
        TreeMap<Integer, TreeRule> current_level = null;
        while (current_level == null && this.rule_idx <= this.max_rule_level) {
            current_level = this.tree.getRules().get(this.rule_idx);
            if (current_level != null) {
                return current_level;
            }
            ++this.rule_idx;
        }
        return null;
    }

    private void resetState() {
        this.meta = null;
        this.splits = null;
        this.rule_idx = 0;
        this.split_idx = 0;
        this.current_branch = null;
        this.rule = null;
        this.not_matched = null;
        if (this.root != null) {
            if (this.root.getBranches() != null) {
                this.root.getBranches().clear();
            }
            if (this.root.getLeaves() != null) {
                this.root.getLeaves().clear();
            }
        }
        this.test_messages = new ArrayList();
    }

    public Tree getTree() {
        return this.tree;
    }

    public Branch getRootBranch() {
        return this.root;
    }

    public ArrayList<String> getTestMessage() {
        return this.test_messages;
    }

    public void setTree(Tree tree) {
        this.tree = tree;
        this.calculateMaxLevel();
        this.root = null;
    }

    static {
        trees_lock = new ReentrantLock();
    }
}

