/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tree;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.opentsdb.core.TSDB;
import net.opentsdb.tree.Tree;
import net.opentsdb.utils.JSON;
import org.hbase.async.Bytes;
import org.hbase.async.DeleteRequest;
import org.hbase.async.GetRequest;
import org.hbase.async.KeyValue;
import org.hbase.async.PutRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
public final class TreeRule {
    private static final Logger LOG = LoggerFactory.getLogger(TreeRule.class);
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private static final byte[] RULE_PREFIX = "tree_rule:".getBytes(CHARSET);
    @JsonDeserialize(using=JSON.TreeRuleTypeDeserializer.class)
    private TreeRuleType type = null;
    private String field = "";
    private String custom_field = "";
    private String regex = "";
    private String separator = "";
    private String description = "";
    private String notes = "";
    private int regex_group_idx = 0;
    private String display_format = "";
    private int level = 0;
    private int order = 0;
    private int tree_id = 0;
    private Pattern compiled_regex = null;
    private final HashMap<String, Boolean> changed = new HashMap();

    public TreeRule() {
        this.initializeChangedMap();
    }

    public TreeRule(int tree_id) {
        this.tree_id = tree_id;
        this.initializeChangedMap();
    }

    public TreeRule(TreeRule original) {
        this.custom_field = original.custom_field;
        this.description = original.description;
        this.display_format = original.display_format;
        this.field = original.field;
        this.level = original.level;
        this.notes = original.notes;
        this.order = original.order;
        this.regex_group_idx = original.regex_group_idx;
        this.separator = original.separator;
        this.tree_id = original.tree_id;
        this.type = original.type;
        this.setRegex(original.regex);
        this.initializeChangedMap();
    }

    public boolean copyChanges(TreeRule rule, boolean overwrite) {
        if (rule == null) {
            throw new IllegalArgumentException("Cannot copy a null rule");
        }
        if (this.tree_id != rule.tree_id) {
            throw new IllegalArgumentException("Tree IDs do not match");
        }
        if (this.level != rule.level) {
            throw new IllegalArgumentException("Levels do not match");
        }
        if (this.order != rule.order) {
            throw new IllegalArgumentException("Orders do not match");
        }
        if (overwrite || rule.changed.get("type").booleanValue() && this.type != rule.type) {
            this.type = rule.type;
            this.changed.put("type", true);
        }
        if (overwrite || rule.changed.get("field").booleanValue() && !this.field.equals(rule.field)) {
            this.field = rule.field;
            this.changed.put("field", true);
        }
        if (overwrite || rule.changed.get("custom_field").booleanValue() && !this.custom_field.equals(rule.custom_field)) {
            this.custom_field = rule.custom_field;
            this.changed.put("custom_field", true);
        }
        if (overwrite || rule.changed.get("regex").booleanValue() && !this.regex.equals(rule.regex)) {
            this.setRegex(rule.regex);
        }
        if (overwrite || rule.changed.get("separator").booleanValue() && !this.separator.equals(rule.separator)) {
            this.separator = rule.separator;
            this.changed.put("separator", true);
        }
        if (overwrite || rule.changed.get("description").booleanValue() && !this.description.equals(rule.description)) {
            this.description = rule.description;
            this.changed.put("description", true);
        }
        if (overwrite || rule.changed.get("notes").booleanValue() && !this.notes.equals(rule.notes)) {
            this.notes = rule.notes;
            this.changed.put("notes", true);
        }
        if (overwrite || rule.changed.get("regex_group_idx").booleanValue() && this.regex_group_idx != rule.regex_group_idx) {
            this.regex_group_idx = rule.regex_group_idx;
            this.changed.put("regex_group_idx", true);
        }
        if (overwrite || rule.changed.get("display_format").booleanValue() && !this.display_format.equals(rule.display_format)) {
            this.display_format = rule.display_format;
            this.changed.put("display_format", true);
        }
        for (boolean has_changes : this.changed.values()) {
            if (!has_changes) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "[" + this.tree_id + ":" + this.level + ":" + this.order + ":" + (Object)((Object)this.type) + "]";
    }

    public Deferred<Boolean> syncToStorage(final TSDB tsdb, final boolean overwrite) {
        if (this.tree_id < 1 || this.tree_id > 65535) {
            throw new IllegalArgumentException("Invalid Tree ID");
        }
        boolean has_changes = false;
        for (Map.Entry<String, Boolean> entry : this.changed.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            has_changes = true;
            break;
        }
        if (!has_changes) {
            LOG.trace(this + " does not have changes, skipping sync to storage");
            throw new IllegalStateException("No changes detected in the rule");
        }
        final class StoreCB
        implements Callback<Deferred<Boolean>, TreeRule> {
            final TreeRule local_rule;

            public StoreCB() {
                this.local_rule = local_rule;
            }

            public Deferred<Boolean> call(TreeRule fetched_rule) {
                byte[] original_rule;
                TreeRule stored_rule = fetched_rule;
                byte[] byArray = original_rule = stored_rule == null ? new byte[]{} : JSON.serializeToBytes(stored_rule);
                if (stored_rule == null) {
                    stored_rule = this.local_rule;
                } else if (!stored_rule.copyChanges(this.local_rule, overwrite)) {
                    LOG.debug(this + " does not have changes, skipping sync to storage");
                    throw new IllegalStateException("No changes detected in the rule");
                }
                TreeRule.this.initializeChangedMap();
                stored_rule.validateRule();
                PutRequest put = new PutRequest(tsdb.treeTable(), Tree.idToBytes(TreeRule.this.tree_id), Tree.TREE_FAMILY(), TreeRule.getQualifier(TreeRule.this.level, TreeRule.this.order), JSON.serializeToBytes(stored_rule));
                return tsdb.getClient().compareAndSet(put, original_rule);
            }
        }
        return TreeRule.fetchRule(tsdb, this.tree_id, this.level, this.order).addCallbackDeferring((Callback)new StoreCB());
    }

    public static TreeRule parseFromStorage(KeyValue column) {
        if (column.value() == null) {
            throw new IllegalArgumentException("Tree rule column value was null");
        }
        TreeRule rule = JSON.parseToObject(column.value(), TreeRule.class);
        rule.initializeChangedMap();
        return rule;
    }

    public static Deferred<TreeRule> fetchRule(TSDB tsdb, int tree_id, int level, int order) {
        if (tree_id < 1 || tree_id > 65535) {
            throw new IllegalArgumentException("Invalid Tree ID");
        }
        if (level < 0) {
            throw new IllegalArgumentException("Invalid rule level");
        }
        if (order < 0) {
            throw new IllegalArgumentException("Invalid rule order");
        }
        GetRequest get = new GetRequest(tsdb.treeTable(), Tree.idToBytes(tree_id));
        get.family(Tree.TREE_FAMILY());
        get.qualifier(TreeRule.getQualifier(level, order));
        final class FetchCB
        implements Callback<Deferred<TreeRule>, ArrayList<KeyValue>> {
            FetchCB() {
            }

            public Deferred<TreeRule> call(ArrayList<KeyValue> row) {
                if (row == null || row.isEmpty()) {
                    return Deferred.fromResult(null);
                }
                return Deferred.fromResult((Object)TreeRule.parseFromStorage(row.get(0)));
            }
        }
        return tsdb.getClient().get(get).addCallbackDeferring((Callback)new FetchCB());
    }

    public static Deferred<Object> deleteRule(TSDB tsdb, int tree_id, int level, int order) {
        if (tree_id < 1 || tree_id > 65535) {
            throw new IllegalArgumentException("Invalid Tree ID");
        }
        if (level < 0) {
            throw new IllegalArgumentException("Invalid rule level");
        }
        if (order < 0) {
            throw new IllegalArgumentException("Invalid rule order");
        }
        DeleteRequest delete = new DeleteRequest(tsdb.treeTable(), Tree.idToBytes(tree_id), Tree.TREE_FAMILY(), TreeRule.getQualifier(level, order));
        return tsdb.getClient().delete(delete);
    }

    public static Deferred<Object> deleteAllRules(final TSDB tsdb, final int tree_id) {
        if (tree_id < 1 || tree_id > 65535) {
            throw new IllegalArgumentException("Invalid Tree ID");
        }
        GetRequest get = new GetRequest(tsdb.treeTable(), Tree.idToBytes(tree_id));
        get.family(Tree.TREE_FAMILY());
        final class GetCB
        implements Callback<Deferred<Object>, ArrayList<KeyValue>> {
            GetCB() {
            }

            public Deferred<Object> call(ArrayList<KeyValue> row) throws Exception {
                if (row == null || row.isEmpty()) {
                    return Deferred.fromResult(null);
                }
                ArrayList<byte[]> qualifiers = new ArrayList<byte[]>(row.size());
                for (KeyValue column : row) {
                    if (column.qualifier().length <= RULE_PREFIX.length || Bytes.memcmp((byte[])RULE_PREFIX, (byte[])column.qualifier(), (int)0, (int)RULE_PREFIX.length) != 0) continue;
                    qualifiers.add(column.qualifier());
                }
                DeleteRequest delete = new DeleteRequest(tsdb.treeTable(), Tree.idToBytes(tree_id), Tree.TREE_FAMILY(), (byte[][])qualifiers.toArray((T[])new byte[qualifiers.size()][]));
                return tsdb.getClient().delete(delete);
            }
        }
        return tsdb.getClient().get(get).addCallbackDeferring((Callback)new GetCB());
    }

    public static TreeRuleType stringToType(String type) {
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("Rule type was empty");
        }
        if (type.toLowerCase().equals("metric")) {
            return TreeRuleType.METRIC;
        }
        if (type.toLowerCase().equals("metric_custom")) {
            return TreeRuleType.METRIC_CUSTOM;
        }
        if (type.toLowerCase().equals("tagk")) {
            return TreeRuleType.TAGK;
        }
        if (type.toLowerCase().equals("tagk_custom")) {
            return TreeRuleType.TAGK_CUSTOM;
        }
        if (type.toLowerCase().equals("tagv_custom")) {
            return TreeRuleType.TAGV_CUSTOM;
        }
        throw new IllegalArgumentException("Unrecognized rule type");
    }

    public static byte[] RULE_PREFIX() {
        return RULE_PREFIX;
    }

    public static byte[] getQualifier(int level, int order) {
        byte[] suffix = (level + ":" + order).getBytes(CHARSET);
        byte[] qualifier = new byte[RULE_PREFIX.length + suffix.length];
        System.arraycopy(RULE_PREFIX, 0, qualifier, 0, RULE_PREFIX.length);
        System.arraycopy(suffix, 0, qualifier, RULE_PREFIX.length, suffix.length);
        return qualifier;
    }

    private void initializeChangedMap() {
        this.changed.put("type", false);
        this.changed.put("field", false);
        this.changed.put("custom_field", false);
        this.changed.put("regex", false);
        this.changed.put("separator", false);
        this.changed.put("description", false);
        this.changed.put("notes", false);
        this.changed.put("regex_group_idx", false);
        this.changed.put("display_format", false);
        this.changed.put("level", false);
        this.changed.put("order", false);
    }

    private void validateRule() {
        if (this.type == null) {
            throw new IllegalArgumentException("Missing rule type");
        }
        switch (this.type) {
            case METRIC: {
                break;
            }
            case METRIC_CUSTOM: 
            case TAGK_CUSTOM: 
            case TAGV_CUSTOM: {
                if (this.field == null || this.field.isEmpty()) {
                    throw new IllegalArgumentException("Missing field name required for " + (Object)((Object)this.type) + " rule");
                }
                if (this.custom_field != null && !this.custom_field.isEmpty()) break;
                throw new IllegalArgumentException("Missing custom field name required for " + (Object)((Object)this.type) + " rule");
            }
            case TAGK: {
                if (this.field != null && !this.field.isEmpty()) break;
                throw new IllegalArgumentException("Missing field name required for " + (Object)((Object)this.type) + " rule");
            }
            default: {
                throw new IllegalArgumentException("Invalid rule type");
            }
        }
        if (!(this.regex == null && this.regex.isEmpty() || this.regex_group_idx >= 0)) {
            throw new IllegalArgumentException("Invalid regex group index. Cannot be less than 0");
        }
    }

    public TreeRuleType getType() {
        return this.type;
    }

    public String getField() {
        return this.field;
    }

    public String getCustomField() {
        return this.custom_field;
    }

    public String getRegex() {
        return this.regex;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNotes() {
        return this.notes;
    }

    public int getRegexGroupIdx() {
        return this.regex_group_idx;
    }

    public String getDisplayFormat() {
        return this.display_format;
    }

    public int getLevel() {
        return this.level;
    }

    public int getOrder() {
        return this.order;
    }

    public int getTreeId() {
        return this.tree_id;
    }

    @JsonIgnore
    public Pattern getCompiledRegex() {
        return this.compiled_regex;
    }

    public void setType(TreeRuleType type) {
        if (this.type != type) {
            this.changed.put("type", true);
            this.type = type;
        }
    }

    public void setField(String field) {
        if (!this.field.equals(field)) {
            this.changed.put("field", true);
            this.field = field;
        }
    }

    public void setCustomField(String custom_field) {
        if (!this.custom_field.equals(custom_field)) {
            this.changed.put("custom_field", true);
            this.custom_field = custom_field;
        }
    }

    public void setRegex(String regex) {
        if (!this.regex.equals(regex)) {
            this.changed.put("regex", true);
            this.regex = regex;
            this.compiled_regex = regex != null && !regex.isEmpty() ? Pattern.compile(regex) : null;
        }
    }

    public void setSeparator(String separator) {
        if (!this.separator.equals(separator)) {
            this.changed.put("separator", true);
            this.separator = separator;
        }
    }

    public void setDescription(String description) {
        if (!this.description.equals(description)) {
            this.changed.put("description", true);
            this.description = description;
        }
    }

    public void setNotes(String notes) {
        if (!this.notes.equals(notes)) {
            this.changed.put("notes", true);
            this.notes = notes;
        }
    }

    public void setRegexGroupIdx(int regex_group_idx) {
        if (this.regex_group_idx != regex_group_idx) {
            this.changed.put("regex_group_idx", true);
            this.regex_group_idx = regex_group_idx;
        }
    }

    public void setDisplayFormat(String display_format) {
        if (!this.display_format.equals(display_format)) {
            this.changed.put("display_format", true);
            this.display_format = display_format;
        }
    }

    public void setLevel(int level) {
        if (level < 0) {
            throw new IllegalArgumentException("Negative levels are not allowed");
        }
        if (this.level != level) {
            this.changed.put("level", true);
            this.level = level;
        }
    }

    public void setOrder(int order) {
        if (this.level < 0) {
            throw new IllegalArgumentException("Negative orders are not allowed");
        }
        if (this.order != order) {
            this.changed.put("order", true);
            this.order = order;
        }
    }

    public void setTreeId(int tree_id) {
        this.tree_id = tree_id;
    }

    public static enum TreeRuleType {
        METRIC,
        METRIC_CUSTOM,
        TAGK,
        TAGK_CUSTOM,
        TAGV_CUSTOM;

    }
}

