/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tsd;

import com.google.common.base.Objects;
import com.stumbleupon.async.Deferred;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.opentsdb.core.TSDB;
import net.opentsdb.stats.QueryStats;
import net.opentsdb.tsd.BadRequestException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpQuery {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHttpQuery.class);
    private final long start_time = System.nanoTime();
    private final HttpRequest request;
    private final Channel chan;
    private final HttpMethod method;
    private Map<String, List<String>> querystring;
    protected final Deferred<Object> deferred = new Deferred();
    private final DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
    protected final TSDB tsdb;
    protected QueryStats stats;

    protected AbstractHttpQuery(TSDB tsdb, HttpRequest request, Channel chan) {
        this.tsdb = tsdb;
        this.request = request;
        this.chan = chan;
        this.method = request.getMethod();
    }

    public HttpRequest request() {
        return this.request;
    }

    public HttpMethod method() {
        return this.method;
    }

    public DefaultHttpResponse response() {
        return this.response;
    }

    public Channel channel() {
        return this.chan;
    }

    public String getRemoteAddress() {
        return this.chan.getRemoteAddress().toString();
    }

    public Map<String, String> getPrintableHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(this.request.headers().entries().size());
        for (Map.Entry header : this.request.headers().entries()) {
            if (((String)header.getKey()).toLowerCase().equals("cookie")) {
                headers.put((String)header.getKey(), "*******");
                continue;
            }
            if (headers.containsKey(header.getKey())) {
                headers.put((String)header.getKey(), (String)headers.get(header.getKey()) + "," + (String)header.getValue());
                continue;
            }
            headers.put((String)header.getKey(), (String)header.getValue());
        }
        return headers;
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(this.request.headers().entries().size());
        for (Map.Entry header : this.request.headers().entries()) {
            if (headers.containsKey(header.getKey())) {
                headers.put((String)header.getKey(), (String)headers.get(header.getKey()) + "," + (String)header.getValue());
                continue;
            }
            headers.put((String)header.getKey(), (String)header.getValue());
        }
        return headers;
    }

    public void setStats(QueryStats stats) {
        this.stats = stats;
    }

    public long startTimeNanos() {
        return this.start_time;
    }

    public int processingTimeMillis() {
        return (int)((System.nanoTime() - this.start_time) / 1000000L);
    }

    public Map<String, List<String>> getQueryString() {
        if (this.querystring == null) {
            try {
                this.querystring = new QueryStringDecoder(this.request.getUri()).getParameters();
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Bad query string: " + e.getMessage());
            }
        }
        return this.querystring;
    }

    public String getQueryStringParam(String paramname) {
        List<String> params = this.getQueryString().get(paramname);
        return params == null ? null : params.get(params.size() - 1);
    }

    public String getRequiredQueryStringParam(String paramname) throws BadRequestException {
        String value = this.getQueryStringParam(paramname);
        if (value == null || value.isEmpty()) {
            throw BadRequestException.missingParameter(paramname);
        }
        return value;
    }

    public boolean hasQueryStringParam(String paramname) {
        return this.getQueryString().get(paramname) != null;
    }

    public List<String> getQueryStringParams(String paramname) {
        return this.getQueryString().get(paramname);
    }

    public String getQueryPath() {
        return new QueryStringDecoder(this.request.getUri()).getPath();
    }

    public String[] explodePath() {
        String path = this.getQueryPath();
        if (path.isEmpty()) {
            throw new BadRequestException("Query path is empty");
        }
        if (path.charAt(0) != '/') {
            throw new BadRequestException("Query path doesn't start with a slash");
        }
        return path.substring(1).split("/");
    }

    public abstract String getQueryBaseRoute();

    public Charset getCharset() {
        for (String type : this.request.headers().getAll("Content-Type")) {
            int idx = type.toUpperCase().indexOf("CHARSET=");
            if (idx <= 1) continue;
            String charset = type.substring(idx + 8);
            return Charset.forName(charset);
        }
        return Charset.forName("UTF-8");
    }

    public boolean hasContent() {
        return this.request.getContent() != null && this.request.getContent().readable();
    }

    public String getContent() {
        return this.request.getContent().toString(this.getCharset());
    }

    public void done() {
        int processing_time = this.processingTimeMillis();
        String url = this.request.getUri();
        String msg = String.format("HTTP %s done in %d ms", url, processing_time);
        if (url.startsWith("/api/put") && LOG.isDebugEnabled()) {
            LOG.debug(msg);
        } else {
            this.logInfo(msg);
        }
        this.logInfo("HTTP " + this.request.getUri() + " done in " + processing_time + "ms");
    }

    public void internalError(Exception cause) {
        this.logError("Internal Server Error on " + this.request().getUri(), cause);
        this.sendStatusOnly(HttpResponseStatus.INTERNAL_SERVER_ERROR);
    }

    public void badRequest(BadRequestException exception) {
        this.logWarn("Bad Request on " + this.request().getUri() + ": " + exception.getMessage());
        this.sendStatusOnly(HttpResponseStatus.BAD_REQUEST);
    }

    public void notFound() {
        this.logWarn("Not Found: " + this.request().getUri());
        this.sendStatusOnly(HttpResponseStatus.NOT_FOUND);
    }

    public void sendStatusOnly(HttpResponseStatus status) {
        if (!this.chan.isConnected()) {
            if (this.stats != null) {
                this.stats.markSendFailed();
            }
            this.done();
            return;
        }
        this.response.setStatus(status);
        boolean keepalive = HttpHeaders.isKeepAlive((HttpMessage)this.request);
        if (keepalive) {
            HttpHeaders.setContentLength((HttpMessage)this.response, (long)0L);
        }
        ChannelFuture future = this.chan.write((Object)this.response);
        if (this.stats != null) {
            future.addListener((ChannelFutureListener)new SendSuccess());
        }
        if (!keepalive) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
        this.done();
    }

    public void sendBuffer(HttpResponseStatus status, ChannelBuffer buf, String contentType) {
        if (!this.chan.isConnected()) {
            if (this.stats != null) {
                this.stats.markSendFailed();
            }
            this.done();
            return;
        }
        this.response.headers().set("Content-Type", (Object)contentType);
        this.response.setStatus(status);
        this.response.setContent(buf);
        boolean keepalive = HttpHeaders.isKeepAlive((HttpMessage)this.request);
        if (keepalive) {
            HttpHeaders.setContentLength((HttpMessage)this.response, (long)buf.readableBytes());
        }
        ChannelFuture future = this.chan.write((Object)this.response);
        if (this.stats != null) {
            future.addListener((ChannelFutureListener)new SendSuccess());
        }
        if (!keepalive) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
        this.done();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("start_time", this.start_time).add("request", (Object)this.request).add("chan", (Object)this.chan).add("querystring", this.querystring).toString();
    }

    protected Logger logger() {
        return LOG;
    }

    protected final String logChannel() {
        if (this.request.headers().contains("X-Forwarded-For")) {
            String proxyChain = this.request.headers().get("X-Forwarded-For");
            int firstComma = proxyChain.indexOf(44);
            String inetAddress = firstComma != -1 ? proxyChain.substring(0, proxyChain.indexOf(44)) : proxyChain;
            return "[id: 0x" + Integer.toHexString(this.chan.hashCode()) + ", /" + inetAddress + " => " + this.chan.getLocalAddress() + ']';
        }
        return this.chan.toString();
    }

    protected final void logInfo(String msg) {
        if (this.logger().isInfoEnabled()) {
            this.logger().info(this.logChannel() + ' ' + msg);
        }
    }

    protected final void logWarn(String msg) {
        if (this.logger().isWarnEnabled()) {
            this.logger().warn(this.logChannel() + ' ' + msg);
        }
    }

    protected final void logError(String msg, Exception e) {
        if (this.logger().isErrorEnabled()) {
            this.logger().error(this.logChannel() + ' ' + msg, (Throwable)e);
        }
    }

    private class SendSuccess
    implements ChannelFutureListener {
        private SendSuccess() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                AbstractHttpQuery.this.stats.markSent();
            } else {
                AbstractHttpQuery.this.stats.markSendFailed();
            }
        }
    }
}

