/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tsd;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.opentsdb.core.TSDB;
import net.opentsdb.meta.Annotation;
import net.opentsdb.tsd.BadRequestException;
import net.opentsdb.tsd.HttpQuery;
import net.opentsdb.tsd.HttpRpc;
import net.opentsdb.uid.UniqueId;
import net.opentsdb.utils.DateTime;
import net.opentsdb.utils.JSONException;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AnnotationRpc
implements HttpRpc {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationRpc.class);

    AnnotationRpc() {
    }

    @Override
    public void execute(final TSDB tsdb, HttpQuery query) throws IOException {
        String endpoint;
        HttpMethod method = query.getAPIMethod();
        String[] uri = query.explodeAPIPath();
        String string = endpoint = uri.length > 1 ? uri[1] : "";
        if (endpoint != null && endpoint.toLowerCase().endsWith("bulk")) {
            this.executeBulk(tsdb, method, query);
            return;
        }
        final Annotation note = query.hasContent() ? query.serializer().parseAnnotationV1() : this.parseQS(query);
        if (method == HttpMethod.GET) {
            try {
                if ("annotations".toLowerCase().equals(uri[0])) {
                    this.fetchMultipleAnnotations(tsdb, note, query);
                }
                this.fetchSingleAnnotation(tsdb, note, query);
            }
            catch (BadRequestException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (method == HttpMethod.POST || method == HttpMethod.PUT) {
            try {
                class SyncCB
                implements Callback<Deferred<Annotation>, Boolean> {
                    SyncCB() {
                    }

                    public Deferred<Annotation> call(Boolean success) throws Exception {
                        if (!success.booleanValue()) {
                            throw new BadRequestException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Failed to save the Annotation to storage", "This may be caused by another process modifying storage data");
                        }
                        return Annotation.getAnnotation(tsdb, note.getTSUID(), note.getStartTime());
                    }
                }
                Deferred process_meta = note.syncToStorage(tsdb, method == HttpMethod.PUT).addCallbackDeferring((Callback)new SyncCB());
                Annotation updated_meta = (Annotation)process_meta.joinUninterruptibly();
                tsdb.indexAnnotation(note);
                query.sendReply(query.serializer().formatAnnotationV1(updated_meta));
            }
            catch (IllegalStateException e) {
                query.sendStatusOnly(HttpResponseStatus.NOT_MODIFIED);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (method == HttpMethod.DELETE) {
            try {
                note.delete(tsdb).joinUninterruptibly();
                tsdb.deleteAnnotation(note);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Unable to delete Annotation information", e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            query.sendStatusOnly(HttpResponseStatus.NO_CONTENT);
        } else {
            throw new BadRequestException(HttpResponseStatus.METHOD_NOT_ALLOWED, "Method not allowed", "The HTTP method [" + method.getName() + "] is not permitted for this endpoint");
        }
    }

    void executeBulk(TSDB tsdb, HttpMethod method, HttpQuery query) {
        if (method == HttpMethod.POST || method == HttpMethod.PUT) {
            this.executeBulkUpdate(tsdb, method, query);
        } else if (method == HttpMethod.DELETE) {
            this.executeBulkDelete(tsdb, query);
        } else {
            throw new BadRequestException(HttpResponseStatus.METHOD_NOT_ALLOWED, "Method not allowed", "The HTTP method [" + query.method().getName() + "] is not permitted for this endpoint");
        }
    }

    void executeBulkUpdate(final TSDB tsdb, HttpMethod method, HttpQuery query) {
        List<Annotation> notes;
        try {
            notes = query.serializer().parseAnnotationsV1();
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e);
        }
        catch (JSONException e) {
            throw new BadRequestException(e);
        }
        ArrayList<Deferred> callbacks = new ArrayList<Deferred>(notes.size());
        for (Annotation annotation : notes) {
            try {
                class SyncCB
                implements Callback<Deferred<Annotation>, Boolean> {
                    private final Annotation note;

                    public SyncCB(Annotation note) {
                        this.note = note;
                    }

                    public Deferred<Annotation> call(Boolean success) throws Exception {
                        if (!success.booleanValue()) {
                            throw new BadRequestException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Failed to save an Annotation to storage", "This may be caused by another process modifying storage data: " + this.note);
                        }
                        return Annotation.getAnnotation(tsdb, this.note.getTSUID(), this.note.getStartTime());
                    }
                }
                Deferred deferred = annotation.syncToStorage(tsdb, method == HttpMethod.PUT).addCallbackDeferring((Callback)new SyncCB(annotation));
                class IndexCB
                implements Callback<Deferred<Annotation>, Annotation> {
                    IndexCB() {
                    }

                    public Deferred<Annotation> call(Annotation note) throws Exception {
                        tsdb.indexAnnotation(note);
                        return Deferred.fromResult((Object)note);
                    }
                }
                Deferred indexer = deferred.addCallbackDeferring((Callback)new IndexCB());
                callbacks.add(indexer);
            }
            catch (IllegalStateException e) {
                LOG.info("No changes for annotation: " + annotation);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, e.getMessage(), "Annotation error: " + annotation, e);
            }
        }
        try {
            Deferred.group(callbacks).joinUninterruptibly();
            notes.clear();
            for (Deferred deferred : callbacks) {
                notes.add((Annotation)deferred.joinUninterruptibly());
            }
            query.sendReply(query.serializer().formatAnnotationsV1(notes));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void executeBulkDelete(TSDB tsdb, HttpQuery query) {
        try {
            AnnotationBulkDelete delete_request = query.hasContent() ? query.serializer().parseAnnotationBulkDeleteV1() : this.parseBulkDeleteQS(query);
            if (delete_request.start_time == null || delete_request.start_time.isEmpty()) {
                throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Missing the start time value");
            }
            if (!delete_request.global && (delete_request.tsuids == null || delete_request.tsuids.isEmpty())) {
                throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Missing the TSUIDs or global annotations flag");
            }
            int pre_allocate = delete_request.tsuids != null ? delete_request.tsuids.size() + 1 : 1;
            ArrayList<Deferred<Integer>> deletes = new ArrayList<Deferred<Integer>>(pre_allocate);
            if (delete_request.global) {
                deletes.add(Annotation.deleteRange(tsdb, null, delete_request.getStartTime(), delete_request.getEndTime()));
            }
            if (delete_request.tsuids != null) {
                for (String string : delete_request.tsuids) {
                    deletes.add(Annotation.deleteRange(tsdb, UniqueId.stringToUid(string), delete_request.getStartTime(), delete_request.getEndTime()));
                }
            }
            Deferred.group(deletes).joinUninterruptibly();
            delete_request.total_deleted = 0L;
            for (Deferred deferred : deletes) {
                delete_request.total_deleted = delete_request.total_deleted + (long)((Integer)deferred.joinUninterruptibly()).intValue();
            }
            query.sendReply(query.serializer().formatAnnotationBulkDeleteV1(delete_request));
        }
        catch (BadRequestException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e);
        }
        catch (RuntimeException e) {
            throw new BadRequestException(e);
        }
        catch (Exception e) {
            throw new RuntimeException("Shouldn't be here", e);
        }
    }

    private Annotation parseQS(HttpQuery query) {
        String notes;
        String start;
        Long start_time;
        Annotation note = new Annotation();
        String tsuid = query.getQueryStringParam("tsuid");
        if (tsuid != null) {
            note.setTSUID(tsuid);
        }
        if ((start_time = Long.valueOf(DateTime.parseDateTimeString(start = query.getQueryStringParam("start_time"), ""))) < 1L) {
            throw new BadRequestException("Missing start time");
        }
        note.setStartTime(start_time / 1000L);
        String end = query.getQueryStringParam("end_time");
        Long end_time = DateTime.parseDateTimeString(end, "");
        note.setEndTime(end_time / 1000L);
        String description = query.getQueryStringParam("description");
        if (description != null) {
            note.setDescription(description);
        }
        if ((notes = query.getQueryStringParam("notes")) != null) {
            note.setNotes(notes);
        }
        return note;
    }

    private void fetchSingleAnnotation(TSDB tsdb, Annotation note, HttpQuery query) throws Exception {
        Annotation stored_annotation = (Annotation)Annotation.getAnnotation(tsdb, note.getTSUID(), note.getStartTime()).joinUninterruptibly();
        if (stored_annotation == null) {
            throw new BadRequestException(HttpResponseStatus.NOT_FOUND, "Unable to locate annotation in storage");
        }
        query.sendReply(query.serializer().formatAnnotationV1(stored_annotation));
    }

    private void fetchMultipleAnnotations(TSDB tsdb, Annotation note, HttpQuery query) throws Exception {
        List annotations;
        if (note.getEndTime() == 0L) {
            note.setEndTime(System.currentTimeMillis());
        }
        if ((annotations = (List)Annotation.getGlobalAnnotations(tsdb, note.getStartTime(), note.getEndTime()).joinUninterruptibly()) == null) {
            throw new BadRequestException(HttpResponseStatus.NOT_FOUND, "Unable to locate annotations in storage");
        }
        query.sendReply(query.serializer().formatAnnotationsV1(annotations));
    }

    private AnnotationBulkDelete parseBulkDeleteQS(HttpQuery query) {
        AnnotationBulkDelete settings = new AnnotationBulkDelete();
        settings.start_time = query.getRequiredQueryStringParam("start_time");
        settings.end_time = query.getQueryStringParam("end_time");
        if (query.hasQueryStringParam("tsuids")) {
            String[] tsuids = query.getQueryStringParam("tsuids").split(",");
            settings.tsuids = new ArrayList(tsuids.length);
            for (String tsuid : tsuids) {
                settings.tsuids.add(tsuid.trim());
            }
        }
        if (query.hasQueryStringParam("global")) {
            settings.global = true;
        }
        return settings;
    }

    public static class AnnotationBulkDelete {
        private String start_time;
        private String end_time;
        private List<String> tsuids;
        private boolean global;
        private long total_deleted;

        public long getStartTime() {
            return DateTime.parseDateTimeString(this.start_time, null);
        }

        public long getEndTime() {
            if (this.end_time == null || this.end_time.isEmpty()) {
                return System.currentTimeMillis();
            }
            return DateTime.parseDateTimeString(this.end_time, null);
        }

        public List<String> getTsuids() {
            return this.tsuids;
        }

        public boolean getGlobal() {
            return this.global;
        }

        public long getTotalDeleted() {
            return this.total_deleted;
        }

        public void setStartTime(String start_time) {
            this.start_time = start_time;
        }

        public void setEndTime(String end_time) {
            this.end_time = end_time;
        }

        public void setTsuids(List<String> tsuids) {
            this.tsuids = tsuids;
        }

        public void setGlobal(boolean global) {
            this.global = global;
        }

        public void setTotalDeleted(long total_deleted) {
            this.total_deleted = total_deleted;
        }
    }
}

