/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tsd;

import com.stumbleupon.async.Deferred;
import java.io.IOException;
import java.util.HashMap;
import net.opentsdb.core.TSDB;
import net.opentsdb.tsd.HttpQuery;
import net.opentsdb.tsd.HttpRpc;
import net.opentsdb.tsd.RpcUtil;
import net.opentsdb.tsd.TelnetRpc;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DropCachesRpc
implements TelnetRpc,
HttpRpc {
    private static final Logger LOG = LoggerFactory.getLogger(DropCachesRpc.class);

    @Override
    public Deferred<Object> execute(TSDB tsdb, Channel chan, String[] cmd) {
        this.dropCaches(tsdb, chan);
        chan.write((Object)"Caches dropped.\n");
        return Deferred.fromResult(null);
    }

    @Override
    public void execute(TSDB tsdb, HttpQuery query) throws IOException {
        RpcUtil.allowedMethods(query.method(), HttpMethod.GET.getName(), HttpMethod.DELETE.getName());
        this.dropCaches(tsdb, query.channel());
        if (query.apiVersion() > 0) {
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("status", "200");
            response.put("message", "Caches dropped");
            query.sendReply(query.serializer().formatDropCachesV1(response));
        } else {
            query.sendReply("Caches dropped.\n");
        }
    }

    private void dropCaches(TSDB tsdb, Channel chan) {
        LOG.warn(chan + " Dropping all in-memory caches.");
        tsdb.dropCaches();
    }
}

