/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tsd;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.opentsdb.core.DataPoint;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.FillPolicy;
import net.opentsdb.core.IncomingDataPoint;
import net.opentsdb.core.QueryException;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.TSQuery;
import net.opentsdb.core.TSSubQuery;
import net.opentsdb.meta.Annotation;
import net.opentsdb.meta.TSMeta;
import net.opentsdb.meta.UIDMeta;
import net.opentsdb.search.SearchQuery;
import net.opentsdb.stats.QueryStats;
import net.opentsdb.tree.Branch;
import net.opentsdb.tree.Tree;
import net.opentsdb.tree.TreeRule;
import net.opentsdb.tsd.AnnotationRpc;
import net.opentsdb.tsd.BadRequestException;
import net.opentsdb.tsd.HttpQuery;
import net.opentsdb.tsd.HttpSerializer;
import net.opentsdb.tsd.QueryRpc;
import net.opentsdb.utils.Config;
import net.opentsdb.utils.DateTime;
import net.opentsdb.utils.JSON;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

class HttpJsonSerializer
extends HttpSerializer {
    private static TypeReference<ArrayList<IncomingDataPoint>> TR_INCOMING = new TypeReference<ArrayList<IncomingDataPoint>>(){};
    private static TypeReference<HashMap<String, List<String>>> UID_ASSIGN = new TypeReference<HashMap<String, List<String>>>(){};
    private static TypeReference<HashMap<String, String>> TR_HASH_MAP = new TypeReference<HashMap<String, String>>(){};
    private static TypeReference<ArrayList<TreeRule>> TR_TREE_RULES = new TypeReference<ArrayList<TreeRule>>(){};
    private static TypeReference<HashMap<String, Object>> TR_HASH_MAP_OBJ = new TypeReference<HashMap<String, Object>>(){};
    private static TypeReference<List<Annotation>> TR_ANNOTATIONS = new TypeReference<List<Annotation>>(){};

    public HttpJsonSerializer() {
    }

    public HttpJsonSerializer(HttpQuery query) {
        super(query);
    }

    @Override
    public void initialize(TSDB tsdb) {
    }

    @Override
    public Deferred<Object> shutdown() {
        return new Deferred();
    }

    @Override
    public String version() {
        return "2.0.0";
    }

    @Override
    public String shortName() {
        return "json";
    }

    @Override
    public List<IncomingDataPoint> parsePutV1() {
        if (!this.query.hasContent()) {
            throw new BadRequestException("Missing request content");
        }
        String content = this.query.getContent().trim();
        char firstbyte = content.charAt(0);
        try {
            if (firstbyte == '{') {
                IncomingDataPoint dp = JSON.parseToObject(content, IncomingDataPoint.class);
                ArrayList<IncomingDataPoint> dps = new ArrayList<IncomingDataPoint>(1);
                dps.add(dp);
                return dps;
            }
            return JSON.parseToObject(content, TR_INCOMING);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException("Unable to parse the given JSON", iae);
        }
    }

    @Override
    public HashMap<String, String> parseSuggestV1() {
        String json = this.query.getContent();
        if (json == null || json.isEmpty()) {
            throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Missing message content", "Supply valid JSON formatted data in the body of your request");
        }
        try {
            return JSON.parseToObject(this.query.getContent(), new TypeReference<HashMap<String, String>>(){});
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException("Unable to parse the given JSON", iae);
        }
    }

    @Override
    public HashMap<String, List<String>> parseUidAssignV1() {
        String json = this.query.getContent();
        if (json == null || json.isEmpty()) {
            throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Missing message content", "Supply valid JSON formatted data in the body of your request");
        }
        try {
            return JSON.parseToObject(json, UID_ASSIGN);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException("Unable to parse the given JSON", iae);
        }
    }

    @Override
    public HashMap<String, String> parseUidRenameV1() {
        String json = this.query.getContent();
        if (json == null || json.isEmpty()) {
            throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Missing message content", "Supply valid JSON formatted data in the body of your request");
        }
        try {
            return JSON.parseToObject(json, TR_HASH_MAP);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException("Unable to parse the given JSON", iae);
        }
    }

    @Override
    public TSQuery parseQueryV1() {
        String json = this.query.getContent();
        if (json == null || json.isEmpty()) {
            throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Missing message content", "Supply valid JSON formatted data in the body of your request");
        }
        try {
            return JSON.parseToObject(json, TSQuery.class);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException("Unable to parse the given JSON", iae);
        }
    }

    @Override
    public QueryRpc.LastPointQuery parseLastPointQueryV1() {
        String json = this.query.getContent();
        if (json == null || json.isEmpty()) {
            throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Missing message content", "Supply valid JSON formatted data in the body of your request");
        }
        try {
            return JSON.parseToObject(json, QueryRpc.LastPointQuery.class);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException("Unable to parse the given JSON", iae);
        }
    }

    @Override
    public UIDMeta parseUidMetaV1() {
        String json = this.query.getContent();
        if (json == null || json.isEmpty()) {
            throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Missing message content", "Supply valid JSON formatted data in the body of your request");
        }
        try {
            return JSON.parseToObject(json, UIDMeta.class);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException("Unable to parse the given JSON", iae);
        }
    }

    @Override
    public TSMeta parseTSMetaV1() {
        String json = this.query.getContent();
        if (json == null || json.isEmpty()) {
            throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Missing message content", "Supply valid JSON formatted data in the body of your request");
        }
        try {
            return JSON.parseToObject(json, TSMeta.class);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException("Unable to parse the given JSON", iae);
        }
    }

    @Override
    public Tree parseTreeV1() {
        String json = this.query.getContent();
        if (json == null || json.isEmpty()) {
            throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Missing message content", "Supply valid JSON formatted data in the body of your request");
        }
        try {
            HashMap<String, String> properties = JSON.parseToObject(json, TR_HASH_MAP);
            Tree tree = new Tree();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                if (entry.getValue() == null) continue;
                if (entry.getKey().toLowerCase().equals("treeid")) {
                    tree.setTreeId(Integer.parseInt(entry.getValue()));
                    continue;
                }
                if (entry.getKey().toLowerCase().equals("name")) {
                    tree.setName(entry.getValue());
                    continue;
                }
                if (entry.getKey().toLowerCase().equals("description")) {
                    tree.setDescription(entry.getValue());
                    continue;
                }
                if (entry.getKey().toLowerCase().equals("notes")) {
                    tree.setNotes(entry.getValue());
                    continue;
                }
                if (entry.getKey().toLowerCase().equals("enabled")) {
                    if (entry.getValue().toLowerCase().equals("true")) {
                        tree.setEnabled(true);
                        continue;
                    }
                    tree.setEnabled(false);
                    continue;
                }
                if (entry.getKey().toLowerCase().equals("strictmatch")) {
                    if (entry.getValue().toLowerCase().equals("true")) {
                        tree.setStrictMatch(true);
                        continue;
                    }
                    tree.setStrictMatch(false);
                    continue;
                }
                if (!entry.getKey().toLowerCase().equals("storefailures")) continue;
                if (entry.getValue().toLowerCase().equals("true")) {
                    tree.setStoreFailures(true);
                    continue;
                }
                tree.setStoreFailures(false);
            }
            return tree;
        }
        catch (NumberFormatException nfe) {
            throw new BadRequestException("Unable to parse 'tree' value");
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException("Unable to parse the given JSON", iae);
        }
    }

    @Override
    public TreeRule parseTreeRuleV1() {
        String json = this.query.getContent();
        if (json == null || json.isEmpty()) {
            throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Missing message content", "Supply valid JSON formatted data in the body of your request");
        }
        return JSON.parseToObject(json, TreeRule.class);
    }

    @Override
    public List<TreeRule> parseTreeRulesV1() {
        String json = this.query.getContent();
        if (json == null || json.isEmpty()) {
            throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Missing message content", "Supply valid JSON formatted data in the body of your request");
        }
        return JSON.parseToObject(json, TR_TREE_RULES);
    }

    @Override
    public Map<String, Object> parseTreeTSUIDsListV1() {
        String json = this.query.getContent();
        if (json == null || json.isEmpty()) {
            throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Missing message content", "Supply valid JSON formatted data in the body of your request");
        }
        return JSON.parseToObject(json, TR_HASH_MAP_OBJ);
    }

    @Override
    public Annotation parseAnnotationV1() {
        String json = this.query.getContent();
        if (json == null || json.isEmpty()) {
            throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Missing message content", "Supply valid JSON formatted data in the body of your request");
        }
        return JSON.parseToObject(json, Annotation.class);
    }

    @Override
    public List<Annotation> parseAnnotationsV1() {
        String json = this.query.getContent();
        if (json == null || json.isEmpty()) {
            throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Missing message content", "Supply valid JSON formatted data in the body of your request");
        }
        return JSON.parseToObject(json, TR_ANNOTATIONS);
    }

    @Override
    public AnnotationRpc.AnnotationBulkDelete parseAnnotationBulkDeleteV1() {
        String json = this.query.getContent();
        if (json == null || json.isEmpty()) {
            throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Missing message content", "Supply valid JSON formatted data in the body of your request");
        }
        return JSON.parseToObject(json, AnnotationRpc.AnnotationBulkDelete.class);
    }

    @Override
    public SearchQuery parseSearchQueryV1() {
        String json = this.query.getContent();
        if (json == null || json.isEmpty()) {
            throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Missing message content", "Supply valid JSON formatted data in the body of your request");
        }
        return JSON.parseToObject(json, SearchQuery.class);
    }

    @Override
    public ChannelBuffer formatPutV1(Map<String, Object> results) {
        return this.serializeJSON(results);
    }

    @Override
    public ChannelBuffer formatSuggestV1(List<String> suggestions) {
        return this.serializeJSON(suggestions);
    }

    @Override
    public ChannelBuffer formatSerializersV1() {
        return this.serializeJSON(HttpQuery.getSerializerStatus());
    }

    @Override
    public ChannelBuffer formatAggregatorsV1(Set<String> aggregators) {
        return this.serializeJSON(aggregators);
    }

    @Override
    public ChannelBuffer formatVersionV1(Map<String, String> version) {
        return this.serializeJSON(version);
    }

    @Override
    public ChannelBuffer formatDropCachesV1(Map<String, String> response) {
        return this.serializeJSON(response);
    }

    @Override
    public ChannelBuffer formatUidAssignV1(Map<String, TreeMap<String, String>> response) {
        return this.serializeJSON(response);
    }

    @Override
    public ChannelBuffer formatUidRenameV1(Map<String, String> response) {
        return this.serializeJSON(response);
    }

    @Override
    public ChannelBuffer formatQueryV1(TSQuery data_query, List<DataPoints[]> results, List<Annotation> globals) {
        try {
            return (ChannelBuffer)this.formatQueryAsyncV1(data_query, results, globals).joinUninterruptibly();
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Shouldn't be here", e);
        }
    }

    @Override
    public Deferred<ChannelBuffer> formatQueryAsyncV1(final TSQuery data_query, List<DataPoints[]> results, final List<Annotation> globals) throws IOException {
        long start = DateTime.currentTimeMillis();
        final boolean as_arrays = this.query.hasQueryStringParam("arrays");
        final String jsonp = this.query.getQueryStringParam("jsonp");
        ChannelBuffer response = ChannelBuffers.dynamicBuffer();
        ChannelBufferOutputStream output = new ChannelBufferOutputStream(response);
        final ArrayList<Boolean> timeout_flag = new ArrayList<Boolean>(1);
        timeout_flag.add(false);
        if (jsonp != null && !jsonp.isEmpty()) {
            output.write((jsonp + "(").getBytes(this.query.getCharset()));
        }
        final JsonGenerator json = JSON.getFactory().createGenerator((OutputStream)output);
        json.writeStartArray();
        Deferred cb_chain = new Deferred();
        for (DataPoints[] separate_dps : results) {
            for (DataPoints dps : separate_dps) {
                try {
                    class DPsResolver
                    implements Callback<Deferred<Object>, Object> {
                        final StringBuilder metric = new StringBuilder(256);
                        final Map<String, String> tags = new HashMap<String, String>();
                        final List<String> agg_tags = new ArrayList<String>();
                        final List<Deferred<Object>> resolve_deferreds = new ArrayList<Deferred<Object>>();
                        final DataPoints dps;
                        long uid_start;

                        public DPsResolver(DataPoints dps) {
                            this.dps = dps;
                        }

                        public Deferred<Object> call(Object obj) throws Exception {
                            this.uid_start = DateTime.nanoTime();
                            this.resolve_deferreds.add((Deferred<Object>)this.dps.metricNameAsync().addCallback((Callback)new 1DPsResolver.MetricResolver()));
                            this.resolve_deferreds.add((Deferred<Object>)this.dps.getTagsAsync().addCallback((Callback)new 1DPsResolver.TagResolver()));
                            this.resolve_deferreds.add((Deferred<Object>)this.dps.getAggregatedTagsAsync().addCallback((Callback)new 1DPsResolver.AggTagResolver()));
                            return Deferred.group(this.resolve_deferreds).addCallback((Callback)new 1DPsResolver.WriteToBuffer(this.dps));
                        }

                        class 1DPsResolver.WriteToBuffer
                        implements Callback<Object, ArrayList<Object>> {
                            final DataPoints dps;

                            public 1DPsResolver.WriteToBuffer(DataPoints dps) {
                                this.dps = dps;
                            }

                            public Object call(ArrayList<Object> deferreds) throws Exception {
                                double value;
                                long timestamp;
                                data_query.getQueryStats().addStat(this.dps.getQueryIndex(), QueryStats.QueryStat.UID_TO_STRING_TIME, DateTime.nanoTime() - uid_start);
                                long local_serialization_start = DateTime.nanoTime();
                                TSSubQuery orig_query = data_query.getQueries().get(this.dps.getQueryIndex());
                                json.writeStartObject();
                                json.writeStringField("metric", metric.toString());
                                json.writeFieldName("tags");
                                json.writeStartObject();
                                if (this.dps.getTags() != null) {
                                    for (Map.Entry<String, String> tag : tags.entrySet()) {
                                        json.writeStringField(tag.getKey(), tag.getValue());
                                    }
                                }
                                json.writeEndObject();
                                json.writeFieldName("aggregateTags");
                                json.writeStartArray();
                                if (this.dps.getAggregatedTags() != null) {
                                    for (String atag : agg_tags) {
                                        json.writeString(atag);
                                    }
                                }
                                json.writeEndArray();
                                if (data_query.getShowQuery()) {
                                    json.writeObjectField("query", (Object)orig_query);
                                }
                                if (data_query.getShowTSUIDs()) {
                                    json.writeFieldName("tsuids");
                                    json.writeStartArray();
                                    List<String> tsuids = this.dps.getTSUIDs();
                                    Collections.sort(tsuids);
                                    for (String tsuid : tsuids) {
                                        json.writeString(tsuid);
                                    }
                                    json.writeEndArray();
                                }
                                if (!data_query.getNoAnnotations()) {
                                    long ts;
                                    List<Annotation> annotations = this.dps.getAnnotations();
                                    if (annotations != null) {
                                        Collections.sort(annotations);
                                        json.writeArrayFieldStart("annotations");
                                        for (Annotation note : annotations) {
                                            ts = note.getStartTime();
                                            if ((ts & 0xFFFFFFFF00000000L) == 0L) {
                                                ts *= 1000L;
                                            }
                                            if (ts < data_query.startTime() || ts > data_query.endTime()) continue;
                                            json.writeObject((Object)note);
                                        }
                                        json.writeEndArray();
                                    }
                                    if (globals != null && !globals.isEmpty()) {
                                        Collections.sort(globals);
                                        json.writeArrayFieldStart("globalAnnotations");
                                        for (Annotation note : globals) {
                                            ts = note.getStartTime();
                                            if ((ts & 0xFFFFFFFF00000000L) == 0L) {
                                                ts *= 1000L;
                                            }
                                            if (ts < data_query.startTime() || ts > data_query.endTime()) continue;
                                            json.writeObject((Object)note);
                                        }
                                        json.writeEndArray();
                                    }
                                }
                                long dps_start = DateTime.nanoTime();
                                json.writeFieldName("dps");
                                long counter = 0L;
                                if (!((Boolean)timeout_flag.get(0)).booleanValue() && as_arrays) {
                                    json.writeStartArray();
                                    for (DataPoint dp : this.dps) {
                                        if (dp.timestamp() < data_query.startTime() || dp.timestamp() > data_query.endTime()) continue;
                                        timestamp = data_query.getMsResolution() ? dp.timestamp() : dp.timestamp() / 1000L;
                                        json.writeStartArray();
                                        json.writeNumber(timestamp);
                                        if (dp.isInteger()) {
                                            json.writeNumber(dp.longValue());
                                        } else {
                                            value = dp.doubleValue();
                                            if (Double.isNaN(value) && orig_query.fillPolicy() == FillPolicy.NULL) {
                                                json.writeNull();
                                            } else {
                                                json.writeNumber(dp.doubleValue());
                                            }
                                        }
                                        json.writeEndArray();
                                        ++counter;
                                    }
                                    json.writeEndArray();
                                } else if (!((Boolean)timeout_flag.get(0)).booleanValue()) {
                                    json.writeStartObject();
                                    for (DataPoint dp : this.dps) {
                                        if (dp.timestamp() < data_query.startTime() || dp.timestamp() > data_query.endTime()) continue;
                                        long l = timestamp = data_query.getMsResolution() ? dp.timestamp() : dp.timestamp() / 1000L;
                                        if (dp.isInteger()) {
                                            json.writeNumberField(Long.toString(timestamp), dp.longValue());
                                        } else {
                                            value = dp.doubleValue();
                                            if (Double.isNaN(value) && orig_query.fillPolicy() == FillPolicy.NULL) {
                                                json.writeNumberField(Long.toString(timestamp), null);
                                            } else {
                                                json.writeNumberField(Long.toString(timestamp), dp.doubleValue());
                                            }
                                        }
                                        ++counter;
                                    }
                                    json.writeEndObject();
                                } else {
                                    json.writeStartObject();
                                    json.writeEndObject();
                                }
                                long agg_time = DateTime.nanoTime() - dps_start;
                                data_query.getQueryStats().addStat(this.dps.getQueryIndex(), QueryStats.QueryStat.AGGREGATION_TIME, agg_time);
                                data_query.getQueryStats().addStat(this.dps.getQueryIndex(), QueryStats.QueryStat.AGGREGATED_SIZE, counter);
                                data_query.getQueryStats().addStat(this.dps.getQueryIndex(), QueryStats.QueryStat.SERIALIZATION_TIME, DateTime.nanoTime() - local_serialization_start);
                                if (!((Boolean)timeout_flag.get(0)).booleanValue() && data_query.getShowStats()) {
                                    int query_index = this.dps == null ? -1 : this.dps.getQueryIndex();
                                    QueryStats stats = data_query.getQueryStats();
                                    if (query_index >= 0) {
                                        json.writeFieldName("stats");
                                        Map<String, Object> s = stats.getQueryStats(query_index, false);
                                        if (s != null) {
                                            json.writeObject(s);
                                        } else {
                                            json.writeStringField("ERROR", "NO STATS FOUND");
                                        }
                                    }
                                }
                                json.writeEndObject();
                                return null;
                            }
                        }

                        class 1DPsResolver.AggTagResolver
                        implements Callback<Object, List<String>> {
                            1DPsResolver.AggTagResolver() {
                            }

                            public Object call(List<String> tags) throws Exception {
                                agg_tags.addAll(tags);
                                return null;
                            }
                        }

                        class 1DPsResolver.TagResolver
                        implements Callback<Object, Map<String, String>> {
                            1DPsResolver.TagResolver() {
                            }

                            public Object call(Map<String, String> tags) throws Exception {
                                tags.putAll(tags);
                                return null;
                            }
                        }

                        class 1DPsResolver.MetricResolver
                        implements Callback<Object, String> {
                            1DPsResolver.MetricResolver() {
                            }

                            public Object call(String metric) throws Exception {
                                metric.append(metric);
                                return null;
                            }
                        }
                    }
                    cb_chain.addCallback((Callback)new DPsResolver(dps));
                }
                catch (Exception e) {
                    throw new RuntimeException("Unexpected error durring resolution", e);
                }
            }
        }
        cb_chain.callback(null);
        class FinalCB
        implements Callback<ChannelBuffer, Object> {
            final /* synthetic */ OutputStream val$output;
            final /* synthetic */ ChannelBuffer val$response;

            FinalCB() {
                this.val$output = outputStream;
                this.val$response = channelBuffer;
            }

            public ChannelBuffer call(Object obj) throws Exception {
                data_query.getQueryStats().markSerializationSuccessful();
                if (data_query.getShowSummary()) {
                    QueryStats stats = data_query.getQueryStats();
                    json.writeStartObject();
                    json.writeFieldName("statsSummary");
                    json.writeObject(stats.getStats(true, true));
                    json.writeEndObject();
                }
                json.writeEndArray();
                json.close();
                if (jsonp != null && !jsonp.isEmpty()) {
                    this.val$output.write(")".getBytes());
                }
                return this.val$response;
            }
        }
        return cb_chain.addCallback((Callback)new FinalCB());
    }

    @Override
    public ChannelBuffer formatLastPointQueryV1(List<IncomingDataPoint> data_points) {
        return this.serializeJSON(data_points);
    }

    @Override
    public ChannelBuffer formatUidMetaV1(UIDMeta meta) {
        return this.serializeJSON(meta);
    }

    @Override
    public ChannelBuffer formatTSMetaV1(TSMeta meta) {
        return this.serializeJSON(meta);
    }

    @Override
    public ChannelBuffer formatTSMetaListV1(List<TSMeta> metas) {
        return this.serializeJSON(metas);
    }

    @Override
    public ChannelBuffer formatBranchV1(Branch branch) {
        return this.serializeJSON(branch);
    }

    @Override
    public ChannelBuffer formatTreeV1(Tree tree) {
        return this.serializeJSON(tree);
    }

    @Override
    public ChannelBuffer formatTreesV1(List<Tree> trees) {
        return this.serializeJSON(trees);
    }

    @Override
    public ChannelBuffer formatTreeRuleV1(TreeRule rule) {
        return this.serializeJSON(rule);
    }

    @Override
    public ChannelBuffer formatTreeCollisionNotMatchedV1(Map<String, String> results, boolean is_collisions) {
        return this.serializeJSON(results);
    }

    @Override
    public ChannelBuffer formatTreeTestV1(HashMap<String, HashMap<String, Object>> results) {
        return this.serializeJSON(results);
    }

    @Override
    public ChannelBuffer formatAnnotationV1(Annotation note) {
        return this.serializeJSON(note);
    }

    @Override
    public ChannelBuffer formatAnnotationsV1(List<Annotation> notes) {
        return this.serializeJSON(notes);
    }

    @Override
    public ChannelBuffer formatAnnotationBulkDeleteV1(AnnotationRpc.AnnotationBulkDelete request) {
        return this.serializeJSON(request);
    }

    @Override
    public ChannelBuffer formatStatsV1(List<IncomingDataPoint> stats) {
        return this.serializeJSON(stats);
    }

    @Override
    public ChannelBuffer formatThreadStatsV1(List<Map<String, Object>> stats) {
        return this.serializeJSON(stats);
    }

    @Override
    public ChannelBuffer formatRegionStatsV1(List<Map<String, Object>> stats) {
        return this.serializeJSON(stats);
    }

    @Override
    public ChannelBuffer formatJVMStatsV1(Map<String, Map<String, Object>> stats) {
        return this.serializeJSON(stats);
    }

    @Override
    public ChannelBuffer formatQueryStatsV1(Map<String, Object> query_stats) {
        return this.serializeJSON(query_stats);
    }

    @Override
    public ChannelBuffer formatSearchResultsV1(SearchQuery results) {
        return this.serializeJSON(results);
    }

    @Override
    public ChannelBuffer formatConfigV1(Config config) {
        TreeMap<String, String> map = new TreeMap<String, String>(config.getMap());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getKey().toUpperCase().contains("PASS")) continue;
            map.put(entry.getKey(), "********");
        }
        return this.serializeJSON(map);
    }

    @Override
    public ChannelBuffer formatFilterConfigV1(Map<String, Map<String, String>> config) {
        return this.serializeJSON(config);
    }

    private ChannelBuffer serializeJSON(Object obj) {
        if (this.query.hasQueryStringParam("jsonp")) {
            return ChannelBuffers.wrappedBuffer((byte[])JSON.serializeToJSONPBytes(this.query.getQueryStringParam("jsonp"), obj));
        }
        return ChannelBuffers.wrappedBuffer((byte[])JSON.serializeToBytes(obj));
    }
}

