/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tsd;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import com.stumbleupon.async.Deferred;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.opentsdb.core.Const;
import net.opentsdb.core.TSDB;
import net.opentsdb.stats.Histogram;
import net.opentsdb.stats.StatsCollector;
import net.opentsdb.tsd.AbstractHttpQuery;
import net.opentsdb.tsd.BadRequestException;
import net.opentsdb.tsd.HttpJsonSerializer;
import net.opentsdb.tsd.HttpSerializer;
import net.opentsdb.utils.PluginLoader;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.DefaultFileRegion;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpQuery
extends AbstractHttpQuery {
    private static final Logger LOG = LoggerFactory.getLogger(HttpQuery.class);
    private static final String HTML_CONTENT_TYPE = "text/html; charset=UTF-8";
    private static final int MAX_API_VERSION = 1;
    private static final Histogram httplatency = new Histogram(16000, 2, 100);
    private static HashMap<String, Constructor<? extends HttpSerializer>> serializer_map_content_type = null;
    private static HashMap<String, Constructor<? extends HttpSerializer>> serializer_map_query_string = null;
    private static ArrayList<HashMap<String, Object>> serializer_status = null;
    private int api_version = 0;
    private HttpSerializer serializer = null;
    private final boolean show_stack_trace;
    private static final String PAGE_HEADER_START = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"><html><head><meta http-equiv=content-type content=\"text/html;charset=utf-8\"><title>";
    private static final String PAGE_HEADER_MID = "</title>\n<style><!--\nbody{font-family:arial,sans-serif;margin-left:2em}A.l:link{color:#6f6f6f}A.u:link{color:green}.fwf{font-family:monospace;white-space:pre-wrap}//--></style>";
    private static final String PAGE_HEADER_END_BODY_START = "</head>\n<body text=#000000 bgcolor=#ffffff><table border=0 cellpadding=2 cellspacing=0 width=100%><tr><td rowspan=3 width=1% nowrap><img src=s/opentsdb_header.jpg><td>&nbsp;</td></tr><tr><td><font color=#507e9b><b>";
    private static final String PAGE_BODY_MID = "</b></td></tr><tr><td>&nbsp;</td></tr></table>";
    private static final String PAGE_FOOTER = "<table width=100% cellpadding=0 cellspacing=0><tr><td class=subg><img alt=\"\" width=1 height=6></td></tr></table></body></html>";
    private static final int BOILERPLATE_LENGTH = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"><html><head><meta http-equiv=content-type content=\"text/html;charset=utf-8\"><title>".length() + "</title>\n<style><!--\nbody{font-family:arial,sans-serif;margin-left:2em}A.l:link{color:#6f6f6f}A.u:link{color:green}.fwf{font-family:monospace;white-space:pre-wrap}//--></style>".length() + "</head>\n<body text=#000000 bgcolor=#ffffff><table border=0 cellpadding=2 cellspacing=0 width=100%><tr><td rowspan=3 width=1% nowrap><img src=s/opentsdb_header.jpg><td>&nbsp;</td></tr><tr><td><font color=#507e9b><b>".length() + "</b></td></tr><tr><td>&nbsp;</td></tr></table>".length() + "<table width=100% cellpadding=0 cellspacing=0><tr><td class=subg><img alt=\"\" width=1 height=6></td></tr></table></body></html>".length();
    private static final StringBuilder PAGE_NOT_FOUND = HttpQuery.makePage("Page Not Found", "Error 404", "<blockquote><h1>Page Not Found</h1>The requested URL was not found on this server.</blockquote>");

    public HttpQuery(TSDB tsdb, HttpRequest request, Channel chan) {
        super(tsdb, request, chan);
        this.show_stack_trace = tsdb.getConfig().getBoolean("tsd.http.show_stack_trace");
        this.serializer = new HttpJsonSerializer(this);
    }

    public static void collectStats(StatsCollector collector) {
        collector.record("http.latency", httplatency, "type=all");
    }

    public int apiVersion() {
        return this.api_version;
    }

    public boolean showStackTrace() {
        return this.show_stack_trace;
    }

    public Deferred<Object> getDeferred() {
        return this.deferred;
    }

    public HttpSerializer serializer() {
        return this.serializer;
    }

    public String[] explodeAPIPath() {
        String[] split = this.explodePath();
        int index = 1;
        if (split.length < 1 || !split[0].toLowerCase().equals("api")) {
            throw new IllegalArgumentException("The URI does not start with \"/api\"");
        }
        if (split.length < 2) {
            String[] root = new String[]{""};
            return root;
        }
        if (split[1].toLowerCase().startsWith("v") && split[1].length() > 1 && Character.isDigit(split[1].charAt(1))) {
            index = 2;
        }
        if (split.length - index == 0) {
            String[] root = new String[]{""};
            return root;
        }
        String[] path = new String[split.length - index];
        int path_idx = 0;
        for (int i = index; i < split.length; ++i) {
            path[path_idx] = split[i];
            ++path_idx;
        }
        return path;
    }

    @Override
    public String getQueryBaseRoute() {
        String[] split = this.explodePath();
        if (split.length < 1) {
            return "";
        }
        if (!split[0].toLowerCase().equals("api")) {
            return split[0].toLowerCase();
        }
        this.api_version = 1;
        if (split.length < 2) {
            return "api";
        }
        if (split[1].toLowerCase().startsWith("v") && split[1].length() > 1 && Character.isDigit(split[1].charAt(1))) {
            try {
                int version = Integer.parseInt(split[1].substring(1));
                if (version > 1) {
                    throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "Requested API version is greater than the max implemented", "API version [" + version + "] is greater than the max [" + 1 + "]");
                }
                this.api_version = version;
            }
            catch (NumberFormatException nfe) {
                throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Invalid API version format supplied", "API version [" + split[1].substring(1) + "] cannot be parsed to an integer");
            }
        } else {
            return "api/" + split[1].toLowerCase();
        }
        if (split.length < 3) {
            return "api";
        }
        return "api/" + split[2].toLowerCase();
    }

    public HttpMethod getAPIMethod() {
        if (this.method() != HttpMethod.GET) {
            return this.method();
        }
        if (this.hasQueryStringParam("method_override")) {
            String qs_method = this.getQueryStringParam("method_override");
            if (qs_method == null || qs_method.isEmpty()) {
                throw new BadRequestException(HttpResponseStatus.METHOD_NOT_ALLOWED, "Missing method override value");
            }
            if (qs_method.toLowerCase().equals("get")) {
                return HttpMethod.GET;
            }
            if (qs_method.toLowerCase().equals("post")) {
                return HttpMethod.POST;
            }
            if (qs_method.toLowerCase().equals("put")) {
                return HttpMethod.PUT;
            }
            if (qs_method.toLowerCase().equals("delete")) {
                return HttpMethod.DELETE;
            }
            throw new BadRequestException(HttpResponseStatus.METHOD_NOT_ALLOWED, "Unknown or unsupported method override value");
        }
        return this.method();
    }

    public void setSerializer() throws InvocationTargetException, IllegalArgumentException, InstantiationException, IllegalAccessException {
        Constructor<? extends HttpSerializer> ctor;
        if (this.hasQueryStringParam("serializer")) {
            String qs = this.getQueryStringParam("serializer");
            Constructor<? extends HttpSerializer> ctor2 = serializer_map_query_string.get(qs);
            if (ctor2 == null) {
                this.serializer = new HttpJsonSerializer(this);
                throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Requested serializer was not found", "Could not find a serializer with the name: " + qs);
            }
            this.serializer = ctor2.newInstance(this);
            return;
        }
        String content_type = this.request().headers().get("Content-Type");
        if (content_type == null || content_type.isEmpty()) {
            return;
        }
        if (content_type.indexOf(";") > -1) {
            content_type = content_type.substring(0, content_type.indexOf(";"));
        }
        if ((ctor = serializer_map_content_type.get(content_type)) == null) {
            return;
        }
        this.serializer = ctor.newInstance(this);
    }

    @Override
    public void internalError(Exception cause) {
        this.logError("Internal Server Error on " + this.request().getUri(), cause);
        if (this.api_version > 0) {
            switch (this.api_version) {
                default: 
            }
            this.sendReply(HttpResponseStatus.INTERNAL_SERVER_ERROR, this.serializer.formatErrorV1(cause));
            return;
        }
        ThrowableProxy tp = new ThrowableProxy((Throwable)cause);
        tp.calculatePackagingData();
        String pretty_exc = ThrowableProxyUtil.asString((IThrowableProxy)tp);
        tp = null;
        if (this.hasQueryStringParam("json")) {
            StringBuilder buf = new StringBuilder(32 + pretty_exc.length());
            buf.append("{\"err\":\"");
            HttpQuery.escapeJson(pretty_exc, buf);
            buf.append("\"}");
            this.sendReply(HttpResponseStatus.INTERNAL_SERVER_ERROR, buf);
        } else {
            this.sendReply(HttpResponseStatus.INTERNAL_SERVER_ERROR, HttpQuery.makePage("Internal Server Error", "Houston, we have a problem", "<blockquote><h1>Internal Server Error</h1>Oops, sorry but your request failed due to a server error.<br/><br/>Please try again in 30 seconds.<pre>" + pretty_exc + "</pre></blockquote>"));
        }
    }

    public void badRequest(String explain) {
        this.badRequest(new BadRequestException(explain));
    }

    @Override
    public void badRequest(BadRequestException exception) {
        this.logWarn("Bad Request on " + this.request().getUri() + ": " + exception.getMessage());
        if (this.api_version > 0) {
            switch (this.api_version) {
                default: 
            }
            this.sendReply(exception.getStatus(), this.serializer.formatErrorV1(exception));
            return;
        }
        if (this.hasQueryStringParam("json")) {
            StringBuilder buf = new StringBuilder(10 + exception.getDetails().length());
            buf.append("{\"err\":\"");
            HttpQuery.escapeJson(exception.getMessage(), buf);
            buf.append("\"}");
            this.sendReply(HttpResponseStatus.BAD_REQUEST, buf);
        } else {
            this.sendReply(HttpResponseStatus.BAD_REQUEST, HttpQuery.makePage("Bad Request", "Looks like it's your fault this time", "<blockquote><h1>Bad Request</h1>Sorry but your request was rejected as being invalid.<br/><br/>The reason provided was:<blockquote>" + exception.getMessage() + "</blockquote></blockquote>"));
        }
    }

    @Override
    public void notFound() {
        this.logWarn("Not Found: " + this.request().getUri());
        if (this.api_version > 0) {
            switch (this.api_version) {
                default: 
            }
            this.sendReply(HttpResponseStatus.NOT_FOUND, this.serializer.formatNotFoundV1());
            return;
        }
        if (this.hasQueryStringParam("json")) {
            this.sendReply(HttpResponseStatus.NOT_FOUND, new StringBuilder("{\"err\":\"Page Not Found\"}"));
        } else {
            this.sendReply(HttpResponseStatus.NOT_FOUND, PAGE_NOT_FOUND);
        }
    }

    public void redirect(String location) {
        this.response().headers().set("Location", (Object)location);
        this.sendReply(HttpResponseStatus.OK, ("<html></head><meta http-equiv=\"refresh\" content=\"0; url=" + location + "\"></head></html>").getBytes(this.getCharset()));
    }

    static void escapeJson(String s, StringBuilder buf) {
        char c;
        int i;
        int length = s.length();
        int extra = 0;
        block12: for (i = 0; i < length; ++i) {
            c = s.charAt(i);
            switch (c) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\"': 
                case '\\': {
                    ++extra;
                    continue block12;
                }
                default: {
                    if (c >= '\u001f') continue block12;
                    extra += 4;
                }
            }
        }
        if (extra == 0) {
            buf.append(s);
            return;
        }
        buf.ensureCapacity(buf.length() + length + extra);
        block13: for (i = 0; i < length; ++i) {
            c = s.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append('\\').append('\"');
                    continue block13;
                }
                case '\\': {
                    buf.append('\\').append('\\');
                    continue block13;
                }
                case '\b': {
                    buf.append('\\').append('b');
                    continue block13;
                }
                case '\f': {
                    buf.append('\\').append('f');
                    continue block13;
                }
                case '\n': {
                    buf.append('\\').append('n');
                    continue block13;
                }
                case '\r': {
                    buf.append('\\').append('r');
                    continue block13;
                }
                case '\t': {
                    buf.append('\\').append('t');
                    continue block13;
                }
                default: {
                    if (c < '\u001f') {
                        buf.append('\\').append('u').append('0').append('0').append((char)Const.HEX[c >>> 4 & 0xF]).append((char)Const.HEX[c & 0xF]);
                        continue block13;
                    }
                    buf.append(c);
                }
            }
        }
    }

    public void sendReply(byte[] data) {
        this.sendBuffer(HttpResponseStatus.OK, ChannelBuffers.wrappedBuffer((byte[])data));
    }

    public void sendReply(HttpResponseStatus status, byte[] data) {
        this.sendBuffer(status, ChannelBuffers.wrappedBuffer((byte[])data));
    }

    public void sendReply(StringBuilder buf) {
        this.sendReply(HttpResponseStatus.OK, buf);
    }

    public void sendReply(String buf) {
        this.sendBuffer(HttpResponseStatus.OK, ChannelBuffers.copiedBuffer((CharSequence)buf, (Charset)CharsetUtil.UTF_8));
    }

    public void sendReply(HttpResponseStatus status, StringBuilder buf) {
        this.sendBuffer(status, ChannelBuffers.copiedBuffer((CharSequence)buf.toString(), (Charset)CharsetUtil.UTF_8));
    }

    public void sendReply(ChannelBuffer buf) {
        this.sendBuffer(HttpResponseStatus.OK, buf);
    }

    public void sendReply(HttpResponseStatus status, ChannelBuffer buf) {
        this.sendBuffer(status, buf);
    }

    public void sendFile(String path, int max_age) throws IOException {
        this.sendFile(HttpResponseStatus.OK, path, max_age);
    }

    public void sendFile(HttpResponseStatus status, String path, int max_age) throws IOException {
        RandomAccessFile file;
        if (max_age < 0) {
            throw new IllegalArgumentException("Negative max_age=" + max_age + " for path=" + path);
        }
        if (!this.channel().isConnected()) {
            this.done();
            return;
        }
        try {
            file = new RandomAccessFile(path, "r");
        }
        catch (FileNotFoundException e) {
            this.logWarn("File not found: " + e.getMessage());
            if (this.getQueryString() != null && !this.getQueryString().isEmpty()) {
                this.getQueryString().remove("png");
            }
            this.sendReply(HttpResponseStatus.NOT_FOUND, this.serializer.formatNotFoundV1());
            return;
        }
        long length = file.length();
        String mimetype = HttpQuery.guessMimeTypeFromUri(path);
        this.response().headers().set("Content-Type", (Object)(mimetype == null ? "text/plain" : mimetype));
        long mtime = new File(path).lastModified();
        if (mtime > 0L) {
            this.response().headers().set("Age", (Object)((System.currentTimeMillis() - mtime) / 1000L));
        } else {
            this.logWarn("Found a file with mtime=" + mtime + ": " + path);
        }
        this.response().headers().set("Cache-Control", (Object)("max-age=" + max_age));
        HttpHeaders.setContentLength((HttpMessage)this.response(), (long)length);
        this.channel().write((Object)this.response());
        final DefaultFileRegion region = new DefaultFileRegion(file.getChannel(), 0L, length);
        ChannelFuture future = this.channel().write((Object)region);
        future.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                region.releaseExternalResources();
                HttpQuery.this.done();
            }
        });
        if (!HttpHeaders.isKeepAlive((HttpMessage)this.request())) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
    }

    @Override
    public void done() {
        int processing_time = this.processingTimeMillis();
        httplatency.add(processing_time);
        this.logInfo("HTTP " + this.request().getUri() + " done in " + processing_time + "ms");
        this.deferred.callback(null);
    }

    private void sendBuffer(HttpResponseStatus status, ChannelBuffer buf) {
        String contentType = this.api_version < 1 ? this.guessMimeType(buf) : this.serializer.responseContentType();
        this.sendBuffer(status, buf, contentType);
    }

    private String guessMimeType(ChannelBuffer buf) {
        String mimetype = HttpQuery.guessMimeTypeFromUri(this.request().getUri());
        return mimetype == null ? this.guessMimeTypeFromContents(buf) : mimetype;
    }

    private static String guessMimeTypeFromUri(String uri) {
        int questionmark = uri.indexOf(63, 1);
        int end = (questionmark > 0 ? questionmark : uri.length()) - 1;
        if (end < 5) {
            return null;
        }
        char a = uri.charAt(end - 3);
        char b = uri.charAt(end - 2);
        char c = uri.charAt(end - 1);
        switch (uri.charAt(end)) {
            case 'g': {
                return a == '.' && b == 'p' && c == 'n' ? "image/png" : null;
            }
            case 'l': {
                return a == 'h' && b == 't' && c == 'm' ? HTML_CONTENT_TYPE : null;
            }
            case 's': {
                if (a == '.' && b == 'c' && c == 's') {
                    return "text/css";
                }
                if (b != '.' || c != 'j') break;
                return "text/javascript";
            }
            case 'f': {
                return a == '.' && b == 'g' && c == 'i' ? "image/gif" : null;
            }
            case 'o': {
                return a == '.' && b == 'i' && c == 'c' ? "image/x-icon" : null;
            }
        }
        return null;
    }

    private String guessMimeTypeFromContents(ChannelBuffer buf) {
        if (!buf.readable()) {
            this.logWarn("Sending an empty result?! buf=" + buf);
            return "text/plain";
        }
        short firstbyte = buf.getUnsignedByte(buf.readerIndex());
        switch (firstbyte) {
            case 60: {
                return HTML_CONTENT_TYPE;
            }
            case 91: 
            case 123: {
                return "application/json";
            }
            case 137: {
                return "image/png";
            }
        }
        return "text/plain";
    }

    public static void initializeSerializerMaps(TSDB tsdb) throws SecurityException, NoSuchMethodException, ClassNotFoundException {
        Method[] methods;
        List<HttpSerializer> serializers = PluginLoader.loadPlugins(HttpSerializer.class);
        if (serializers == null) {
            serializers = new ArrayList<HttpSerializer>(1);
        }
        HttpJsonSerializer default_serializer = new HttpJsonSerializer();
        serializers.add(default_serializer);
        serializer_map_content_type = new HashMap();
        serializer_map_query_string = new HashMap();
        serializer_status = new ArrayList();
        for (HttpSerializer serializer : serializers) {
            Method[] methods2;
            String err;
            Constructor<?> ctor = serializer.getClass().getDeclaredConstructor(HttpQuery.class);
            Constructor<? extends HttpSerializer> map_ctor = serializer_map_content_type.get(serializer.requestContentType());
            if (map_ctor != null) {
                err = "Serializer content type collision between \"" + serializer.getClass().getCanonicalName() + "\" and \"" + map_ctor.getClass().getCanonicalName() + "\"";
                LOG.error(err);
                throw new IllegalStateException(err);
            }
            serializer_map_content_type.put(serializer.requestContentType(), ctor);
            map_ctor = serializer_map_query_string.get(serializer.shortName());
            if (map_ctor != null) {
                err = "Serializer name collision between \"" + serializer.getClass().getCanonicalName() + "\" and \"" + map_ctor.getClass().getCanonicalName() + "\"";
                LOG.error(err);
                throw new IllegalStateException(err);
            }
            serializer_map_query_string.put(serializer.shortName(), ctor);
            serializer.initialize(tsdb);
            if (serializer.shortName().equals("json")) continue;
            HashMap<String, Object> status = new HashMap<String, Object>();
            status.put("version", serializer.version());
            status.put("class", serializer.getClass().getCanonicalName());
            status.put("serializer", serializer.shortName());
            status.put("request_content_type", serializer.requestContentType());
            status.put("response_content_type", serializer.responseContentType());
            HashSet<String> parsers = new HashSet<String>();
            HashSet<String> formats = new HashSet<String>();
            for (Method m : methods2 = serializer.getClass().getDeclaredMethods()) {
                if (!Modifier.isPublic(m.getModifiers())) continue;
                if (m.getName().startsWith("parse")) {
                    parsers.add(m.getName().substring(5));
                    continue;
                }
                if (!m.getName().startsWith("format")) continue;
                formats.add(m.getName().substring(6));
            }
            status.put("parsers", parsers);
            status.put("formatters", formats);
            serializer_status.add(status);
        }
        HashMap<String, Object> status = new HashMap<String, Object>();
        Class<?> base_serializer = Class.forName("net.opentsdb.tsd.HttpSerializer");
        status.put("class", default_serializer.getClass().getCanonicalName());
        status.put("serializer", ((HttpSerializer)default_serializer).shortName());
        status.put("request_content_type", default_serializer.requestContentType());
        status.put("response_content_type", default_serializer.responseContentType());
        ArrayList<String> parsers = new ArrayList<String>();
        ArrayList<String> formats = new ArrayList<String>();
        for (Method m : methods = base_serializer.getDeclaredMethods()) {
            if (!Modifier.isPublic(m.getModifiers())) continue;
            if (m.getName().startsWith("parse")) {
                parsers.add(m.getName().substring(5));
            }
            if (!m.getName().startsWith("format")) continue;
            formats.add(m.getName().substring(6));
        }
        status.put("parsers", parsers);
        status.put("formatters", formats);
        serializer_status.add(status);
    }

    public static ArrayList<HashMap<String, Object>> getSerializerStatus() {
        return serializer_status;
    }

    public static StringBuilder makePage(String title, String subtitle, String body) {
        return HttpQuery.makePage(null, title, subtitle, body);
    }

    public static StringBuilder makePage(String htmlheader, String title, String subtitle, String body) {
        StringBuilder buf = new StringBuilder(BOILERPLATE_LENGTH + (htmlheader == null ? 0 : htmlheader.length()) + title.length() + subtitle.length() + body.length());
        buf.append(PAGE_HEADER_START).append(title).append(PAGE_HEADER_MID);
        if (htmlheader != null) {
            buf.append(htmlheader);
        }
        buf.append(PAGE_HEADER_END_BODY_START).append(subtitle).append(PAGE_BODY_MID).append(body).append(PAGE_FOOTER);
        return buf;
    }

    @Override
    protected Logger logger() {
        return LOG;
    }
}

