/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tsd;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import com.stumbleupon.async.Deferred;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.IncomingDataPoint;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.TSQuery;
import net.opentsdb.meta.Annotation;
import net.opentsdb.meta.TSMeta;
import net.opentsdb.meta.UIDMeta;
import net.opentsdb.search.SearchQuery;
import net.opentsdb.tree.Branch;
import net.opentsdb.tree.Tree;
import net.opentsdb.tree.TreeRule;
import net.opentsdb.tsd.AnnotationRpc;
import net.opentsdb.tsd.BadRequestException;
import net.opentsdb.tsd.HttpQuery;
import net.opentsdb.tsd.QueryRpc;
import net.opentsdb.utils.Config;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public abstract class HttpSerializer {
    protected String request_content_type = "application/json";
    protected String response_content_type = "application/json; charset=UTF-8";
    protected final HttpQuery query;

    public HttpSerializer() {
        this(null);
    }

    public HttpSerializer(HttpQuery query) {
        this.query = query;
    }

    public abstract void initialize(TSDB var1);

    public abstract Deferred<Object> shutdown();

    public abstract String version();

    public abstract String shortName();

    public String requestContentType() {
        return this.request_content_type;
    }

    public String responseContentType() {
        return this.response_content_type;
    }

    public List<IncomingDataPoint> parsePutV1() {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented parsePutV1");
    }

    public HashMap<String, String> parseSuggestV1() {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented parseSuggestV1");
    }

    public HashMap<String, List<String>> parseUidAssignV1() {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented parseUidAssignV1");
    }

    public HashMap<String, String> parseUidRenameV1() {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented parseUidRenameV1");
    }

    public SearchQuery parseSearchQueryV1() {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented parseSearchQueryV1");
    }

    public TSQuery parseQueryV1() {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented parseQueryV1");
    }

    public QueryRpc.LastPointQuery parseLastPointQueryV1() {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented parseLastPointQueryV1");
    }

    public UIDMeta parseUidMetaV1() {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented parseUidMetaV1");
    }

    public TSMeta parseTSMetaV1() {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented parseTSMetaV1");
    }

    public Tree parseTreeV1() {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented parseTreeV1");
    }

    public TreeRule parseTreeRuleV1() {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented parseTreeRuleV1");
    }

    public List<TreeRule> parseTreeRulesV1() {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented parseTreeRulesV1");
    }

    public Map<String, Object> parseTreeTSUIDsListV1() {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented parseTreeCollisionNotMatchedV1");
    }

    public Annotation parseAnnotationV1() {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented parseAnnotationV1");
    }

    public List<Annotation> parseAnnotationsV1() {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented parseAnnotationsV1");
    }

    public AnnotationRpc.AnnotationBulkDelete parseAnnotationBulkDeleteV1() {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented parseAnnotationBulkDeleteV1");
    }

    public ChannelBuffer formatPutV1(Map<String, Object> results) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatPutV1");
    }

    public ChannelBuffer formatSuggestV1(List<String> suggestions) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatSuggestV1");
    }

    public ChannelBuffer formatSerializersV1() {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatSerializersV1");
    }

    public ChannelBuffer formatAggregatorsV1(Set<String> aggregators) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatAggregatorsV1");
    }

    public ChannelBuffer formatVersionV1(Map<String, String> version) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatVersionV1");
    }

    public ChannelBuffer formatDropCachesV1(Map<String, String> response) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatDropCachesV1");
    }

    public ChannelBuffer formatUidAssignV1(Map<String, TreeMap<String, String>> response) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatUidAssignV1");
    }

    public ChannelBuffer formatUidRenameV1(Map<String, String> response) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatUidRenameV1");
    }

    public ChannelBuffer formatQueryV1(TSQuery query, List<DataPoints[]> results, List<Annotation> globals) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatQueryV1");
    }

    public Deferred<ChannelBuffer> formatQueryAsyncV1(TSQuery query, List<DataPoints[]> results, List<Annotation> globals) throws IOException {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatQueryV1");
    }

    public ChannelBuffer formatLastPointQueryV1(List<IncomingDataPoint> data_points) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatLastPointQueryV1");
    }

    public ChannelBuffer formatUidMetaV1(UIDMeta meta) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatUidMetaV1");
    }

    public ChannelBuffer formatTSMetaV1(TSMeta meta) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatTSMetaV1");
    }

    public ChannelBuffer formatTSMetaListV1(List<TSMeta> metas) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatTSMetaV1");
    }

    public ChannelBuffer formatBranchV1(Branch branch) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatBranchV1");
    }

    public ChannelBuffer formatTreeV1(Tree tree) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatTreeV1");
    }

    public ChannelBuffer formatTreesV1(List<Tree> trees) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatTreesV1");
    }

    public ChannelBuffer formatTreeRuleV1(TreeRule rule) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatTreeRuleV1");
    }

    public ChannelBuffer formatTreeCollisionNotMatchedV1(Map<String, String> results, boolean is_collisions) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatTreeCollisionNotMatched");
    }

    public ChannelBuffer formatTreeTestV1(HashMap<String, HashMap<String, Object>> results) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatTreeTestV1");
    }

    public ChannelBuffer formatAnnotationV1(Annotation note) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatAnnotationV1");
    }

    public ChannelBuffer formatAnnotationsV1(List<Annotation> notes) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatAnnotationsV1");
    }

    public ChannelBuffer formatAnnotationBulkDeleteV1(AnnotationRpc.AnnotationBulkDelete request) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatAnnotationBulkDeleteV1");
    }

    public ChannelBuffer formatStatsV1(List<IncomingDataPoint> stats) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatStatsV1");
    }

    public ChannelBuffer formatThreadStatsV1(List<Map<String, Object>> stats) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatThreadStatsV1");
    }

    public ChannelBuffer formatRegionStatsV1(List<Map<String, Object>> stats) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatRegionStatsV1");
    }

    public ChannelBuffer formatJVMStatsV1(Map<String, Map<String, Object>> map) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatJVMStatsV1");
    }

    public ChannelBuffer formatQueryStatsV1(Map<String, Object> query_stats) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatQueryStatsV1");
    }

    public ChannelBuffer formatSearchResultsV1(SearchQuery results) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatSearchResultsV1");
    }

    public ChannelBuffer formatConfigV1(Config config) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatConfigV1");
    }

    public ChannelBuffer formatFilterConfigV1(Map<String, Map<String, String>> config) {
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "The requested API endpoint has not been implemented", this.getClass().getCanonicalName() + " has not implemented formatFilterConfigV1");
    }

    public ChannelBuffer formatNotFoundV1() {
        StringBuilder output = new StringBuilder(1024);
        if (this.query.hasQueryStringParam("jsonp")) {
            output.append(this.query.getQueryStringParam("jsonp") + "(");
        }
        output.append("{\"error\":{\"code\":");
        output.append(404);
        output.append(",\"message\":\"");
        if (this.query.apiVersion() > 0) {
            output.append("Endpoint not found");
        } else {
            output.append("Page not found");
        }
        output.append("\"}}");
        if (this.query.hasQueryStringParam("jsonp")) {
            output.append(")");
        }
        return ChannelBuffers.copiedBuffer((byte[])output.toString().getBytes(this.query.getCharset()));
    }

    public ChannelBuffer formatErrorV1(BadRequestException exception) {
        StringBuilder output = new StringBuilder(exception.getMessage().length() * 2);
        String jsonp = this.query.getQueryStringParam("jsonp");
        if (jsonp != null && !jsonp.isEmpty()) {
            output.append(this.query.getQueryStringParam("jsonp") + "(");
        }
        output.append("{\"error\":{\"code\":");
        output.append(exception.getStatus().getCode());
        StringBuilder msg = new StringBuilder(exception.getMessage().length());
        HttpQuery.escapeJson(exception.getMessage(), msg);
        output.append(",\"message\":\"").append(msg.toString()).append("\"");
        if (!exception.getDetails().isEmpty()) {
            StringBuilder details = new StringBuilder(exception.getDetails().length());
            HttpQuery.escapeJson(exception.getDetails(), details);
            output.append(",\"details\":\"").append(details.toString()).append("\"");
        }
        if (this.query.showStackTrace()) {
            ThrowableProxy tp = new ThrowableProxy((Throwable)exception);
            tp.calculatePackagingData();
            String pretty_exc = ThrowableProxyUtil.asString((IThrowableProxy)tp);
            StringBuilder trace = new StringBuilder(pretty_exc.length());
            HttpQuery.escapeJson(pretty_exc, trace);
            output.append(",\"trace\":\"").append(trace.toString()).append("\"");
        }
        output.append("}}");
        if (jsonp != null && !jsonp.isEmpty()) {
            output.append(")");
        }
        return ChannelBuffers.copiedBuffer((byte[])output.toString().getBytes(this.query.getCharset()));
    }

    public ChannelBuffer formatErrorV1(Exception exception) {
        String message = exception.getMessage();
        if (exception.getClass() == NullPointerException.class) {
            message = "An internal null pointer exception was thrown";
        } else if (message == null) {
            message = "An unknown exception occurred";
        }
        StringBuilder output = new StringBuilder(message.length() * 2);
        String jsonp = this.query.getQueryStringParam("jsonp");
        if (jsonp != null && !jsonp.isEmpty()) {
            output.append(this.query.getQueryStringParam("jsonp") + "(");
        }
        output.append("{\"error\":{\"code\":");
        output.append(500);
        StringBuilder msg = new StringBuilder(message.length());
        HttpQuery.escapeJson(message, msg);
        output.append(",\"message\":\"").append(msg.toString()).append("\"");
        if (this.query.showStackTrace()) {
            ThrowableProxy tp = new ThrowableProxy((Throwable)exception);
            tp.calculatePackagingData();
            String pretty_exc = ThrowableProxyUtil.asString((IThrowableProxy)tp);
            StringBuilder trace = new StringBuilder(pretty_exc.length());
            HttpQuery.escapeJson(pretty_exc, trace);
            output.append(",\"trace\":\"").append(trace.toString()).append("\"");
        }
        output.append("}}");
        if (jsonp != null && !jsonp.isEmpty()) {
            output.append(")");
        }
        return ChannelBuffers.copiedBuffer((byte[])output.toString().getBytes(this.query.getCharset()));
    }
}

