/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tsd;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;

final class LineBasedFrameDecoder
extends FrameDecoder {
    private final int max_length;
    private boolean discarding;

    public LineBasedFrameDecoder(int max_length) {
        this.max_length = max_length;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        int eol = LineBasedFrameDecoder.findEndOfLine(buffer);
        if (eol != -1) {
            ChannelBuffer frame;
            int length = eol - buffer.readerIndex();
            assert (length >= 0) : "WTF?  length=" + length;
            if (this.discarding) {
                frame = null;
                buffer.skipBytes(length);
            } else {
                frame = buffer.readBytes(length);
            }
            byte delim = buffer.readByte();
            if (delim == 13) {
                buffer.skipBytes(1);
            }
            return frame;
        }
        int buffered = buffer.readableBytes();
        if (!this.discarding && buffered > this.max_length) {
            this.discarding = true;
            Channels.fireExceptionCaught((Channel)ctx.getChannel(), (Throwable)new TooLongFrameException("Frame length exceeds " + this.max_length + " (" + buffered + " bytes buffered already)"));
        }
        if (this.discarding) {
            buffer.skipBytes(buffer.readableBytes());
        }
        return null;
    }

    private static int findEndOfLine(ChannelBuffer buffer) {
        int n = buffer.writerIndex();
        for (int i = buffer.readerIndex(); i < n; ++i) {
            byte b = buffer.getByte(i);
            if (b == 10) {
                return i;
            }
            if (b != 13 || i >= n - 1 || buffer.getByte(i + 1) != 10) continue;
            return i;
        }
        return -1;
    }
}

