/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tsd;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.read.CyclicBufferAppender;
import com.fasterxml.jackson.core.JsonGenerationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.opentsdb.core.TSDB;
import net.opentsdb.tsd.BadRequestException;
import net.opentsdb.tsd.HttpQuery;
import net.opentsdb.tsd.HttpRpc;
import net.opentsdb.utils.JSON;
import org.slf4j.LoggerFactory;

final class LogsRpc
implements HttpRpc {
    LogsRpc() {
    }

    @Override
    public void execute(TSDB tsdb, HttpQuery query) throws JsonGenerationException, IOException {
        LogIterator logmsgs = new LogIterator();
        if (query.hasQueryStringParam("json")) {
            ArrayList<String> logs = new ArrayList<String>();
            for (String log : logmsgs) {
                logs.add(log);
            }
            query.sendReply(JSON.serializeToBytes(logs));
        } else if (query.hasQueryStringParam("level")) {
            Level level = Level.toLevel((String)query.getQueryStringParam("level"), null);
            if (level == null) {
                throw new BadRequestException("Invalid level: " + query.getQueryStringParam("level"));
            }
            Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
            String logger_name = query.getQueryStringParam("logger");
            if (logger_name == null) {
                logger_name = "ROOT";
            } else if (root.getLoggerContext().exists(logger_name) == null) {
                throw new BadRequestException("Invalid logger: " + logger_name);
            }
            Logger logger = (Logger)LoggerFactory.getLogger((String)logger_name);
            int nloggers = 0;
            if (logger == root) {
                for (Logger l : logger.getLoggerContext().getLoggerList()) {
                    l.setLevel(level);
                    ++nloggers;
                }
            } else {
                logger.setLevel(level);
                ++nloggers;
            }
            query.sendReply("Set the log level to " + level + " on " + nloggers + " logger" + (nloggers > 1 ? "s" : "") + ".\n");
        } else {
            StringBuilder buf = new StringBuilder(512);
            for (String logmsg : logmsgs) {
                buf.append(logmsg).append('\n');
            }
            logmsgs = null;
            query.sendReply(buf);
        }
    }

    private static final class LogIterator
    implements Iterator<String>,
    Iterable<String> {
        private final CyclicBufferAppender<ILoggingEvent> logbuf;
        private final StringBuilder buf = new StringBuilder(64);
        private int nevents;

        public LogIterator() {
            Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
            this.logbuf = (CyclicBufferAppender)root.getAppender("CYCLIC");
            if (this.logbuf == null) {
                throw new BadRequestException("No CyclicBufferAppender found. Please configure logback to store the latest log entries.");
            }
        }

        @Override
        public Iterator<String> iterator() {
            this.nevents = this.logbuf.getLength();
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.nevents > 0;
        }

        @Override
        public String next() {
            if (this.hasNext()) {
                --this.nevents;
                ILoggingEvent event = (ILoggingEvent)this.logbuf.get(this.nevents);
                String msg = event.getFormattedMessage();
                this.buf.setLength(0);
                this.buf.append(event.getTimeStamp() / 1000L).append('\t').append(event.getLevel().toString()).append('\t').append(event.getThreadName()).append('\t').append(event.getLoggerName()).append('\t').append(msg);
                IThrowableProxy thrown = event.getThrowableProxy();
                if (thrown != null) {
                    this.buf.append('\t').append(ThrowableProxyUtil.asString((IThrowableProxy)thrown));
                }
                return this.buf.toString();
            }
            throw new NoSuchElementException("no more elements");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

