/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tsd;

import net.opentsdb.core.TSDB;
import net.opentsdb.tsd.ConnectionManager;
import net.opentsdb.tsd.HttpQuery;
import net.opentsdb.tsd.LineBasedFrameDecoder;
import net.opentsdb.tsd.RpcHandler;
import net.opentsdb.tsd.RpcManager;
import net.opentsdb.tsd.WordSplitter;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpContentCompressor;
import org.jboss.netty.handler.codec.http.HttpContentDecompressor;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.codec.string.StringEncoder;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.Timer;

public final class PipelineFactory
implements ChannelPipelineFactory {
    private static final StringEncoder ENCODER = new StringEncoder();
    private static final WordSplitter DECODER = new WordSplitter();
    private final ConnectionManager connmgr;
    private final DetectHttpOrRpc HTTP_OR_RPC = new DetectHttpOrRpc();
    private final Timer timer;
    private final ChannelHandler timeoutHandler;
    private final RpcHandler rpchandler;
    private final TSDB tsdb;
    private final int socketTimeout;

    public PipelineFactory(TSDB tsdb) {
        this(tsdb, RpcManager.instance(tsdb), tsdb.getConfig().getInt("tsd.core.connections.limit"));
    }

    public PipelineFactory(TSDB tsdb, RpcManager manager) {
        this(tsdb, RpcManager.instance(tsdb), tsdb.getConfig().getInt("tsd.core.connections.limit"));
    }

    public PipelineFactory(TSDB tsdb, RpcManager manager, int connections_limit) {
        this.tsdb = tsdb;
        this.socketTimeout = tsdb.getConfig().getInt("tsd.core.socket.timeout");
        this.timer = tsdb.getTimer();
        this.timeoutHandler = new IdleStateHandler(this.timer, 0, 0, this.socketTimeout);
        this.rpchandler = new RpcHandler(tsdb, manager);
        this.connmgr = new ConnectionManager(connections_limit);
        try {
            HttpQuery.initializeSerializerMaps(tsdb);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize formatter plugins", e);
        }
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("connmgr", (ChannelHandler)this.connmgr);
        pipeline.addLast("detect", (ChannelHandler)this.HTTP_OR_RPC);
        return pipeline;
    }

    final class DetectHttpOrRpc
    extends FrameDecoder {
        DetectHttpOrRpc() {
        }

        protected Object decode(ChannelHandlerContext ctx, Channel chan, ChannelBuffer buffer) throws Exception {
            if (buffer.readableBytes() < 1) {
                return null;
            }
            short firstbyte = buffer.getUnsignedByte(buffer.readerIndex());
            ChannelPipeline pipeline = ctx.getPipeline();
            if (65 <= firstbyte && firstbyte <= 90) {
                pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
                if (PipelineFactory.this.tsdb.getConfig().enable_chunked_requests()) {
                    pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(PipelineFactory.this.tsdb.getConfig().max_chunked_requests()));
                }
                pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
                pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
                pipeline.addLast("deflater", (ChannelHandler)new HttpContentCompressor());
            } else {
                pipeline.addLast("framer", (ChannelHandler)new LineBasedFrameDecoder(1024));
                pipeline.addLast("encoder", (ChannelHandler)ENCODER);
                pipeline.addLast("decoder", (ChannelHandler)DECODER);
            }
            pipeline.addLast("timeout", PipelineFactory.this.timeoutHandler);
            pipeline.remove((ChannelHandler)this);
            pipeline.addLast("handler", (ChannelHandler)PipelineFactory.this.rpchandler);
            return buffer.readBytes(buffer.readableBytes());
        }
    }
}

