/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tsd;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import com.stumbleupon.async.TimeoutException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.opentsdb.core.IncomingDataPoint;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.Tags;
import net.opentsdb.stats.StatsCollector;
import net.opentsdb.tsd.BadRequestException;
import net.opentsdb.tsd.HttpQuery;
import net.opentsdb.tsd.HttpRpc;
import net.opentsdb.tsd.StorageExceptionHandler;
import net.opentsdb.tsd.TelnetRpc;
import net.opentsdb.uid.NoSuchUniqueName;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PutDataPointRpc
implements TelnetRpc,
HttpRpc {
    private static final Logger LOG = LoggerFactory.getLogger(PutDataPointRpc.class);
    private static final ArrayList<Boolean> EMPTY_DEFERREDS = new ArrayList(0);
    private static final AtomicLong requests = new AtomicLong();
    private static final AtomicLong hbase_errors = new AtomicLong();
    private static final AtomicLong invalid_values = new AtomicLong();
    private static final AtomicLong illegal_arguments = new AtomicLong();
    private static final AtomicLong unknown_metrics = new AtomicLong();
    private static final AtomicLong writes_blocked = new AtomicLong();
    private static final AtomicLong writes_timedout = new AtomicLong();

    PutDataPointRpc() {
    }

    @Override
    public Deferred<Object> execute(final TSDB tsdb, final Channel chan, final String[] cmd) {
        requests.incrementAndGet();
        String errmsg = null;
        try {
            final class PutErrback
            implements Callback<Exception, Exception> {
                PutErrback() {
                }

                public Exception call(Exception arg) {
                    PutDataPointRpc.this.handleStorageException(tsdb, PutDataPointRpc.this.getDataPointFromString(cmd), arg);
                    if (chan.isConnected()) {
                        if (chan.isWritable()) {
                            chan.write((Object)("put: HBase error: " + arg.getMessage() + '\n'));
                        } else {
                            writes_blocked.incrementAndGet();
                        }
                    }
                    hbase_errors.incrementAndGet();
                    return null;
                }

                public String toString() {
                    return "report error to channel";
                }
            }
            return this.importDataPoint(tsdb, cmd).addErrback((Callback)new PutErrback());
        }
        catch (NumberFormatException x) {
            errmsg = "put: invalid value: " + x.getMessage() + '\n';
            invalid_values.incrementAndGet();
        }
        catch (IllegalArgumentException x) {
            errmsg = "put: illegal argument: " + x.getMessage() + '\n';
            illegal_arguments.incrementAndGet();
        }
        catch (NoSuchUniqueName x) {
            errmsg = "put: unknown metric: " + x.getMessage() + '\n';
            unknown_metrics.incrementAndGet();
        }
        if (errmsg != null) {
            LOG.debug(errmsg);
            if (chan.isConnected()) {
                if (chan.isWritable()) {
                    chan.write((Object)errmsg);
                } else {
                    writes_blocked.incrementAndGet();
                }
            }
        }
        return Deferred.fromResult(null);
    }

    @Override
    public void execute(final TSDB tsdb, final HttpQuery query) throws IOException {
        class GroupCB
        implements Callback<Object, ArrayList<Boolean>> {
            final int queued;

            public GroupCB(int queued) {
                this.queued = queued;
            }

            public Object call(ArrayList<Boolean> results) {
                if (sending_response.get()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Put data point call " + query + " was marked as timedout");
                    }
                    return null;
                }
                sending_response.set(true);
                if (timeout != null) {
                    timeout.cancel();
                }
                int good_writes = 0;
                int failed_writes = 0;
                for (boolean result : results) {
                    if (result) {
                        ++good_writes;
                        continue;
                    }
                    ++failed_writes;
                }
                int failures = dps.size() - this.queued;
                if (!show_summary && !show_details) {
                    if (failures + failed_writes > 0) {
                        query.sendReply(HttpResponseStatus.BAD_REQUEST, query.serializer().formatErrorV1(new BadRequestException(HttpResponseStatus.BAD_REQUEST, "One or more data points had errors", "Please see the TSD logs or append \"details\" to the put request")));
                    } else {
                        query.sendReply(HttpResponseStatus.NO_CONTENT, "".getBytes());
                    }
                } else {
                    HashMap<String, Object> summary = new HashMap<String, Object>();
                    if (sync_timeout > 0) {
                        summary.put("timeouts", 0);
                    }
                    summary.put("success", results.isEmpty() ? this.queued : good_writes);
                    summary.put("failed", failures + failed_writes);
                    if (show_details) {
                        summary.put("errors", details);
                    }
                    if (failures > 0) {
                        query.sendReply(HttpResponseStatus.BAD_REQUEST, query.serializer().formatPutV1(summary));
                    } else {
                        query.sendReply(query.serializer().formatPutV1(summary));
                    }
                }
                return null;
            }

            public String toString() {
                return "put data point serialization callback";
            }
        }
        Timeout timeout;
        requests.incrementAndGet();
        if (query.method() != HttpMethod.POST) {
            throw new BadRequestException(HttpResponseStatus.METHOD_NOT_ALLOWED, "Method not allowed", "The HTTP method [" + query.method().getName() + "] is not permitted for this endpoint");
        }
        final List<IncomingDataPoint> dps = query.serializer().parsePutV1();
        if (dps.size() < 1) {
            throw new BadRequestException("No datapoints found in content");
        }
        final boolean show_details = query.hasQueryStringParam("details");
        final boolean show_summary = query.hasQueryStringParam("summary");
        boolean synchronous = query.hasQueryStringParam("sync");
        final int sync_timeout = query.hasQueryStringParam("sync_timeout") ? Integer.parseInt(query.getQueryStringParam("sync_timeout")) : 0;
        final AtomicBoolean sending_response = new AtomicBoolean();
        sending_response.set(false);
        final ArrayList<HashMap<String, Object>> details = show_details ? new ArrayList<HashMap<String, Object>>() : null;
        int queued = 0;
        final ArrayList<Deferred> deferreds = synchronous ? new ArrayList<Deferred>(dps.size()) : null;
        for (final IncomingDataPoint dp : dps) {
            try {
                if (dp == null) {
                    if (show_details) {
                        details.add(this.getHttpDetails("Unexpected null datapoint encountered in set.", dp));
                    }
                    LOG.warn("Datapoint null was encountered in set.");
                    illegal_arguments.incrementAndGet();
                    continue;
                }
                if (dp.getMetric() == null || dp.getMetric().isEmpty()) {
                    if (show_details) {
                        details.add(this.getHttpDetails("Metric name was empty", dp));
                    }
                    LOG.warn("Metric name was empty: " + dp);
                    illegal_arguments.incrementAndGet();
                    continue;
                }
                if (dp.getTimestamp() <= 0L) {
                    if (show_details) {
                        details.add(this.getHttpDetails("Invalid timestamp", dp));
                    }
                    LOG.warn("Invalid timestamp: " + dp);
                    illegal_arguments.incrementAndGet();
                    continue;
                }
                if (dp.getValue() == null || dp.getValue().isEmpty()) {
                    if (show_details) {
                        details.add(this.getHttpDetails("Empty value", dp));
                    }
                    LOG.warn("Empty value: " + dp);
                    invalid_values.incrementAndGet();
                    continue;
                }
                if (dp.getTags() == null || dp.getTags().size() < 1) {
                    if (show_details) {
                        details.add(this.getHttpDetails("Missing tags", dp));
                    }
                    LOG.warn("Missing tags: " + dp);
                    illegal_arguments.incrementAndGet();
                    continue;
                }
                Deferred<Object> deferred = Tags.looksLikeInteger(dp.getValue()) ? tsdb.addPoint(dp.getMetric(), dp.getTimestamp(), Tags.parseLong(dp.getValue()), (Map<String, String>)dp.getTags()) : tsdb.addPoint(dp.getMetric(), dp.getTimestamp(), Float.parseFloat(dp.getValue()), (Map<String, String>)dp.getTags());
                if (synchronous) {
                    final class SuccessCB
                    implements Callback<Boolean, Object> {
                        SuccessCB() {
                        }

                        public Boolean call(Object obj) {
                            return true;
                        }

                        public String toString() {
                            return "HTTP Put success CB";
                        }
                    }
                    deferreds.add(deferred.addCallback((Callback)new SuccessCB()));
                }
                final class PutErrback
                implements Callback<Boolean, Exception> {
                    PutErrback() {
                    }

                    public Boolean call(Exception arg) {
                        PutDataPointRpc.this.handleStorageException(tsdb, dp, arg);
                        hbase_errors.incrementAndGet();
                        if (show_details) {
                            details.add(PutDataPointRpc.this.getHttpDetails("Storage exception: " + arg.getMessage(), dp));
                        }
                        return false;
                    }

                    public String toString() {
                        return "HTTP Put Exception CB";
                    }
                }
                deferred.addErrback((Callback)new PutErrback());
                ++queued;
            }
            catch (NumberFormatException x) {
                if (show_details) {
                    details.add(this.getHttpDetails("Unable to parse value to a number", dp));
                }
                LOG.warn("Unable to parse value to a number: " + dp);
                invalid_values.incrementAndGet();
            }
            catch (IllegalArgumentException iae) {
                if (show_details) {
                    details.add(this.getHttpDetails(iae.getMessage(), dp));
                }
                LOG.warn(iae.getMessage() + ": " + dp);
                illegal_arguments.incrementAndGet();
            }
            catch (NoSuchUniqueName nsu) {
                if (show_details) {
                    details.add(this.getHttpDetails("Unknown metric", dp));
                }
                LOG.warn("Unknown metric: " + dp);
                unknown_metrics.incrementAndGet();
            }
        }
        class PutTimeout
        implements TimerTask {
            final int queued;

            public PutTimeout(int queued) {
                this.queued = queued;
            }

            public void run(Timeout timeout) throws Exception {
                if (sending_response.get()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Put data point call " + query + " already responded successfully");
                    }
                    return;
                }
                sending_response.set(true);
                int good_writes = 0;
                int failed_writes = 0;
                int timeouts = 0;
                for (int i = 0; i < deferreds.size(); ++i) {
                    try {
                        if (((Boolean)((Deferred)deferreds.get(i)).join(1L)).booleanValue()) {
                            ++good_writes;
                            continue;
                        }
                        ++failed_writes;
                        continue;
                    }
                    catch (TimeoutException te) {
                        if (show_details) {
                            details.add(PutDataPointRpc.this.getHttpDetails("Write timedout", (IncomingDataPoint)dps.get(i)));
                        }
                        ++timeouts;
                    }
                }
                writes_timedout.addAndGet(timeouts);
                int failures = dps.size() - this.queued;
                if (!show_summary && !show_details) {
                    throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "The put call has timedout with " + good_writes + " successful writes, " + failed_writes + " failed writes and " + timeouts + " timed out writes.", "Please see the TSD logs or append \"details\" to the put request");
                }
                HashMap<String, Object> summary = new HashMap<String, Object>();
                summary.put("success", good_writes);
                summary.put("failed", failures + failed_writes);
                summary.put("timeouts", timeouts);
                if (show_details) {
                    summary.put("errors", details);
                }
                query.sendReply(HttpResponseStatus.BAD_REQUEST, query.serializer().formatPutV1(summary));
            }
        }
        Timeout timeout2 = timeout = sync_timeout > 0 ? tsdb.getTimer().newTimeout((TimerTask)new PutTimeout(queued), (long)sync_timeout, TimeUnit.MILLISECONDS) : null;
        if (synchronous) {
            class ErrCB
            implements Callback<Object, Exception> {
                ErrCB() {
                }

                public Object call(Exception e) throws Exception {
                    if (sending_response.get()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Put data point call " + query + " was marked as timedout");
                        }
                        return null;
                    }
                    sending_response.set(true);
                    if (timeout != null) {
                        timeout.cancel();
                    }
                    LOG.error("Unexpected exception", (Throwable)e);
                    throw new RuntimeException("Unexpected exception", e);
                }

                public String toString() {
                    return "put data point error callback";
                }
            }
            Deferred.groupInOrder(deferreds).addCallback((Callback)new GroupCB(queued)).addErrback((Callback)new ErrCB());
        } else {
            new GroupCB(queued).call(EMPTY_DEFERREDS);
        }
    }

    public static void collectStats(StatsCollector collector) {
        collector.record("rpc.received", requests, "type=put");
        collector.record("rpc.errors", hbase_errors, "type=hbase_errors");
        collector.record("rpc.errors", invalid_values, "type=invalid_values");
        collector.record("rpc.errors", illegal_arguments, "type=illegal_arguments");
        collector.record("rpc.errors", unknown_metrics, "type=unknown_metrics");
        collector.record("rpc.errors", writes_blocked, "type=socket_writes_blocked");
    }

    private Deferred<Object> importDataPoint(TSDB tsdb, String[] words) {
        words[0] = null;
        if (words.length < 5) {
            throw new IllegalArgumentException("not enough arguments (need least 4, got " + (words.length - 1) + ')');
        }
        String metric = words[1];
        if (metric.length() <= 0) {
            throw new IllegalArgumentException("empty metric name");
        }
        long timestamp = words[2].contains(".") ? Tags.parseLong(words[2].replace(".", "")) : Tags.parseLong(words[2]);
        if (timestamp <= 0L) {
            throw new IllegalArgumentException("invalid timestamp: " + timestamp);
        }
        String value = words[3];
        if (value.length() <= 0) {
            throw new IllegalArgumentException("empty value");
        }
        HashMap<String, String> tags = new HashMap<String, String>();
        for (int i = 4; i < words.length; ++i) {
            if (words[i].isEmpty()) continue;
            Tags.parse(tags, words[i]);
        }
        if (Tags.looksLikeInteger(value)) {
            return tsdb.addPoint(metric, timestamp, Tags.parseLong(value), (Map<String, String>)tags);
        }
        return tsdb.addPoint(metric, timestamp, Float.parseFloat(value), (Map<String, String>)tags);
    }

    private final IncomingDataPoint getDataPointFromString(String[] words) {
        IncomingDataPoint dp = new IncomingDataPoint();
        dp.setMetric(words[1]);
        if (words[2].contains(".")) {
            dp.setTimestamp(Tags.parseLong(words[2].replace(".", "")));
        } else {
            dp.setTimestamp(Tags.parseLong(words[2]));
        }
        dp.setValue(words[3]);
        HashMap<String, String> tags = new HashMap<String, String>();
        for (int i = 4; i < words.length; ++i) {
            if (words[i].isEmpty()) continue;
            Tags.parse(tags, words[i]);
        }
        dp.setTags(tags);
        return dp;
    }

    private final HashMap<String, Object> getHttpDetails(String message, IncomingDataPoint dp) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("error", message);
        map.put("datapoint", dp);
        return map;
    }

    void handleStorageException(TSDB tsdb, IncomingDataPoint dp, Exception e) {
        StorageExceptionHandler handler = tsdb.getStorageExceptionHandler();
        if (handler != null) {
            handler.handleError(dp, e);
        }
    }
}

