/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tsd;

import com.fasterxml.jackson.core.JsonGenerator;
import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import com.stumbleupon.async.DeferredGroupException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.Query;
import net.opentsdb.core.QueryException;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.TSQuery;
import net.opentsdb.core.TSSubQuery;
import net.opentsdb.core.Tags;
import net.opentsdb.query.expression.ExpressionDataPoint;
import net.opentsdb.query.expression.ExpressionIterator;
import net.opentsdb.query.expression.NumericFillPolicy;
import net.opentsdb.query.expression.TimeSyncedIterator;
import net.opentsdb.query.expression.VariableIterator;
import net.opentsdb.query.filter.TagVFilter;
import net.opentsdb.query.pojo.Expression;
import net.opentsdb.query.pojo.Filter;
import net.opentsdb.query.pojo.Metric;
import net.opentsdb.query.pojo.Output;
import net.opentsdb.query.pojo.Timespan;
import net.opentsdb.stats.QueryStats;
import net.opentsdb.tsd.BadRequestException;
import net.opentsdb.tsd.HttpQuery;
import net.opentsdb.tsd.QueryRpc;
import net.opentsdb.uid.NoSuchUniqueName;
import net.opentsdb.uid.UniqueId;
import net.opentsdb.utils.DateTime;
import net.opentsdb.utils.JSON;
import org.hbase.async.HBaseException;
import org.hbase.async.RpcTimedOutException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jgrapht.DirectedGraph;
import org.jgrapht.experimental.dag.DirectedAcyclicGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(QueryExecutor.class);
    private final TSDB tsdb;
    private final net.opentsdb.query.pojo.Query query;
    private final TSQuery ts_query;
    private final Map<String, TSSubQuery> sub_queries;
    private final Map<String, DataPoints[]> sub_query_results;
    private final Map<String, ExpressionIterator> expressions;
    private final Map<String, NumericFillPolicy> fills;
    private HttpQuery http_query;

    public QueryExecutor(TSDB tsdb, net.opentsdb.query.pojo.Query query) {
        this.tsdb = tsdb;
        this.query = query;
        this.sub_queries = new HashMap<String, TSSubQuery>(query.getMetrics().size());
        this.sub_query_results = new HashMap<String, DataPoints[]>(query.getMetrics().size());
        this.expressions = query.getExpressions() != null ? new HashMap<String, ExpressionIterator>(query.getExpressions().size()) : null;
        Timespan timespan = query.getTime();
        this.ts_query = new TSQuery();
        this.ts_query.setStart(timespan.getStart());
        this.ts_query.setTimezone(timespan.getTimezone());
        if (timespan.getEnd() != null && !timespan.getEnd().isEmpty()) {
            this.ts_query.setEnd(timespan.getEnd());
        }
        this.fills = new HashMap<String, NumericFillPolicy>(query.getMetrics().size());
        for (Metric mq : query.getMetrics()) {
            if (mq.getFillPolicy() != null) {
                this.fills.put(mq.getId(), mq.getFillPolicy());
            }
            TSSubQuery sub = new TSSubQuery();
            this.sub_queries.put(mq.getId(), sub);
            sub.setMetric(mq.getMetric());
            if (timespan.getDownsampler() != null) {
                sub.setDownsample(timespan.getDownsampler().getInterval() + "-" + timespan.getDownsampler().getAggregator());
            }
            if (mq.getFilter() != null && !mq.getFilter().isEmpty()) {
                ArrayList<TagVFilter> filters = null;
                boolean explicit_tags = false;
                if (query.getFilters() == null || query.getFilters().isEmpty()) {
                    throw new IllegalArgumentException("No filter defined: " + mq.getFilter());
                }
                for (Filter filter : query.getFilters()) {
                    if (!filter.getId().equals(mq.getFilter())) continue;
                    filters = new ArrayList<TagVFilter>(filter.getTags().size());
                    for (TagVFilter f : filter.getTags()) {
                        filters.add(f.getCopy());
                    }
                    explicit_tags = filter.getExplicitTags();
                    break;
                }
                if (filters != null) {
                    sub.setFilters(filters);
                    sub.setExplicitTags(explicit_tags);
                }
            }
            sub.setRate(timespan.isRate());
            sub.setAggregator(mq.getAggregator() != null ? mq.getAggregator() : timespan.getAggregator());
        }
        ArrayList<TSSubQuery> subs = new ArrayList<TSSubQuery>(this.sub_queries.values());
        this.ts_query.setQueries(subs);
        for (Expression expression : query.getExpressions()) {
            VariableIterator.SetOperator operator = expression.getJoin() != null ? expression.getJoin().getOperator() : VariableIterator.SetOperator.UNION;
            boolean qts = expression.getJoin() == null ? false : expression.getJoin().getUseQueryTags();
            boolean ats = expression.getJoin() == null ? true : expression.getJoin().getIncludeAggTags();
            ExpressionIterator iterator = new ExpressionIterator(expression.getId(), expression.getExpr(), operator, qts, ats);
            if (expression.getFillPolicy() != null) {
                iterator.setFillPolicy(expression.getFillPolicy());
            }
            this.expressions.put(expression.getId(), iterator);
        }
        this.ts_query.validateAndSetQuery();
    }

    public void execute(final HttpQuery query) {
        this.http_query = query;
        QueryStats query_stats = new QueryStats(query.getRemoteAddress(), this.ts_query, query.getHeaders());
        this.ts_query.setQueryStats(query_stats);
        class BuildCB
        implements Callback<Deferred<Object>, Query[]> {
            BuildCB() {
            }

            public Deferred<Object> call(Query[] queries) {
                ArrayList<Deferred<DataPoints[]>> deferreds = new ArrayList<Deferred<DataPoints[]>>(queries.length);
                for (Query query2 : queries) {
                    deferreds.add(query2.runAsync());
                }
                class QueriesCB
                implements Callback<Object, ArrayList<DataPoints[]>> {
                    final /* synthetic */ HttpQuery val$query;

                    QueriesCB() {
                        this.val$query = httpQuery;
                    }

                    public Object call(ArrayList<DataPoints[]> query_results) throws Exception {
                        for (int i = 0; i < query_results.size(); ++i) {
                            TSSubQuery sub = QueryExecutor.this.ts_query.getQueries().get(i);
                            for (Map.Entry entry : QueryExecutor.this.sub_queries.entrySet()) {
                                if (!((TSSubQuery)entry.getValue()).equals(sub)) continue;
                                QueryExecutor.this.sub_query_results.put(entry.getKey(), query_results.get(i));
                                for (ExpressionIterator ei : QueryExecutor.this.expressions.values()) {
                                    if (!ei.getVariableNames().contains(entry.getKey())) continue;
                                    TimeSyncedIterator tsi = new TimeSyncedIterator((String)entry.getKey(), sub.getFilterTagKs(), query_results.get(i));
                                    NumericFillPolicy fill = (NumericFillPolicy)QueryExecutor.this.fills.get(entry.getKey());
                                    if (fill != null) {
                                        tsi.setFillPolicy(fill);
                                    }
                                    ei.addResults((String)entry.getKey(), tsi);
                                    if (!LOG.isDebugEnabled()) continue;
                                    LOG.debug("Added results for " + (String)entry.getKey() + " to " + ei.getId());
                                }
                            }
                        }
                        DirectedAcyclicGraph graph = new DirectedAcyclicGraph(DefaultEdge.class);
                        for (Map.Entry entry : QueryExecutor.this.expressions.entrySet()) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug(String.format("Expression entry key is %s, value is %s", entry.getKey(), ((ExpressionIterator)entry.getValue()).toString()));
                                LOG.debug(String.format("Time to loop through the variable names for %s", entry.getKey()));
                            }
                            if (!graph.containsVertex(entry.getKey())) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Adding vertex " + (String)entry.getKey());
                                }
                                graph.addVertex(entry.getKey());
                            }
                            for (String var : ((ExpressionIterator)entry.getValue()).getVariableNames()) {
                                ExpressionIterator ei;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug(String.format("var is %s", var));
                                }
                                if ((ei = (ExpressionIterator)QueryExecutor.this.expressions.get(var)) != null) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug(String.format("The expression iterator for %s is %s", var, ei.toString()));
                                    }
                                    if (((String)entry.getKey()).equals(var)) {
                                        throw new IllegalArgumentException("Self referencing expression found: " + (String)entry.getKey());
                                    }
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("Nested expression detected. " + (String)entry.getKey() + " depends on " + var);
                                    }
                                    if (!graph.containsVertex(entry.getKey())) {
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug("Added vertex " + (String)entry.getKey());
                                        }
                                        graph.addVertex(entry.getKey());
                                    } else if (LOG.isDebugEnabled()) {
                                        LOG.debug("Already contains vertex " + (String)entry.getKey());
                                    }
                                    if (!graph.containsVertex((Object)var)) {
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug("Added vertex " + var);
                                        }
                                        graph.addVertex((Object)var);
                                    } else if (LOG.isDebugEnabled()) {
                                        LOG.debug("Already contains vertex " + var);
                                    }
                                    try {
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug("Added Edge " + (String)entry.getKey() + " - " + var);
                                        }
                                        graph.addDagEdge(entry.getKey(), (Object)var);
                                        continue;
                                    }
                                    catch (DirectedAcyclicGraph.CycleFoundException cfe) {
                                        throw new IllegalArgumentException("Circular reference found: " + (String)entry.getKey(), cfe);
                                    }
                                }
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug(String.format("The expression iterator for %s is null", var));
                            }
                        }
                        long intersect_start = DateTime.currentTimeMillis();
                        Integer expressionLength = QueryExecutor.this.expressions.size();
                        ExpressionIterator[] compile_stack = new ExpressionIterator[expressionLength.intValue()];
                        TopologicalOrderIterator it = new TopologicalOrderIterator((DirectedGraph)graph);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(String.format("Expressions Size is %d", expressionLength));
                            LOG.debug(String.format("Topology Iterator %s", it.toString()));
                        }
                        int i = 0;
                        while (it.hasNext()) {
                            String next = (String)it.next();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug(String.format("Expression: %s", next));
                            }
                            ExpressionIterator ei = (ExpressionIterator)QueryExecutor.this.expressions.get(next);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug(String.format("Expression Iterator: %s", ei.toString()));
                            }
                            if (ei == null) {
                                LOG.error(String.format("The expression iterator for %s is null", next));
                            }
                            compile_stack[i] = ei;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug(String.format("Added expression %s to compile_stack[%d]", next, i));
                            }
                            ++i;
                        }
                        if (i != expressionLength) {
                            throw new IOException(String.format(" Internal Error: Fewer expressions where added to the compile stack than expressions.size (%d instead of %d)", i, expressionLength));
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(String.format("compile stack length: %d", compile_stack.length));
                        }
                        for (int x = compile_stack.length - 1; x >= 0; --x) {
                            if (compile_stack[x] == null) {
                                throw new NullPointerException(String.format("Item %d in compile_stack[] is null", x));
                            }
                            for (String var : compile_stack[x].getVariableNames()) {
                                ExpressionIterator source;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug(String.format("Looking for variable %s for %s", var, compile_stack[x].getId()));
                                }
                                if ((source = (ExpressionIterator)QueryExecutor.this.expressions.get(var)) == null) continue;
                                compile_stack[x].addResults(var, source.getCopy());
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug(String.format("Adding expression %s to %s", source.getId(), compile_stack[x].getId()));
                            }
                            compile_stack[x].compile();
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug(String.format("Successfully compiled %s", compile_stack[x].getId()));
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Finished compilations in " + (DateTime.currentTimeMillis() - intersect_start) + " ms");
                        }
                        class CompleteCB
                        implements Callback<Object, ChannelBuffer> {
                            final /* synthetic */ HttpQuery val$query;

                            CompleteCB() {
                                this.val$query = httpQuery;
                            }

                            public Object call(ChannelBuffer cb) throws Exception {
                                this.val$query.sendReply(cb);
                                return null;
                            }
                        }
                        return QueryExecutor.this.serialize().addCallback((Callback)new CompleteCB(QueryExecutor.this, this.val$query)).addErrback((Callback)new ErrorCB());
                    }
                }
                return Deferred.groupInOrder(deferreds).addCallback((Callback)new QueriesCB(QueryExecutor.this, query)).addErrback((Callback)new ErrorCB());
            }
        }
        this.ts_query.buildQueriesAsync(this.tsdb).addCallback((Callback)new BuildCB()).addErrback((Callback)new ErrorCB());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Deferred<ChannelBuffer> serialize() throws Exception {
        List<Output> outputs;
        long start = System.currentTimeMillis();
        final ChannelBuffer response = ChannelBuffers.dynamicBuffer();
        ChannelBufferOutputStream output_stream = new ChannelBufferOutputStream(response);
        final JsonGenerator json = JSON.getFactory().createGenerator((OutputStream)output_stream);
        json.writeStartObject();
        json.writeFieldName("outputs");
        json.writeStartArray();
        Deferred cb_chain = new Deferred();
        if (this.query.getOutputs() == null || this.query.getOutputs().isEmpty()) {
            if (this.query.getExpressions() != null && !this.query.getExpressions().isEmpty()) {
                outputs = new ArrayList<Output>(this.query.getExpressions().size());
                for (Expression exp : this.query.getExpressions()) {
                    outputs.add(Output.Builder().setId(exp.getId()).build());
                }
            } else {
                if (this.query.getMetrics() == null || this.query.getMetrics().isEmpty()) throw new IllegalArgumentException("How did we get here?? No metrics or expressions??");
                outputs = new ArrayList<Output>(this.query.getMetrics().size());
                for (Metric metric : this.query.getMetrics()) {
                    outputs.add(Output.Builder().setId(metric.getId()).build());
                }
            }
        } else {
            outputs = this.query.getOutputs();
        }
        for (Output output : outputs) {
            ExpressionIterator it;
            if (this.expressions != null && (it = this.expressions.get(output.getId())) != null) {
                cb_chain.addCallback((Callback)new SerializeExpressionIterator(this.tsdb, json, output, it, this.ts_query));
                continue;
            }
            if (this.query.getMetrics() != null && !this.query.getMetrics().isEmpty()) {
                TSSubQuery sub = this.sub_queries.get(output.getId());
                if (sub == null) continue;
                TimeSyncedIterator it2 = new TimeSyncedIterator(output.getId(), sub.getFilterTagKs(), this.sub_query_results.get(output.getId()));
                cb_chain.addCallback((Callback)new SerializeSubIterator(this.tsdb, json, output, it2));
                continue;
            }
            LOG.warn("Couldn't find a variable matching: " + output.getId() + " in query " + this.query);
        }
        cb_chain.callback(null);
        class FinalCB
        implements Callback<ChannelBuffer, Object> {
            FinalCB() {
            }

            public ChannelBuffer call(Object obj) throws Exception {
                json.writeEndArray();
                QueryExecutor.this.ts_query.getQueryStats().markSerializationSuccessful();
                json.writeFieldName("query");
                json.writeObject((Object)QueryExecutor.this.query);
                json.writeEndObject();
                json.close();
                return response;
            }
        }
        return cb_chain.addCallback((Callback)new FinalCB());
    }

    private class MetaSerializer
    implements Callback<Deferred<Object>, Object> {
        final TSDB tsdb;
        final JsonGenerator json;
        final ExpressionDataPoint[] dps;
        final List<String> metrics;
        final Map<String, String>[] tags;
        final List<String>[] agg_tags;
        final Deferred<Object> completed;

        public MetaSerializer(TSDB tsdb, JsonGenerator json, ExpressionDataPoint[] dps) {
            this.tsdb = tsdb;
            this.json = json;
            this.dps = dps;
            this.completed = new Deferred();
            this.metrics = new ArrayList<String>();
            this.tags = new Map[dps.length];
            this.agg_tags = new List[dps.length];
        }

        public Deferred<Object> call(Object ignored) throws Exception {
            ArrayList<Deferred> deferreds = new ArrayList<Deferred>();
            ArrayList<Deferred<String>> metric_deferreds = new ArrayList<Deferred<String>>(this.dps[0].metricUIDs().size());
            for (byte[] uid : this.dps[0].metricUIDs()) {
                metric_deferreds.add(this.tsdb.getUidName(UniqueId.UniqueIdType.METRIC, uid));
            }
            deferreds.add(Deferred.group(metric_deferreds).addCallback((Callback)new MetricsCB()));
            for (int i = 0; i < this.dps.length; ++i) {
                if (this.dps[i].aggregatedTags().size() > 0) {
                    ArrayList<Deferred<String>> agg_deferreds = new ArrayList<Deferred<String>>(this.dps[i].aggregatedTags().size());
                    for (byte[] uid : this.dps[i].aggregatedTags()) {
                        agg_deferreds.add(this.tsdb.getUidName(UniqueId.UniqueIdType.TAGK, uid));
                    }
                    deferreds.add(Deferred.group(agg_deferreds).addCallback((Callback)new AggTagsCB(i)));
                }
                deferreds.add(Tags.getTagsAsync(this.tsdb, this.dps[i].tags()).addCallback((Callback)new TagsCB(i)));
            }
            Deferred.groupInOrder(deferreds).addCallback((Callback)new MetaCB()).addErrback((Callback)new ErrorCB());
            return this.completed;
        }

        class MetaCB
        implements Callback<Object, ArrayList<Object>> {
            MetaCB() {
            }

            public Object call(ArrayList<Object> ignored) throws Exception {
                MetaSerializer.this.json.writeFieldName("meta");
                MetaSerializer.this.json.writeStartArray();
                MetaSerializer.this.json.writeStartObject();
                MetaSerializer.this.json.writeNumberField("index", 0);
                MetaSerializer.this.json.writeFieldName("metrics");
                MetaSerializer.this.json.writeStartArray();
                MetaSerializer.this.json.writeString("timestamp");
                MetaSerializer.this.json.writeEndArray();
                MetaSerializer.this.json.writeEndObject();
                for (int i = 0; i < MetaSerializer.this.dps.length; ++i) {
                    MetaSerializer.this.json.writeStartObject();
                    MetaSerializer.this.json.writeNumberField("index", i + 1);
                    MetaSerializer.this.json.writeFieldName("metrics");
                    MetaSerializer.this.json.writeObject(MetaSerializer.this.metrics);
                    MetaSerializer.this.json.writeFieldName("commonTags");
                    if (MetaSerializer.this.tags[i] == null) {
                        MetaSerializer.this.json.writeObject(Collections.emptyMap());
                    } else {
                        MetaSerializer.this.json.writeObject(MetaSerializer.this.tags[i]);
                    }
                    MetaSerializer.this.json.writeFieldName("aggregatedTags");
                    if (MetaSerializer.this.agg_tags[i] == null) {
                        MetaSerializer.this.json.writeObject(Collections.emptyList());
                    } else {
                        MetaSerializer.this.json.writeObject(MetaSerializer.this.agg_tags[i]);
                    }
                    MetaSerializer.this.json.writeEndObject();
                }
                MetaSerializer.this.json.writeEndArray();
                MetaSerializer.this.json.writeEndObject();
                MetaSerializer.this.completed.callback(null);
                return null;
            }
        }

        class TagsCB
        implements Callback<Object, Map<String, String>> {
            final int index;

            public TagsCB(int index) {
                this.index = index;
            }

            public Object call(Map<String, String> tags) throws Exception {
                MetaSerializer.this.tags[this.index] = tags;
                return null;
            }
        }

        class AggTagsCB
        implements Callback<Object, ArrayList<String>> {
            final int index;

            public AggTagsCB(int index) {
                this.index = index;
            }

            public Object call(ArrayList<String> tags) throws Exception {
                MetaSerializer.this.agg_tags[this.index] = tags;
                return null;
            }
        }

        class MetricsCB
        implements Callback<Object, ArrayList<String>> {
            MetricsCB() {
            }

            public Object call(ArrayList<String> names) throws Exception {
                MetaSerializer.this.metrics.addAll(names);
                Collections.sort(MetaSerializer.this.metrics);
                return null;
            }
        }
    }

    private class SerializeSubIterator
    implements Callback<Deferred<Object>, Object> {
        final TSDB tsdb;
        final JsonGenerator json;
        final Output output;
        final TimeSyncedIterator iterator;
        final Deferred<Object> completed;

        public SerializeSubIterator(TSDB tsdb, JsonGenerator json, Output output, TimeSyncedIterator iterator) {
            this.tsdb = tsdb;
            this.json = json;
            this.output = output;
            this.iterator = iterator;
            this.completed = new Deferred();
        }

        public Deferred<Object> call(Object ignored) throws Exception {
            long first_ts;
            this.json.writeStartObject();
            this.json.writeStringField("id", this.output.getId());
            if (this.output.getAlias() != null) {
                this.json.writeStringField("alias", this.output.getAlias());
            }
            this.json.writeFieldName("dps");
            this.json.writeStartArray();
            long ts = first_ts = this.iterator.nextTimestamp();
            long last_ts = 0L;
            long count = 0L;
            ExpressionDataPoint[] dps = this.iterator.values();
            while (this.iterator.hasNext()) {
                this.iterator.next(ts);
                this.json.writeStartArray();
                if (dps.length > 0) {
                    this.json.writeNumber(dps[0].timestamp());
                    last_ts = dps[0].timestamp();
                    ++count;
                }
                for (int i = 0; i < dps.length; ++i) {
                    this.json.writeNumber(dps[i].toDouble());
                }
                this.json.writeEndArray();
                ts = this.iterator.nextTimestamp();
            }
            this.json.writeEndArray();
            this.json.writeFieldName("dpsMeta");
            this.json.writeStartObject();
            this.json.writeNumberField("firstTimestamp", first_ts);
            this.json.writeNumberField("lastTimestamp", last_ts);
            this.json.writeNumberField("setCount", count);
            this.json.writeNumberField("series", dps.length);
            this.json.writeEndObject();
            if (dps.length > 0) {
                DataPoints[] odps = this.iterator.getDataPoints();
                ExpressionDataPoint[] edps = new ExpressionDataPoint[dps.length];
                for (int i = 0; i < dps.length; ++i) {
                    edps[i] = new ExpressionDataPoint(odps[i]);
                }
                MetaSerializer meta_serializer = new MetaSerializer(this.tsdb, this.json, edps);
                meta_serializer.call(null).addCallback((Callback)new MetaCB());
            } else {
                this.json.writeEndObject();
                this.completed.callback(null);
            }
            return this.completed;
        }

        class MetaCB
        implements Callback<Object, Object> {
            MetaCB() {
            }

            public Object call(Object ignored) throws Exception {
                SerializeSubIterator.this.completed.callback(null);
                return SerializeSubIterator.this.completed;
            }
        }
    }

    private class SerializeExpressionIterator
    implements Callback<Deferred<Object>, Object> {
        final TSDB tsdb;
        final JsonGenerator json;
        final Output output;
        final ExpressionIterator iterator;
        final ExpressionDataPoint[] dps;
        final TSQuery query;
        final Deferred<Object> completed;

        public SerializeExpressionIterator(TSDB tsdb, JsonGenerator json, Output output, ExpressionIterator iterator, TSQuery query) {
            this.tsdb = tsdb;
            this.json = json;
            this.output = output;
            this.iterator = iterator;
            this.query = query;
            this.dps = iterator.values();
            this.completed = new Deferred();
        }

        public Deferred<Object> call(Object ignored) throws Exception {
            this.json.writeStartObject();
            this.json.writeStringField("id", this.output.getId());
            if (this.output.getAlias() != null) {
                this.json.writeStringField("alias", this.output.getAlias());
            }
            this.json.writeFieldName("dps");
            this.json.writeStartArray();
            long first_ts = Long.MIN_VALUE;
            long last_ts = 0L;
            long count = 0L;
            long ts = this.iterator.nextTimestamp();
            long qs = this.query.startTime();
            long qe = this.query.endTime();
            while (this.iterator.hasNext()) {
                this.iterator.next(ts);
                long timestamp = this.dps[0].timestamp();
                if (timestamp >= qs && timestamp <= qe) {
                    this.json.writeStartArray();
                    if (this.dps.length > 0) {
                        this.json.writeNumber(timestamp);
                        if (first_ts == Long.MIN_VALUE) {
                            first_ts = timestamp;
                        } else {
                            last_ts = timestamp;
                        }
                        ++count;
                    }
                    for (int i = 0; i < this.dps.length; ++i) {
                        this.json.writeNumber(this.dps[i].toDouble());
                    }
                    this.json.writeEndArray();
                }
                ts = this.iterator.nextTimestamp();
            }
            this.json.writeEndArray();
            this.json.writeFieldName("dpsMeta");
            this.json.writeStartObject();
            this.json.writeNumberField("firstTimestamp", first_ts < 0L ? 0L : first_ts);
            this.json.writeNumberField("lastTimestamp", last_ts);
            this.json.writeNumberField("setCount", count);
            this.json.writeNumberField("series", this.dps.length);
            this.json.writeEndObject();
            if (this.dps.length > 0) {
                MetaSerializer meta_serializer = new MetaSerializer(this.tsdb, this.json, this.iterator.values());
                meta_serializer.call(null).addCallback((Callback)new MetaCB()).addErrback((Callback)new ErrorCB());
            } else {
                this.json.writeEndObject();
                this.completed.callback(null);
            }
            return this.completed;
        }

        class MetaCB
        implements Callback<Object, Object> {
            MetaCB() {
            }

            public Object call(Object ignored) throws Exception {
                SerializeExpressionIterator.this.completed.callback(null);
                return SerializeExpressionIterator.this.completed;
            }
        }
    }

    class ErrorCB
    implements Callback<Object, Exception> {
        ErrorCB() {
        }

        public Object call(Exception e) throws Exception {
            QueryRpc.query_exceptions.incrementAndGet();
            Throwable ex = e;
            try {
                LOG.error("Query exception: ", (Throwable)e);
                if (e instanceof DeferredGroupException) {
                    for (ex = e.getCause(); ex != null && ex instanceof DeferredGroupException; ex = ex.getCause()) {
                    }
                    if (ex == null) {
                        LOG.error("The deferred group exception didn't have a cause???");
                    }
                }
                if (ex instanceof RpcTimedOutException) {
                    QueryExecutor.this.http_query.badRequest(new BadRequestException(HttpResponseStatus.REQUEST_TIMEOUT, ex.getMessage()));
                } else if (ex instanceof HBaseException) {
                    QueryExecutor.this.http_query.badRequest(new BadRequestException(HttpResponseStatus.FAILED_DEPENDENCY, ex.getMessage()));
                } else if (ex instanceof QueryException) {
                    QueryExecutor.this.http_query.badRequest(new BadRequestException(((QueryException)ex).getStatus(), ex.getMessage()));
                } else if (ex instanceof BadRequestException) {
                    QueryExecutor.this.http_query.badRequest((BadRequestException)ex);
                } else if (ex instanceof NoSuchUniqueName) {
                    QueryExecutor.this.http_query.badRequest(new BadRequestException(ex));
                } else {
                    QueryExecutor.this.http_query.badRequest(new BadRequestException(ex));
                }
            }
            catch (RuntimeException ex2) {
                LOG.error("Exception thrown during exception handling", (Throwable)ex2);
                QueryExecutor.this.http_query.sendReply(HttpResponseStatus.INTERNAL_SERVER_ERROR, ex2.getMessage().getBytes());
            }
            return null;
        }
    }
}

