/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tsd;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import com.stumbleupon.async.DeferredGroupException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.IncomingDataPoint;
import net.opentsdb.core.Query;
import net.opentsdb.core.QueryException;
import net.opentsdb.core.RateOptions;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.TSQuery;
import net.opentsdb.core.TSSubQuery;
import net.opentsdb.core.Tags;
import net.opentsdb.meta.Annotation;
import net.opentsdb.meta.TSUIDQuery;
import net.opentsdb.query.expression.ExpressionTree;
import net.opentsdb.query.expression.Expressions;
import net.opentsdb.query.filter.TagVFilter;
import net.opentsdb.stats.QueryStats;
import net.opentsdb.stats.StatsCollector;
import net.opentsdb.tsd.BadRequestException;
import net.opentsdb.tsd.HttpQuery;
import net.opentsdb.tsd.HttpRpc;
import net.opentsdb.tsd.QueryExecutor;
import net.opentsdb.uid.NoSuchUniqueName;
import net.opentsdb.uid.UniqueId;
import net.opentsdb.utils.DateTime;
import net.opentsdb.utils.JSON;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseException;
import org.hbase.async.RpcTimedOutException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class QueryRpc
implements HttpRpc {
    private static final Logger LOG = LoggerFactory.getLogger(QueryRpc.class);
    static final AtomicLong query_invalid = new AtomicLong();
    static final AtomicLong query_exceptions = new AtomicLong();
    static final AtomicLong query_success = new AtomicLong();

    QueryRpc() {
    }

    @Override
    public void execute(TSDB tsdb, HttpQuery query) throws IOException {
        String endpoint;
        if (query.method() != HttpMethod.GET && query.method() != HttpMethod.POST && query.method() != HttpMethod.DELETE) {
            throw new BadRequestException(HttpResponseStatus.METHOD_NOT_ALLOWED, "Method not allowed", "The HTTP method [" + query.method().getName() + "] is not permitted for this endpoint");
        }
        if (query.method() == HttpMethod.DELETE && !tsdb.getConfig().getBoolean("tsd.http.query.allow_delete")) {
            throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Bad request", "Deleting data is not enabled (tsd.http.query.allow_delete=false)");
        }
        String[] uri = query.explodeAPIPath();
        String string = endpoint = uri.length > 1 ? uri[1] : "";
        if (endpoint.toLowerCase().equals("last")) {
            this.handleLastDataPointQuery(tsdb, query);
        } else if (endpoint.toLowerCase().equals("gexp")) {
            this.handleQuery(tsdb, query, true);
        } else {
            if (endpoint.toLowerCase().equals("exp")) {
                this.handleExpressionQuery(tsdb, query);
                return;
            }
            this.handleQuery(tsdb, query, false);
        }
    }

    private void handleQuery(final TSDB tsdb, final HttpQuery query, final boolean allow_expressions) {
        class ErrorCB
        implements Callback<Object, Exception> {
            final /* synthetic */ QueryStats val$query_stats;
            final /* synthetic */ HttpQuery val$query;

            ErrorCB() {
                this.val$query_stats = queryStats;
                this.val$query = httpQuery;
            }

            public Object call(Exception e) throws Exception {
                Throwable ex = e;
                try {
                    LOG.error("Query exception: ", (Throwable)e);
                    if (ex instanceof DeferredGroupException) {
                        for (ex = e.getCause(); ex != null && ex instanceof DeferredGroupException; ex = ex.getCause()) {
                        }
                        if (ex == null) {
                            LOG.error("The deferred group exception didn't have a cause???");
                        }
                    }
                    if (ex instanceof RpcTimedOutException) {
                        this.val$query_stats.markSerialized(HttpResponseStatus.REQUEST_TIMEOUT, ex);
                        this.val$query.badRequest(new BadRequestException(HttpResponseStatus.REQUEST_TIMEOUT, ex.getMessage()));
                        query_exceptions.incrementAndGet();
                    } else if (ex instanceof HBaseException) {
                        this.val$query_stats.markSerialized(HttpResponseStatus.FAILED_DEPENDENCY, ex);
                        this.val$query.badRequest(new BadRequestException(HttpResponseStatus.FAILED_DEPENDENCY, ex.getMessage()));
                        query_exceptions.incrementAndGet();
                    } else if (ex instanceof QueryException) {
                        this.val$query_stats.markSerialized(((QueryException)ex).getStatus(), ex);
                        this.val$query.badRequest(new BadRequestException(((QueryException)ex).getStatus(), ex.getMessage()));
                        query_exceptions.incrementAndGet();
                    } else if (ex instanceof BadRequestException) {
                        this.val$query_stats.markSerialized(((BadRequestException)ex).getStatus(), ex);
                        this.val$query.badRequest((BadRequestException)ex);
                        query_invalid.incrementAndGet();
                    } else if (ex instanceof NoSuchUniqueName) {
                        this.val$query_stats.markSerialized(HttpResponseStatus.BAD_REQUEST, ex);
                        this.val$query.badRequest(new BadRequestException(ex));
                        query_invalid.incrementAndGet();
                    } else {
                        this.val$query_stats.markSerialized(HttpResponseStatus.INTERNAL_SERVER_ERROR, ex);
                        this.val$query.badRequest(new BadRequestException(ex));
                        query_exceptions.incrementAndGet();
                    }
                }
                catch (RuntimeException ex2) {
                    LOG.error("Exception thrown during exception handling", (Throwable)ex2);
                    this.val$query_stats.markSerialized(HttpResponseStatus.INTERNAL_SERVER_ERROR, ex2);
                    this.val$query.sendReply(HttpResponseStatus.INTERNAL_SERVER_ERROR, ex2.getMessage().getBytes());
                    query_exceptions.incrementAndGet();
                }
                return null;
            }
        }
        ArrayList<ExpressionTree> expressions;
        TSQuery data_query;
        long start = DateTime.currentTimeMillis();
        if (query.method() == HttpMethod.POST) {
            switch (query.apiVersion()) {
                case 0: 
                case 1: {
                    data_query = query.serializer().parseQueryV1();
                    break;
                }
                default: {
                    query_invalid.incrementAndGet();
                    throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "Requested API version not implemented", "Version " + query.apiVersion() + " is not implemented");
                }
            }
            expressions = null;
        } else {
            expressions = new ArrayList<ExpressionTree>();
            data_query = QueryRpc.parseQuery(tsdb, query, expressions);
        }
        if (query.getAPIMethod() == HttpMethod.DELETE && tsdb.getConfig().getBoolean("tsd.http.query.allow_delete")) {
            data_query.setDelete(true);
        }
        try {
            LOG.debug(data_query.toString());
            data_query.validateAndSetQuery();
        }
        catch (Exception e) {
            throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, e.getMessage(), data_query.toString(), e);
        }
        final QueryStats query_stats = new QueryStats(query.getRemoteAddress(), data_query, query.getPrintableHeaders());
        data_query.setQueryStats(query_stats);
        query.setStats(query_stats);
        int nqueries = data_query.getQueries().size();
        final ArrayList results = new ArrayList(nqueries);
        final ArrayList globals = new ArrayList();
        if (!data_query.getNoAnnotations() && data_query.getGlobalAnnotations()) {
            class GlobalCB
            implements Callback<Object, List<Annotation>> {
                GlobalCB() {
                }

                public Object call(List<Annotation> annotations) throws Exception {
                    globals.addAll(annotations);
                    class BuildCB
                    implements Callback<Deferred<Object>, Query[]> {
                        final /* synthetic */ QueryStats val$query_stats;
                        final /* synthetic */ List val$globals;
                        final /* synthetic */ TSQuery val$data_query;
                        final /* synthetic */ HttpQuery val$query;
                        final /* synthetic */ ArrayList val$results;
                        final /* synthetic */ List val$expressions;
                        final /* synthetic */ boolean val$allow_expressions;

                        BuildCB() {
                            this.val$query_stats = queryStats;
                            this.val$globals = list;
                            this.val$data_query = tSQuery;
                            this.val$query = httpQuery;
                            this.val$results = arrayList;
                            this.val$expressions = list2;
                            this.val$allow_expressions = bl;
                        }

                        public Deferred<Object> call(Query[] queries) {
                            ArrayList<Deferred<DataPoints[]>> deferreds = new ArrayList<Deferred<DataPoints[]>>(queries.length);
                            for (Query query : queries) {
                                deferreds.add(query.runAsync());
                            }
                            class QueriesCB
                            implements Callback<Object, ArrayList<DataPoints[]>> {
                                final /* synthetic */ boolean val$allow_expressions;
                                final /* synthetic */ List val$expressions;
                                final /* synthetic */ ArrayList val$results;
                                final /* synthetic */ HttpQuery val$query;
                                final /* synthetic */ TSQuery val$data_query;
                                final /* synthetic */ List val$globals;
                                final /* synthetic */ QueryStats val$query_stats;

                                QueriesCB() {
                                    this.val$allow_expressions = bl;
                                    this.val$expressions = list;
                                    this.val$results = arrayList;
                                    this.val$query = httpQuery;
                                    this.val$data_query = tSQuery;
                                    this.val$globals = list2;
                                    this.val$query_stats = queryStats;
                                }

                                public Object call(ArrayList<DataPoints[]> query_results) throws Exception {
                                    if (this.val$allow_expressions) {
                                        ArrayList<DataPoints[]> expression_results = new ArrayList<DataPoints[]>(this.val$expressions.size());
                                        for (ExpressionTree expression : this.val$expressions) {
                                            expression_results.add(expression.evaluate(query_results));
                                        }
                                        this.val$results.addAll(expression_results);
                                    } else {
                                        this.val$results.addAll(query_results);
                                    }
                                    switch (this.val$query.apiVersion()) {
                                        case 0: 
                                        case 1: {
                                            class SendIt
                                            implements Callback<Object, ChannelBuffer> {
                                                SendIt() {
                                                }

                                                public Object call(ChannelBuffer buffer) throws Exception {
                                                    val$query.sendReply(buffer);
                                                    query_success.incrementAndGet();
                                                    return null;
                                                }
                                            }
                                            this.val$query.serializer().formatQueryAsyncV1(this.val$data_query, this.val$results, this.val$globals).addCallback((Callback)new SendIt()).addErrback((Callback)new ErrorCB(QueryRpc.this, this.val$query_stats, this.val$query));
                                            break;
                                        }
                                        default: {
                                            query_invalid.incrementAndGet();
                                            throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "Requested API version not implemented", "Version " + this.val$query.apiVersion() + " is not implemented");
                                        }
                                    }
                                    return null;
                                }
                            }
                            return Deferred.groupInOrder(deferreds).addCallback((Callback)new QueriesCB(QueryRpc.this, this.val$allow_expressions, this.val$expressions, this.val$results, this.val$query, this.val$data_query, this.val$globals, this.val$query_stats));
                        }
                    }
                    return data_query.buildQueriesAsync(tsdb).addCallback((Callback)new BuildCB(QueryRpc.this, query_stats, globals, data_query, query, results, expressions, allow_expressions));
                }
            }
            Annotation.getGlobalAnnotations(tsdb, data_query.startTime() / 1000L, data_query.endTime() / 1000L).addCallback((Callback)new GlobalCB()).addErrback((Callback)new ErrorCB());
        } else {
            data_query.buildQueriesAsync(tsdb).addCallback((Callback)new BuildCB()).addErrback((Callback)new ErrorCB());
        }
    }

    private void handleExpressionQuery(TSDB tsdb, HttpQuery query) {
        net.opentsdb.query.pojo.Query v2_query = JSON.parseToObject(query.getContent(), net.opentsdb.query.pojo.Query.class);
        v2_query.validate();
        QueryExecutor executor = new QueryExecutor(tsdb, v2_query);
        executor.execute(query);
    }

    private void handleLastDataPointQuery(final TSDB tsdb, final HttpQuery query) {
        LastPointQuery data_query;
        block16: {
            block15: {
                if (query.method() != HttpMethod.POST) break block15;
                switch (query.apiVersion()) {
                    case 0: 
                    case 1: {
                        data_query = query.serializer().parseLastPointQueryV1();
                        break block16;
                    }
                    default: {
                        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "Requested API version not implemented", "Version " + query.apiVersion() + " is not implemented");
                    }
                }
            }
            data_query = this.parseLastPointQuery(tsdb, query);
        }
        if (data_query.sub_queries == null || data_query.sub_queries.isEmpty()) {
            throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Missing sub queries");
        }
        ArrayList<Deferred> calls = new ArrayList<Deferred>();
        final ArrayList results = new ArrayList();
        try {
            for (LastPointSubQuery sub_query : data_query.getQueries()) {
                ArrayList<Deferred<IncomingDataPoint>> deferreds = new ArrayList<Deferred<IncomingDataPoint>>();
                if (sub_query.getTSUIDs() != null && !sub_query.getTSUIDs().isEmpty()) {
                    for (String tsuid : sub_query.getTSUIDs()) {
                        TSUIDQuery tsuid_query = new TSUIDQuery(tsdb, UniqueId.stringToUid(tsuid));
                        deferreds.add(tsuid_query.getLastPoint(data_query.getResolveNames(), data_query.getBackScan()));
                    }
                } else {
                    TSUIDQuery tsuid_query = new TSUIDQuery(tsdb, sub_query.getMetric(), sub_query.getTags() != null ? sub_query.getTags() : Collections.EMPTY_MAP);
                    if (data_query.getBackScan() > 0) {
                        deferreds.add(tsuid_query.getLastPoint(data_query.getResolveNames(), data_query.getBackScan()));
                    } else {
                        final class TSUIDQueryCB
                        implements Callback<Deferred<Object>, Bytes.ByteMap<Long>> {
                            TSUIDQueryCB() {
                            }

                            public Deferred<Object> call(Bytes.ByteMap<Long> tsuids) throws Exception {
                                if (tsuids == null || tsuids.isEmpty()) {
                                    return null;
                                }
                                ArrayList<Deferred<IncomingDataPoint>> deferreds = new ArrayList<Deferred<IncomingDataPoint>>(tsuids.size());
                                for (Map.Entry entry : tsuids.entrySet()) {
                                    deferreds.add(TSUIDQuery.getLastPoint(tsdb, (byte[])entry.getKey(), data_query.getResolveNames(), data_query.getBackScan(), (Long)entry.getValue()));
                                }
                                final class FetchCB
                                implements Callback<Deferred<Object>, ArrayList<IncomingDataPoint>> {
                                    final /* synthetic */ List val$results;

                                    FetchCB() {
                                        this.val$results = list;
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public Deferred<Object> call(ArrayList<IncomingDataPoint> dps) throws Exception {
                                        List list = this.val$results;
                                        synchronized (list) {
                                            for (IncomingDataPoint dp : dps) {
                                                if (dp == null) continue;
                                                this.val$results.add(dp);
                                            }
                                        }
                                        return Deferred.fromResult(null);
                                    }

                                    public String toString() {
                                        return "Fetched data points CB";
                                    }
                                }
                                return Deferred.group(deferreds).addCallbackDeferring((Callback)new FetchCB(QueryRpc.this, results));
                            }

                            public String toString() {
                                return "TSMeta scan CB";
                            }
                        }
                        calls.add(tsuid_query.getLastWriteTimes().addCallbackDeferring((Callback)new TSUIDQueryCB()));
                    }
                }
                if (deferreds.size() <= 0) continue;
                calls.add(Deferred.group(deferreds).addCallbackDeferring((Callback)new FetchCB()));
            }
            final class FinalCB
            implements Callback<Object, ArrayList<Object>> {
                FinalCB() {
                }

                public Object call(ArrayList<Object> done) throws Exception {
                    query.sendReply(query.serializer().formatLastPointQueryV1(results));
                    return null;
                }

                public String toString() {
                    return "Final CB";
                }
            }
            final class ErrBack
            implements Callback<Object, Exception> {
                ErrBack() {
                }

                public Object call(Exception e) throws Exception {
                    Throwable ex = e;
                    while (ex.getClass().equals(DeferredGroupException.class)) {
                        if (ex.getCause() == null) {
                            LOG.warn("Unable to get to the root cause of the DGE");
                            break;
                        }
                        ex = ex.getCause();
                    }
                    if (ex instanceof RuntimeException) {
                        throw new BadRequestException(ex);
                    }
                    throw e;
                }

                public String toString() {
                    return "Error back";
                }
            }
            Deferred.group(calls).addCallback((Callback)new FinalCB()).addErrback((Callback)new ErrBack()).joinUninterruptibly();
        }
        catch (Exception e) {
            Throwable ex = e;
            while (ex.getClass().equals(DeferredGroupException.class)) {
                if (ex.getCause() == null) {
                    LOG.warn("Unable to get to the root cause of the DGE");
                    break;
                }
                ex = ex.getCause();
            }
            if (ex instanceof RuntimeException) {
                throw new BadRequestException(ex);
            }
            throw new RuntimeException("Shouldn't be here", e);
        }
    }

    public static TSQuery parseQuery(TSDB tsdb, HttpQuery query) {
        return QueryRpc.parseQuery(tsdb, query, null);
    }

    public static TSQuery parseQuery(TSDB tsdb, HttpQuery query, List<ExpressionTree> expressions) {
        TSQuery data_query = new TSQuery();
        data_query.setStart(query.getRequiredQueryStringParam("start"));
        data_query.setEnd(query.getQueryStringParam("end"));
        if (query.hasQueryStringParam("padding")) {
            data_query.setPadding(true);
        }
        if (query.hasQueryStringParam("no_annotations")) {
            data_query.setNoAnnotations(true);
        }
        if (query.hasQueryStringParam("global_annotations")) {
            data_query.setGlobalAnnotations(true);
        }
        if (query.hasQueryStringParam("show_tsuids")) {
            data_query.setShowTSUIDs(true);
        }
        if (query.hasQueryStringParam("ms")) {
            data_query.setMsResolution(true);
        }
        if (query.hasQueryStringParam("show_query")) {
            data_query.setShowQuery(true);
        }
        if (query.hasQueryStringParam("show_stats")) {
            data_query.setShowStats(true);
        }
        if (query.hasQueryStringParam("show_summary")) {
            data_query.setShowSummary(true);
        }
        if (query.hasQueryStringParam("tsuid")) {
            List<String> tsuids = query.getQueryStringParams("tsuid");
            for (String q : tsuids) {
                QueryRpc.parseTsuidTypeSubQuery(q, data_query);
            }
        }
        if (query.hasQueryStringParam("m")) {
            List<String> legacy_queries = query.getQueryStringParams("m");
            for (String q : legacy_queries) {
                QueryRpc.parseMTypeSubQuery(q, data_query);
            }
        }
        if (expressions != null) {
            if (query.hasQueryStringParam("exp")) {
                List<String> uri_expressions = query.getQueryStringParams("exp");
                ArrayList<String> metric_queries = new ArrayList<String>(uri_expressions.size());
                expressions.addAll(Expressions.parseExpressions(uri_expressions, data_query, metric_queries));
                for (String mq : metric_queries) {
                    QueryRpc.parseMTypeSubQuery(mq, data_query);
                }
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Received a request with an expression but at the wrong endpoint: " + query);
        }
        if (data_query.getQueries() == null || data_query.getQueries().size() < 1) {
            throw new BadRequestException("Missing sub queries");
        }
        return data_query;
    }

    private static void parseMTypeSubQuery(String query_string, TSQuery data_query) {
        if (query_string == null || query_string.isEmpty()) {
            throw new BadRequestException("The query string was empty");
        }
        String[] parts = Tags.splitString(query_string, ':');
        int i = parts.length;
        if (i < 2 || i > 5) {
            throw new BadRequestException("Invalid parameter m=" + query_string + " (" + (i < 2 ? "not enough" : "too many") + " :-separated parts)");
        }
        TSSubQuery sub_query = new TSSubQuery();
        sub_query.setAggregator(parts[0]);
        ArrayList<TagVFilter> filters = new ArrayList<TagVFilter>();
        sub_query.setMetric(Tags.parseWithMetricAndFilters(parts[--i], filters));
        sub_query.setFilters(filters);
        for (int x = 1; x < parts.length - 1; ++x) {
            if (parts[x].toLowerCase().startsWith("rate")) {
                sub_query.setRate(true);
                if (parts[x].indexOf("{") < 0) continue;
                sub_query.setRateOptions(QueryRpc.parseRateOptions(true, parts[x]));
                continue;
            }
            if (Character.isDigit(parts[x].charAt(0))) {
                sub_query.setDownsample(parts[x]);
                continue;
            }
            if (!parts[x].toLowerCase().startsWith("explicit_tags")) continue;
            sub_query.setExplicitTags(true);
        }
        if (data_query.getQueries() == null) {
            ArrayList<TSSubQuery> subs = new ArrayList<TSSubQuery>(1);
            data_query.setQueries(subs);
        }
        data_query.getQueries().add(sub_query);
    }

    private static void parseTsuidTypeSubQuery(String query_string, TSQuery data_query) {
        if (query_string == null || query_string.isEmpty()) {
            throw new BadRequestException("The tsuid query string was empty");
        }
        String[] parts = Tags.splitString(query_string, ':');
        int i = parts.length;
        if (i < 2 || i > 5) {
            throw new BadRequestException("Invalid parameter m=" + query_string + " (" + (i < 2 ? "not enough" : "too many") + " :-separated parts)");
        }
        TSSubQuery sub_query = new TSSubQuery();
        sub_query.setAggregator(parts[0]);
        List<String> tsuid_array = Arrays.asList(parts[--i].split(","));
        sub_query.setTsuids(tsuid_array);
        for (int x = 1; x < parts.length - 1; ++x) {
            if (parts[x].toLowerCase().startsWith("rate")) {
                sub_query.setRate(true);
                if (parts[x].indexOf("{") < 0) continue;
                sub_query.setRateOptions(QueryRpc.parseRateOptions(true, parts[x]));
                continue;
            }
            if (!Character.isDigit(parts[x].charAt(0))) continue;
            sub_query.setDownsample(parts[x]);
        }
        if (data_query.getQueries() == null) {
            ArrayList<TSSubQuery> subs = new ArrayList<TSSubQuery>(1);
            data_query.setQueries(subs);
        }
        data_query.getQueries().add(sub_query);
    }

    public static final RateOptions parseRateOptions(boolean rate, String spec) {
        if (!rate || spec.length() == 4) {
            return new RateOptions(false, Long.MAX_VALUE, 0L);
        }
        if (spec.length() < 6) {
            throw new BadRequestException("Invalid rate options specification: " + spec);
        }
        String[] parts = Tags.splitString(spec.substring(5, spec.length() - 1), ',');
        if (parts.length < 1 || parts.length > 3) {
            throw new BadRequestException("Incorrect number of values in rate options specification, must be counter[,counter max value,reset value], recieved: " + parts.length + " parts");
        }
        boolean counter = parts[0].endsWith("counter");
        try {
            long max = parts.length >= 2 && parts[1].length() > 0 ? Long.parseLong(parts[1]) : Long.MAX_VALUE;
            try {
                long reset = parts.length >= 3 && parts[2].length() > 0 ? Long.parseLong(parts[2]) : 0L;
                boolean drop_counter = parts[0].equals("dropcounter");
                return new RateOptions(counter, max, reset, drop_counter);
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("Reset value of counter was not a number, received '" + parts[2] + "'");
            }
        }
        catch (NumberFormatException e) {
            throw new BadRequestException("Max value of counter was not a number, received '" + parts[1] + "'");
        }
    }

    private LastPointQuery parseLastPointQuery(TSDB tsdb, HttpQuery http_query) {
        LastPointQuery query = new LastPointQuery();
        if (http_query.hasQueryStringParam("resolve")) {
            query.setResolveNames(true);
        }
        if (http_query.hasQueryStringParam("back_scan")) {
            try {
                query.setBackScan(Integer.parseInt(http_query.getQueryStringParam("back_scan")));
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("Unable to parse back_scan parameter");
            }
        }
        List<String> ts_queries = http_query.getQueryStringParams("timeseries");
        List<String> tsuid_queries = http_query.getQueryStringParams("tsuids");
        int num_queries = (ts_queries != null ? ts_queries.size() : 0) + (tsuid_queries != null ? tsuid_queries.size() : 0);
        ArrayList<LastPointSubQuery> sub_queries = new ArrayList<LastPointSubQuery>(num_queries);
        if (ts_queries != null) {
            for (String ts_query : ts_queries) {
                sub_queries.add(LastPointSubQuery.parseTimeSeriesQuery(ts_query));
            }
        }
        if (tsuid_queries != null) {
            for (String tsuid_query : tsuid_queries) {
                sub_queries.add(LastPointSubQuery.parseTSUIDQuery(tsuid_query));
            }
        }
        query.setQueries(sub_queries);
        return query;
    }

    public static void collectStats(StatsCollector collector) {
        collector.record("http.query.invalid_requests", query_invalid);
        collector.record("http.query.exceptions", query_exceptions);
        collector.record("http.query.success", query_success);
    }

    public static class LastPointSubQuery {
        private String metric;
        private HashMap<String, String> tags;
        private List<String> tsuids;

        public static LastPointSubQuery parseTimeSeriesQuery(String query) {
            LastPointSubQuery sub_query = new LastPointSubQuery();
            sub_query.tags = new HashMap();
            sub_query.metric = Tags.parseWithMetric(query, sub_query.tags);
            return sub_query;
        }

        public static LastPointSubQuery parseTSUIDQuery(String query) {
            LastPointSubQuery sub_query = new LastPointSubQuery();
            String[] tsuids = query.split(",");
            sub_query.tsuids = new ArrayList<String>(tsuids.length);
            for (String tsuid : tsuids) {
                sub_query.tsuids.add(tsuid);
            }
            return sub_query;
        }

        public String getMetric() {
            return this.metric;
        }

        public Map<String, String> getTags() {
            return this.tags;
        }

        public List<String> getTSUIDs() {
            return this.tsuids;
        }

        public void setMetric(String metric) {
            this.metric = metric;
        }

        public void setTags(Map<String, String> tags) {
            this.tags = (HashMap)tags;
        }

        public void setTSUIDs(List<String> tsuids) {
            this.tsuids = tsuids;
        }
    }

    public static class LastPointQuery {
        private boolean resolve_names;
        private int back_scan;
        private List<LastPointSubQuery> sub_queries;

        public boolean getResolveNames() {
            return this.resolve_names;
        }

        public int getBackScan() {
            return this.back_scan;
        }

        public List<LastPointSubQuery> getQueries() {
            return this.sub_queries;
        }

        public void setResolveNames(boolean resolve_names) {
            this.resolve_names = resolve_names;
        }

        public void setBackScan(int back_scan) {
            this.back_scan = back_scan;
        }

        public void setQueries(List<LastPointSubQuery> queries) {
            this.sub_queries = queries;
        }
    }
}

