/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tsd;

import com.google.common.base.Strings;
import com.stumbleupon.async.Deferred;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicLong;
import net.opentsdb.core.TSDB;
import net.opentsdb.stats.StatsCollector;
import net.opentsdb.tsd.AbstractHttpQuery;
import net.opentsdb.tsd.BadRequestException;
import net.opentsdb.tsd.GraphHandler;
import net.opentsdb.tsd.HttpQuery;
import net.opentsdb.tsd.HttpRpc;
import net.opentsdb.tsd.HttpRpcPlugin;
import net.opentsdb.tsd.HttpRpcPluginQuery;
import net.opentsdb.tsd.PutDataPointRpc;
import net.opentsdb.tsd.QueryRpc;
import net.opentsdb.tsd.RpcManager;
import net.opentsdb.tsd.TelnetRpc;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelUpstreamHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RpcHandler
extends IdleStateAwareChannelUpstreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RpcHandler.class);
    private static final AtomicLong telnet_rpcs_received = new AtomicLong();
    private static final AtomicLong http_rpcs_received = new AtomicLong();
    private static final AtomicLong http_plugin_rpcs_received = new AtomicLong();
    private static final AtomicLong exceptions_caught = new AtomicLong();
    private final TelnetRpc unknown_cmd = new Unknown();
    private final HashSet<String> cors_domains;
    private final String cors_headers;
    private final RpcManager rpc_manager;
    private final TSDB tsdb;

    public RpcHandler(TSDB tsdb) {
        this(tsdb, RpcManager.instance(tsdb));
    }

    public RpcHandler(TSDB tsdb, RpcManager manager) {
        this.tsdb = tsdb;
        this.rpc_manager = manager;
        String cors = tsdb.getConfig().getString("tsd.http.request.cors_domains");
        String mode = tsdb.getConfig().getString("tsd.mode");
        LOG.info("TSD is in " + mode + " mode");
        if (cors == null || cors.isEmpty()) {
            this.cors_domains = null;
            LOG.info("CORS domain list was empty, CORS will not be enabled");
        } else {
            String[] domains = cors.split(",");
            this.cors_domains = new HashSet(domains.length);
            for (String domain : domains) {
                if (domain.equals("*") && domains.length > 1) {
                    throw new IllegalArgumentException("tsd.http.request.cors_domains must be a public resource (*) or a list of specific domains, you cannot mix both.");
                }
                this.cors_domains.add(domain.trim().toUpperCase());
                LOG.info("Loaded CORS domain (" + domain + ")");
            }
        }
        this.cors_headers = tsdb.getConfig().getString("tsd.http.request.cors_headers").trim();
        if (this.cors_headers == null || !this.cors_headers.matches("^([a-zA-Z0-9_.-]+,\\s*)*[a-zA-Z0-9_.-]+$")) {
            throw new IllegalArgumentException("tsd.http.request.cors_headers must be a list of validly-formed HTTP header names. No wildcards are allowed.");
        }
        LOG.info("Loaded CORS headers (" + this.cors_headers + ")");
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent msgevent) {
        try {
            Object message = msgevent.getMessage();
            if (message instanceof String[]) {
                this.handleTelnetRpc(msgevent.getChannel(), (String[])message);
            } else if (message instanceof HttpRequest) {
                this.handleHttpQuery(this.tsdb, msgevent.getChannel(), (HttpRequest)message);
            } else {
                this.logError(msgevent.getChannel(), "Unexpected message type " + message.getClass() + ": " + message);
                exceptions_caught.incrementAndGet();
            }
        }
        catch (Exception e) {
            Object pretty_message = msgevent.getMessage();
            if (pretty_message instanceof String[]) {
                pretty_message = Arrays.toString((String[])pretty_message);
            }
            this.logError(msgevent.getChannel(), "Unexpected exception caught while serving " + pretty_message, e);
            exceptions_caught.incrementAndGet();
        }
    }

    private void handleTelnetRpc(Channel chan, String[] command) {
        TelnetRpc rpc = this.rpc_manager.lookupTelnetRpc(command[0]);
        if (rpc == null) {
            rpc = this.unknown_cmd;
        }
        telnet_rpcs_received.incrementAndGet();
        rpc.execute(this.tsdb, chan, command);
    }

    private AbstractHttpQuery createQueryInstance(TSDB tsdb, HttpRequest request, Channel chan) throws BadRequestException {
        String uri = request.getUri();
        if (Strings.isNullOrEmpty((String)uri)) {
            throw new BadRequestException("Request URI is empty");
        }
        if (uri.charAt(0) != '/') {
            throw new BadRequestException("Request URI doesn't start with a slash");
        }
        if (this.rpc_manager.isHttpRpcPluginPath(uri)) {
            http_plugin_rpcs_received.incrementAndGet();
            return new HttpRpcPluginQuery(tsdb, request, chan);
        }
        http_rpcs_received.incrementAndGet();
        HttpQuery builtinQuery = new HttpQuery(tsdb, request, chan);
        return builtinQuery;
    }

    private boolean applyCorsConfig(HttpRequest req, AbstractHttpQuery query) throws BadRequestException {
        String domain = req.headers().get("Origin");
        if (query.method() == HttpMethod.OPTIONS || this.cors_domains != null && domain != null && !domain.isEmpty()) {
            if (this.cors_domains == null || domain == null || domain.isEmpty()) {
                throw new BadRequestException(HttpResponseStatus.METHOD_NOT_ALLOWED, "Method not allowed", "The HTTP method [" + query.method().getName() + "] is not permitted");
            }
            if (this.cors_domains.contains("*") || this.cors_domains.contains(domain.toUpperCase())) {
                query.response().headers().add("Access-Control-Allow-Origin", (Object)domain);
                query.response().headers().add("Access-Control-Allow-Methods", (Object)"GET, POST, PUT, DELETE");
                query.response().headers().add("Access-Control-Allow-Headers", (Object)this.cors_headers);
                if (query.method() == HttpMethod.OPTIONS) {
                    query.sendStatusOnly(HttpResponseStatus.OK);
                    return true;
                }
            } else {
                throw new BadRequestException(HttpResponseStatus.OK, "CORS domain not allowed", "The domain [" + domain + "] is not permitted access");
            }
        }
        return false;
    }

    private void handleHttpQuery(TSDB tsdb, Channel chan, HttpRequest req) {
        block15: {
            AbstractHttpQuery abstractQuery = null;
            try {
                abstractQuery = this.createQueryInstance(tsdb, req, chan);
                if (!tsdb.getConfig().enable_chunked_requests() && req.isChunked()) {
                    this.logError(abstractQuery, "Received an unsupported chunked request: " + abstractQuery.request());
                    abstractQuery.badRequest(new BadRequestException("Chunked request not supported."));
                    return;
                }
                String route = abstractQuery.getQueryBaseRoute();
                if (abstractQuery.getClass().isAssignableFrom(HttpRpcPluginQuery.class)) {
                    if (this.applyCorsConfig(req, abstractQuery)) {
                        return;
                    }
                    HttpRpcPluginQuery pluginQuery = (HttpRpcPluginQuery)abstractQuery;
                    HttpRpcPlugin rpc = this.rpc_manager.lookupHttpRpcPlugin(route);
                    if (rpc != null) {
                        rpc.execute(tsdb, pluginQuery);
                    } else {
                        pluginQuery.notFound();
                    }
                    break block15;
                }
                if (abstractQuery.getClass().isAssignableFrom(HttpQuery.class)) {
                    HttpQuery builtinQuery = (HttpQuery)abstractQuery;
                    builtinQuery.setSerializer();
                    if (this.applyCorsConfig(req, abstractQuery)) {
                        return;
                    }
                    HttpRpc rpc = this.rpc_manager.lookupHttpRpc(route);
                    if (rpc != null) {
                        rpc.execute(tsdb, builtinQuery);
                    } else {
                        builtinQuery.notFound();
                    }
                    break block15;
                }
                throw new IllegalStateException("Unknown instance of AbstractHttpQuery: " + abstractQuery.getClass().getName());
            }
            catch (BadRequestException ex) {
                if (abstractQuery == null) {
                    LOG.warn("{} Unable to create query for {}. Reason: {}", new Object[]{chan, req, ex});
                    this.sendStatusAndClose(chan, HttpResponseStatus.BAD_REQUEST);
                } else {
                    abstractQuery.badRequest(ex);
                }
            }
            catch (Exception ex) {
                exceptions_caught.incrementAndGet();
                if (abstractQuery == null) {
                    LOG.warn("{} Unexpected error handling HTTP request {}. Reason: {} ", new Object[]{chan, req, ex});
                    this.sendStatusAndClose(chan, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                }
                abstractQuery.internalError(ex);
            }
        }
    }

    private void sendStatusAndClose(Channel chan, HttpResponseStatus status) {
        if (chan.isConnected()) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
            ChannelFuture future = chan.write((Object)response);
            future.addListener(ChannelFutureListener.CLOSE);
        }
    }

    public static void collectStats(StatsCollector collector) {
        collector.record("rpc.received", telnet_rpcs_received, "type=telnet");
        collector.record("rpc.received", http_rpcs_received, "type=http");
        collector.record("rpc.received", http_plugin_rpcs_received, "type=http_plugin");
        collector.record("rpc.exceptions", exceptions_caught);
        HttpQuery.collectStats(collector);
        GraphHandler.collectStats(collector);
        PutDataPointRpc.collectStats(collector);
        QueryRpc.collectStats(collector);
    }

    static String getDirectoryFromSystemProp(String prop) {
        String dir = System.getProperty(prop);
        String err = null;
        if (dir == null) {
            err = "' is not set.";
        } else if (dir.isEmpty()) {
            err = "' is empty.";
        } else if (dir.charAt(dir.length() - 1) != '/') {
            err = "' is not terminated with `/'.";
        }
        if (err != null) {
            throw new IllegalStateException("System property `" + prop + err);
        }
        return dir;
    }

    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) {
        if (e.getState() == IdleState.ALL_IDLE) {
            String channel_info = e.getChannel().toString();
            LOG.debug("Closing idle socket: " + channel_info);
            e.getChannel().close();
            LOG.info("Closed idle socket: " + channel_info);
        }
    }

    private static void logWarn(AbstractHttpQuery query, String msg) {
        LOG.warn(query.channel().toString() + ' ' + msg);
    }

    private void logError(AbstractHttpQuery query, String msg) {
        LOG.error(query.channel().toString() + ' ' + msg);
    }

    private static void logWarn(Channel chan, String msg) {
        LOG.warn(chan.toString() + ' ' + msg);
    }

    private void logError(Channel chan, String msg) {
        LOG.error(chan.toString() + ' ' + msg);
    }

    private void logError(Channel chan, String msg, Exception e) {
        LOG.error(chan.toString() + ' ' + msg, (Throwable)e);
    }

    private static final class Unknown
    implements TelnetRpc {
        private Unknown() {
        }

        @Override
        public Deferred<Object> execute(TSDB tsdb, Channel chan, String[] cmd) {
            RpcHandler.logWarn(chan, "unknown command : " + Arrays.toString(cmd));
            chan.write((Object)("unknown command: " + cmd[0] + ".  Try `help'.\n"));
            return Deferred.fromResult(null);
        }
    }
}

