/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tsd;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Atomics;
import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import net.opentsdb.core.Aggregators;
import net.opentsdb.core.TSDB;
import net.opentsdb.query.filter.TagVFilter;
import net.opentsdb.stats.StatsCollector;
import net.opentsdb.tools.BuildData;
import net.opentsdb.tsd.AnnotationRpc;
import net.opentsdb.tsd.BadRequestException;
import net.opentsdb.tsd.ConnectionManager;
import net.opentsdb.tsd.DropCachesRpc;
import net.opentsdb.tsd.GraphHandler;
import net.opentsdb.tsd.HttpQuery;
import net.opentsdb.tsd.HttpRpc;
import net.opentsdb.tsd.HttpRpcPlugin;
import net.opentsdb.tsd.LogsRpc;
import net.opentsdb.tsd.PutDataPointRpc;
import net.opentsdb.tsd.QueryRpc;
import net.opentsdb.tsd.RpcPlugin;
import net.opentsdb.tsd.RpcUtil;
import net.opentsdb.tsd.SearchRpc;
import net.opentsdb.tsd.StaticFileRpc;
import net.opentsdb.tsd.StatsRpc;
import net.opentsdb.tsd.SuggestRpc;
import net.opentsdb.tsd.TelnetRpc;
import net.opentsdb.tsd.TreeRpc;
import net.opentsdb.tsd.UniqueIdRpc;
import net.opentsdb.utils.JSON;
import net.opentsdb.utils.PluginLoader;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RpcManager {
    private static final Logger LOG = LoggerFactory.getLogger(RpcManager.class);
    @VisibleForTesting
    protected static final String PLUGIN_BASE_WEBPATH = "plugin";
    private static final Splitter WEBPATH_SPLITTER = Splitter.on((char)'/').trimResults().omitEmptyStrings();
    private static final Pattern HAS_PLUGIN_BASE_WEBPATH = Pattern.compile("^/?plugin/?.*", 34);
    private static final AtomicReference<RpcManager> INSTANCE = Atomics.newReference();
    private ImmutableMap<String, TelnetRpc> telnet_commands;
    private ImmutableMap<String, HttpRpc> http_commands;
    private ImmutableMap<String, HttpRpcPlugin> http_plugin_commands;
    private ImmutableList<RpcPlugin> rpc_plugins;
    private TSDB tsdb;

    private RpcManager(TSDB tsdb) {
        this.tsdb = tsdb;
    }

    public static synchronized RpcManager instance(TSDB tsdb) {
        RpcManager existing = INSTANCE.get();
        if (existing != null) {
            return existing;
        }
        RpcManager manager = new RpcManager(tsdb);
        String mode = Strings.nullToEmpty((String)tsdb.getConfig().getString("tsd.mode"));
        ImmutableList.Builder rpcBuilder = ImmutableList.builder();
        if (tsdb.getConfig().hasProperty("tsd.rpc.plugins")) {
            String[] plugins = tsdb.getConfig().getString("tsd.rpc.plugins").split(",");
            manager.initializeRpcPlugins(plugins, (ImmutableList.Builder<RpcPlugin>)rpcBuilder);
        }
        manager.rpc_plugins = rpcBuilder.build();
        ImmutableMap.Builder telnetBuilder = ImmutableMap.builder();
        ImmutableMap.Builder httpBuilder = ImmutableMap.builder();
        manager.initializeBuiltinRpcs(mode, (ImmutableMap.Builder<String, TelnetRpc>)telnetBuilder, (ImmutableMap.Builder<String, HttpRpc>)httpBuilder);
        manager.telnet_commands = telnetBuilder.build();
        manager.http_commands = httpBuilder.build();
        ImmutableMap.Builder httpPluginsBuilder = ImmutableMap.builder();
        if (tsdb.getConfig().hasProperty("tsd.http.rpc.plugins")) {
            String[] plugins = tsdb.getConfig().getString("tsd.http.rpc.plugins").split(",");
            manager.initializeHttpRpcPlugins(mode, plugins, (ImmutableMap.Builder<String, HttpRpcPlugin>)httpPluginsBuilder);
        }
        manager.http_plugin_commands = httpPluginsBuilder.build();
        INSTANCE.set(manager);
        return manager;
    }

    public static synchronized boolean isInitialized() {
        return INSTANCE.get() != null;
    }

    @VisibleForTesting
    protected ImmutableList<RpcPlugin> getRpcPlugins() {
        return this.rpc_plugins;
    }

    TelnetRpc lookupTelnetRpc(String command) {
        return (TelnetRpc)this.telnet_commands.get((Object)command);
    }

    HttpRpc lookupHttpRpc(String queryBaseRoute) {
        return (HttpRpc)this.http_commands.get((Object)queryBaseRoute);
    }

    HttpRpcPlugin lookupHttpRpcPlugin(String queryBaseRoute) {
        return (HttpRpcPlugin)this.http_plugin_commands.get((Object)queryBaseRoute);
    }

    boolean isHttpRpcPluginPath(String uri) {
        List parts;
        if (Strings.isNullOrEmpty((String)uri) || uri.length() <= PLUGIN_BASE_WEBPATH.length()) {
            return false;
        }
        int qmark = uri.indexOf(63);
        String path = uri;
        if (qmark != -1) {
            path = uri.substring(0, qmark);
        }
        return (parts = WEBPATH_SPLITTER.splitToList((CharSequence)path)).size() > 1 && ((String)parts.get(0)).equals(PLUGIN_BASE_WEBPATH);
    }

    private void initializeBuiltinRpcs(String mode, ImmutableMap.Builder<String, TelnetRpc> telnet, ImmutableMap.Builder<String, HttpRpc> http) {
        Boolean enableApi = this.tsdb.getConfig().getString("tsd.core.enable_api").equals("true");
        Boolean enableUi = this.tsdb.getConfig().getString("tsd.core.enable_ui").equals("true");
        Boolean enableDieDieDie = this.tsdb.getConfig().getString("tsd.no_diediedie").equals("false");
        LOG.info("Mode: {}, HTTP UI Enabled: {}, HTTP API Enabled: {}", new Object[]{mode, enableUi, enableApi});
        if (mode.equals("rw") || mode.equals("wo")) {
            PutDataPointRpc put = new PutDataPointRpc();
            telnet.put((Object)"put", (Object)put);
            if (enableApi.booleanValue()) {
                http.put((Object)"api/put", (Object)put);
            }
        }
        if (mode.equals("rw") || mode.equals("ro")) {
            StaticFileRpc staticfile = new StaticFileRpc();
            StatsRpc stats = new StatsRpc();
            DropCachesRpc dropcaches = new DropCachesRpc();
            ListAggregators aggregators = new ListAggregators();
            SuggestRpc suggest_rpc = new SuggestRpc();
            AnnotationRpc annotation_rpc = new AnnotationRpc();
            Version version = new Version();
            telnet.put((Object)"stats", (Object)stats);
            telnet.put((Object)"dropcaches", (Object)dropcaches);
            telnet.put((Object)"version", (Object)version);
            telnet.put((Object)"exit", (Object)new Exit());
            telnet.put((Object)"help", (Object)new Help());
            if (enableUi.booleanValue()) {
                http.put((Object)"", (Object)new HomePage());
                http.put((Object)"aggregators", (Object)aggregators);
                http.put((Object)"dropcaches", (Object)dropcaches);
                http.put((Object)"favicon.ico", (Object)staticfile);
                http.put((Object)"logs", (Object)new LogsRpc());
                http.put((Object)"q", (Object)new GraphHandler());
                http.put((Object)"s", (Object)staticfile);
                http.put((Object)"stats", (Object)stats);
                http.put((Object)"suggest", (Object)suggest_rpc);
                http.put((Object)"version", (Object)version);
            }
            if (enableApi.booleanValue()) {
                http.put((Object)"api/aggregators", (Object)aggregators);
                http.put((Object)"api/annotation", (Object)annotation_rpc);
                http.put((Object)"api/annotations", (Object)annotation_rpc);
                http.put((Object)"api/config", (Object)new ShowConfig());
                http.put((Object)"api/dropcaches", (Object)dropcaches);
                http.put((Object)"api/query", (Object)new QueryRpc());
                http.put((Object)"api/search", (Object)new SearchRpc());
                http.put((Object)"api/serializers", (Object)new Serializers());
                http.put((Object)"api/stats", (Object)stats);
                http.put((Object)"api/suggest", (Object)suggest_rpc);
                http.put((Object)"api/tree", (Object)new TreeRpc());
                http.put((Object)"api/uid", (Object)new UniqueIdRpc());
                http.put((Object)"api/version", (Object)version);
            }
        }
        if (enableDieDieDie.booleanValue()) {
            DieDieDie diediedie = new DieDieDie();
            telnet.put((Object)"diediedie", (Object)diediedie);
            if (enableUi.booleanValue()) {
                http.put((Object)"diediedie", (Object)diediedie);
            }
        }
    }

    @VisibleForTesting
    protected void initializeHttpRpcPlugins(String mode, String[] pluginClassNames, ImmutableMap.Builder<String, HttpRpcPlugin> http) {
        for (String plugin : pluginClassNames) {
            HttpRpcPlugin rpc = this.createAndInitialize(plugin, HttpRpcPlugin.class);
            this.validateHttpRpcPluginPath(rpc.getPath());
            String path = rpc.getPath().trim();
            String canonicalized_path = this.canonicalizePluginPath(path);
            http.put((Object)canonicalized_path, (Object)rpc);
            LOG.info("Mounted HttpRpcPlugin [{}] at path \"{}\"", (Object)rpc.getClass().getName(), (Object)canonicalized_path);
        }
    }

    @VisibleForTesting
    protected void validateHttpRpcPluginPath(String path) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)path) ? 1 : 0) != 0, (Object)"Invalid HttpRpcPlugin path. Path is null or empty.");
        String testPath = path.trim();
        Preconditions.checkArgument((!HAS_PLUGIN_BASE_WEBPATH.matcher(path).matches() ? 1 : 0) != 0, (String)"Invalid HttpRpcPlugin path %s. Path contains system's plugin base path.", (Object[])new Object[]{testPath});
        URI uri = URI.create(testPath);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uri.getPath()) ? 1 : 0) != 0, (String)"Invalid HttpRpcPlugin path %s. Parsed path is null or empty.", (Object[])new Object[]{testPath});
        Preconditions.checkArgument((!uri.getPath().equals("/") ? 1 : 0) != 0, (String)"Invalid HttpRpcPlugin path %s. Path is equal to root.", (Object[])new Object[]{testPath});
        Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)uri.getQuery()), (String)"Invalid HttpRpcPlugin path %s. Path contains query parameters.", (Object[])new Object[]{testPath});
    }

    @VisibleForTesting
    protected String canonicalizePluginPath(String origPath) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)origPath) && !origPath.equals("/") ? 1 : 0) != 0, (String)"Path %s is a root.", (Object[])new Object[]{origPath});
        String new_path = origPath;
        if (new_path.startsWith("/")) {
            new_path = new_path.substring(1);
        }
        if (new_path.endsWith("/")) {
            new_path = new_path.substring(0, new_path.length() - 1);
        }
        return new_path;
    }

    private void initializeRpcPlugins(String[] pluginClassNames, ImmutableList.Builder<RpcPlugin> rpcs) {
        for (String plugin : pluginClassNames) {
            RpcPlugin rpc = this.createAndInitialize(plugin, RpcPlugin.class);
            rpcs.add((Object)rpc);
        }
    }

    @VisibleForTesting
    protected <T> T createAndInitialize(String pluginClassName, Class<T> pluginClass) {
        T instance = PluginLoader.loadSpecificPlugin(pluginClassName, pluginClass);
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (String)"Unable to locate %s using name '%s", (Object[])new Object[]{pluginClass, pluginClassName});
        try {
            Method initMeth = instance.getClass().getMethod("initialize", TSDB.class);
            initMeth.invoke(instance, this.tsdb);
            Method versionMeth = instance.getClass().getMethod("version", new Class[0]);
            String version = (String)versionMeth.invoke(instance, new Object[0]);
            LOG.info("Successfully initialized plugin [{}] version: {}", (Object)instance.getClass().getCanonicalName(), (Object)version);
            return instance;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize " + instance.getClass(), e);
        }
    }

    public Deferred<ArrayList<Object>> shutdown() {
        INSTANCE.set(null);
        ArrayList deferreds = Lists.newArrayList();
        if (this.http_plugin_commands != null) {
            for (Map.Entry entry : this.http_plugin_commands.entrySet()) {
                deferreds.add(((HttpRpcPlugin)entry.getValue()).shutdown());
            }
        }
        if (this.rpc_plugins != null) {
            for (RpcPlugin rpc : this.rpc_plugins) {
                deferreds.add(rpc.shutdown());
            }
        }
        return Deferred.groupInOrder((Collection)deferreds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void collectStats(StatsCollector collector) {
        RpcManager manager = INSTANCE.get();
        if (manager != null) {
            if (manager.rpc_plugins != null) {
                try {
                    collector.addExtraTag(PLUGIN_BASE_WEBPATH, "rpc");
                    for (RpcPlugin rpc : manager.rpc_plugins) {
                        rpc.collectStats(collector);
                    }
                }
                finally {
                    collector.clearExtraTag(PLUGIN_BASE_WEBPATH);
                }
            }
            if (manager.http_plugin_commands != null) {
                try {
                    collector.addExtraTag(PLUGIN_BASE_WEBPATH, "httprpc");
                    for (Map.Entry entry : manager.http_plugin_commands.entrySet()) {
                        ((HttpRpcPlugin)entry.getValue()).collectStats(collector);
                    }
                }
                finally {
                    collector.clearExtraTag(PLUGIN_BASE_WEBPATH);
                }
            }
        }
    }

    private static final class ShowConfig
    implements HttpRpc {
        private ShowConfig() {
        }

        @Override
        public void execute(TSDB tsdb, HttpQuery query) throws IOException {
            block7: {
                block6: {
                    String endpoint;
                    RpcUtil.allowedMethods(query.method(), HttpMethod.GET.getName(), HttpMethod.POST.getName());
                    String[] uri = query.explodeAPIPath();
                    String string = endpoint = uri.length > 1 ? uri[1].toLowerCase() : "";
                    if (!endpoint.equals("filters")) break block6;
                    switch (query.apiVersion()) {
                        case 0: 
                        case 1: {
                            query.sendReply(query.serializer().formatFilterConfigV1(TagVFilter.loadedFilters()));
                            break block7;
                        }
                        default: {
                            throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "Requested API version not implemented", "Version " + query.apiVersion() + " is not implemented");
                        }
                    }
                }
                switch (query.apiVersion()) {
                    case 0: 
                    case 1: {
                        query.sendReply(query.serializer().formatConfigV1(tsdb.getConfig()));
                        break;
                    }
                    default: {
                        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "Requested API version not implemented", "Version " + query.apiVersion() + " is not implemented");
                    }
                }
            }
        }
    }

    private static final class Serializers
    implements HttpRpc {
        private Serializers() {
        }

        @Override
        public void execute(TSDB tsdb, HttpQuery query) throws IOException {
            RpcUtil.allowedMethods(query.method(), HttpMethod.GET.getName(), HttpMethod.POST.getName());
            switch (query.apiVersion()) {
                case 0: 
                case 1: {
                    query.sendReply(query.serializer().formatSerializersV1());
                    break;
                }
                default: {
                    throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "Requested API version not implemented", "Version " + query.apiVersion() + " is not implemented");
                }
            }
        }
    }

    private static final class Version
    implements TelnetRpc,
    HttpRpc {
        private Version() {
        }

        @Override
        public Deferred<Object> execute(TSDB tsdb, Channel chan, String[] cmd) {
            if (chan.isConnected()) {
                chan.write((Object)(BuildData.revisionString() + '\n' + BuildData.buildString() + '\n'));
            }
            return Deferred.fromResult(null);
        }

        @Override
        public void execute(TSDB tsdb, HttpQuery query) throws IOException {
            RpcUtil.allowedMethods(query.method(), HttpMethod.GET.getName(), HttpMethod.POST.getName());
            HashMap<String, String> version = new HashMap<String, String>();
            version.put("version", "BuildData");
            version.put("short_revision", "fac1e739");
            version.put("full_revision", "fac1e7392178775aac66962940f1a276cb747be5");
            version.put("timestamp", Long.toString(1545003412L));
            version.put("repo_status", BuildData.repo_status.toString());
            version.put("user", "clarsen");
            version.put("host", "C02VQ1KGHTDD");
            version.put("repo", "/Users/clarsen/Documents/opentsdb/opentsdb_OFFICIAL");
            version.put("branch", "master");
            if (query.apiVersion() > 0) {
                query.sendReply(query.serializer().formatVersionV1(version));
            } else {
                boolean json = query.request().getUri().endsWith("json");
                if (json) {
                    query.sendReply(JSON.serializeToBytes(version));
                } else {
                    String revision = BuildData.revisionString();
                    String build = BuildData.buildString();
                    StringBuilder buf = new StringBuilder(2 + revision.length() + build.length());
                    buf.append(revision).append('\n').append(build).append('\n');
                    query.sendReply(buf);
                }
            }
        }
    }

    private static final class ListAggregators
    implements HttpRpc {
        private ListAggregators() {
        }

        @Override
        public void execute(TSDB tsdb, HttpQuery query) throws IOException {
            RpcUtil.allowedMethods(query.method(), HttpMethod.GET.getName(), HttpMethod.POST.getName());
            if (query.apiVersion() > 0) {
                query.sendReply(query.serializer().formatAggregatorsV1(Aggregators.set()));
            } else {
                query.sendReply(JSON.serializeToBytes(Aggregators.set()));
            }
        }
    }

    private static final class HomePage
    implements HttpRpc {
        private HomePage() {
        }

        @Override
        public void execute(TSDB tsdb, HttpQuery query) throws IOException {
            StringBuilder buf = new StringBuilder(2048);
            buf.append("<div id=queryuimain></div><noscript>You must have JavaScript enabled.</noscript><iframe src=javascript:'' id=__gwt_historyFrame tabIndex=-1 style=position:absolute;width:0;height:0;border:0></iframe>");
            query.sendReply(HttpQuery.makePage("<script type=text/javascript language=javascript src=s/queryui.nocache.js></script>", "OpenTSDB", "", buf.toString()));
        }
    }

    private final class Help
    implements TelnetRpc {
        private Help() {
        }

        @Override
        public Deferred<Object> execute(TSDB tsdb, Channel chan, String[] cmd) {
            StringBuilder buf = new StringBuilder();
            buf.append("available commands: ");
            for (String command : RpcManager.this.telnet_commands.keySet()) {
                buf.append(command).append(' ');
            }
            buf.append('\n');
            chan.write((Object)buf.toString());
            return Deferred.fromResult(null);
        }
    }

    private static final class Exit
    implements TelnetRpc {
        private Exit() {
        }

        @Override
        public Deferred<Object> execute(TSDB tsdb, Channel chan, String[] cmd) {
            chan.disconnect();
            return Deferred.fromResult(null);
        }
    }

    private final class DieDieDie
    implements TelnetRpc,
    HttpRpc {
        private DieDieDie() {
        }

        @Override
        public Deferred<Object> execute(TSDB tsdb, Channel chan, String[] cmd) {
            LOG.warn("{} {}", (Object)chan, (Object)"shutdown requested");
            chan.write((Object)"Cleaning up and exiting now.\n");
            return this.doShutdown(tsdb, chan);
        }

        @Override
        public void execute(TSDB tsdb, HttpQuery query) {
            LOG.warn("{} {}", (Object)query, (Object)"shutdown requested");
            query.sendReply(HttpQuery.makePage("TSD Exiting", "You killed me", "Cleaning up and exiting now."));
            this.doShutdown(tsdb, query.channel());
        }

        private Deferred<Object> doShutdown(TSDB tsdb, final Channel chan) {
            ((GraphHandler)RpcManager.this.http_commands.get((Object)"q")).shutdown();
            ConnectionManager.closeAllConnections();
            final class ShutdownNetty
            extends Thread {
                ShutdownNetty() {
                    super("ShutdownNetty");
                }

                @Override
                public void run() {
                    chan.getFactory().releaseExternalResources();
                }
            }
            new ShutdownNetty().start();
            final class ShutdownTSDB
            implements Callback<Exception, Exception> {
                ShutdownTSDB() {
                }

                public Exception call(Exception arg) {
                    LOG.error("Unexpected exception while shutting down", (Throwable)arg);
                    return arg;
                }

                public String toString() {
                    return "shutdown callback";
                }
            }
            return tsdb.shutdown().addErrback((Callback)new ShutdownTSDB());
        }
    }
}

