/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tsd;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import com.stumbleupon.async.DeferredGroupException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.Tags;
import net.opentsdb.search.SearchQuery;
import net.opentsdb.search.TimeSeriesLookup;
import net.opentsdb.tsd.BadRequestException;
import net.opentsdb.tsd.HttpQuery;
import net.opentsdb.tsd.HttpRpc;
import net.opentsdb.uid.NoSuchUniqueId;
import net.opentsdb.uid.NoSuchUniqueName;
import net.opentsdb.uid.UniqueId;
import net.opentsdb.utils.Exceptions;
import net.opentsdb.utils.Pair;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

final class SearchRpc
implements HttpRpc {
    SearchRpc() {
    }

    @Override
    public void execute(TSDB tsdb, HttpQuery query) {
        SearchQuery.SearchType type;
        HttpMethod method = query.getAPIMethod();
        if (method != HttpMethod.GET && method != HttpMethod.POST) {
            throw new BadRequestException("Unsupported method: " + method.getName());
        }
        String[] uri = query.explodeAPIPath();
        String endpoint = uri.length > 1 ? uri[1] : "";
        try {
            type = SearchQuery.parseSearchType(endpoint);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Invalid search query type supplied", e);
        }
        SearchQuery search_query = query.hasContent() ? query.serializer().parseSearchQueryV1() : this.parseQueryString(query, type);
        search_query.setType(type);
        if (type == SearchQuery.SearchType.LOOKUP) {
            this.processLookup(tsdb, query, search_query);
            return;
        }
        try {
            SearchQuery results = (SearchQuery)tsdb.executeSearch(search_query).joinUninterruptibly();
            query.sendReply(query.serializer().formatSearchResultsV1(results));
        }
        catch (IllegalStateException e) {
            throw new BadRequestException("Searching is not enabled", e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private final SearchQuery parseQueryString(HttpQuery query, SearchQuery.SearchType type) {
        SearchQuery search_query = new SearchQuery();
        if (type == SearchQuery.SearchType.LOOKUP) {
            String query_string = query.getRequiredQueryStringParam("m");
            search_query.setTags(new ArrayList<Pair<String, String>>());
            try {
                search_query.setMetric(Tags.parseWithMetric(query_string, search_query.getTags()));
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Unable to parse query", e);
            }
            if (query.hasQueryStringParam("limit")) {
                String limit = query.getQueryStringParam("limit");
                try {
                    search_query.setLimit(Integer.parseInt(limit));
                }
                catch (NumberFormatException e) {
                    throw new BadRequestException("Unable to convert 'limit' to a valid number");
                }
            }
            return search_query;
        }
        search_query.setQuery(query.getRequiredQueryStringParam("query"));
        if (query.hasQueryStringParam("limit")) {
            String limit = query.getQueryStringParam("limit");
            try {
                search_query.setLimit(Integer.parseInt(limit));
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("Unable to convert 'limit' to a valid number");
            }
        }
        if (query.hasQueryStringParam("start_index")) {
            String idx = query.getQueryStringParam("start_index");
            try {
                search_query.setStartIndex(Integer.parseInt(idx));
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("Unable to convert 'start_index' to a valid number");
            }
        }
        if (query.hasQueryStringParam("use_meta")) {
            search_query.setUseMeta(Boolean.parseBoolean(query.getQueryStringParam("use_meta")));
        }
        return search_query;
    }

    private void processLookup(final TSDB tsdb, final HttpQuery query, final SearchQuery search_query) {
        if (search_query.getMetric() == null && (search_query.getTags() == null || search_query.getTags().size() < 1)) {
            throw new BadRequestException("Missing metric and tags. Please supply at least one value.");
        }
        final long start = System.currentTimeMillis();
        class LookupCB
        implements Callback<Deferred<Object>, List<byte[]>> {
            LookupCB() {
            }

            public Deferred<Object> call(List<byte[]> tsuids) throws Exception {
                ArrayList<ConcurrentHashMap<String, Object>> results = new ArrayList<ConcurrentHashMap<String, Object>>(tsuids.size());
                search_query.setTotalResults(tsuids.size());
                ArrayList<Deferred> deferreds = new ArrayList<Deferred>(tsuids.size());
                for (byte[] tsuid : tsuids) {
                    ConcurrentHashMap<String, Object> series = new ConcurrentHashMap<String, Object>(3);
                    results.add(series);
                    series.put("tsuid", UniqueId.uidToString(tsuid));
                    byte[] metric_uid = Arrays.copyOfRange(tsuid, 0, (int)TSDB.metrics_width());
                    class MetricCB
                    implements Callback<Object, String> {
                        final Map<String, Object> series;

                        MetricCB(Map<String, Object> series) {
                            this.series = series;
                        }

                        public Object call(String name) throws Exception {
                            this.series.put("metric", name);
                            return null;
                        }
                    }
                    deferreds.add(tsdb.getUidName(UniqueId.UniqueIdType.METRIC, metric_uid).addCallback((Callback)new MetricCB(series)));
                    List<byte[]> tag_ids = UniqueId.getTagPairsFromTSUID(tsuid);
                    class TagsCB
                    implements Callback<Object, HashMap<String, String>> {
                        final Map<String, Object> series;

                        TagsCB(Map<String, Object> series) {
                            this.series = series;
                        }

                        public Object call(HashMap<String, String> names) throws Exception {
                            this.series.put("tags", names);
                            return null;
                        }
                    }
                    deferreds.add(Tags.resolveIdsAsync(tsdb, tag_ids).addCallback((Callback)new TagsCB(series)));
                }
                class Serialize
                implements Callback<Object, ArrayList<Object>> {
                    final List<Object> results;
                    final /* synthetic */ SearchQuery val$search_query;
                    final /* synthetic */ long val$start;
                    final /* synthetic */ HttpQuery val$query;
                    final /* synthetic */ SearchRpc this$0;

                    Serialize(List<Object> results) {
                        this.this$0 = this$0;
                        this.val$search_query = var3_3;
                        this.val$start = l;
                        this.val$query = var6_5;
                        this.results = results;
                    }

                    public Object call(ArrayList<Object> ignored) throws Exception {
                        this.val$search_query.setResults(this.results);
                        this.val$search_query.setTime(System.currentTimeMillis() - this.val$start);
                        this.val$query.sendReply(this.val$query.serializer().formatSearchResultsV1(this.val$search_query));
                        return null;
                    }
                }
                return Deferred.group(deferreds).addCallback((Callback)new Serialize(SearchRpc.this, results, search_query, start, query));
            }
        }
        class ErrCB
        implements Callback<Object, Exception> {
            ErrCB() {
            }

            public Object call(Exception e) throws Exception {
                if (e instanceof NoSuchUniqueId) {
                    query.sendReply(HttpResponseStatus.NOT_FOUND, query.serializer().formatErrorV1(new BadRequestException(HttpResponseStatus.NOT_FOUND, "Unable to resolve one or more TSUIDs", (NoSuchUniqueId)e)));
                } else if (e instanceof NoSuchUniqueName) {
                    query.sendReply(HttpResponseStatus.NOT_FOUND, query.serializer().formatErrorV1(new BadRequestException(HttpResponseStatus.NOT_FOUND, "Unable to resolve one or more UIDs", (NoSuchUniqueName)e)));
                } else if (e instanceof DeferredGroupException) {
                    Throwable ex = Exceptions.getCause((DeferredGroupException)((Object)e));
                    if (ex instanceof NoSuchUniqueId) {
                        query.sendReply(HttpResponseStatus.NOT_FOUND, query.serializer().formatErrorV1(new BadRequestException(HttpResponseStatus.NOT_FOUND, "Unable to resolve one or more TSUIDs", (NoSuchUniqueId)ex)));
                    } else if (ex instanceof NoSuchUniqueName) {
                        query.sendReply(HttpResponseStatus.NOT_FOUND, query.serializer().formatErrorV1(new BadRequestException(HttpResponseStatus.NOT_FOUND, "Unable to resolve one or more UIDs", (NoSuchUniqueName)ex)));
                    } else {
                        query.sendReply(HttpResponseStatus.INTERNAL_SERVER_ERROR, query.serializer().formatErrorV1(new BadRequestException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Unexpected exception", ex)));
                    }
                } else {
                    query.sendReply(HttpResponseStatus.INTERNAL_SERVER_ERROR, query.serializer().formatErrorV1(new BadRequestException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Unexpected exception", e)));
                }
                return null;
            }
        }
        new TimeSeriesLookup(tsdb, search_query).lookupAsync().addCallback((Callback)new LookupCB()).addErrback((Callback)new ErrCB());
    }
}

