/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tsd;

import java.io.IOException;
import net.opentsdb.core.TSDB;
import net.opentsdb.tsd.BadRequestException;
import net.opentsdb.tsd.HttpQuery;
import net.opentsdb.tsd.HttpRpc;

final class StaticFileRpc
implements HttpRpc {
    @Override
    public void execute(TSDB tsdb, HttpQuery query) throws IOException {
        String uri = query.request().getUri();
        if ("/favicon.ico".equals(uri)) {
            query.sendFile(tsdb.getConfig().getDirectoryName("tsd.http.staticroot") + "/favicon.ico", 31536000);
            return;
        }
        if (uri.length() < 3) {
            throw new BadRequestException("URI too short <code>" + uri + "</code>");
        }
        if (uri.indexOf("..", 3) > 0) {
            throw new BadRequestException("Malformed URI <code>" + uri + "</code>");
        }
        int questionmark = uri.indexOf(63, 3);
        int pathend = questionmark > 0 ? questionmark : uri.length();
        query.sendFile(tsdb.getConfig().getDirectoryName("tsd.http.staticroot") + uri.substring(2, pathend), uri.contains("nocache") ? 0 : 31536000);
    }
}

