/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tsd;

import com.stumbleupon.async.Deferred;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.opentsdb.core.IncomingDataPoint;
import net.opentsdb.core.TSDB;
import net.opentsdb.stats.QueryStats;
import net.opentsdb.stats.StatsCollector;
import net.opentsdb.tsd.BadRequestException;
import net.opentsdb.tsd.ConnectionManager;
import net.opentsdb.tsd.HttpQuery;
import net.opentsdb.tsd.HttpRpc;
import net.opentsdb.tsd.RpcHandler;
import net.opentsdb.tsd.RpcManager;
import net.opentsdb.tsd.TelnetRpc;
import net.opentsdb.utils.JSON;
import org.hbase.async.RegionClientStats;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatsRpc
implements TelnetRpc,
HttpRpc {
    private static final Logger LOG = LoggerFactory.getLogger(StatsRpc.class);

    @Override
    public Deferred<Object> execute(TSDB tsdb, Channel chan, String[] cmd) {
        boolean canonical = tsdb.getConfig().getBoolean("tsd.stats.canonical");
        StringBuilder buf = new StringBuilder(1024);
        ASCIICollector collector = new ASCIICollector("tsd", buf, null);
        this.doCollectStats(tsdb, collector, canonical);
        chan.write((Object)buf.toString());
        return Deferred.fromResult(null);
    }

    @Override
    public void execute(TSDB tsdb, HttpQuery query) {
        if (query.method() != HttpMethod.GET && query.method() != HttpMethod.POST) {
            throw new BadRequestException(HttpResponseStatus.METHOD_NOT_ALLOWED, "Method not allowed", "The HTTP method [" + query.method().getName() + "] is not permitted for this endpoint");
        }
        try {
            String endpoint;
            String[] uri = query.explodeAPIPath();
            String string = endpoint = uri.length > 1 ? uri[1].toLowerCase() : "";
            if ("threads".equals(endpoint)) {
                this.printThreadStats(query);
                return;
            }
            if ("jvm".equals(endpoint)) {
                this.printJVMStats(tsdb, query);
                return;
            }
            if ("query".equals(endpoint)) {
                this.printQueryStats(query);
                return;
            }
            if ("region_clients".equals(endpoint)) {
                this.printRegionClientStats(tsdb, query);
                return;
            }
        }
        catch (IllegalArgumentException uri) {
            // empty catch block
        }
        boolean canonical = tsdb.getConfig().getBoolean("tsd.stats.canonical");
        if (query.apiVersion() < 1) {
            boolean json = query.hasQueryStringParam("json");
            StringBuilder buf = json ? null : new StringBuilder(2048);
            ArrayList<String> stats = json ? new ArrayList<String>(64) : null;
            ASCIICollector collector = new ASCIICollector("tsd", buf, stats);
            this.doCollectStats(tsdb, collector, canonical);
            if (json) {
                query.sendReply(JSON.serializeToBytes(stats));
            } else {
                query.sendReply(buf);
            }
            return;
        }
        ArrayList<IncomingDataPoint> dps = new ArrayList<IncomingDataPoint>(64);
        SerializerCollector collector = new SerializerCollector("tsd", dps, canonical);
        ConnectionManager.collectStats(collector);
        RpcHandler.collectStats(collector);
        RpcManager.collectStats(collector);
        tsdb.collectStats(collector);
        query.sendReply(query.serializer().formatStatsV1(dps));
    }

    private void doCollectStats(TSDB tsdb, StatsCollector collector, boolean canonical) {
        collector.addHostTag(canonical);
        ConnectionManager.collectStats(collector);
        RpcHandler.collectStats(collector);
        RpcManager.collectStats(collector);
        this.collectThreadStats(collector);
        tsdb.collectStats(collector);
    }

    private void printRegionClientStats(TSDB tsdb, HttpQuery query) {
        List region_stats = tsdb.getClient().regionStats();
        ArrayList<Map<String, Object>> stats = new ArrayList<Map<String, Object>>(region_stats.size());
        for (RegionClientStats rcs : region_stats) {
            HashMap<String, Object> stat_map = new HashMap<String, Object>(8);
            stat_map.put("rpcsSent", rcs.rpcsSent());
            stat_map.put("rpcsInFlight", rcs.inflightRPCs());
            stat_map.put("pendingRPCs", rcs.pendingRPCs());
            stat_map.put("pendingBatchedRPCs", rcs.pendingBatchedRPCs());
            stat_map.put("dead", rcs.isDead());
            stat_map.put("rpcid", rcs.rpcID());
            stat_map.put("endpoint", rcs.remoteEndpoint());
            stat_map.put("rpcsTimedout", rcs.rpcsTimedout());
            stat_map.put("rpcResponsesTimedout", rcs.rpcResponsesTimedout());
            stat_map.put("rpcResponsesUnknown", rcs.rpcResponsesUnknown());
            stat_map.put("inflightBreached", rcs.inflightBreached());
            stat_map.put("pendingBreached", rcs.pendingBreached());
            stat_map.put("writesBlocked", rcs.writesBlocked());
            stats.add(stat_map);
        }
        query.sendReply(query.serializer().formatRegionStatsV1(stats));
    }

    private void printThreadStats(HttpQuery query) {
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        ArrayList<Map<String, Object>> output = new ArrayList<Map<String, Object>>(threads.size());
        for (Thread thread : threads) {
            HashMap<String, Object> status = new HashMap<String, Object>();
            status.put("threadID", thread.getId());
            status.put("name", thread.getName());
            status.put("state", thread.getState().toString());
            status.put("interrupted", thread.isInterrupted());
            status.put("priority", thread.getPriority());
            ArrayList<String> stack = new ArrayList<String>(thread.getStackTrace().length);
            for (StackTraceElement element : thread.getStackTrace()) {
                stack.add(element.toString());
            }
            status.put("stack", stack);
            output.add(status);
        }
        query.sendReply(query.serializer().formatThreadStatsV1(output));
    }

    private void printJVMStats(TSDB tsdb, HttpQuery query) {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        RuntimeMXBean runtime_bean = ManagementFactory.getRuntimeMXBean();
        HashMap<String, Object> runtime = new HashMap<String, Object>();
        map.put("runtime", runtime);
        runtime.put("startTime", runtime_bean.getStartTime());
        runtime.put("uptime", runtime_bean.getUptime());
        runtime.put("vmName", runtime_bean.getVmName());
        runtime.put("vmVendor", runtime_bean.getVmVendor());
        runtime.put("vmVersion", runtime_bean.getVmVersion());
        MemoryMXBean mem_bean = ManagementFactory.getMemoryMXBean();
        HashMap<String, Object> memory = new HashMap<String, Object>();
        map.put("memory", memory);
        memory.put("heapMemoryUsage", mem_bean.getHeapMemoryUsage());
        memory.put("nonHeapMemoryUsage", mem_bean.getNonHeapMemoryUsage());
        memory.put("objectsPendingFinalization", mem_bean.getObjectPendingFinalizationCount());
        List<GarbageCollectorMXBean> gc_beans = ManagementFactory.getGarbageCollectorMXBeans();
        HashMap<String, Object> gc = new HashMap<String, Object>();
        map.put("gc", gc);
        for (GarbageCollectorMXBean gc_bean : gc_beans) {
            HashMap stats = new HashMap();
            String name = StatsRpc.formatStatName(gc_bean.getName());
            if (name == null) {
                LOG.warn("Null name for bean: " + gc_bean);
                continue;
            }
            gc.put(name, stats);
            stats.put("collectionCount", gc_bean.getCollectionCount());
            stats.put("collectionTime", gc_bean.getCollectionTime());
        }
        List<MemoryPoolMXBean> pool_beans = ManagementFactory.getMemoryPoolMXBeans();
        HashMap pools = new HashMap();
        map.put("pools", pools);
        for (MemoryPoolMXBean pool_bean : pool_beans) {
            HashMap<String, Object> stats = new HashMap<String, Object>();
            String name = StatsRpc.formatStatName(pool_bean.getName());
            if (name == null) {
                LOG.warn("Null name for bean: " + pool_bean);
                continue;
            }
            pools.put(name, stats);
            stats.put("collectionUsage", pool_bean.getCollectionUsage());
            stats.put("usage", pool_bean.getUsage());
            stats.put("peakUsage", pool_bean.getPeakUsage());
            stats.put("type", (Object)pool_bean.getType());
        }
        OperatingSystemMXBean os_bean = ManagementFactory.getOperatingSystemMXBean();
        HashMap<String, Double> os = new HashMap<String, Double>();
        map.put("os", os);
        os.put("systemLoadAverage", os_bean.getSystemLoadAverage());
        query.sendReply(query.serializer().formatJVMStatsV1(map));
    }

    private void collectThreadStats(StatsCollector collector) {
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        HashMap<String, Integer> states = new HashMap<String, Integer>(6);
        states.put("new", 0);
        states.put("runnable", 0);
        states.put("blocked", 0);
        states.put("waiting", 0);
        states.put("timed_waiting", 0);
        states.put("terminated", 0);
        for (Thread thread : threads) {
            int state_count = (Integer)states.get(thread.getState().toString().toLowerCase());
            states.put(thread.getState().toString().toLowerCase(), ++state_count);
        }
        for (Map.Entry entry : states.entrySet()) {
            collector.record("jvm.thread.states", (Number)entry.getValue(), "state=" + (String)entry.getKey());
        }
        collector.record("jvm.thread.count", threads.size());
    }

    private static String formatStatName(String stat) {
        if (stat == null || stat.isEmpty()) {
            return stat;
        }
        String name = stat.replace(" ", "");
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    private void printQueryStats(HttpQuery query) {
        switch (query.apiVersion()) {
            case 0: 
            case 1: {
                query.sendReply(query.serializer().formatQueryStatsV1(QueryStats.getRunningAndCompleteStats()));
                break;
            }
            default: {
                throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "Requested API version not implemented", "Version " + query.apiVersion() + " is not implemented");
            }
        }
    }

    final class SerializerCollector
    extends StatsCollector {
        final boolean canonical;
        final List<IncomingDataPoint> dps;

        public SerializerCollector(String prefix, List<IncomingDataPoint> dps, boolean canonical) {
            super(prefix);
            this.dps = dps;
            this.canonical = canonical;
        }

        @Override
        public void record(String name, long value, String xtratag) {
            IncomingDataPoint dp = new IncomingDataPoint();
            dp.setMetric(this.prefix + "." + name);
            dp.setTimestamp(System.currentTimeMillis() / 1000L);
            dp.setValue(Long.toString(value));
            String tagk = "";
            if (xtratag != null) {
                if (xtratag.indexOf(61) != xtratag.lastIndexOf(61)) {
                    throw new IllegalArgumentException("invalid xtratag: " + xtratag + " (multiple '=' signs), name=" + name + ", value=" + value);
                }
                if (xtratag.indexOf(61) < 0) {
                    throw new IllegalArgumentException("invalid xtratag: " + xtratag + " (missing '=' signs), name=" + name + ", value=" + value);
                }
                String[] pair = xtratag.split("=");
                tagk = pair[0];
                this.addExtraTag(tagk, pair[1]);
            }
            this.addHostTag(this.canonical);
            HashMap<String, String> tags = new HashMap<String, String>(this.extratags);
            dp.setTags(tags);
            this.dps.add(dp);
            if (!tagk.isEmpty()) {
                this.clearExtraTag(tagk);
            }
        }
    }

    final class ASCIICollector
    extends StatsCollector {
        final StringBuilder buf;
        final ArrayList<String> stats;

        public ASCIICollector(String prefix, StringBuilder buf, ArrayList<String> stats) {
            super(prefix);
            this.buf = buf;
            this.stats = stats;
        }

        @Override
        public final void emit(String line) {
            if (this.stats != null) {
                this.stats.add(line.substring(0, line.length() - 1));
            } else {
                this.buf.append(line);
            }
        }
    }
}

