/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tsd;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import net.opentsdb.core.TSDB;
import net.opentsdb.tsd.BadRequestException;
import net.opentsdb.tsd.HttpQuery;
import net.opentsdb.tsd.HttpRpc;
import net.opentsdb.utils.JSON;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

final class SuggestRpc
implements HttpRpc {
    SuggestRpc() {
    }

    @Override
    public void execute(TSDB tsdb, HttpQuery query) throws IOException {
        List<String> suggestions;
        int max_results;
        String max;
        String q;
        String type;
        if (query.method() != HttpMethod.GET && query.method() != HttpMethod.POST) {
            throw new BadRequestException(HttpResponseStatus.METHOD_NOT_ALLOWED, "Method not allowed", "The HTTP method [" + query.method().getName() + "] is not permitted for this endpoint");
        }
        if (query.apiVersion() > 0 && query.method() == HttpMethod.POST) {
            HashMap<String, String> map = query.serializer().parseSuggestV1();
            type = map.get("type");
            if (type == null || type.isEmpty()) {
                throw new BadRequestException("Missing 'type' parameter");
            }
            q = map.get("q") == null ? "" : map.get("q");
            max = map.get("max");
        } else {
            type = query.getRequiredQueryStringParam("type");
            q = query.hasQueryStringParam("q") ? query.getQueryStringParam("q") : "";
            max = query.getQueryStringParam("max");
        }
        if (max != null && !max.isEmpty()) {
            try {
                max_results = Integer.parseInt(max);
            }
            catch (NumberFormatException nfe) {
                throw new BadRequestException("Unable to parse 'max' as a number");
            }
        } else {
            max_results = 0;
        }
        if ("metrics".equals(type)) {
            suggestions = max_results > 0 ? tsdb.suggestMetrics(q, max_results) : tsdb.suggestMetrics(q);
        } else if ("tagk".equals(type)) {
            suggestions = max_results > 0 ? tsdb.suggestTagNames(q, max_results) : tsdb.suggestTagNames(q);
        } else if ("tagv".equals(type)) {
            suggestions = max_results > 0 ? tsdb.suggestTagValues(q, max_results) : tsdb.suggestTagValues(q);
        } else {
            throw new BadRequestException("Invalid 'type' parameter:" + type);
        }
        if (query.apiVersion() > 0) {
            query.sendReply(query.serializer().formatSuggestV1(suggestions));
        } else {
            query.sendReply(JSON.serializeToBytes(suggestions));
        }
    }
}

