/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tsd;

import com.fasterxml.jackson.core.type.TypeReference;
import com.stumbleupon.async.DeferredGroupException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import net.opentsdb.core.TSDB;
import net.opentsdb.meta.TSMeta;
import net.opentsdb.tree.Branch;
import net.opentsdb.tree.Tree;
import net.opentsdb.tree.TreeBuilder;
import net.opentsdb.tree.TreeRule;
import net.opentsdb.tsd.BadRequestException;
import net.opentsdb.tsd.HttpQuery;
import net.opentsdb.tsd.HttpRpc;
import net.opentsdb.uid.NoSuchUniqueId;
import net.opentsdb.utils.JSON;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

final class TreeRpc
implements HttpRpc {
    private static TypeReference<HashMap<String, String>> TR_HASH_MAP = new TypeReference<HashMap<String, String>>(){};

    TreeRpc() {
    }

    @Override
    public void execute(TSDB tsdb, HttpQuery query) throws IOException {
        block10: {
            String[] uri = query.explodeAPIPath();
            String endpoint = uri.length > 1 ? uri[1] : "";
            try {
                if (endpoint.isEmpty()) {
                    this.handleTree(tsdb, query);
                    break block10;
                }
                if (endpoint.toLowerCase().equals("branch")) {
                    this.handleBranch(tsdb, query);
                    break block10;
                }
                if (endpoint.toLowerCase().equals("rule")) {
                    this.handleRule(tsdb, query);
                    break block10;
                }
                if (endpoint.toLowerCase().equals("rules")) {
                    this.handleRules(tsdb, query);
                    break block10;
                }
                if (endpoint.toLowerCase().equals("test")) {
                    this.handleTest(tsdb, query);
                    break block10;
                }
                if (endpoint.toLowerCase().equals("collisions")) {
                    this.handleCollisionNotMatched(tsdb, query, true);
                    break block10;
                }
                if (endpoint.toLowerCase().equals("notmatched")) {
                    this.handleCollisionNotMatched(tsdb, query, false);
                    break block10;
                }
                throw new BadRequestException(HttpResponseStatus.NOT_FOUND, "This endpoint is not supported");
            }
            catch (BadRequestException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void handleTree(TSDB tsdb, HttpQuery query) {
        block20: {
            Tree tree = query.hasContent() ? query.serializer().parseTreeV1() : this.parseTree(query);
            try {
                if (query.getAPIMethod() == HttpMethod.GET) {
                    if (tree.getTreeId() == 0) {
                        query.sendReply(query.serializer().formatTreesV1((List)Tree.fetchAllTrees(tsdb).joinUninterruptibly()));
                    } else {
                        Tree single_tree = (Tree)Tree.fetchTree(tsdb, tree.getTreeId()).joinUninterruptibly();
                        if (single_tree == null) {
                            throw new BadRequestException(HttpResponseStatus.NOT_FOUND, "Unable to locate tree: " + tree.getTreeId());
                        }
                        query.sendReply(query.serializer().formatTreeV1(single_tree));
                    }
                    break block20;
                }
                if (query.getAPIMethod() == HttpMethod.POST || query.getAPIMethod() == HttpMethod.PUT) {
                    if (tree.getTreeId() > 0) {
                        if (Tree.fetchTree(tsdb, tree.getTreeId()).joinUninterruptibly() == null) {
                            throw new BadRequestException(HttpResponseStatus.NOT_FOUND, "Unable to locate tree: " + tree.getTreeId());
                        }
                        if (tree.storeTree(tsdb, query.getAPIMethod() == HttpMethod.PUT).joinUninterruptibly() != null) {
                            Tree stored_tree = (Tree)Tree.fetchTree(tsdb, tree.getTreeId()).joinUninterruptibly();
                            query.sendReply(query.serializer().formatTreeV1(stored_tree));
                            break block20;
                        }
                        throw new BadRequestException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Unable to save changes to tre tree: " + tree.getTreeId(), "Plesae try again at a later time");
                    }
                    int tree_id = (Integer)tree.createNewTree(tsdb).joinUninterruptibly();
                    if (tree_id > 0) {
                        Tree stored_tree = (Tree)Tree.fetchTree(tsdb, tree_id).joinUninterruptibly();
                        query.sendReply(query.serializer().formatTreeV1(stored_tree));
                        break block20;
                    }
                    throw new BadRequestException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Unable to save changes to tree: " + tree.getTreeId(), "Plesae try again at a later time");
                }
                if (query.getAPIMethod() == HttpMethod.DELETE) {
                    boolean delete_definition = false;
                    if (query.hasContent()) {
                        String json = query.getContent();
                        HashMap<String, String> properties = JSON.parseToObject(json, TR_HASH_MAP);
                        String delete_all = properties.get("definition");
                        if (delete_all != null && delete_all.toLowerCase().equals("true")) {
                            delete_definition = true;
                        }
                    } else {
                        String delete_all = query.getQueryStringParam("definition");
                        if (delete_all != null && delete_all.toLowerCase().equals("true")) {
                            delete_definition = true;
                        }
                    }
                    if (Tree.fetchTree(tsdb, tree.getTreeId()).joinUninterruptibly() == null) {
                        throw new BadRequestException(HttpResponseStatus.NOT_FOUND, "Unable to locate tree: " + tree.getTreeId());
                    }
                    Tree.deleteTree(tsdb, tree.getTreeId(), delete_definition).joinUninterruptibly();
                    query.sendStatusOnly(HttpResponseStatus.NO_CONTENT);
                    break block20;
                }
                throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Unsupported HTTP request method");
            }
            catch (BadRequestException e) {
                throw e;
            }
            catch (IllegalStateException e) {
                query.sendStatusOnly(HttpResponseStatus.NOT_MODIFIED);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void handleBranch(TSDB tsdb, HttpQuery query) {
        if (query.getAPIMethod() != HttpMethod.GET) {
            throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Unsupported HTTP request method");
        }
        try {
            byte[] branch_id;
            int tree_id = this.parseTreeId(query, false);
            String branch_hex = query.getQueryStringParam("branch");
            if (branch_hex == null || branch_hex.isEmpty()) {
                if (tree_id < 1) {
                    throw new BadRequestException("Missing or invalid branch and tree IDs");
                }
                branch_id = Tree.idToBytes(tree_id);
            } else {
                branch_id = Branch.stringToId(branch_hex);
            }
            Branch branch = (Branch)Branch.fetchBranch(tsdb, branch_id, true).joinUninterruptibly();
            if (branch == null) {
                throw new BadRequestException(HttpResponseStatus.NOT_FOUND, "Unable to locate branch '" + Branch.idToString(branch_id) + "' for tree '" + Tree.bytesToId(branch_id) + "'");
            }
            query.sendReply(query.serializer().formatBranchV1(branch));
        }
        catch (BadRequestException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void handleRule(TSDB tsdb, HttpQuery query) {
        block12: {
            TreeRule rule = query.hasContent() ? query.serializer().parseTreeRuleV1() : this.parseRule(query);
            try {
                Tree tree = null;
                tree = (Tree)Tree.fetchTree(tsdb, rule.getTreeId()).joinUninterruptibly();
                if (tree == null) {
                    throw new BadRequestException(HttpResponseStatus.NOT_FOUND, "Unable to locate tree: " + rule.getTreeId());
                }
                if (query.getAPIMethod() == HttpMethod.GET) {
                    TreeRule tree_rule = tree.getRule(rule.getLevel(), rule.getOrder());
                    if (tree_rule == null) {
                        throw new BadRequestException(HttpResponseStatus.NOT_FOUND, "Unable to locate rule: " + rule);
                    }
                    query.sendReply(query.serializer().formatTreeRuleV1(tree_rule));
                    break block12;
                }
                if (query.getAPIMethod() == HttpMethod.POST || query.getAPIMethod() == HttpMethod.PUT) {
                    if (((Boolean)rule.syncToStorage(tsdb, query.getAPIMethod() == HttpMethod.PUT).joinUninterruptibly()).booleanValue()) {
                        TreeRule stored_rule = (TreeRule)TreeRule.fetchRule(tsdb, rule.getTreeId(), rule.getLevel(), rule.getOrder()).joinUninterruptibly();
                        query.sendReply(query.serializer().formatTreeRuleV1(stored_rule));
                        break block12;
                    }
                    throw new RuntimeException("Unable to save rule " + rule + " to storage");
                }
                if (query.getAPIMethod() == HttpMethod.DELETE) {
                    if (tree.getRule(rule.getLevel(), rule.getOrder()) == null) {
                        throw new BadRequestException(HttpResponseStatus.NOT_FOUND, "Unable to locate rule: " + rule);
                    }
                    TreeRule.deleteRule(tsdb, tree.getTreeId(), rule.getLevel(), rule.getOrder()).joinUninterruptibly();
                    query.sendStatusOnly(HttpResponseStatus.NO_CONTENT);
                    break block12;
                }
                throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Unsupported HTTP request method");
            }
            catch (BadRequestException e) {
                throw e;
            }
            catch (IllegalStateException e) {
                query.sendStatusOnly(HttpResponseStatus.NOT_MODIFIED);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void handleRules(TSDB tsdb, HttpQuery query) {
        block14: {
            int tree_id = 0;
            List<TreeRule> rules = null;
            if (query.hasContent()) {
                rules = query.serializer().parseTreeRulesV1();
                if (rules == null || rules.isEmpty()) {
                    throw new BadRequestException("Missing tree rules");
                }
                tree_id = rules.get(0).getTreeId();
                for (TreeRule rule : rules) {
                    if (rule.getTreeId() == tree_id) continue;
                    throw new BadRequestException("All rules must belong to the same tree");
                }
            } else {
                tree_id = this.parseTreeId(query, false);
            }
            try {
                if (Tree.fetchTree(tsdb, tree_id).joinUninterruptibly() == null) {
                    throw new BadRequestException(HttpResponseStatus.NOT_FOUND, "Unable to locate tree: " + tree_id);
                }
                if (query.getAPIMethod() == HttpMethod.POST || query.getAPIMethod() == HttpMethod.PUT) {
                    if ((rules == null || rules.isEmpty()) && (rules == null || rules.isEmpty())) {
                        throw new BadRequestException("Missing tree rules");
                    }
                    if (query.getAPIMethod() == HttpMethod.PUT) {
                        TreeRule.deleteAllRules(tsdb, tree_id).joinUninterruptibly();
                    }
                    for (TreeRule rule : rules) {
                        rule.syncToStorage(tsdb, query.getAPIMethod() == HttpMethod.PUT).joinUninterruptibly();
                    }
                    query.sendStatusOnly(HttpResponseStatus.NO_CONTENT);
                    break block14;
                }
                if (query.getAPIMethod() == HttpMethod.DELETE) {
                    TreeRule.deleteAllRules(tsdb, tree_id).joinUninterruptibly();
                    query.sendStatusOnly(HttpResponseStatus.NO_CONTENT);
                    break block14;
                }
                throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Unsupported HTTP request method");
            }
            catch (BadRequestException e) {
                throw e;
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void handleTest(TSDB tsdb, HttpQuery query) {
        Map<String, Object> map = query.hasContent() ? query.serializer().parseTreeTSUIDsListV1() : this.parseTSUIDsList(query);
        Integer tree_id = (Integer)map.get("treeId");
        if (tree_id == null) {
            throw new BadRequestException("Missing or invalid Tree ID");
        }
        Tree tree = null;
        try {
            HashMap<String, HashMap<String, Object>> results;
            tree = (Tree)Tree.fetchTree(tsdb, tree_id).joinUninterruptibly();
            if (tree == null) {
                throw new BadRequestException(HttpResponseStatus.NOT_FOUND, "Unable to locate tree: " + tree_id);
            }
            List tsuids = (List)map.get("tsuids");
            if (tsuids == null || tsuids.isEmpty()) {
                throw new BadRequestException("Missing or empty TSUID list");
            }
            if (query.getAPIMethod() == HttpMethod.GET || query.getAPIMethod() == HttpMethod.POST || query.getAPIMethod() == HttpMethod.PUT) {
                results = new HashMap<String, HashMap<String, Object>>(tsuids.size());
                TreeBuilder builder = new TreeBuilder(tsdb, tree);
                for (String tsuid : tsuids) {
                    HashMap<String, Object> tsuid_results = new HashMap<String, Object>();
                    try {
                        TSMeta meta = (TSMeta)TSMeta.getTSMeta(tsdb, tsuid).joinUninterruptibly();
                        if (meta == null) {
                            tsuid_results.put("branch", null);
                            tsuid_results.put("meta", null);
                            ArrayList<String> messages = new ArrayList<String>(1);
                            messages.add("Unable to locate TSUID meta data");
                            tsuid_results.put("messages", messages);
                            results.put(tsuid, tsuid_results);
                            continue;
                        }
                        builder.processTimeseriesMeta(meta, true).joinUninterruptibly();
                        tsuid_results.put("branch", builder.getRootBranch());
                        tsuid_results.put("meta", meta);
                        tsuid_results.put("messages", builder.getTestMessage());
                        results.put(tsuid, tsuid_results);
                    }
                    catch (DeferredGroupException e) {
                        Throwable ex = e;
                        while (ex.getClass().equals(DeferredGroupException.class)) {
                            ex = ex.getCause();
                        }
                        if (!ex.getClass().equals(NoSuchUniqueId.class)) continue;
                        tsuid_results.put("branch", null);
                        tsuid_results.put("meta", null);
                        ArrayList<String> messages = new ArrayList<String>(1);
                        messages.add("TSUID was missing a UID name: " + ex.getMessage());
                        tsuid_results.put("messages", messages);
                        results.put(tsuid, tsuid_results);
                    }
                }
            } else {
                throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Unsupported HTTP request method");
            }
            query.sendReply(query.serializer().formatTreeTestV1(results));
        }
        catch (BadRequestException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void handleCollisionNotMatched(TSDB tsdb, HttpQuery query, boolean for_collisions) {
        Map<String, Object> map = query.hasContent() ? query.serializer().parseTreeTSUIDsListV1() : this.parseTSUIDsList(query);
        Integer tree_id = (Integer)map.get("treeId");
        if (tree_id == null) {
            throw new BadRequestException("Missing or invalid Tree ID");
        }
        try {
            if (Tree.fetchTree(tsdb, tree_id).joinUninterruptibly() == null) {
                throw new BadRequestException(HttpResponseStatus.NOT_FOUND, "Unable to locate tree: " + tree_id);
            }
            if (query.getAPIMethod() != HttpMethod.GET && query.getAPIMethod() != HttpMethod.POST && query.getAPIMethod() != HttpMethod.PUT) {
                throw new BadRequestException(HttpResponseStatus.BAD_REQUEST, "Unsupported HTTP request method");
            }
            List tsuids = (List)map.get("tsuids");
            Map results = for_collisions ? (Map)Tree.fetchCollisions(tsdb, tree_id, tsuids).joinUninterruptibly() : (Map)Tree.fetchNotMatched(tsdb, tree_id, tsuids).joinUninterruptibly();
            query.sendReply(query.serializer().formatTreeCollisionNotMatchedV1(results, for_collisions));
        }
        catch (ClassCastException e) {
            throw new BadRequestException("Unable to convert the given data to a list", e);
        }
        catch (BadRequestException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Tree parseTree(HttpQuery query) {
        Tree tree = new Tree(this.parseTreeId(query, false));
        if (query.hasQueryStringParam("name")) {
            tree.setName(query.getQueryStringParam("name"));
        }
        if (query.hasQueryStringParam("description")) {
            tree.setDescription(query.getQueryStringParam("description"));
        }
        if (query.hasQueryStringParam("notes")) {
            tree.setNotes(query.getQueryStringParam("notes"));
        }
        if (query.hasQueryStringParam("strict_match")) {
            if (query.getQueryStringParam("strict_match").toLowerCase().equals("true")) {
                tree.setStrictMatch(true);
            } else {
                tree.setStrictMatch(false);
            }
        }
        if (query.hasQueryStringParam("enabled")) {
            String enabled = query.getQueryStringParam("enabled");
            if (enabled.toLowerCase().equals("true")) {
                tree.setEnabled(true);
            } else {
                tree.setEnabled(false);
            }
        }
        if (query.hasQueryStringParam("store_failures")) {
            if (query.getQueryStringParam("store_failures").toLowerCase().equals("true")) {
                tree.setStoreFailures(true);
            } else {
                tree.setStoreFailures(false);
            }
        }
        return tree;
    }

    private TreeRule parseRule(HttpQuery query) {
        TreeRule rule = new TreeRule(this.parseTreeId(query, true));
        if (query.hasQueryStringParam("type")) {
            try {
                rule.setType(TreeRule.stringToType(query.getQueryStringParam("type")));
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Unable to parse the 'type' parameter", e);
            }
        }
        if (query.hasQueryStringParam("field")) {
            rule.setField(query.getQueryStringParam("field"));
        }
        if (query.hasQueryStringParam("custom_field")) {
            rule.setCustomField(query.getQueryStringParam("custom_field"));
        }
        if (query.hasQueryStringParam("regex")) {
            try {
                rule.setRegex(query.getQueryStringParam("regex"));
            }
            catch (PatternSyntaxException e) {
                throw new BadRequestException("Unable to parse the 'regex' parameter", e);
            }
        }
        if (query.hasQueryStringParam("separator")) {
            rule.setSeparator(query.getQueryStringParam("separator"));
        }
        if (query.hasQueryStringParam("description")) {
            rule.setDescription(query.getQueryStringParam("description"));
        }
        if (query.hasQueryStringParam("notes")) {
            rule.setNotes(query.getQueryStringParam("notes"));
        }
        if (query.hasQueryStringParam("regex_group_idx")) {
            try {
                rule.setRegexGroupIdx(Integer.parseInt(query.getQueryStringParam("regex_group_idx")));
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("Unable to parse the 'regex_group_idx' parameter", e);
            }
        }
        if (query.hasQueryStringParam("display_format")) {
            rule.setDisplayFormat(query.getQueryStringParam("display_format"));
        }
        try {
            rule.setLevel(Integer.parseInt(query.getRequiredQueryStringParam("level")));
        }
        catch (NumberFormatException e) {
            throw new BadRequestException("Unable to parse the 'level' parameter", e);
        }
        try {
            rule.setOrder(Integer.parseInt(query.getRequiredQueryStringParam("order")));
        }
        catch (NumberFormatException e) {
            throw new BadRequestException("Unable to parse the 'order' parameter", e);
        }
        return rule;
    }

    private int parseTreeId(HttpQuery query, boolean required) {
        try {
            if (required) {
                return Integer.parseInt(query.getRequiredQueryStringParam("treeid"));
            }
            if (query.hasQueryStringParam("treeid")) {
                return Integer.parseInt(query.getQueryStringParam("treeid"));
            }
            return 0;
        }
        catch (NumberFormatException nfe) {
            throw new BadRequestException("Unable to parse 'tree' value", nfe);
        }
    }

    private Map<String, Object> parseTSUIDsList(HttpQuery query) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("treeId", this.parseTreeId(query, true));
        String tsquery = query.getQueryStringParam("tsuids");
        if (tsquery != null) {
            String[] tsuids = tsquery.split(",");
            map.put("tsuids", Arrays.asList(tsuids));
        }
        return map;
    }
}

