/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.tsd;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.Tags;
import net.opentsdb.meta.TSMeta;
import net.opentsdb.meta.TSUIDQuery;
import net.opentsdb.meta.UIDMeta;
import net.opentsdb.tsd.BadRequestException;
import net.opentsdb.tsd.HttpQuery;
import net.opentsdb.tsd.HttpRpc;
import net.opentsdb.uid.NoSuchUniqueId;
import net.opentsdb.uid.NoSuchUniqueName;
import net.opentsdb.uid.UniqueId;
import org.hbase.async.Bytes;
import org.hbase.async.PutRequest;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

final class UniqueIdRpc
implements HttpRpc {
    UniqueIdRpc() {
    }

    @Override
    public void execute(TSDB tsdb, HttpQuery query) throws IOException {
        String endpoint;
        String[] uri = query.explodeAPIPath();
        String string = endpoint = uri.length > 1 ? uri[1] : "";
        if (endpoint.toLowerCase().equals("assign")) {
            this.handleAssign(tsdb, query);
            return;
        }
        if (endpoint.toLowerCase().equals("uidmeta")) {
            this.handleUIDMeta(tsdb, query);
            return;
        }
        if (endpoint.toLowerCase().equals("tsmeta")) {
            this.handleTSMeta(tsdb, query);
            return;
        }
        if (endpoint.toLowerCase().equals("rename")) {
            this.handleRename(tsdb, query);
            return;
        }
        throw new BadRequestException(HttpResponseStatus.NOT_IMPLEMENTED, "Other UID endpoints have not been implemented yet");
    }

    private void handleAssign(TSDB tsdb, HttpQuery query) {
        HashMap<String, List<String>> source;
        if (query.method() != HttpMethod.GET && query.method() != HttpMethod.POST) {
            throw new BadRequestException(HttpResponseStatus.METHOD_NOT_ALLOWED, "Method not allowed", "The HTTP method [" + query.method().getName() + "] is not permitted for this endpoint");
        }
        if (query.method() == HttpMethod.POST) {
            source = query.serializer().parseUidAssignV1();
        } else {
            source = new HashMap(3);
            String[] types = new String[]{"metric", "tagk", "tagv"};
            for (int i = 0; i < types.length; ++i) {
                String[] metrics;
                String values = query.getQueryStringParam(types[i]);
                if (values == null || values.isEmpty() || (metrics = values.split(",")) == null || metrics.length <= 0) continue;
                source.put(types[i], Arrays.asList(metrics));
            }
        }
        if (source.size() < 1) {
            throw new BadRequestException("Missing values to assign UIDs");
        }
        HashMap<String, TreeMap<String, String>> response = new HashMap<String, TreeMap<String, String>>();
        int error_count = 0;
        for (Map.Entry<String, List<String>> entry : source.entrySet()) {
            TreeMap<String, String> results = new TreeMap<String, String>();
            TreeMap<String, String> errors = new TreeMap<String, String>();
            for (String name : entry.getValue()) {
                try {
                    byte[] uid = tsdb.assignUid(entry.getKey(), name);
                    results.put(name, UniqueId.uidToString(uid));
                }
                catch (IllegalArgumentException e) {
                    errors.put(name, e.getMessage());
                    ++error_count;
                }
            }
            response.put(entry.getKey(), results);
            if (errors.size() <= 0) continue;
            response.put(entry.getKey() + "_errors", errors);
        }
        if (error_count < 1) {
            query.sendReply(query.serializer().formatUidAssignV1(response));
        } else {
            query.sendReply(HttpResponseStatus.BAD_REQUEST, query.serializer().formatUidAssignV1(response));
        }
    }

    private void handleUIDMeta(final TSDB tsdb, HttpQuery query) {
        HttpMethod method = query.getAPIMethod();
        if (method == HttpMethod.GET) {
            String uid = query.getRequiredQueryStringParam("uid");
            UniqueId.UniqueIdType type = UniqueId.stringToUniqueIdType(query.getRequiredQueryStringParam("type"));
            try {
                UIDMeta meta = (UIDMeta)UIDMeta.getUIDMeta(tsdb, type, uid).joinUninterruptibly();
                query.sendReply(query.serializer().formatUidMetaV1(meta));
            }
            catch (NoSuchUniqueId e) {
                throw new BadRequestException(HttpResponseStatus.NOT_FOUND, "Could not find the requested UID", e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (method == HttpMethod.POST || method == HttpMethod.PUT) {
            final UIDMeta meta = query.hasContent() ? query.serializer().parseUidMetaV1() : this.parseUIDMetaQS(query);
            try {
                class SyncCB
                implements Callback<Deferred<UIDMeta>, Boolean> {
                    SyncCB() {
                    }

                    public Deferred<UIDMeta> call(Boolean success) throws Exception {
                        if (!success.booleanValue()) {
                            throw new BadRequestException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Failed to save the UIDMeta to storage", "This may be caused by another process modifying storage data");
                        }
                        return UIDMeta.getUIDMeta(tsdb, meta.getType(), meta.getUID());
                    }
                }
                Deferred process_meta = meta.syncToStorage(tsdb, method == HttpMethod.PUT).addCallbackDeferring((Callback)new SyncCB());
                UIDMeta updated_meta = (UIDMeta)process_meta.joinUninterruptibly();
                tsdb.indexUIDMeta(updated_meta);
                query.sendReply(query.serializer().formatUidMetaV1(updated_meta));
            }
            catch (IllegalStateException e) {
                query.sendStatusOnly(HttpResponseStatus.NOT_MODIFIED);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(e);
            }
            catch (NoSuchUniqueId e) {
                throw new BadRequestException(HttpResponseStatus.NOT_FOUND, "Could not find the requested UID", e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (method == HttpMethod.DELETE) {
            UIDMeta meta = query.hasContent() ? query.serializer().parseUidMetaV1() : this.parseUIDMetaQS(query);
            try {
                meta.delete(tsdb).joinUninterruptibly();
                tsdb.deleteUIDMeta(meta);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Unable to delete UIDMeta information", e);
            }
            catch (NoSuchUniqueId e) {
                throw new BadRequestException(HttpResponseStatus.NOT_FOUND, "Could not find the requested UID", e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            query.sendStatusOnly(HttpResponseStatus.NO_CONTENT);
        } else {
            throw new BadRequestException(HttpResponseStatus.METHOD_NOT_ALLOWED, "Method not allowed", "The HTTP method [" + method.getName() + "] is not permitted for this endpoint");
        }
    }

    private void handleTSMeta(final TSDB tsdb, HttpQuery query) {
        HttpMethod method = query.getAPIMethod();
        if (method == HttpMethod.GET) {
            String tsuid = null;
            if (query.hasQueryStringParam("tsuid")) {
                tsuid = query.getQueryStringParam("tsuid");
                try {
                    TSMeta meta = (TSMeta)TSMeta.getTSMeta(tsdb, tsuid).joinUninterruptibly();
                    if (meta == null) {
                        throw new BadRequestException(HttpResponseStatus.NOT_FOUND, "Could not find Timeseries meta data");
                    }
                    query.sendReply(query.serializer().formatTSMetaV1(meta));
                }
                catch (NoSuchUniqueName e) {
                    throw new BadRequestException(HttpResponseStatus.NOT_FOUND, "Unable to find one of the UIDs", e);
                }
                catch (BadRequestException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            String mquery = query.getRequiredQueryStringParam("m");
            HashMap<String, String> tags = new HashMap<String, String>();
            String metric = null;
            try {
                metric = Tags.parseWithMetric(mquery, tags);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(e);
            }
            TSUIDQuery tsuid_query = new TSUIDQuery(tsdb, metric, tags);
            try {
                List tsmetas = (List)tsuid_query.getTSMetas().joinUninterruptibly();
                query.sendReply(query.serializer().formatTSMetaListV1(tsmetas));
            }
            catch (NoSuchUniqueName e) {
                throw new BadRequestException(HttpResponseStatus.NOT_FOUND, "Unable to find one of the UIDs", e);
            }
            catch (BadRequestException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new BadRequestException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (method == HttpMethod.POST || method == HttpMethod.PUT) {
            class SyncCB
            implements Callback<Deferred<TSMeta>, Boolean> {
                SyncCB() {
                }

                public Deferred<TSMeta> call(Boolean success) throws Exception {
                    if (!success.booleanValue()) {
                        throw new BadRequestException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Failed to save the TSMeta to storage", "This may be caused by another process modifying storage data");
                    }
                    return TSMeta.getTSMeta(tsdb, meta.getTSUID());
                }
            }
            final TSMeta meta = query.hasContent() ? query.serializer().parseTSMetaV1() : this.parseTSMetaQS(query);
            if (meta.getTSUID() == null || meta.getTSUID().isEmpty()) {
                String metric = query.getRequiredQueryStringParam("m");
                final boolean create = query.getQueryStringParam("create") != null && query.getQueryStringParam("create").equals("true");
                final String tsuid = this.getTSUIDForMetric(metric, tsdb);
                try {
                    boolean exists = (Boolean)TSMeta.metaExistsInStorage(tsdb, tsuid).joinUninterruptibly();
                    meta.setTSUID(tsuid);
                    if (!exists && create) {
                        class WriteCounterIfNotPresentCB
                        implements Callback<Boolean, Boolean> {
                            WriteCounterIfNotPresentCB() {
                            }

                            public Boolean call(Boolean exists) throws Exception {
                                if (!exists.booleanValue() && create) {
                                    PutRequest put = new PutRequest(tsdb.metaTable(), UniqueId.stringToUid(tsuid), TSMeta.FAMILY(), TSMeta.COUNTER_QUALIFIER(), Bytes.fromLong((long)0L));
                                    tsdb.getClient().put(put);
                                }
                                return exists;
                            }
                        }
                        TSMeta.counterExistsInStorage(tsdb, UniqueId.stringToUid(tsuid)).addCallback((Callback)new WriteCounterIfNotPresentCB()).joinUninterruptibly();
                        Deferred process_meta = meta.storeNew(tsdb).addCallbackDeferring((Callback)new SyncCB());
                        TSMeta updated_meta = (TSMeta)process_meta.joinUninterruptibly();
                        tsdb.indexTSMeta(updated_meta);
                        tsdb.processTSMetaThroughTrees(updated_meta);
                        query.sendReply(query.serializer().formatTSMetaV1(updated_meta));
                    }
                    if (exists) {
                        Deferred process_meta = meta.syncToStorage(tsdb, method == HttpMethod.PUT).addCallbackDeferring((Callback)new SyncCB());
                        TSMeta updated_meta = (TSMeta)process_meta.joinUninterruptibly();
                        tsdb.indexTSMeta(updated_meta);
                        query.sendReply(query.serializer().formatTSMetaV1(updated_meta));
                    }
                    throw new BadRequestException("Could not find TSMeta, specify \"create=true\" to create a new one.");
                }
                catch (IllegalStateException e) {
                    query.sendStatusOnly(HttpResponseStatus.NOT_MODIFIED);
                }
                catch (IllegalArgumentException e) {
                    throw new BadRequestException(e);
                }
                catch (BadRequestException e) {
                    throw e;
                }
                catch (NoSuchUniqueName e) {
                    throw new BadRequestException(HttpResponseStatus.NOT_FOUND, "Unable to find one or more UIDs", e);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                try {
                    Deferred process_meta = meta.syncToStorage(tsdb, method == HttpMethod.PUT).addCallbackDeferring((Callback)new SyncCB());
                    TSMeta updated_meta = (TSMeta)process_meta.joinUninterruptibly();
                    tsdb.indexTSMeta(updated_meta);
                    query.sendReply(query.serializer().formatTSMetaV1(updated_meta));
                }
                catch (IllegalStateException e) {
                    query.sendStatusOnly(HttpResponseStatus.NOT_MODIFIED);
                }
                catch (IllegalArgumentException e) {
                    throw new BadRequestException(e);
                }
                catch (NoSuchUniqueName e) {
                    throw new BadRequestException(HttpResponseStatus.NOT_FOUND, "Unable to find one or more UIDs", e);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (method == HttpMethod.DELETE) {
            TSMeta meta = query.hasContent() ? query.serializer().parseTSMetaV1() : this.parseTSMetaQS(query);
            try {
                meta.delete(tsdb);
                tsdb.deleteTSMeta(meta.getTSUID());
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Unable to delete TSMeta information", e);
            }
            query.sendStatusOnly(HttpResponseStatus.NO_CONTENT);
        } else {
            throw new BadRequestException(HttpResponseStatus.METHOD_NOT_ALLOWED, "Method not allowed", "The HTTP method [" + method.getName() + "] is not permitted for this endpoint");
        }
    }

    private UIDMeta parseUIDMetaQS(HttpQuery query) {
        String notes;
        String description;
        String uid = query.getRequiredQueryStringParam("uid");
        String type = query.getRequiredQueryStringParam("type");
        UIDMeta meta = new UIDMeta(UniqueId.stringToUniqueIdType(type), uid);
        String display_name = query.getQueryStringParam("display_name");
        if (display_name != null) {
            meta.setDisplayName(display_name);
        }
        if ((description = query.getQueryStringParam("description")) != null) {
            meta.setDescription(description);
        }
        if ((notes = query.getQueryStringParam("notes")) != null) {
            meta.setNotes(notes);
        }
        return meta;
    }

    private void handleRename(TSDB tsdb, HttpQuery query) {
        HashMap<String, String> source;
        if (query.method() != HttpMethod.GET && query.method() != HttpMethod.POST) {
            throw new BadRequestException(HttpResponseStatus.METHOD_NOT_ALLOWED, "Method not allowed", "The HTTP method[" + query.method().getName() + "] is not permitted for this endpoint");
        }
        if (query.method() == HttpMethod.POST) {
            source = query.serializer().parseUidRenameV1();
        } else {
            source = new HashMap(3);
            String[] types = new String[]{"metric", "tagk", "tagv", "name"};
            for (int i = 0; i < types.length; ++i) {
                String value = query.getQueryStringParam(types[i]);
                if (value == null || value.isEmpty()) continue;
                source.put(types[i], value);
            }
        }
        String type = null;
        String oldname = null;
        String newname = null;
        for (Map.Entry<String, String> entry : source.entrySet()) {
            if (entry.getKey().equals("name")) {
                newname = entry.getValue();
                continue;
            }
            type = entry.getKey();
            oldname = entry.getValue();
        }
        if (type == null || oldname == null || newname == null) {
            throw new BadRequestException("Missing necessary values to rename UID");
        }
        HashMap<String, String> response = new HashMap<String, String>(2);
        try {
            tsdb.renameUid(type, oldname, newname);
            response.put("result", "true");
        }
        catch (IllegalArgumentException e) {
            response.put("result", "false");
            response.put("error", e.getMessage());
        }
        if (!response.containsKey("error")) {
            query.sendReply(query.serializer().formatUidRenameV1(response));
        } else {
            query.sendReply(HttpResponseStatus.BAD_REQUEST, query.serializer().formatUidRenameV1(response));
        }
    }

    private TSMeta parseTSMetaQS(HttpQuery query) {
        String min;
        String max;
        String retention;
        String data_type;
        String units;
        String notes;
        String description;
        String tsuid = query.getQueryStringParam("tsuid");
        TSMeta meta = tsuid != null && !tsuid.isEmpty() ? new TSMeta(tsuid) : new TSMeta();
        String display_name = query.getQueryStringParam("display_name");
        if (display_name != null) {
            meta.setDisplayName(display_name);
        }
        if ((description = query.getQueryStringParam("description")) != null) {
            meta.setDescription(description);
        }
        if ((notes = query.getQueryStringParam("notes")) != null) {
            meta.setNotes(notes);
        }
        if ((units = query.getQueryStringParam("units")) != null) {
            meta.setUnits(units);
        }
        if ((data_type = query.getQueryStringParam("data_type")) != null) {
            meta.setDataType(data_type);
        }
        if ((retention = query.getQueryStringParam("retention")) != null && !retention.isEmpty()) {
            try {
                meta.setRetention(Integer.parseInt(retention));
            }
            catch (NumberFormatException nfe) {
                throw new BadRequestException("Unable to parse 'retention' value");
            }
        }
        if ((max = query.getQueryStringParam("max")) != null && !max.isEmpty()) {
            try {
                meta.setMax(Float.parseFloat(max));
            }
            catch (NumberFormatException nfe) {
                throw new BadRequestException("Unable to parse 'max' value");
            }
        }
        if ((min = query.getQueryStringParam("min")) != null && !min.isEmpty()) {
            try {
                meta.setMin(Float.parseFloat(min));
            }
            catch (NumberFormatException nfe) {
                throw new BadRequestException("Unable to parse 'min' value");
            }
        }
        return meta;
    }

    private String getTSUIDForMetric(String query_string, TSDB tsdb) {
        if (query_string == null || query_string.isEmpty()) {
            throw new BadRequestException("The query string was empty");
        }
        HashMap<String, String> tags = new HashMap<String, String>();
        String metric = null;
        try {
            metric = Tags.parseWithMetric(query_string, tags);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e);
        }
        Bytes.ByteMap tag_uids = new Bytes.ByteMap();
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            tag_uids.put((Object)tsdb.getUID(UniqueId.UniqueIdType.TAGK, entry.getKey()), (Object)tsdb.getUID(UniqueId.UniqueIdType.TAGV, entry.getValue()));
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream(TSDB.metrics_width() + tag_uids.size() * (TSDB.tagk_width() + TSDB.tagv_width()));
        try {
            buf.write(tsdb.getUID(UniqueId.UniqueIdType.METRIC, metric));
            for (Map.Entry uids : tag_uids.entrySet()) {
                buf.write((byte[])uids.getKey());
                buf.write((byte[])uids.getValue());
            }
        }
        catch (IOException iOException) {
            throw new BadRequestException(iOException);
        }
        String string = UniqueId.uidToString(buf.toByteArray());
        return string;
    }
}

