/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.uid;

import java.security.SecureRandom;
import net.opentsdb.core.TSDB;
import org.hbase.async.Bytes;

public class RandomUniqueId {
    private static SecureRandom random_generator = new SecureRandom(Bytes.fromLong((long)System.currentTimeMillis()));
    public static final int MAX_WIDTH = 7;

    public static long getRandomUID() {
        return RandomUniqueId.getRandomUID(TSDB.metrics_width());
    }

    public static long getRandomUID(int width) {
        if (width > 7) {
            throw new IllegalArgumentException("Expecting to return an unsigned long random integer, it can not be larger than 7 bytes wide");
        }
        byte[] bytes = new byte[width];
        random_generator.nextBytes(bytes);
        long value = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            value <<= 8;
            value |= (long)(bytes[i] & 0xFF);
        }
        return value != 0L ? value : value + 1L;
    }
}

