/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.uid;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.DatatypeConverter;
import net.opentsdb.core.Const;
import net.opentsdb.core.Internal;
import net.opentsdb.core.TSDB;
import net.opentsdb.meta.UIDMeta;
import net.opentsdb.uid.FailedToAssignUniqueIdException;
import net.opentsdb.uid.NoSuchUniqueId;
import net.opentsdb.uid.NoSuchUniqueName;
import net.opentsdb.uid.RandomUniqueId;
import net.opentsdb.uid.UniqueIdInterface;
import org.hbase.async.AtomicIncrementRequest;
import org.hbase.async.Bytes;
import org.hbase.async.DeleteRequest;
import org.hbase.async.GetRequest;
import org.hbase.async.HBaseClient;
import org.hbase.async.HBaseException;
import org.hbase.async.KeyValue;
import org.hbase.async.PutRequest;
import org.hbase.async.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UniqueId
implements UniqueIdInterface {
    private static final Logger LOG = LoggerFactory.getLogger(UniqueId.class);
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private static final byte[] ID_FAMILY = UniqueId.toBytes("id");
    private static final byte[] NAME_FAMILY = UniqueId.toBytes("name");
    private static final byte[] MAXID_ROW = new byte[]{0};
    private static final short MAX_ATTEMPTS_ASSIGN_ID = 3;
    private static final short MAX_ATTEMPTS_PUT = 6;
    private static final short MAX_ATTEMPTS_ASSIGN_RANDOM_ID = 10;
    private static final short INITIAL_EXP_BACKOFF_DELAY = 800;
    private static final short MAX_SUGGESTIONS = 25;
    private final HBaseClient client;
    private final byte[] table;
    private final byte[] kind;
    private final UniqueIdType type;
    private final short id_width;
    private final boolean randomize_id;
    private final ConcurrentHashMap<String, byte[]> name_cache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> id_cache = new ConcurrentHashMap();
    private final HashMap<String, Deferred<byte[]>> pending_assignments = new HashMap();
    private final Set<String> renaming_id_names = Collections.synchronizedSet(new HashSet());
    private volatile long cache_hits;
    private volatile long cache_misses;
    private volatile int random_id_collisions;
    private volatile int rejected_assignments;
    private TSDB tsdb;
    private static final byte[] START_ROW = new byte[]{33};
    private static final byte[] END_ROW = new byte[]{126};

    public UniqueId(HBaseClient client, byte[] table, String kind, int width) {
        this(client, table, kind, width, false);
    }

    public UniqueId(HBaseClient client, byte[] table, String kind, int width, boolean randomize_id) {
        this.client = client;
        this.table = table;
        if (kind.isEmpty()) {
            throw new IllegalArgumentException("Empty string as 'kind' argument!");
        }
        this.kind = UniqueId.toBytes(kind);
        this.type = UniqueId.stringToUniqueIdType(kind);
        if (width < 1 || width > 8) {
            throw new IllegalArgumentException("Invalid width: " + width);
        }
        this.id_width = (short)width;
        this.randomize_id = randomize_id;
    }

    public UniqueId(TSDB tsdb, byte[] table, String kind, int width, boolean randomize_id) {
        this.client = tsdb.getClient();
        this.tsdb = tsdb;
        this.table = table;
        if (kind.isEmpty()) {
            throw new IllegalArgumentException("Empty string as 'kind' argument!");
        }
        this.kind = UniqueId.toBytes(kind);
        this.type = UniqueId.stringToUniqueIdType(kind);
        if (width < 1 || width > 8) {
            throw new IllegalArgumentException("Invalid width: " + width);
        }
        this.id_width = (short)width;
        this.randomize_id = randomize_id;
    }

    public long cacheHits() {
        return this.cache_hits;
    }

    public long cacheMisses() {
        return this.cache_misses;
    }

    public long cacheSize() {
        return this.name_cache.size() + this.id_cache.size();
    }

    private void incrementCacheHits() {
        this.cache_hits = this.cache_hits >= Long.MAX_VALUE ? 1L : ++this.cache_hits;
    }

    private void incrementCacheMiss() {
        this.cache_misses = this.cache_misses >= Long.MAX_VALUE ? 1L : ++this.cache_misses;
    }

    public int randomIdCollisions() {
        return this.random_id_collisions;
    }

    public int rejectedAssignments() {
        return this.rejected_assignments;
    }

    @Override
    public String kind() {
        return UniqueId.fromBytes(this.kind);
    }

    @Override
    public short width() {
        return this.id_width;
    }

    public void setTSDB(TSDB tsdb) {
        this.tsdb = tsdb;
    }

    public long maxPossibleId() {
        return Internal.getMaxUnsignedValueOnBytes(this.id_width);
    }

    public void dropCaches() {
        this.name_cache.clear();
        this.id_cache.clear();
    }

    @Override
    public String getName(byte[] id) throws NoSuchUniqueId, HBaseException {
        try {
            return (String)this.getNameAsync(id).joinUninterruptibly();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never be here", e);
        }
    }

    public Deferred<String> getNameAsync(final byte[] id) {
        if (id.length != this.id_width) {
            throw new IllegalArgumentException("Wrong id.length = " + id.length + " which is != " + this.id_width + " required for '" + this.kind() + '\'');
        }
        String name = this.getNameFromCache(id);
        if (name != null) {
            this.incrementCacheHits();
            return Deferred.fromResult((Object)name);
        }
        this.incrementCacheMiss();
        class GetNameCB
        implements Callback<String, String> {
            GetNameCB() {
            }

            public String call(String name) {
                if (name == null) {
                    throw new NoSuchUniqueId(UniqueId.this.kind(), id);
                }
                UniqueId.this.addNameToCache(id, name);
                UniqueId.this.addIdToCache(name, id);
                return name;
            }
        }
        return this.getNameFromHBase(id).addCallback((Callback)new GetNameCB());
    }

    private String getNameFromCache(byte[] id) {
        return this.id_cache.get(UniqueId.fromBytes(id));
    }

    private Deferred<String> getNameFromHBase(byte[] id) {
        class NameFromHBaseCB
        implements Callback<String, byte[]> {
            NameFromHBaseCB() {
            }

            public String call(byte[] name) {
                return name == null ? null : UniqueId.fromBytes(name);
            }
        }
        return this.hbaseGet(id, NAME_FAMILY).addCallback((Callback)new NameFromHBaseCB());
    }

    private void addNameToCache(byte[] id, String name) {
        String key = UniqueId.fromBytes(id);
        String found = this.id_cache.get(key);
        if (found == null) {
            found = this.id_cache.putIfAbsent(key, name);
        }
        if (found != null && !found.equals(name)) {
            throw new IllegalStateException("id=" + Arrays.toString(id) + " => name=" + name + ", already mapped to " + found);
        }
    }

    @Override
    public byte[] getId(String name) throws NoSuchUniqueName, HBaseException {
        try {
            return (byte[])this.getIdAsync(name).joinUninterruptibly();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never be here", e);
        }
    }

    public Deferred<byte[]> getIdAsync(final String name) {
        byte[] id = this.getIdFromCache(name);
        if (id != null) {
            this.incrementCacheHits();
            return Deferred.fromResult((Object)id);
        }
        this.incrementCacheMiss();
        class GetIdCB
        implements Callback<byte[], byte[]> {
            GetIdCB() {
            }

            public byte[] call(byte[] id) {
                if (id == null) {
                    throw new NoSuchUniqueName(UniqueId.this.kind(), name);
                }
                if (id.length != UniqueId.this.id_width) {
                    throw new IllegalStateException("Found id.length = " + id.length + " which is != " + UniqueId.this.id_width + " required for '" + UniqueId.this.kind() + '\'');
                }
                UniqueId.this.addIdToCache(name, id);
                UniqueId.this.addNameToCache(id, name);
                return id;
            }
        }
        Deferred d = this.getIdFromHBase(name).addCallback((Callback)new GetIdCB());
        return d;
    }

    private byte[] getIdFromCache(String name) {
        return this.name_cache.get(name);
    }

    private Deferred<byte[]> getIdFromHBase(String name) {
        return this.hbaseGet(UniqueId.toBytes(name), ID_FAMILY);
    }

    private void addIdToCache(String name, byte[] id) {
        byte[] found = this.name_cache.get(name);
        if (found == null) {
            found = this.name_cache.putIfAbsent(name, Arrays.copyOf(id, id.length));
        }
        if (found != null && !Arrays.equals(found, id)) {
            throw new IllegalStateException("name=" + name + " => id=" + Arrays.toString(id) + ", already mapped to " + Arrays.toString(found));
        }
    }

    private void cacheMapping(String name, byte[] id) {
        this.addIdToCache(name, id);
        this.addNameToCache(id, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getOrCreateId(String name) throws HBaseException {
        try {
            return (byte[])this.getIdAsync(name).joinUninterruptibly();
        }
        catch (NoSuchUniqueName e) {
            if (this.tsdb != null && this.tsdb.getUidFilter() != null && this.tsdb.getUidFilter().fillterUIDAssignments()) {
                try {
                    if (!((Boolean)this.tsdb.getUidFilter().allowUIDAssignment(this.type, name, null, null).join()).booleanValue()) {
                        ++this.rejected_assignments;
                        throw new FailedToAssignUniqueIdException(new String(this.kind), name, 0, "Blocked by UID filter.");
                    }
                }
                catch (FailedToAssignUniqueIdException e1) {
                    throw e1;
                }
                catch (InterruptedException e1) {
                    LOG.error("Interrupted", (Throwable)e1);
                    Thread.currentThread().interrupt();
                }
                catch (Exception e1) {
                    throw new RuntimeException("Should never be here", e1);
                }
            }
            Deferred assignment = null;
            boolean pending = false;
            HashMap<String, Deferred<byte[]>> hashMap = this.pending_assignments;
            synchronized (hashMap) {
                assignment = this.pending_assignments.get(name);
                if (assignment == null) {
                    assignment = new Deferred();
                    this.pending_assignments.put(name, (Deferred<byte[]>)assignment);
                } else {
                    pending = true;
                }
            }
            if (pending) {
                LOG.info("Already waiting for UID assignment: " + name);
                try {
                    return (byte[])assignment.joinUninterruptibly();
                }
                catch (Exception e1) {
                    throw new RuntimeException("Should never be here", e1);
                }
            }
            byte[] uid = null;
            try {
                uid = (byte[])new UniqueIdAllocator(name, (Deferred<byte[]>)assignment).tryAllocate().joinUninterruptibly();
            }
            catch (RuntimeException e1) {
                throw e1;
            }
            catch (Exception e1) {
                throw new RuntimeException("Should never be here", e);
            }
            finally {
                HashMap<String, Deferred<byte[]>> hashMap2 = this.pending_assignments;
                synchronized (hashMap2) {
                    if (this.pending_assignments.remove(name) != null) {
                        LOG.info("Completed pending assignment for: " + name);
                    }
                }
            }
            return uid;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never be here", e);
        }
    }

    public Deferred<byte[]> getOrCreateIdAsync(String name) {
        return this.getOrCreateIdAsync(name, null, null);
    }

    public Deferred<byte[]> getOrCreateIdAsync(final String name, final String metric, final Map<String, String> tags) {
        byte[] id = this.getIdFromCache(name);
        if (id != null) {
            this.incrementCacheHits();
            return Deferred.fromResult((Object)id);
        }
        class HandleNoSuchUniqueNameCB
        implements Callback<Object, Exception> {
            HandleNoSuchUniqueNameCB() {
            }

            public Object call(Exception e) {
                if (e instanceof NoSuchUniqueName) {
                    class AssignmentAllowedCB
                    implements Callback<Deferred<byte[]>, Boolean> {
                        final /* synthetic */ String val$name;
                        final /* synthetic */ String val$metric;
                        final /* synthetic */ Map val$tags;

                        AssignmentAllowedCB() {
                            this.val$name = string;
                            this.val$metric = string2;
                            this.val$tags = map;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Deferred<byte[]> call(Boolean allowed) throws Exception {
                            if (!allowed.booleanValue()) {
                                UniqueId.this.rejected_assignments++;
                                return Deferred.fromError((Exception)new FailedToAssignUniqueIdException(new String(UniqueId.this.kind), this.val$name, 0, "Blocked by UID filter."));
                            }
                            Deferred assignment = null;
                            HashMap hashMap = UniqueId.this.pending_assignments;
                            synchronized (hashMap) {
                                assignment = (Deferred)UniqueId.this.pending_assignments.get(this.val$name);
                                if (assignment != null) {
                                    LOG.info("Already waiting for UID assignment: " + this.val$name);
                                    return assignment;
                                }
                                assignment = new Deferred();
                                UniqueId.this.pending_assignments.put(this.val$name, assignment);
                            }
                            if (this.val$metric != null && LOG.isDebugEnabled()) {
                                LOG.debug("Assigning UID for '" + this.val$name + "' of type '" + (Object)((Object)UniqueId.this.type) + "' for series '" + this.val$metric + ", " + this.val$tags + "'");
                            }
                            return new UniqueIdAllocator(this.val$name, (Deferred<byte[]>)assignment).tryAllocate();
                        }

                        public String toString() {
                            return "AssignmentAllowedCB";
                        }
                    }
                    if (UniqueId.this.tsdb != null && UniqueId.this.tsdb.getUidFilter() != null && UniqueId.this.tsdb.getUidFilter().fillterUIDAssignments()) {
                        return UniqueId.this.tsdb.getUidFilter().allowUIDAssignment(UniqueId.this.type, name, metric, tags).addCallbackDeferring((Callback)new AssignmentAllowedCB(UniqueId.this, name, metric, tags));
                    }
                    return Deferred.fromResult((Object)true).addCallbackDeferring((Callback)new AssignmentAllowedCB(UniqueId.this, name, metric, tags));
                }
                return e;
            }
        }
        return this.getIdAsync(name).addErrback((Callback)new HandleNoSuchUniqueNameCB());
    }

    public List<String> suggest(String search) throws HBaseException {
        return this.suggest(search, 25);
    }

    public List<String> suggest(String search, int max_results) throws HBaseException {
        if (max_results < 1) {
            throw new IllegalArgumentException("Count must be greater than 0");
        }
        try {
            return (List)this.suggestAsync(search, max_results).joinUninterruptibly();
        }
        catch (HBaseException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Unexpected exception caught by " + this + ".suggest(" + search + ')';
            LOG.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    public Deferred<List<String>> suggestAsync(String search, int max_results) {
        return new SuggestCB(search, max_results).search();
    }

    public void rename(String oldname, String newname) {
        byte[] row = this.getId(oldname);
        String row_string = UniqueId.fromBytes(row);
        byte[] id = null;
        try {
            id = this.getId(newname);
        }
        catch (NoSuchUniqueName noSuchUniqueName) {
            // empty catch block
        }
        if (id != null) {
            throw new IllegalArgumentException("When trying rename(\"" + oldname + "\", \"" + newname + "\") on " + this + ": new name already assigned ID=" + Arrays.toString(id));
        }
        if (this.renaming_id_names.contains(row_string) || this.renaming_id_names.contains(newname)) {
            throw new IllegalArgumentException("Ongoing rename on the same ID(\"" + Arrays.toString(row) + "\") or an identical new name(\"" + newname + "\")");
        }
        this.renaming_id_names.add(row_string);
        this.renaming_id_names.add(newname);
        byte[] newnameb = UniqueId.toBytes(newname);
        try {
            PutRequest reverse_mapping = new PutRequest(this.table, row, NAME_FAMILY, this.kind, newnameb);
            this.hbasePutWithRetry(reverse_mapping, (short)6, (short)800);
        }
        catch (HBaseException e) {
            LOG.error("When trying rename(\"" + oldname + "\", \"" + newname + "\") on " + this + ": Failed to update reverse mapping for ID=" + Arrays.toString(row), (Throwable)e);
            this.renaming_id_names.remove(row_string);
            this.renaming_id_names.remove(newname);
            throw e;
        }
        try {
            PutRequest forward_mapping = new PutRequest(this.table, newnameb, ID_FAMILY, this.kind, row);
            this.hbasePutWithRetry(forward_mapping, (short)6, (short)800);
        }
        catch (HBaseException e) {
            LOG.error("When trying rename(\"" + oldname + "\", \"" + newname + "\") on " + this + ": Failed to create the new forward mapping with ID=" + Arrays.toString(row), (Throwable)e);
            this.renaming_id_names.remove(row_string);
            this.renaming_id_names.remove(newname);
            throw e;
        }
        this.addIdToCache(newname, row);
        this.id_cache.put(UniqueId.fromBytes(row), newname);
        this.name_cache.remove(oldname);
        try {
            DeleteRequest old_forward_mapping = new DeleteRequest(this.table, UniqueId.toBytes(oldname), ID_FAMILY, this.kind);
            this.client.delete(old_forward_mapping).joinUninterruptibly();
        }
        catch (HBaseException e) {
            LOG.error("When trying rename(\"" + oldname + "\", \"" + newname + "\") on " + this + ": Failed to remove the old forward mapping for ID=" + Arrays.toString(row), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            String msg = "Unexpected exception when trying rename(\"" + oldname + "\", \"" + newname + "\") on " + this + ": Failed to remove the old forward mapping for ID=" + Arrays.toString(row);
            LOG.error("WTF?  " + msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.renaming_id_names.remove(row_string);
            this.renaming_id_names.remove(newname);
        }
    }

    public Deferred<Object> deleteAsync(final String name) {
        class ErrCB
        implements Callback<Object, Exception> {
            ErrCB() {
            }

            public Object call(Exception ex) throws Exception {
                UniqueId.this.name_cache.remove(name);
                UniqueId.this.id_cache.remove(UniqueId.fromBytes(uid));
                LOG.error("Failed to delete " + UniqueId.fromBytes(UniqueId.this.kind) + " UID " + name + " but still cleared the cache", (Throwable)ex);
                return ex;
            }
        }
        if (this.tsdb == null) {
            throw new IllegalStateException("The TSDB is null for this UID object.");
        }
        final byte[] uid = new byte[this.id_width];
        final ArrayList<Deferred> deferreds = new ArrayList<Deferred>(2);
        byte[] cached_uid = this.name_cache.get(name);
        if (cached_uid == null) {
            class LookupCB
            implements Callback<Deferred<Object>, byte[]> {
                LookupCB() {
                }

                public Deferred<Object> call(byte[] stored_uid) throws Exception {
                    if (stored_uid == null) {
                        return Deferred.fromError((Exception)new NoSuchUniqueName(UniqueId.this.kind(), name));
                    }
                    System.arraycopy(stored_uid, 0, uid, 0, UniqueId.this.id_width);
                    DeleteRequest forward = new DeleteRequest(UniqueId.this.table, UniqueId.toBytes(name), ID_FAMILY, UniqueId.this.kind);
                    deferreds.add(UniqueId.this.tsdb.getClient().delete(forward));
                    DeleteRequest reverse = new DeleteRequest(UniqueId.this.table, uid, NAME_FAMILY, UniqueId.this.kind);
                    deferreds.add(UniqueId.this.tsdb.getClient().delete(reverse));
                    DeleteRequest meta = new DeleteRequest(UniqueId.this.table, uid, NAME_FAMILY, UniqueId.toBytes(UniqueId.this.type.toString().toLowerCase() + "_meta"));
                    deferreds.add(UniqueId.this.tsdb.getClient().delete(meta));
                    class GroupCB
                    implements Callback<Deferred<Object>, ArrayList<Object>> {
                        final /* synthetic */ String val$name;
                        final /* synthetic */ byte[] val$uid;

                        GroupCB() {
                            this.val$name = string;
                            this.val$uid = byArray;
                        }

                        public Deferred<Object> call(ArrayList<Object> response) throws Exception {
                            UniqueId.this.name_cache.remove(this.val$name);
                            UniqueId.this.id_cache.remove(UniqueId.fromBytes(this.val$uid));
                            LOG.info("Successfully deleted " + UniqueId.fromBytes(UniqueId.this.kind) + " UID " + this.val$name);
                            return Deferred.fromResult(null);
                        }
                    }
                    return Deferred.group((Collection)deferreds).addCallbackDeferring((Callback)new GroupCB(UniqueId.this, name, uid));
                }
            }
            return this.getIdFromHBase(name).addCallbackDeferring((Callback)new LookupCB()).addErrback((Callback)new ErrCB());
        }
        System.arraycopy(cached_uid, 0, uid, 0, this.id_width);
        DeleteRequest forward = new DeleteRequest(this.table, UniqueId.toBytes(name), ID_FAMILY, this.kind);
        deferreds.add(this.tsdb.getClient().delete(forward));
        DeleteRequest reverse = new DeleteRequest(this.table, uid, NAME_FAMILY, this.kind);
        deferreds.add(this.tsdb.getClient().delete(reverse));
        DeleteRequest meta = new DeleteRequest(this.table, uid, NAME_FAMILY, UniqueId.toBytes(this.type.toString().toLowerCase() + "_meta"));
        deferreds.add(this.tsdb.getClient().delete(meta));
        return Deferred.group(deferreds).addCallbackDeferring((Callback)new GroupCB()).addErrback((Callback)new ErrCB());
    }

    private static Scanner getSuggestScanner(HBaseClient client, byte[] tsd_uid_table, String search, byte[] kind_or_null, int max_results) {
        byte[] end_row;
        byte[] start_row;
        if (search.isEmpty()) {
            start_row = START_ROW;
            end_row = END_ROW;
        } else {
            start_row = UniqueId.toBytes(search);
            end_row = Arrays.copyOf(start_row, start_row.length);
            int n = start_row.length - 1;
            end_row[n] = (byte)(end_row[n] + 1);
        }
        Scanner scanner = client.newScanner(tsd_uid_table);
        scanner.setStartKey(start_row);
        scanner.setStopKey(end_row);
        scanner.setFamily(ID_FAMILY);
        if (kind_or_null != null) {
            scanner.setQualifier(kind_or_null);
        }
        scanner.setMaxNumRows(max_results <= 4096 ? max_results : 4096);
        return scanner;
    }

    private Deferred<byte[]> hbaseGet(byte[] key, byte[] family) {
        GetRequest get = new GetRequest(this.table, key);
        get.family(family).qualifier(this.kind);
        class GetCB
        implements Callback<byte[], ArrayList<KeyValue>> {
            GetCB() {
            }

            public byte[] call(ArrayList<KeyValue> row) {
                if (row == null || row.isEmpty()) {
                    return null;
                }
                return row.get(0).value();
            }
        }
        return this.client.get(get).addCallback((Callback)new GetCB());
    }

    private void hbasePutWithRetry(PutRequest put, short attempts, short wait) throws HBaseException {
        put.setBufferable(false);
        while (true) {
            short s = attempts;
            attempts = (short)(attempts - 1);
            if (s <= 0) break;
            try {
                this.client.put(put).joinUninterruptibly();
                return;
            }
            catch (HBaseException e) {
                if (attempts > 0) {
                    LOG.error("Put failed, attempts left=" + attempts + " (retrying in " + wait + " ms), put=" + put, (Throwable)e);
                    try {
                        Thread.sleep(wait);
                    }
                    catch (InterruptedException ie) {
                        throw new RuntimeException("interrupted", ie);
                    }
                    wait = (short)(wait * 2);
                    continue;
                }
                throw e;
            }
            catch (Exception e) {
                LOG.error("WTF?  Unexpected exception type, put=" + put, (Throwable)e);
                continue;
            }
            break;
        }
        throw new IllegalStateException("This code should never be reached!");
    }

    private static byte[] toBytes(String s) {
        return s.getBytes(CHARSET);
    }

    private static String fromBytes(byte[] b) {
        return new String(b, CHARSET);
    }

    public String toString() {
        return "UniqueId(" + UniqueId.fromBytes(this.table) + ", " + this.kind() + ", " + this.id_width + ")";
    }

    public static String uidToString(byte[] uid) {
        return DatatypeConverter.printHexBinary((byte[])uid);
    }

    public static byte[] stringToUid(String uid) {
        return UniqueId.stringToUid(uid, (short)0);
    }

    public static long uidToLong(String uid, short uid_length) {
        return UniqueId.uidToLong(UniqueId.stringToUid(uid), uid_length);
    }

    public static long uidToLong(byte[] uid, short uid_length) {
        if (uid.length != uid_length) {
            throw new IllegalArgumentException("UID was " + uid.length + " bytes long but expected to be " + uid_length);
        }
        byte[] uid_raw = new byte[8];
        System.arraycopy(uid, 0, uid_raw, 8 - uid_length, uid_length);
        return Bytes.getLong((byte[])uid_raw);
    }

    public static byte[] longToUID(long uid, short width) {
        byte[] padded = Bytes.fromLong((long)uid);
        for (int i = 0; i < padded.length - width; ++i) {
            if (padded[i] == 0) continue;
            String message = "UID " + Long.toString(uid) + " was too large for " + width + " bytes";
            LOG.error("OMG " + message);
            throw new IllegalStateException(message);
        }
        return Arrays.copyOfRange(padded, padded.length - width, padded.length);
    }

    public static void addIdToRegexp(StringBuilder buf, byte[] id) {
        boolean backslash = false;
        for (byte b : id) {
            buf.append((char)(b & 0xFF));
            if (b == 69 && backslash) {
                buf.append("\\\\E\\Q");
                continue;
            }
            backslash = b == 92;
        }
        buf.append("\\E");
    }

    public static UniqueIdType stringToUniqueIdType(String type) {
        if (type.toLowerCase().equals("metric") || type.toLowerCase().equals("metrics")) {
            return UniqueIdType.METRIC;
        }
        if (type.toLowerCase().equals("tagk")) {
            return UniqueIdType.TAGK;
        }
        if (type.toLowerCase().equals("tagv")) {
            return UniqueIdType.TAGV;
        }
        throw new IllegalArgumentException("Invalid type requested: " + type);
    }

    public static byte[] stringToUid(String uid, short uid_length) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("UID was empty");
        }
        String id = uid;
        if (uid_length > 0) {
            while (id.length() < uid_length * 2) {
                id = "0" + id;
            }
        } else if (id.length() % 2 > 0) {
            id = "0" + id;
        }
        return DatatypeConverter.parseHexBinary((String)id);
    }

    public static byte[] getTSUIDFromKey(byte[] row_key, short metric_width, short timestamp_width) {
        int idx = 0;
        int tag_pair_width = TSDB.tagk_width() + TSDB.tagv_width();
        int tags_length = row_key.length - (Const.SALT_WIDTH() + metric_width + timestamp_width);
        if (tags_length < tag_pair_width || tags_length % tag_pair_width != 0) {
            throw new IllegalArgumentException("Row key is missing tags or it is corrupted " + Arrays.toString(row_key));
        }
        byte[] tsuid = new byte[row_key.length - timestamp_width - Const.SALT_WIDTH()];
        for (int i = Const.SALT_WIDTH(); i < row_key.length; ++i) {
            if (i >= Const.SALT_WIDTH() + metric_width && i < Const.SALT_WIDTH() + metric_width + timestamp_width) continue;
            tsuid[idx] = row_key[i];
            ++idx;
        }
        return tsuid;
    }

    public static List<byte[]> getTagsFromTSUID(String tsuid) {
        if (tsuid == null || tsuid.isEmpty()) {
            throw new IllegalArgumentException("Missing TSUID");
        }
        if (tsuid.length() <= TSDB.metrics_width() * 2) {
            throw new IllegalArgumentException("TSUID is too short, may be missing tags");
        }
        ArrayList<byte[]> tags = new ArrayList<byte[]>();
        int pair_width = TSDB.tagk_width() * 2 + TSDB.tagv_width() * 2;
        for (int i = TSDB.metrics_width() * 2; i < tsuid.length(); i += pair_width) {
            if (i + pair_width > tsuid.length()) {
                throw new IllegalArgumentException("The TSUID appears to be malformed, improper tag width");
            }
            String tag = tsuid.substring(i, i + TSDB.tagk_width() * 2);
            tags.add(UniqueId.stringToUid(tag));
            tag = tsuid.substring(i + TSDB.tagk_width() * 2, i + pair_width);
            tags.add(UniqueId.stringToUid(tag));
        }
        return tags;
    }

    public static List<byte[]> getTagPairsFromTSUID(String tsuid) {
        if (tsuid == null || tsuid.isEmpty()) {
            throw new IllegalArgumentException("Missing TSUID");
        }
        if (tsuid.length() <= TSDB.metrics_width() * 2) {
            throw new IllegalArgumentException("TSUID is too short, may be missing tags");
        }
        ArrayList<byte[]> tags = new ArrayList<byte[]>();
        int pair_width = TSDB.tagk_width() * 2 + TSDB.tagv_width() * 2;
        for (int i = TSDB.metrics_width() * 2; i < tsuid.length(); i += pair_width) {
            if (i + pair_width > tsuid.length()) {
                throw new IllegalArgumentException("The TSUID appears to be malformed, improper tag width");
            }
            String tag = tsuid.substring(i, i + pair_width);
            tags.add(UniqueId.stringToUid(tag));
        }
        return tags;
    }

    public static List<byte[]> getTagPairsFromTSUID(byte[] tsuid) {
        if (tsuid == null) {
            throw new IllegalArgumentException("Missing TSUID");
        }
        if (tsuid.length <= TSDB.metrics_width()) {
            throw new IllegalArgumentException("TSUID is too short, may be missing tags");
        }
        ArrayList<byte[]> tags = new ArrayList<byte[]>();
        int pair_width = TSDB.tagk_width() + TSDB.tagv_width();
        for (int i = TSDB.metrics_width(); i < tsuid.length; i += pair_width) {
            if (i + pair_width > tsuid.length) {
                throw new IllegalArgumentException("The TSUID appears to be malformed, improper tag width");
            }
            tags.add(Arrays.copyOfRange(tsuid, i, i + pair_width));
        }
        return tags;
    }

    public static Deferred<Map<String, Long>> getUsedUIDs(TSDB tsdb, byte[][] kinds) {
        GetRequest get = new GetRequest(tsdb.uidTable(), MAXID_ROW);
        get.family(ID_FAMILY);
        get.qualifiers(kinds);
        final class GetCB
        implements Callback<Map<String, Long>, ArrayList<KeyValue>> {
            final /* synthetic */ byte[][] val$kinds;

            GetCB(byte[][] byArray) {
                this.val$kinds = byArray;
            }

            public Map<String, Long> call(ArrayList<KeyValue> row) throws Exception {
                HashMap<String, Long> results = new HashMap<String, Long>(3);
                if (row == null || row.isEmpty()) {
                    LOG.info("Could not find the UID assignment row");
                    for (byte[] kind : this.val$kinds) {
                        results.put(new String(kind, CHARSET), 0L);
                    }
                    return results;
                }
                for (KeyValue column : row) {
                    results.put(new String(column.qualifier(), CHARSET), Bytes.getLong((byte[])column.value()));
                }
                for (Object kind : (Object)this.val$kinds) {
                    if (results.get(new String((byte[])kind, CHARSET)) != null) continue;
                    results.put(new String((byte[])kind, CHARSET), 0L);
                }
                return results;
            }
        }
        return tsdb.getClient().get(get).addCallback((Callback)new GetCB(kinds));
    }

    public static void preloadUidCache(TSDB tsdb, Bytes.ByteMap<UniqueId> uid_cache_map) throws HBaseException {
        int max_results = tsdb.getConfig().getInt("tsd.core.preload_uid_cache.max_entries");
        LOG.info("Preloading uid cache with max_results=" + max_results);
        if (max_results <= 0) {
            return;
        }
        Scanner scanner = null;
        try {
            int num_rows = 0;
            scanner = UniqueId.getSuggestScanner(tsdb.getClient(), tsdb.uidTable(), "", null, max_results);
            ArrayList rows = (ArrayList)scanner.nextRows().join();
            while (rows != null) {
                for (ArrayList row : rows) {
                    for (KeyValue kv : row) {
                        String name = UniqueId.fromBytes(kv.key());
                        byte[] kind = kv.qualifier();
                        byte[] id = kv.value();
                        LOG.debug("id='{}', name='{}', kind='{}'", new Object[]{Arrays.toString(id), name, UniqueId.fromBytes(kind)});
                        UniqueId uid_cache = (UniqueId)uid_cache_map.get((Object)kind);
                        if (uid_cache == null) continue;
                        uid_cache.cacheMapping(name, id);
                    }
                    row.clear();
                    if ((num_rows += row.size()) < max_results) continue;
                    break;
                }
                rows = (ArrayList)scanner.nextRows().join();
            }
            for (UniqueId unique_id_table : uid_cache_map.values()) {
                LOG.info("After preloading, uid cache '{}' has {} ids and {} names.", new Object[]{unique_id_table.kind(), unique_id_table.id_cache.size(), unique_id_table.name_cache.size()});
            }
        }
        catch (Exception e) {
            if (e instanceof HBaseException) {
                throw (HBaseException)((Object)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Error while preloading IDs", e);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    private final class SuggestCB
    implements Callback<Object, ArrayList<ArrayList<KeyValue>>> {
        private final LinkedList<String> suggestions = new LinkedList();
        private final Scanner scanner;
        private final int max_results;

        SuggestCB(String search, int max_results) {
            this.max_results = max_results;
            this.scanner = UniqueId.getSuggestScanner(UniqueId.this.client, UniqueId.this.table, search, UniqueId.this.kind, max_results);
        }

        Deferred<List<String>> search() {
            return this.scanner.nextRows().addCallback((Callback)this);
        }

        public Object call(ArrayList<ArrayList<KeyValue>> rows) {
            if (rows == null) {
                return this.suggestions;
            }
            for (ArrayList<KeyValue> row : rows) {
                if (row.size() != 1) {
                    LOG.error("WTF shouldn't happen!  Scanner " + this.scanner + " returned a row that doesn't have exactly 1 KeyValue: " + row);
                    if (row.isEmpty()) continue;
                }
                byte[] key = row.get(0).key();
                String name = UniqueId.fromBytes(key);
                byte[] id = row.get(0).value();
                byte[] cached_id = (byte[])UniqueId.this.name_cache.get(name);
                if (cached_id == null) {
                    UniqueId.this.cacheMapping(name, id);
                } else if (!Arrays.equals(id, cached_id)) {
                    throw new IllegalStateException("WTF?  For kind=" + UniqueId.this.kind() + " name=" + name + ", we have id=" + Arrays.toString(cached_id) + " in cache, but just scanned id=" + Arrays.toString(id));
                }
                this.suggestions.add(name);
                if ((short)this.suggestions.size() >= this.max_results) {
                    return this.scanner.close().addCallback((Callback)new Callback<Object, Object>(){

                        public Object call(Object ignored) throws Exception {
                            return SuggestCB.this.suggestions;
                        }
                    });
                }
                row.clear();
            }
            return this.search();
        }
    }

    private final class UniqueIdAllocator
    implements Callback<Object, Object> {
        private final String name;
        private final Deferred<byte[]> assignment;
        private short attempt;
        private HBaseException hbe;
        private boolean called;
        private long id;
        private byte[] row;
        private static final byte ALLOCATE_UID = 0;
        private static final byte CREATE_REVERSE_MAPPING = 1;
        private static final byte CREATE_FORWARD_MAPPING = 2;
        private static final byte DONE = 3;
        private byte state;

        UniqueIdAllocator(String name, Deferred<byte[]> assignment) {
            this.attempt = (short)(UniqueId.this.randomize_id ? 10 : 3);
            this.hbe = null;
            this.called = false;
            this.id = -1L;
            this.state = 0;
            this.name = name;
            this.assignment = assignment;
        }

        Deferred<byte[]> tryAllocate() {
            this.attempt = (short)(this.attempt - 1);
            this.state = 0;
            this.call(null);
            return this.assignment;
        }

        public Object call(Object arg) {
            Object d;
            if (this.attempt == 0) {
                if (this.hbe == null && !UniqueId.this.randomize_id) {
                    throw new IllegalStateException("Should never happen!");
                }
                LOG.error("Failed to assign an ID for kind='" + UniqueId.this.kind() + "' name='" + this.name + "'", (Throwable)this.hbe);
                if (this.hbe == null) {
                    throw new FailedToAssignUniqueIdException(UniqueId.this.kind(), this.name, 10);
                }
                throw this.hbe;
            }
            if (arg instanceof Exception) {
                String msg = "Failed attempt #" + (UniqueId.this.randomize_id ? 10 - this.attempt : 3 - this.attempt) + " to assign an UID for " + UniqueId.this.kind() + ':' + this.name + " at step #" + this.state;
                if (arg instanceof HBaseException) {
                    LOG.error(msg, (Throwable)((Exception)arg));
                    this.hbe = (HBaseException)((Object)arg);
                    this.attempt = (short)(this.attempt - 1);
                    this.state = 0;
                } else {
                    LOG.error("WTF?  Unexpected exception!  " + msg, (Throwable)((Exception)arg));
                    return arg;
                }
            }
            switch (this.state) {
                case 0: {
                    d = this.allocateUid();
                    break;
                }
                case 1: {
                    d = this.createReverseMapping(arg);
                    break;
                }
                case 2: {
                    d = this.createForwardMapping(arg);
                    break;
                }
                case 3: {
                    return this.done(arg);
                }
                default: {
                    throw new AssertionError((Object)"Should never be here!");
                }
            }
            class ErrBack
            implements Callback<Object, Exception> {
                ErrBack() {
                }

                public Object call(Exception e) throws Exception {
                    if (!UniqueIdAllocator.this.called) {
                        LOG.warn("Failed pending assignment for: " + UniqueIdAllocator.this.name, (Throwable)e);
                        UniqueIdAllocator.this.assignment.callback((Object)e);
                        UniqueIdAllocator.this.called = true;
                    }
                    return UniqueIdAllocator.this.assignment;
                }
            }
            return d.addBoth((Callback)this).addErrback((Callback)new ErrBack());
        }

        private Deferred<Long> allocateUid() {
            LOG.info("Creating " + (UniqueId.this.randomize_id ? "a random " : "an ") + "ID for kind='" + UniqueId.this.kind() + "' name='" + this.name + '\'');
            this.state = 1;
            if (UniqueId.this.randomize_id) {
                return Deferred.fromResult((Object)RandomUniqueId.getRandomUID());
            }
            return UniqueId.this.client.atomicIncrement(new AtomicIncrementRequest(UniqueId.this.table, MAXID_ROW, ID_FAMILY, UniqueId.this.kind));
        }

        private Deferred<Boolean> createReverseMapping(Object arg) {
            if (!(arg instanceof Long)) {
                throw new IllegalStateException("Expected a Long but got " + arg);
            }
            this.id = (Long)arg;
            if (this.id <= 0L) {
                throw new IllegalStateException("Got a negative ID from HBase: " + this.id);
            }
            LOG.info("Got ID=" + this.id + " for kind='" + UniqueId.this.kind() + "' name='" + this.name + "'");
            this.row = Bytes.fromLong((long)this.id);
            if (this.row.length < UniqueId.this.id_width) {
                throw new IllegalStateException("OMG, row.length = " + this.row.length + " which is less than " + UniqueId.this.id_width + " for id=" + this.id + " row=" + Arrays.toString(this.row));
            }
            for (int i = 0; i < this.row.length - UniqueId.this.id_width; ++i) {
                if (this.row[i] == 0) continue;
                String message = "All Unique IDs for " + UniqueId.this.kind() + " on " + UniqueId.this.id_width + " bytes are already assigned!";
                LOG.error("OMG " + message);
                throw new IllegalStateException(message);
            }
            this.row = Arrays.copyOfRange(this.row, this.row.length - UniqueId.this.id_width, this.row.length);
            this.state = (byte)2;
            return UniqueId.this.client.compareAndSet(this.reverseMapping(), HBaseClient.EMPTY_ARRAY);
        }

        private PutRequest reverseMapping() {
            return new PutRequest(UniqueId.this.table, this.row, NAME_FAMILY, UniqueId.this.kind, UniqueId.toBytes(this.name));
        }

        private Deferred<?> createForwardMapping(Object arg) {
            if (!(arg instanceof Boolean)) {
                throw new IllegalStateException("Expected a Boolean but got " + arg);
            }
            if (!((Boolean)arg).booleanValue()) {
                if (UniqueId.this.randomize_id) {
                    LOG.warn("Detected random id collision and retrying kind='" + UniqueId.this.kind() + "' name='" + this.name + "'");
                    UniqueId.this.random_id_collisions++;
                } else {
                    LOG.error("WTF!  Failed to CAS reverse mapping: " + this.reverseMapping() + " -- run an fsck against the UID table!");
                }
                this.attempt = (short)(this.attempt - 1);
                this.state = 0;
                return Deferred.fromResult((Object)false);
            }
            this.state = (byte)3;
            return UniqueId.this.client.compareAndSet(this.forwardMapping(), HBaseClient.EMPTY_ARRAY);
        }

        private PutRequest forwardMapping() {
            return new PutRequest(UniqueId.this.table, UniqueId.toBytes(this.name), ID_FAMILY, UniqueId.this.kind, this.row);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Deferred<byte[]> done(Object arg) {
            if (!(arg instanceof Boolean)) {
                throw new IllegalStateException("Expected a Boolean but got " + arg);
            }
            if (!((Boolean)arg).booleanValue()) {
                LOG.warn("Race condition: tried to assign ID " + this.id + " to " + UniqueId.this.kind() + ":" + this.name + ", but CAS failed on " + this.forwardMapping() + ", which indicates this UID must have been allocated concurrently by another TSD or thread. So ID " + this.id + " was leaked.");
                if (UniqueId.this.randomize_id) {
                    LOG.warn("Detected random id collision between two tsdb servers kind='" + UniqueId.this.kind() + "' name='" + this.name + "'");
                    UniqueId.this.random_id_collisions++;
                }
                class GetIdCB
                implements Callback<Object, byte[]> {
                    GetIdCB() {
                    }

                    public Object call(byte[] row) throws Exception {
                        UniqueIdAllocator.this.assignment.callback((Object)row);
                        return null;
                    }
                }
                UniqueId.this.getIdAsync(this.name).addCallback((Callback)new GetIdCB());
                return this.assignment;
            }
            UniqueId.this.cacheMapping(this.name, this.row);
            if (UniqueId.this.tsdb != null && UniqueId.this.tsdb.getConfig().enable_realtime_uid()) {
                UIDMeta meta = new UIDMeta(UniqueId.this.type, this.row, this.name);
                meta.storeNew(UniqueId.this.tsdb);
                LOG.info("Wrote UIDMeta for: " + this.name);
                UniqueId.this.tsdb.indexUIDMeta(meta);
            }
            HashMap hashMap = UniqueId.this.pending_assignments;
            synchronized (hashMap) {
                if (UniqueId.this.pending_assignments.remove(this.name) != null) {
                    LOG.info("Completed pending assignment for: " + this.name);
                }
            }
            this.assignment.callback((Object)this.row);
            return this.assignment;
        }
    }

    public static enum UniqueIdType {
        METRIC,
        TAGK,
        TAGV;

    }
}

