/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.uid;

import com.google.common.annotations.VisibleForTesting;
import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.opentsdb.core.TSDB;
import net.opentsdb.stats.StatsCollector;
import net.opentsdb.uid.UniqueId;
import net.opentsdb.uid.UniqueIdFilterPlugin;
import net.opentsdb.utils.Config;

public class UniqueIdWhitelistFilter
extends UniqueIdFilterPlugin {
    public static final String DEFAULT_REGEX_DELIMITER = ",";
    private List<Pattern> metric_patterns;
    private List<Pattern> tagk_patterns;
    private List<Pattern> tagv_patterns;
    private final AtomicLong metrics_rejected = new AtomicLong();
    private final AtomicLong metrics_allowed = new AtomicLong();
    private final AtomicLong tagks_rejected = new AtomicLong();
    private final AtomicLong tagks_allowed = new AtomicLong();
    private final AtomicLong tagvs_rejected = new AtomicLong();
    private final AtomicLong tagvs_allowed = new AtomicLong();

    @Override
    public void initialize(TSDB tsdb) {
        String[] splits;
        String raw;
        Config config = tsdb.getConfig();
        String delimiter = config.getString("tsd.uidfilter.whitelist.delimiter");
        if (delimiter == null) {
            delimiter = DEFAULT_REGEX_DELIMITER;
        }
        if ((raw = config.getString("tsd.uidfilter.whitelist.metric_patterns")) != null) {
            splits = raw.split(delimiter);
            this.metric_patterns = new ArrayList<Pattern>(splits.length);
            for (String pattern : splits) {
                try {
                    this.metric_patterns.add(Pattern.compile(pattern));
                }
                catch (PatternSyntaxException e) {
                    throw new IllegalArgumentException("The metric whitelist pattern [" + pattern + "] does not compile.", e);
                }
            }
        }
        if ((raw = config.getString("tsd.uidfilter.whitelist.tagk_patterns")) != null) {
            splits = raw.split(delimiter);
            this.tagk_patterns = new ArrayList<Pattern>(splits.length);
            for (String pattern : splits) {
                try {
                    this.tagk_patterns.add(Pattern.compile(pattern));
                }
                catch (PatternSyntaxException e) {
                    throw new IllegalArgumentException("The tagk whitelist pattern [" + pattern + "] does not compile.", e);
                }
            }
        }
        if ((raw = config.getString("tsd.uidfilter.whitelist.tagv_patterns")) != null) {
            splits = raw.split(delimiter);
            this.tagv_patterns = new ArrayList<Pattern>(splits.length);
            for (String pattern : splits) {
                try {
                    this.tagv_patterns.add(Pattern.compile(pattern));
                }
                catch (PatternSyntaxException e) {
                    throw new IllegalArgumentException("The tagv whitelist pattern [" + pattern + "] does not compile.", e);
                }
            }
        }
    }

    @Override
    public Deferred<Object> shutdown() {
        return Deferred.fromResult(null);
    }

    @Override
    public String version() {
        return "2.3.0";
    }

    @Override
    public void collectStats(StatsCollector collector) {
        collector.record("uid.filter.whitelist.accepted", this.metrics_allowed.get(), "type=metrics");
        collector.record("uid.filter.whitelist.accepted", this.tagks_allowed.get(), "type=tagk");
        collector.record("uid.filter.whitelist.accepted", this.tagvs_allowed.get(), "type=tagv");
        collector.record("uid.filter.whitelist.rejected", this.metrics_rejected.get(), "type=metrics");
        collector.record("uid.filter.whitelist.rejected", this.tagks_rejected.get(), "type=tagk");
        collector.record("uid.filter.whitelist.rejected", this.tagvs_rejected.get(), "type=tagv");
    }

    @Override
    public Deferred<Boolean> allowUIDAssignment(UniqueId.UniqueIdType type, String value, String metric, Map<String, String> tags) {
        switch (type) {
            case METRIC: {
                if (this.metric_patterns != null) {
                    for (Pattern pattern : this.metric_patterns) {
                        if (pattern.matcher(value).find()) continue;
                        this.metrics_rejected.incrementAndGet();
                        return Deferred.fromResult((Object)false);
                    }
                }
                this.metrics_allowed.incrementAndGet();
                break;
            }
            case TAGK: {
                if (this.tagk_patterns != null) {
                    for (Pattern pattern : this.tagk_patterns) {
                        if (pattern.matcher(value).find()) continue;
                        this.tagks_rejected.incrementAndGet();
                        return Deferred.fromResult((Object)false);
                    }
                }
                this.tagks_allowed.incrementAndGet();
                break;
            }
            case TAGV: {
                if (this.tagv_patterns != null) {
                    for (Pattern pattern : this.tagv_patterns) {
                        if (pattern.matcher(value).find()) continue;
                        this.tagvs_rejected.incrementAndGet();
                        return Deferred.fromResult((Object)false);
                    }
                }
                this.tagvs_allowed.incrementAndGet();
            }
        }
        return Deferred.fromResult((Object)true);
    }

    @Override
    public boolean fillterUIDAssignments() {
        return true;
    }

    @VisibleForTesting
    List<Pattern> metricPatterns() {
        return this.metric_patterns;
    }

    @VisibleForTesting
    List<Pattern> tagkPatterns() {
        return this.tagk_patterns;
    }

    @VisibleForTesting
    List<Pattern> tagvPatterns() {
        return this.tagv_patterns;
    }
}

