/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.utils;

import java.util.Arrays;
import net.opentsdb.utils.Pair;
import org.hbase.async.Bytes;

public class ByteArrayPair
extends Pair<byte[], byte[]>
implements Comparable<ByteArrayPair> {
    public ByteArrayPair(byte[] key, byte[] value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int compareTo(ByteArrayPair a) {
        int key_compare = Bytes.memcmpMaybeNull((byte[])((byte[])this.key), (byte[])((byte[])a.key));
        if (key_compare == 0) {
            return Bytes.memcmpMaybeNull((byte[])((byte[])this.value), (byte[])((byte[])a.value));
        }
        return key_compare;
    }

    @Override
    public String toString() {
        return "key=" + Arrays.toString((byte[])this.key) + ", value=" + Arrays.toString((byte[])this.value);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ByteArrayPair) {
            ByteArrayPair other_pair = (ByteArrayPair)object;
            return (this.key == null ? other_pair.getKey() == null : Bytes.memcmp((byte[])((byte[])this.key), (byte[])((byte[])other_pair.key)) == 0) && (this.value == null ? other_pair.getValue() == null : Bytes.memcmp((byte[])((byte[])this.value), (byte[])((byte[])other_pair.value)) == 0);
        }
        return false;
    }
}

