/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.utils;

import com.google.common.collect.ImmutableMap;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger LOG = LoggerFactory.getLogger(Config.class);
    public static final boolean IS_WINDOWS = System.getProperty("os.name", "").contains("Windows");
    private boolean auto_metric = false;
    private boolean auto_tagk = true;
    private boolean auto_tagv = true;
    private boolean enable_compactions = true;
    private boolean enable_appends = false;
    private boolean repair_appends = false;
    private boolean enable_realtime_ts = false;
    private boolean enable_realtime_uid = false;
    private boolean enable_tsuid_incrementing = false;
    private boolean enable_tsuid_tracking = false;
    private boolean enable_chunked_requests = false;
    private boolean fix_duplicates = false;
    private int max_chunked_requests = 4096;
    private boolean enable_tree_processing = false;
    private int scanner_max_num_rows = 128;
    protected final HashMap<String, String> properties = new HashMap();
    protected static final HashMap<String, String> default_map = new HashMap();
    protected String config_location;

    public Config(boolean auto_load_config) throws IOException {
        if (auto_load_config) {
            this.loadConfig();
        }
        this.setDefaults();
    }

    public Config(String file) throws IOException {
        this.loadConfig(file);
        this.setDefaults();
    }

    public Config(Config parent) {
        this.properties.putAll(parent.properties);
        this.config_location = parent.config_location;
        this.setDefaults();
    }

    public String configLocation() {
        return this.config_location;
    }

    public boolean auto_metric() {
        return this.auto_metric;
    }

    public boolean auto_tagk() {
        return this.auto_tagk;
    }

    public boolean auto_tagv() {
        return this.auto_tagv;
    }

    public void setAutoMetric(boolean auto_metric) {
        this.auto_metric = auto_metric;
        this.properties.put("tsd.core.auto_create_metrics", Boolean.toString(auto_metric));
    }

    public boolean enable_compactions() {
        return this.enable_compactions;
    }

    public boolean enable_appends() {
        return this.enable_appends;
    }

    public boolean repair_appends() {
        return this.repair_appends;
    }

    public boolean enable_realtime_ts() {
        return this.enable_realtime_ts;
    }

    public boolean enable_realtime_uid() {
        return this.enable_realtime_uid;
    }

    public boolean enable_tsuid_incrementing() {
        return this.enable_tsuid_incrementing;
    }

    public boolean enable_tsuid_tracking() {
        return this.enable_tsuid_tracking;
    }

    public int scanner_maxNumRows() {
        return this.scanner_max_num_rows;
    }

    public boolean enable_chunked_requests() {
        return this.enable_chunked_requests;
    }

    public int max_chunked_requests() {
        return this.max_chunked_requests;
    }

    public boolean fix_duplicates() {
        return this.fix_duplicates;
    }

    public void setFixDuplicates(boolean fix_duplicates) {
        this.fix_duplicates = fix_duplicates;
    }

    public boolean enable_tree_processing() {
        return this.enable_tree_processing;
    }

    public void overrideConfig(String property, String value) {
        this.properties.put(property, value);
        this.loadStaticVariables();
    }

    public final String getString(String property) {
        return this.properties.get(property);
    }

    public final int getInt(String property) {
        return Integer.parseInt(this.sanitize(this.properties.get(property)));
    }

    private final String sanitize(String string) {
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    public final short getShort(String property) {
        return Short.parseShort(this.sanitize(this.properties.get(property)));
    }

    public final long getLong(String property) {
        return Long.parseLong(this.sanitize(this.properties.get(property)));
    }

    public final float getFloat(String property) {
        return Float.parseFloat(this.sanitize(this.properties.get(property)));
    }

    public final double getDouble(String property) {
        return Double.parseDouble(this.sanitize(this.properties.get(property)));
    }

    public final boolean getBoolean(String property) {
        String val = this.properties.get(property).trim().toUpperCase();
        if (val.equals("1")) {
            return true;
        }
        if (val.equals("TRUE")) {
            return true;
        }
        return val.equals("YES");
    }

    public final String getDirectoryName(String property) {
        String directory = this.properties.get(property);
        if (directory == null || directory.isEmpty()) {
            return null;
        }
        if (IS_WINDOWS) {
            if (directory.charAt(directory.length() - 1) == '\\' || directory.charAt(directory.length() - 1) == '/') {
                return directory;
            }
            if (directory.contains("/")) {
                return directory + "/";
            }
            return directory + "\\";
        }
        if (directory.contains("\\")) {
            throw new IllegalArgumentException("Unix path names cannot contain a back slash");
        }
        if (directory == null || directory.isEmpty()) {
            return null;
        }
        if (directory.charAt(directory.length() - 1) == '/') {
            return directory;
        }
        return directory + "/";
    }

    public final boolean hasProperty(String property) {
        String val = this.properties.get(property);
        if (val == null) {
            return false;
        }
        return !val.isEmpty();
    }

    public final String dumpConfiguration() {
        if (this.properties.isEmpty()) {
            return "No configuration settings stored";
        }
        StringBuilder response = new StringBuilder("TSD Configuration:\n");
        response.append("File [" + this.config_location + "]\n");
        int line = 0;
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (line > 0) {
                response.append("\n");
            }
            response.append("Key [" + entry.getKey() + "]  Value [");
            if (entry.getKey().toUpperCase().contains("PASS")) {
                response.append("********");
            } else {
                response.append(entry.getValue());
            }
            response.append("]");
            ++line;
        }
        return response.toString();
    }

    public final Map<String, String> getMap() {
        return ImmutableMap.copyOf(this.properties);
    }

    public final void enableCompactions() {
        this.enable_compactions = true;
    }

    public final void disableCompactions() {
        this.enable_compactions = false;
    }

    protected void setDefaults() {
        default_map.put("tsd.mode", "rw");
        default_map.put("tsd.no_diediedie", "false");
        default_map.put("tsd.network.bind", "0.0.0.0");
        default_map.put("tsd.network.worker_threads", "");
        default_map.put("tsd.network.async_io", "true");
        default_map.put("tsd.network.tcp_no_delay", "true");
        default_map.put("tsd.network.keep_alive", "true");
        default_map.put("tsd.network.reuse_address", "true");
        default_map.put("tsd.core.auto_create_metrics", "false");
        default_map.put("tsd.core.auto_create_tagks", "true");
        default_map.put("tsd.core.auto_create_tagvs", "true");
        default_map.put("tsd.core.connections.limit", "0");
        default_map.put("tsd.core.enable_api", "true");
        default_map.put("tsd.core.enable_ui", "true");
        default_map.put("tsd.core.meta.enable_realtime_ts", "false");
        default_map.put("tsd.core.meta.enable_realtime_uid", "false");
        default_map.put("tsd.core.meta.enable_tsuid_incrementing", "false");
        default_map.put("tsd.core.meta.enable_tsuid_tracking", "false");
        default_map.put("tsd.core.meta.cache.enable", "false");
        default_map.put("tsd.core.plugin_path", "");
        default_map.put("tsd.core.socket.timeout", "0");
        default_map.put("tsd.core.tree.enable_processing", "false");
        default_map.put("tsd.core.preload_uid_cache", "false");
        default_map.put("tsd.core.preload_uid_cache.max_entries", "300000");
        default_map.put("tsd.core.storage_exception_handler.enable", "false");
        default_map.put("tsd.core.uid.random_metrics", "false");
        default_map.put("tsd.core.bulk.allow_out_of_order_timestamps", "false");
        default_map.put("tsd.query.filter.expansion_limit", "4096");
        default_map.put("tsd.query.skip_unresolved_tagvs", "false");
        default_map.put("tsd.query.allow_simultaneous_duplicates", "true");
        default_map.put("tsd.query.enable_fuzzy_filter", "true");
        default_map.put("tsd.rtpublisher.enable", "false");
        default_map.put("tsd.rtpublisher.plugin", "");
        default_map.put("tsd.search.enable", "false");
        default_map.put("tsd.search.plugin", "");
        default_map.put("tsd.stats.canonical", "false");
        default_map.put("tsd.startup.enable", "false");
        default_map.put("tsd.startup.plugin", "");
        default_map.put("tsd.storage.hbase.scanner.maxNumRows", "128");
        default_map.put("tsd.storage.fix_duplicates", "false");
        default_map.put("tsd.storage.flush_interval", "1000");
        default_map.put("tsd.storage.hbase.data_table", "tsdb");
        default_map.put("tsd.storage.hbase.uid_table", "tsdb-uid");
        default_map.put("tsd.storage.hbase.tree_table", "tsdb-tree");
        default_map.put("tsd.storage.hbase.meta_table", "tsdb-meta");
        default_map.put("tsd.storage.hbase.zk_quorum", "localhost");
        default_map.put("tsd.storage.hbase.zk_basedir", "/hbase");
        default_map.put("tsd.storage.hbase.prefetch_meta", "false");
        default_map.put("tsd.storage.enable_appends", "false");
        default_map.put("tsd.storage.repair_appends", "false");
        default_map.put("tsd.storage.enable_compaction", "true");
        default_map.put("tsd.storage.compaction.flush_interval", "10");
        default_map.put("tsd.storage.compaction.min_flush_threshold", "100");
        default_map.put("tsd.storage.compaction.max_concurrent_flushes", "10000");
        default_map.put("tsd.storage.compaction.flush_speed", "2");
        default_map.put("tsd.timeseriesfilter.enable", "false");
        default_map.put("tsd.uidfilter.enable", "false");
        default_map.put("tsd.core.stats_with_port", "false");
        default_map.put("tsd.http.show_stack_trace", "true");
        default_map.put("tsd.http.query.allow_delete", "false");
        default_map.put("tsd.http.request.enable_chunked", "false");
        default_map.put("tsd.http.request.max_chunk", "4096");
        default_map.put("tsd.http.request.cors_domains", "");
        default_map.put("tsd.http.request.cors_headers", "Authorization, Content-Type, Accept, Origin, User-Agent, DNT, Cache-Control, X-Mx-ReqToken, Keep-Alive, X-Requested-With, If-Modified-Since");
        default_map.put("tsd.query.timeout", "0");
        for (Map.Entry<String, String> entry : default_map.entrySet()) {
            if (this.properties.containsKey(entry.getKey())) continue;
            this.properties.put(entry.getKey(), entry.getValue());
        }
        this.loadStaticVariables();
    }

    protected void loadConfig() throws IOException {
        if (this.config_location != null && !this.config_location.isEmpty()) {
            this.loadConfig(this.config_location);
            return;
        }
        ArrayList<String> file_locations = new ArrayList<String>();
        file_locations.add("opentsdb.conf");
        if (System.getProperty("os.name").toUpperCase().contains("WINDOWS")) {
            file_locations.add("C:\\Program Files\\opentsdb\\opentsdb.conf");
            file_locations.add("C:\\Program Files (x86)\\opentsdb\\opentsdb.conf");
        } else {
            file_locations.add("/etc/opentsdb.conf");
            file_locations.add("/etc/opentsdb/opentsdb.conf");
            file_locations.add("/opt/opentsdb/opentsdb.conf");
        }
        for (String file : file_locations) {
            try {
                FileInputStream file_stream = new FileInputStream(file);
                Properties props = new Properties();
                props.load(file_stream);
                this.loadHashMap(props);
            }
            catch (Exception e) {
                LOG.debug("Unable to find or load " + file, (Throwable)e);
                continue;
            }
            LOG.info("Successfully loaded configuration file: " + file);
            this.config_location = file;
            return;
        }
        LOG.info("No configuration found, will use defaults");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfig(String file) throws FileNotFoundException, IOException {
        FileInputStream file_stream = new FileInputStream(file);
        try {
            Properties props = new Properties();
            props.load(file_stream);
            this.loadHashMap(props);
            LOG.info("Successfully loaded configuration file: " + file);
            this.config_location = file;
        }
        finally {
            file_stream.close();
        }
    }

    protected void loadStaticVariables() {
        this.auto_metric = this.getBoolean("tsd.core.auto_create_metrics");
        this.auto_tagk = this.getBoolean("tsd.core.auto_create_tagks");
        this.auto_tagv = this.getBoolean("tsd.core.auto_create_tagvs");
        this.enable_compactions = this.getBoolean("tsd.storage.enable_compaction");
        this.enable_appends = this.getBoolean("tsd.storage.enable_appends");
        this.repair_appends = this.getBoolean("tsd.storage.repair_appends");
        this.enable_chunked_requests = this.getBoolean("tsd.http.request.enable_chunked");
        this.enable_realtime_ts = this.getBoolean("tsd.core.meta.enable_realtime_ts");
        this.enable_realtime_uid = this.getBoolean("tsd.core.meta.enable_realtime_uid");
        this.enable_tsuid_incrementing = this.getBoolean("tsd.core.meta.enable_tsuid_incrementing");
        this.enable_tsuid_tracking = this.getBoolean("tsd.core.meta.enable_tsuid_tracking");
        if (this.hasProperty("tsd.http.request.max_chunk")) {
            this.max_chunked_requests = this.getInt("tsd.http.request.max_chunk");
        }
        this.enable_tree_processing = this.getBoolean("tsd.core.tree.enable_processing");
        this.fix_duplicates = this.getBoolean("tsd.storage.fix_duplicates");
        this.scanner_max_num_rows = this.getInt("tsd.storage.hbase.scanner.maxNumRows");
    }

    private void loadHashMap(Properties props) {
        this.properties.clear();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.properties.put(key, props.getProperty(key));
        }
    }
}

