/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import net.opentsdb.core.Tags;

public class DateTime {
    public static final String UTC_ID = "UTC";
    public static final HashMap<String, TimeZone> timezones;

    public static final long parseDateTimeString(String datetime, String tz) {
        if (datetime == null || datetime.isEmpty()) {
            return -1L;
        }
        if (datetime.matches("^[0-9]+ms$")) {
            return Tags.parseLong(datetime.replaceFirst("^([0-9]+)(ms)$", "$1"));
        }
        if (datetime.toLowerCase().equals("now")) {
            return System.currentTimeMillis();
        }
        if (datetime.toLowerCase().endsWith("-ago")) {
            long interval = DateTime.parseDuration(datetime.substring(0, datetime.length() - 4));
            return System.currentTimeMillis() - interval;
        }
        if (datetime.contains("/") || datetime.contains(":")) {
            try {
                SimpleDateFormat fmt = null;
                switch (datetime.length()) {
                    case 10: {
                        fmt = new SimpleDateFormat("yyyy/MM/dd");
                        break;
                    }
                    case 16: {
                        if (datetime.contains("-")) {
                            fmt = new SimpleDateFormat("yyyy/MM/dd-HH:mm");
                            break;
                        }
                        fmt = new SimpleDateFormat("yyyy/MM/dd HH:mm");
                        break;
                    }
                    case 19: {
                        if (datetime.contains("-")) {
                            fmt = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
                            break;
                        }
                        fmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid absolute date: " + datetime);
                    }
                }
                if (tz != null && !tz.isEmpty()) {
                    DateTime.setTimeZone(fmt, tz);
                }
                return fmt.parse(datetime).getTime();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid date: " + datetime + ". " + e.getMessage());
            }
        }
        try {
            long time;
            boolean contains_dot = datetime.contains(".");
            boolean valid_dotted_ms = datetime.matches("^[0-9]{10}\\.[0-9]{1,3}$");
            if (contains_dot) {
                if (!valid_dotted_ms) {
                    throw new IllegalArgumentException("Invalid time: " + datetime + ". Millisecond timestamps must be in the format <seconds>.<ms> where the milliseconds are limited to 3 digits");
                }
                time = Tags.parseLong(datetime.replace(".", ""));
            } else {
                time = Tags.parseLong(datetime);
            }
            if (time < 0L) {
                throw new IllegalArgumentException("Invalid time: " + datetime + ". Negative timestamps are not supported.");
            }
            if (datetime.length() <= 10) {
                time *= 1000L;
            }
            return time;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid time: " + datetime + ". " + e.getMessage());
        }
    }

    public static final long parseDuration(String duration) {
        long multiplier;
        long interval;
        int unit = 0;
        while (Character.isDigit(duration.charAt(unit))) {
            if (++unit < duration.length()) continue;
            throw new IllegalArgumentException("Invalid duration, must have an integer and unit: " + duration);
        }
        try {
            interval = Long.parseLong(duration.substring(0, unit));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid duration (number): " + duration);
        }
        if (interval <= 0L) {
            throw new IllegalArgumentException("Zero or negative duration: " + duration);
        }
        switch (duration.toLowerCase().charAt(duration.length() - 1)) {
            case 's': {
                if (duration.charAt(duration.length() - 2) == 'm') {
                    return interval;
                }
                multiplier = 1L;
                break;
            }
            case 'm': {
                multiplier = 60L;
                break;
            }
            case 'h': {
                multiplier = 3600L;
                break;
            }
            case 'd': {
                multiplier = 86400L;
                break;
            }
            case 'w': {
                multiplier = 604800L;
                break;
            }
            case 'n': {
                multiplier = 2592000L;
                break;
            }
            case 'y': {
                multiplier = 31536000L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid duration (suffix): " + duration);
            }
        }
        double temp = (double)interval * (double)(multiplier *= 1000L);
        if (temp > 9.223372036854776E18) {
            throw new IllegalArgumentException("Duration must be < Long.MAX_VALUE ms: " + duration);
        }
        return interval * multiplier;
    }

    public static boolean isRelativeDate(String value) {
        return value.toLowerCase().endsWith("-ago");
    }

    public static void setTimeZone(SimpleDateFormat fmt, String tzname) {
        if (tzname == null) {
            return;
        }
        TimeZone tz = timezones.get(tzname);
        if (tz == null) {
            throw new IllegalArgumentException("Invalid timezone name: " + tzname);
        }
        fmt.setTimeZone(tz);
    }

    public static void setDefaultTimezone(String tzname) {
        TimeZone tz = timezones.get(tzname);
        if (tz == null) {
            throw new IllegalArgumentException("Invalid timezone name: " + tzname);
        }
        TimeZone.setDefault(tz);
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static long nanoTime() {
        return System.nanoTime();
    }

    public static double msFromNano(long ts) {
        return (double)ts / 1000000.0;
    }

    public static double msFromNanoDiff(long end, long start) {
        if (end < start) {
            throw new IllegalArgumentException("End (" + end + ") cannot be less than start (" + start + ")");
        }
        return ((double)end - (double)start) / 1000000.0;
    }

    public static Calendar previousInterval(long ts, int interval, int unit) {
        return DateTime.previousInterval(ts, interval, unit, null);
    }

    public static Calendar previousInterval(long ts, int interval, int unit, TimeZone tz) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be less than zero");
        }
        if (interval < 1) {
            throw new IllegalArgumentException("Interval must be greater than zero");
        }
        int unit_override = unit;
        int interval_override = interval;
        Calendar calendar = tz == null ? Calendar.getInstance(timezones.get(UTC_ID)) : Calendar.getInstance(tz);
        switch (unit_override) {
            case 14: {
                if (1000 % interval_override == 0) {
                    calendar.setTimeInMillis(ts);
                    calendar.set(14, 0);
                    if (interval_override <= 1000) break;
                    calendar.add(14, -interval_override);
                    break;
                }
                calendar.setTimeInMillis(ts);
                calendar.set(14, 0);
                calendar.set(13, 0);
                break;
            }
            case 13: {
                if (60 % interval_override == 0) {
                    calendar.setTimeInMillis(ts);
                    calendar.set(14, 0);
                    calendar.set(13, 0);
                    if (interval_override <= 60) break;
                    calendar.add(13, -interval_override);
                    break;
                }
                calendar.setTimeInMillis(ts);
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                break;
            }
            case 12: {
                if (60 % interval_override == 0) {
                    calendar.setTimeInMillis(ts);
                    calendar.set(14, 0);
                    calendar.set(13, 0);
                    calendar.set(12, 0);
                    if (interval_override <= 60) break;
                    calendar.add(12, -interval_override);
                    break;
                }
                calendar.setTimeInMillis(ts);
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                calendar.set(11, 0);
                break;
            }
            case 11: {
                if (24 % interval_override == 0) {
                    calendar.setTimeInMillis(ts);
                    calendar.set(14, 0);
                    calendar.set(13, 0);
                    calendar.set(12, 0);
                    calendar.set(11, 0);
                    if (interval_override <= 24) break;
                    calendar.add(11, -interval_override);
                    break;
                }
                calendar.setTimeInMillis(ts);
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                calendar.set(11, 0);
                calendar.set(5, 1);
                break;
            }
            case 5: {
                if (interval_override == 1) {
                    calendar.setTimeInMillis(ts);
                    calendar.set(14, 0);
                    calendar.set(13, 0);
                    calendar.set(12, 0);
                    calendar.set(11, 0);
                    calendar.set(5, 1);
                    break;
                }
                calendar.setTimeInMillis(ts);
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                calendar.set(11, 0);
                calendar.set(5, 1);
                calendar.set(2, 0);
                break;
            }
            case 7: {
                if (2 % interval_override == 0) {
                    calendar.setTimeInMillis(ts);
                    calendar.set(14, 0);
                    calendar.set(13, 0);
                    calendar.set(12, 0);
                    calendar.set(11, 0);
                    calendar.set(7, calendar.getFirstDayOfWeek());
                } else {
                    calendar.setTimeInMillis(ts);
                    calendar.set(14, 0);
                    calendar.set(13, 0);
                    calendar.set(12, 0);
                    calendar.set(11, 0);
                    calendar.set(2, 0);
                    calendar.set(7, calendar.getFirstDayOfWeek());
                }
                unit_override = 5;
                interval_override = 7;
                break;
            }
            case 3: {
                calendar.setTimeInMillis(ts);
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                calendar.set(11, 0);
                calendar.set(5, 1);
                calendar.set(2, 0);
                break;
            }
            case 1: 
            case 2: {
                calendar.setTimeInMillis(ts);
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                calendar.set(11, 0);
                calendar.set(5, 1);
                calendar.set(2, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected unit_overrides of type: " + unit_override);
            }
        }
        if (calendar.getTimeInMillis() == ts) {
            return calendar;
        }
        while (calendar.getTimeInMillis() <= ts) {
            calendar.add(unit_override, interval_override);
        }
        calendar.add(unit_override, -interval_override);
        return calendar;
    }

    public static int unitsToCalendarType(String units) {
        if (units == null || units.isEmpty()) {
            throw new IllegalArgumentException("Units cannot be null or empty");
        }
        String lc = units.toLowerCase();
        if (lc.equals("ms")) {
            return 14;
        }
        if (lc.equals("s")) {
            return 13;
        }
        if (lc.equals("m")) {
            return 12;
        }
        if (lc.equals("h")) {
            return 11;
        }
        if (lc.equals("d")) {
            return 5;
        }
        if (lc.equals("w")) {
            return 7;
        }
        if (lc.equals("n")) {
            return 2;
        }
        if (lc.equals("y")) {
            return 1;
        }
        throw new IllegalArgumentException("Unrecognized unit type: " + units);
    }

    static {
        String[] tzs = TimeZone.getAvailableIDs();
        timezones = new HashMap(tzs.length);
        for (String tz : tzs) {
            timezones.put(tz, TimeZone.getTimeZone(tz));
        }
    }
}

