/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.JSONPObject;
import java.io.IOException;
import java.io.InputStream;
import net.opentsdb.search.SearchQuery;
import net.opentsdb.tree.TreeRule;
import net.opentsdb.uid.UniqueId;
import net.opentsdb.utils.JSONException;

public final class JSON {
    private static final ObjectMapper jsonMapper = new ObjectMapper();

    public static final <T> T parseToObject(String json, Class<T> pojo) {
        if (json == null || json.isEmpty()) {
            throw new IllegalArgumentException("Incoming data was null or empty");
        }
        if (pojo == null) {
            throw new IllegalArgumentException("Missing class type");
        }
        try {
            return (T)jsonMapper.readValue(json, pojo);
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException(e);
        }
        catch (JsonMappingException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    public static final <T> T parseToObject(byte[] json, Class<T> pojo) {
        if (json == null) {
            throw new IllegalArgumentException("Incoming data was null");
        }
        if (pojo == null) {
            throw new IllegalArgumentException("Missing class type");
        }
        try {
            return (T)jsonMapper.readValue(json, pojo);
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException(e);
        }
        catch (JsonMappingException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    public static final <T> T parseToObject(String json, TypeReference<T> type) {
        if (json == null || json.isEmpty()) {
            throw new IllegalArgumentException("Incoming data was null or empty");
        }
        if (type == null) {
            throw new IllegalArgumentException("Missing type reference");
        }
        try {
            return (T)jsonMapper.readValue(json, type);
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException(e);
        }
        catch (JsonMappingException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    public static final <T> T parseToObject(byte[] json, TypeReference<T> type) {
        if (json == null) {
            throw new IllegalArgumentException("Incoming data was null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Missing type reference");
        }
        try {
            return (T)jsonMapper.readValue(json, type);
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException(e);
        }
        catch (JsonMappingException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    public static final JsonParser parseToStream(String json) {
        if (json == null || json.isEmpty()) {
            throw new IllegalArgumentException("Incoming data was null or empty");
        }
        try {
            return jsonMapper.getFactory().createJsonParser(json);
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    public static final JsonParser parseToStream(byte[] json) {
        if (json == null) {
            throw new IllegalArgumentException("Incoming data was null");
        }
        try {
            return jsonMapper.getFactory().createJsonParser(json);
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    public static final JsonParser parseToStream(InputStream json) {
        if (json == null) {
            throw new IllegalArgumentException("Incoming data was null");
        }
        try {
            return jsonMapper.getFactory().createJsonParser(json);
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    public static final String serializeToString(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Object was null");
        }
        try {
            return jsonMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new JSONException(e);
        }
    }

    public static final byte[] serializeToBytes(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Object was null");
        }
        try {
            return jsonMapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new JSONException(e);
        }
    }

    public static final String serializeToJSONPString(String callback, Object object) {
        if (callback == null || callback.isEmpty()) {
            throw new IllegalArgumentException("Missing callback name");
        }
        if (object == null) {
            throw new IllegalArgumentException("Object was null");
        }
        try {
            return jsonMapper.writeValueAsString((Object)new JSONPObject(callback, object));
        }
        catch (JsonProcessingException e) {
            throw new JSONException(e);
        }
    }

    public static final byte[] serializeToJSONPBytes(String callback, Object object) {
        if (callback == null || callback.isEmpty()) {
            throw new IllegalArgumentException("Missing callback name");
        }
        if (object == null) {
            throw new IllegalArgumentException("Object was null");
        }
        try {
            return jsonMapper.writeValueAsBytes((Object)new JSONPObject(callback, object));
        }
        catch (JsonProcessingException e) {
            throw new JSONException(e);
        }
    }

    public static final ObjectMapper getMapper() {
        return jsonMapper;
    }

    public static final JsonFactory getFactory() {
        return jsonMapper.getFactory();
    }

    static {
        jsonMapper.configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true);
    }

    public static class SearchTypeDeserializer
    extends JsonDeserializer<SearchQuery.SearchType> {
        public SearchQuery.SearchType deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            return SearchQuery.parseSearchType(parser.getValueAsString());
        }
    }

    public static class TreeRuleTypeDeserializer
    extends JsonDeserializer<TreeRule.TreeRuleType> {
        public TreeRule.TreeRuleType deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            return TreeRule.stringToType(parser.getValueAsString());
        }
    }

    public static class UniqueIdTypeDeserializer
    extends JsonDeserializer<UniqueId.UniqueIdType> {
        public UniqueId.UniqueIdType deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            return UniqueId.stringToUniqueIdType(parser.getValueAsString());
        }
    }
}

