/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginLoader {
    private static final Logger LOG = LoggerFactory.getLogger(PluginLoader.class);
    private static final Class<?>[] PARAMETER_TYPES = new Class[]{URL.class};

    public static <T> T loadSpecificPlugin(String name, Class<T> type) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Missing plugin name");
        }
        ServiceLoader<T> serviceLoader = ServiceLoader.load(type);
        Iterator<T> it = serviceLoader.iterator();
        if (!it.hasNext()) {
            LOG.warn("Unable to locate any plugins of the type: " + type.getName());
            return null;
        }
        while (it.hasNext()) {
            T plugin = it.next();
            if (!plugin.getClass().getName().equals(name) && !plugin.getClass().getSuperclass().getName().equals(name)) continue;
            return plugin;
        }
        LOG.warn("Unable to locate plugin: " + name);
        return null;
    }

    public static <T> List<T> loadPlugins(Class<T> type) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(type);
        Iterator<T> it = serviceLoader.iterator();
        if (!it.hasNext()) {
            LOG.warn("Unable to locate any plugins of the type: " + type.getName());
            return null;
        }
        ArrayList<T> plugins = new ArrayList<T>();
        while (it.hasNext()) {
            plugins.add(it.next());
        }
        if (plugins.size() > 0) {
            return plugins;
        }
        LOG.warn("Unable to locate plugins for type: " + type.getName());
        return null;
    }

    public static void loadJAR(String jar) throws IOException, SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (!jar.toLowerCase().endsWith(".jar")) {
            throw new IllegalArgumentException("File specified did not end with .jar");
        }
        File file = new File(jar);
        if (!file.exists()) {
            throw new FileNotFoundException(jar);
        }
        PluginLoader.addFile(file);
    }

    public static void loadJARs(String directory) throws SecurityException, IllegalArgumentException, IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        File file = new File(directory);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("The path specified was not a directory");
        }
        ArrayList<File> jars = new ArrayList<File>();
        PluginLoader.searchForJars(file, jars);
        if (jars.size() < 1) {
            LOG.debug("No JAR files found in path: " + directory);
            return;
        }
        for (File jar : jars) {
            PluginLoader.addFile(jar);
        }
    }

    private static void searchForJars(File file, List<File> jars) {
        if (file.isFile()) {
            if (file.getAbsolutePath().toLowerCase().endsWith(".jar")) {
                jars.add(file);
                LOG.debug("Found a jar: " + file.getAbsolutePath());
            }
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                LOG.warn("Access denied to directory: " + file.getAbsolutePath());
            } else {
                for (File f : files) {
                    PluginLoader.searchForJars(f, jars);
                }
            }
        }
    }

    private static void addFile(File f) throws IOException, SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        PluginLoader.addURL(f.toURI().toURL());
    }

    private static void addURL(URL url) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        Method method = sysclass.getDeclaredMethod("addURL", PARAMETER_TYPES);
        method.setAccessible(true);
        method.invoke((Object)sysloader, url);
        LOG.debug("Successfully added JAR to class loader: " + url.getFile());
    }
}

