/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.utils;

import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.ThreadNameDeterminer;

public class Threads {
    static final AtomicInteger TIMER_ID = new AtomicInteger();

    public static HashedWheelTimer newTimer(String name) {
        return Threads.newTimer(100, name);
    }

    public static HashedWheelTimer newTimer(int ticks, String name) {
        return Threads.newTimer(ticks, 512, name);
    }

    public static HashedWheelTimer newTimer(int ticks, int ticks_per_wheel, String name) {
        class TimerThreadNamer
        implements ThreadNameDeterminer {
            final /* synthetic */ String val$name;

            TimerThreadNamer(String string) {
                this.val$name = string;
            }

            public String determineThreadName(String currentThreadName, String proposedThreadName) throws Exception {
                return "OpenTSDB Timer " + this.val$name + " #" + TIMER_ID.incrementAndGet();
            }
        }
        return new HashedWheelTimer(Executors.defaultThreadFactory(), (ThreadNameDeterminer)new TimerThreadNamer(name), (long)ticks, TimeUnit.MILLISECONDS, ticks_per_wheel);
    }

    public static class PrependThreadNamer
    implements ThreadNameDeterminer {
        public String determineThreadName(String currentThreadName, String proposedThreadName) throws Exception {
            return "OpenTSDB " + proposedThreadName;
        }
    }

    public static class WorkerThreadNamer
    implements ThreadNameDeterminer {
        static final AtomicInteger tid = new AtomicInteger();

        public String determineThreadName(String currentThreadName, String proposedThreadName) throws Exception {
            return "OpenTSDB I/O Worker #" + tid.incrementAndGet();
        }
    }

    public static class BossThreadNamer
    implements ThreadNameDeterminer {
        static final AtomicInteger tid = new AtomicInteger();

        public String determineThreadName(String currentThreadName, String proposedThreadName) throws Exception {
            return "OpenTSDB I/O Boss #" + tid.incrementAndGet();
        }
    }
}

