/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.cache.support.redis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.oschina.j2cache.Level2Cache;
import org.springframework.data.redis.core.RedisTemplate;

public class SpringRedisCache
implements Level2Cache {
    private String namespace;
    private String region;
    private RedisTemplate<String, Serializable> redisTemplate;

    public SpringRedisCache(String namespace, String region, RedisTemplate<String, Serializable> redisTemplate) {
        if (region == null || region.isEmpty()) {
            region = "_";
        }
        this.namespace = namespace;
        this.redisTemplate = redisTemplate;
        this.region = this.getRegionName(region);
    }

    private String getRegionName(String region) {
        if (this.namespace != null && !this.namespace.isEmpty()) {
            region = this.namespace + ":" + region;
        }
        return region;
    }

    public void clear() {
        this.redisTemplate.opsForHash().delete((Object)this.region, new Object[0]);
    }

    public boolean exists(String key) {
        return this.redisTemplate.opsForHash().hasKey((Object)this.region, (Object)key);
    }

    public void evict(String ... keys) {
        for (String k : keys) {
            if (!k.equals("null")) {
                this.redisTemplate.opsForHash().delete((Object)this.region, new Object[]{k});
                continue;
            }
            this.redisTemplate.delete((Object)this.region);
        }
    }

    public Collection<String> keys() {
        Set list = this.redisTemplate.opsForHash().keys((Object)this.region);
        ArrayList<String> keys = new ArrayList<String>(list.size());
        for (Object object : list) {
            keys.add((String)object);
        }
        return keys;
    }

    public byte[] getBytes(String key) {
        return (byte[])this.redisTemplate.opsForHash().getOperations().execute(redis -> redis.hGet(this.region.getBytes(), key.getBytes()));
    }

    public List<byte[]> getBytes(Collection<String> keys) {
        return (List)this.redisTemplate.opsForHash().getOperations().execute(redis -> {
            byte[][] bytes = (byte[][])keys.stream().map(k -> k.getBytes()).toArray(x$0 -> new byte[x$0][]);
            return redis.hMGet(this.region.getBytes(), bytes);
        });
    }

    public void put(String key, Object value) {
        this.redisTemplate.opsForHash().put((Object)this.region, (Object)key, value);
    }

    public void put(String key, Object value, long timeToLiveInSeconds) {
        this.redisTemplate.opsForHash().put((Object)this.region, (Object)key, value);
    }

    public void setBytes(String key, byte[] bytes) {
        this.redisTemplate.opsForHash().getOperations().execute(redis -> {
            redis.set(this._key(key).getBytes(), bytes);
            redis.hSet(this.region.getBytes(), key.getBytes(), bytes);
            return null;
        });
    }

    public void setBytes(Map<String, byte[]> bytes) {
        bytes.forEach((k, v) -> this.setBytes((String)k, (byte[])v));
    }

    private String _key(String key) {
        return this.region + ":" + key;
    }
}

