/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.css.SelectorSpecificity;
import com.gargoylesoftware.htmlunit.css.StyleElement;
import com.gargoylesoftware.htmlunit.html.AbstractDomNodeList;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNamespaceNode;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.NamedAttrNodeMapImpl;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.AbstractJavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import com.gargoylesoftware.htmlunit.javascript.host.event.MouseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.PointerEvent;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.TypeInfo;

public class DomElement
extends DomNamespaceNode
implements Element {
    private static final Log LOG = LogFactory.getLog(DomElement.class);
    public static final String ATTRIBUTE_NOT_DEFINED = new String("");
    public static final String ATTRIBUTE_VALUE_EMPTY = new String();
    private NamedAttrNodeMapImpl attributes_ = new NamedAttrNodeMapImpl(this, this.isAttributeCaseSensitive());
    private Map<String, String> namespaces_ = new HashMap<String, String>();
    private String styleString_ = new String();
    private Map<String, StyleElement> styleMap_;
    private boolean mouseOver_;

    public DomElement(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page);
        if (attributes != null && !attributes.isEmpty()) {
            this.attributes_ = new NamedAttrNodeMapImpl(this, this.isAttributeCaseSensitive(), attributes);
            for (DomAttr entry : this.attributes_.values()) {
                entry.setParentNode(this);
                String attrNamespaceURI = entry.getNamespaceURI();
                if (attrNamespaceURI == null) continue;
                this.namespaces_.put(attrNamespaceURI, entry.getPrefix());
            }
        }
    }

    @Override
    public String getNodeName() {
        return this.getQualifiedName();
    }

    @Override
    public final short getNodeType() {
        return 1;
    }

    @Override
    public final String getTagName() {
        return this.getNodeName();
    }

    @Override
    public final boolean hasAttributes() {
        return !this.attributes_.isEmpty();
    }

    @Override
    public boolean hasAttribute(String attributeName) {
        return this.attributes_.containsKey(attributeName);
    }

    public void replaceStyleAttribute(String name, String value, String priority) {
        if (StringUtils.isBlank((CharSequence)value)) {
            this.removeStyleAttribute(name);
            return;
        }
        Map<String, StyleElement> styleMap = this.getStyleMap();
        StyleElement old = styleMap.get(name);
        StyleElement element = old == null ? new StyleElement(name, value, priority, SelectorSpecificity.FROM_STYLE_ATTRIBUTE) : new StyleElement(name, value, priority, SelectorSpecificity.FROM_STYLE_ATTRIBUTE, old.getIndex());
        styleMap.put(name, element);
        this.writeStyleToElement(styleMap);
    }

    public String removeStyleAttribute(String name) {
        Map<String, StyleElement> styleMap = this.getStyleMap();
        StyleElement value = styleMap.get(name);
        if (value == null) {
            return "";
        }
        styleMap.remove(name);
        this.writeStyleToElement(styleMap);
        return value.getValue();
    }

    public StyleElement getStyleElement(String name) {
        Map<String, StyleElement> map = this.getStyleMap();
        if (map != null) {
            return map.get(name);
        }
        return null;
    }

    public StyleElement getStyleElementCaseInSensitive(String name) {
        Map<String, StyleElement> map = this.getStyleMap();
        for (Map.Entry<String, StyleElement> entry : map.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(name)) continue;
            return entry.getValue();
        }
        return null;
    }

    public Map<String, StyleElement> getStyleMap() {
        String styleAttribute = this.getAttribute("style");
        if (this.styleString_ == styleAttribute) {
            return this.styleMap_;
        }
        LinkedHashMap<String, StyleElement> styleMap = new LinkedHashMap<String, StyleElement>();
        if (ATTRIBUTE_NOT_DEFINED == styleAttribute || ATTRIBUTE_VALUE_EMPTY == styleAttribute) {
            this.styleMap_ = styleMap;
            this.styleString_ = styleAttribute;
            return this.styleMap_;
        }
        for (String token : StringUtils.split((String)styleAttribute, (char)';')) {
            int index = token.indexOf(":");
            if (index == -1) continue;
            String key = token.substring(0, index).trim().toLowerCase(Locale.ROOT);
            String value = token.substring(index + 1).trim();
            String priority = "";
            if (StringUtils.endsWithIgnoreCase((CharSequence)value, (CharSequence)"!important")) {
                priority = "important";
                value = value.substring(0, value.length() - 10);
                value = value.trim();
            }
            StyleElement element = new StyleElement(key, value, priority, SelectorSpecificity.FROM_STYLE_ATTRIBUTE);
            styleMap.put(key, element);
        }
        this.styleMap_ = styleMap;
        this.styleString_ = styleAttribute;
        return this.styleMap_;
    }

    protected void printOpeningTagContentAsXml(PrintWriter printWriter) {
        printWriter.print(this.getTagName());
        for (Map.Entry<String, DomAttr> entry : this.attributes_.entrySet()) {
            printWriter.print(" ");
            printWriter.print(entry.getKey());
            printWriter.print("=\"");
            printWriter.print(com.gargoylesoftware.htmlunit.util.StringUtils.escapeXmlAttributeValue(entry.getValue().getNodeValue()));
            printWriter.print("\"");
        }
    }

    @Override
    protected void printXml(String indent, PrintWriter printWriter) {
        boolean hasChildren = this.getFirstChild() != null;
        printWriter.print(indent + "<");
        this.printOpeningTagContentAsXml(printWriter);
        if (hasChildren || this.isEmptyXmlTagExpanded()) {
            printWriter.print(">\r\n");
            this.printChildrenAsXml(indent, printWriter);
            printWriter.print(indent);
            printWriter.print("</");
            printWriter.print(this.getTagName());
            printWriter.print(">\r\n");
        } else {
            printWriter.print("/>\r\n");
        }
    }

    protected boolean isEmptyXmlTagExpanded() {
        return false;
    }

    String getQualifiedName(String namespaceURI, String localName) {
        String prefix;
        Object qualifiedName = namespaceURI == null ? localName : ((prefix = this.namespaces_.get(namespaceURI)) == null ? null : prefix + ':' + localName);
        return qualifiedName;
    }

    @Override
    public String getAttribute(String attributeName) {
        DomAttr attr = this.attributes_.get(attributeName);
        if (attr != null) {
            return attr.getNodeValue();
        }
        return ATTRIBUTE_NOT_DEFINED;
    }

    @Override
    public void removeAttribute(String attributeName) {
        this.attributes_.remove(attributeName);
    }

    @Override
    public final void removeAttributeNS(String namespaceURI, String localName) {
        String qualifiedName = this.getQualifiedName(namespaceURI, localName);
        if (qualifiedName != null) {
            this.removeAttribute(qualifiedName);
        }
    }

    @Override
    public final Attr removeAttributeNode(Attr attribute) {
        throw new UnsupportedOperationException("DomElement.removeAttributeNode is not yet implemented.");
    }

    @Override
    public final boolean hasAttributeNS(String namespaceURI, String localName) {
        String qualifiedName = this.getQualifiedName(namespaceURI, localName);
        if (qualifiedName != null) {
            return this.attributes_.get(qualifiedName) != null;
        }
        return false;
    }

    public final Map<String, DomAttr> getAttributesMap() {
        return this.attributes_;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.attributes_;
    }

    @Override
    public void setAttribute(String attributeName, String attributeValue) {
        this.setAttributeNS(null, attributeName, attributeValue);
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        this.setAttributeNS(namespaceURI, qualifiedName, attributeValue, true, true);
    }

    protected void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue, boolean notifyAttributeChangeListeners, boolean notifyMutationObservers) {
        String value = attributeValue;
        DomAttr newAttr = new DomAttr(this.getPage(), namespaceURI, qualifiedName, value, true);
        newAttr.setParentNode(this);
        this.attributes_.put(qualifiedName, newAttr);
        if (namespaceURI != null) {
            this.namespaces_.put(namespaceURI, newAttr.getPrefix());
        }
    }

    protected boolean isAttributeCaseSensitive() {
        return true;
    }

    @Override
    public final String getAttributeNS(String namespaceURI, String localName) {
        String qualifiedName = this.getQualifiedName(namespaceURI, localName);
        if (qualifiedName != null) {
            return this.getAttribute(qualifiedName);
        }
        return ATTRIBUTE_NOT_DEFINED;
    }

    @Override
    public DomAttr getAttributeNode(String name) {
        return this.attributes_.get(name);
    }

    @Override
    public DomAttr getAttributeNodeNS(String namespaceURI, String localName) {
        String qualifiedName = this.getQualifiedName(namespaceURI, localName);
        if (qualifiedName != null) {
            return this.attributes_.get(qualifiedName);
        }
        return null;
    }

    public void writeStyleToElement(Map<String, StyleElement> styleMap) {
        StringBuilder builder = new StringBuilder();
        TreeSet<StyleElement> sortedValues = new TreeSet<StyleElement>(styleMap.values());
        for (StyleElement e : sortedValues) {
            if (builder.length() != 0) {
                builder.append(" ");
            }
            builder.append(e.getName());
            builder.append(": ");
            builder.append(e.getValue());
            String prio = e.getPriority();
            if (StringUtils.isNotBlank((CharSequence)prio)) {
                builder.append(" !");
                builder.append(prio);
            }
            builder.append(";");
        }
        String value = builder.toString();
        this.setAttribute("style", value);
    }

    @Override
    public DomNodeList<HtmlElement> getElementsByTagName(String tagName) {
        return this.getElementsByTagNameImpl(tagName);
    }

    <E extends HtmlElement> DomNodeList<E> getElementsByTagNameImpl(final String tagName) {
        return new AbstractDomNodeList<E>(this){

            @Override
            protected List<E> provideElements() {
                LinkedList<HtmlElement> res = new LinkedList<HtmlElement>();
                for (HtmlElement elem : this.getDomNode().getHtmlElementDescendants()) {
                    if (!elem.getLocalName().equalsIgnoreCase(tagName)) continue;
                    res.add(elem);
                }
                return res;
            }
        };
    }

    @Override
    public DomNodeList<HtmlElement> getElementsByTagNameNS(String namespace, String localName) {
        throw new UnsupportedOperationException("DomElement.getElementsByTagNameNS is not yet implemented.");
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException("DomElement.getSchemaTypeInfo is not yet implemented.");
    }

    @Override
    public void setIdAttribute(String name, boolean isId) {
        throw new UnsupportedOperationException("DomElement.setIdAttribute is not yet implemented.");
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) {
        throw new UnsupportedOperationException("DomElement.setIdAttributeNS is not yet implemented.");
    }

    @Override
    public Attr setAttributeNode(Attr attribute) {
        this.attributes_.setNamedItem(attribute);
        return null;
    }

    @Override
    public Attr setAttributeNodeNS(Attr attribute) {
        throw new UnsupportedOperationException("DomElement.setAttributeNodeNS is not yet implemented.");
    }

    @Override
    public final void setIdAttributeNode(Attr idAttr, boolean isId) {
        throw new UnsupportedOperationException("DomElement.setIdAttributeNode is not yet implemented.");
    }

    @Override
    public DomNode cloneNode(boolean deep) {
        DomElement clone = (DomElement)super.cloneNode(deep);
        clone.attributes_ = new NamedAttrNodeMapImpl(clone, this.isAttributeCaseSensitive());
        clone.attributes_.putAll(this.attributes_);
        return clone;
    }

    public final String getId() {
        return this.getAttribute("id");
    }

    public final void setId(String newId) {
        this.setAttribute("id", newId);
    }

    public DomElement getFirstElementChild() {
        Iterator<DomElement> i = this.getChildElements().iterator();
        if (i.hasNext()) {
            return i.next();
        }
        return null;
    }

    public DomElement getLastElementChild() {
        DomElement lastChild2 = null;
        for (DomElement lastChild2 : this.getChildElements()) {
        }
        return lastChild2;
    }

    public int getChildElementCount() {
        int counter = 0;
        Iterator<DomElement> i = this.getChildElements().iterator();
        while (i.hasNext()) {
            ++counter;
            i.next();
        }
        return counter;
    }

    public final Iterable<DomElement> getChildElements() {
        return new ChildElementsIterable(this);
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.print(this.getClass().getSimpleName());
        printWriter.print("[<");
        this.printOpeningTagContentAsXml(printWriter);
        printWriter.print(">]");
        printWriter.flush();
        return writer.toString();
    }

    public <P extends Page> P click() throws IOException {
        return this.click(false, false, false);
    }

    public <P extends Page> P click(boolean shiftKey, boolean ctrlKey, boolean altKey) throws IOException {
        return this.click(shiftKey, ctrlKey, altKey, true);
    }

    public <P extends Page> P click(boolean shiftKey, boolean ctrlKey, boolean altKey, boolean triggerMouseEvents) throws IOException {
        return this.click(shiftKey, ctrlKey, altKey, triggerMouseEvents, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P extends Page> P click(boolean shiftKey, boolean ctrlKey, boolean altKey, boolean triggerMouseEvents, boolean ignoreVisibility, boolean disableProcessLabelAfterBubbling) throws IOException {
        SgmlPage page = this.getPage();
        page.getWebClient().setCurrentWindow(page.getEnclosingWindow());
        if (!ignoreVisibility && !this.isDisplayed() || !(page instanceof HtmlPage) || this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return (P)page;
        }
        SgmlPage sgmlPage = page;
        synchronized (sgmlPage) {
            if (triggerMouseEvents) {
                this.mouseDown(shiftKey, ctrlKey, altKey, 0);
            }
            DomElement elementToFocus = null;
            if (this instanceof SubmittableElement || this instanceof HtmlAnchor || this instanceof HtmlElement && ((HtmlElement)this).getTabIndex() != null) {
                elementToFocus = this;
            } else if (this instanceof HtmlOption) {
                elementToFocus = ((HtmlOption)this).getEnclosingSelect();
            }
            ((HtmlPage)page).setFocusedElement(elementToFocus);
            if (triggerMouseEvents) {
                this.mouseUp(shiftKey, ctrlKey, altKey, 0);
            }
            MouseEvent event = this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONCLICK_USES_POINTEREVENT) ? new PointerEvent(this.getEventTargetElement(), "click", shiftKey, ctrlKey, altKey, 0) : new MouseEvent(this.getEventTargetElement(), "click", shiftKey, ctrlKey, altKey, 0);
            if (disableProcessLabelAfterBubbling) {
                event.disableProcessLabelAfterBubbling();
            }
            return this.click(event, ignoreVisibility);
        }
    }

    protected DomNode getEventTargetElement() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P extends Page> P click(Event event, boolean ignoreVisibility) throws IOException {
        SgmlPage page = this.getPage();
        if (!ignoreVisibility && !this.isDisplayed() || this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return (P)page;
        }
        Page contentPage = page.getEnclosingWindow().getEnclosedPage();
        boolean stateUpdated = false;
        boolean changed = false;
        if (this.isStateUpdateFirst()) {
            changed = this.doClickStateUpdate(event.isShiftKey(), event.isCtrlKey());
            stateUpdated = true;
        }
        AbstractJavaScriptEngine<?> jsEngine = page.getWebClient().getJavaScriptEngine();
        jsEngine.holdPosponedActions();
        try {
            boolean pageAlreadyChanged;
            ScriptResult scriptResult = this.doClickFireClickEvent(event);
            boolean eventIsAborted = event.isAborted(scriptResult);
            boolean bl = pageAlreadyChanged = contentPage != page.getEnclosingWindow().getEnclosedPage();
            if (!(pageAlreadyChanged || stateUpdated || eventIsAborted)) {
                changed = this.doClickStateUpdate(event.isShiftKey(), event.isCtrlKey());
            }
        }
        finally {
            jsEngine.processPostponedActions();
        }
        if (changed) {
            this.doClickFireChangeEvent();
        }
        return (P)this.getPage().getWebClient().getCurrentWindow().getEnclosedPage();
    }

    protected boolean doClickStateUpdate(boolean shiftKey, boolean ctrlKey) throws IOException {
        DomNode parent;
        if (this.propagateClickStateUpdateToParent() && (parent = this.getParentNode()) instanceof DomElement) {
            return ((DomElement)parent).doClickStateUpdate(false, false);
        }
        return false;
    }

    protected boolean propagateClickStateUpdateToParent() {
        return true;
    }

    protected void doClickFireChangeEvent() {
    }

    protected ScriptResult doClickFireClickEvent(Event event) {
        return this.fireEvent(event);
    }

    public <P extends Page> P dblClick() throws IOException {
        return this.dblClick(false, false, false);
    }

    public <P extends Page> P dblClick(boolean shiftKey, boolean ctrlKey, boolean altKey) throws IOException {
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return (P)this.getPage();
        }
        P clickPage = this.click(shiftKey, ctrlKey, altKey);
        if (clickPage != this.getPage()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"dblClick() is ignored, as click() loaded a different page.");
            }
            return clickPage;
        }
        clickPage = this.click(shiftKey, ctrlKey, altKey);
        if (clickPage != this.getPage()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"dblClick() is ignored, as click() loaded a different page.");
            }
            return clickPage;
        }
        MouseEvent event = this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONCLICK_USES_POINTEREVENT) ? new PointerEvent(this, "dblclick", shiftKey, ctrlKey, altKey, 0) : new MouseEvent(this, "dblclick", shiftKey, ctrlKey, altKey, 0);
        ScriptResult scriptResult = this.fireEvent(event);
        if (scriptResult == null) {
            return clickPage;
        }
        return (P)scriptResult.getNewPage();
    }

    public Page mouseOver() {
        return this.mouseOver(false, false, false, 0);
    }

    public Page mouseOver(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mouseover", shiftKey, ctrlKey, altKey, button);
    }

    public Page mouseMove() {
        return this.mouseMove(false, false, false, 0);
    }

    public Page mouseMove(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mousemove", shiftKey, ctrlKey, altKey, button);
    }

    public Page mouseOut() {
        return this.mouseOut(false, false, false, 0);
    }

    public Page mouseOut(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mouseout", shiftKey, ctrlKey, altKey, button);
    }

    public Page mouseDown() {
        return this.mouseDown(false, false, false, 0);
    }

    public Page mouseDown(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mousedown", shiftKey, ctrlKey, altKey, button);
    }

    public Page mouseUp() {
        return this.mouseUp(false, false, false, 0);
    }

    public Page mouseUp(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mouseup", shiftKey, ctrlKey, altKey, button);
    }

    public Page rightClick() {
        return this.rightClick(false, false, false);
    }

    public Page rightClick(boolean shiftKey, boolean ctrlKey, boolean altKey) {
        Page mouseDownPage = this.mouseDown(shiftKey, ctrlKey, altKey, 2);
        if (mouseDownPage != this.getPage()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"rightClick() is incomplete, as mouseDown() loaded a different page.");
            }
            return mouseDownPage;
        }
        Page mouseUpPage = this.mouseUp(shiftKey, ctrlKey, altKey, 2);
        if (mouseUpPage != this.getPage()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"rightClick() is incomplete, as mouseUp() loaded a different page.");
            }
            return mouseUpPage;
        }
        return this.doMouseEvent("contextmenu", shiftKey, ctrlKey, altKey, 2);
    }

    private Page doMouseEvent(String eventType, boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        boolean mouseOver;
        SgmlPage page = this.getPage();
        MouseEvent event = "contextmenu".equals(eventType) && this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONCLICK_USES_POINTEREVENT) ? new PointerEvent(this, eventType, shiftKey, ctrlKey, altKey, button) : new MouseEvent(this, eventType, shiftKey, ctrlKey, altKey, button);
        ScriptResult scriptResult = this.fireEvent(event);
        Page currentPage = scriptResult == null ? page : scriptResult.getNewPage();
        boolean bl = mouseOver = !"mouseout".equals(eventType);
        if (this.mouseOver_ != mouseOver) {
            this.mouseOver_ = mouseOver;
            SimpleScriptable scriptable = (SimpleScriptable)this.getScriptableObject();
            scriptable.getWindow().clearComputedStyles();
        }
        return currentPage;
    }

    public ScriptResult fireEvent(String eventType) {
        return this.fireEvent(new Event(this, eventType));
    }

    public ScriptResult fireEvent(final Event event) {
        WebClient client = this.getPage().getWebClient();
        if (!client.getOptions().isJavaScriptEnabled()) {
            return null;
        }
        if (!this.handles(event)) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Firing " + event));
        }
        final EventTarget jsElt = (EventTarget)this.getScriptableObject();
        ContextAction action = new ContextAction(){

            public Object run(Context cx) {
                return jsElt.fireEvent(event);
            }
        };
        HtmlUnitContextFactory cf = ((JavaScriptEngine)client.getJavaScriptEngine()).getContextFactory();
        ScriptResult result = (ScriptResult)cf.call(action);
        if (event.isAborted(result)) {
            this.preventDefault();
        }
        return result;
    }

    protected void preventDefault() {
    }

    public void focus() {
        HtmlPage page = (HtmlPage)this.getPage();
        page.setFocusedElement(this);
        Object o = this.getScriptableObject();
        if (o instanceof HTMLElement) {
            ((HTMLElement)o).setActive();
        }
    }

    public void blur() {
        ((HtmlPage)this.getPage()).setFocusedElement(null);
    }

    public void removeFocus() {
    }

    protected boolean isStateUpdateFirst() {
        return false;
    }

    public boolean isMouseOver() {
        if (this.mouseOver_) {
            return true;
        }
        for (DomElement child : this.getChildElements()) {
            if (!child.isMouseOver()) continue;
            return true;
        }
        return false;
    }

    public boolean matches(String selectorString) {
        try {
            BrowserVersion browserVersion = this.getPage().getWebClient().getBrowserVersion();
            SelectorList selectorList = this.getSelectorList(selectorString, browserVersion);
            if (selectorList != null) {
                for (int i = 0; i < selectorList.getLength(); ++i) {
                    Selector selector = selectorList.item(i);
                    if (!CSSStyleSheet.selects(browserVersion, selector, this, null, true)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (IOException e) {
            throw new CSSException("Error parsing CSS selectors from '" + selectorString + "': " + e.getMessage());
        }
    }

    protected static class ChildElementsIterator
    implements Iterator<DomElement> {
        private DomElement nextElement_;

        protected ChildElementsIterator(DomNode domNode) {
            DomNode child = domNode.getFirstChild();
            if (child != null) {
                if (child instanceof DomElement) {
                    this.nextElement_ = (DomElement)child;
                } else {
                    this.setNextElement(child);
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextElement_ != null;
        }

        @Override
        public DomElement next() {
            return this.nextElement();
        }

        @Override
        public void remove() {
            if (this.nextElement_ == null) {
                throw new IllegalStateException();
            }
            DomNode sibling = this.nextElement_.getPreviousSibling();
            if (sibling != null) {
                sibling.remove();
            }
        }

        public DomElement nextElement() {
            if (this.nextElement_ != null) {
                DomElement result = this.nextElement_;
                this.setNextElement(this.nextElement_);
                return result;
            }
            throw new NoSuchElementException();
        }

        private void setNextElement(DomNode node) {
            DomNode next;
            for (next = node.getNextSibling(); next != null && !(next instanceof DomElement); next = next.getNextSibling()) {
            }
            this.nextElement_ = (DomElement)next;
        }
    }

    private static class ChildElementsIterable
    implements Iterable<DomElement> {
        private final Iterator<DomElement> iterator_;

        protected ChildElementsIterable(DomNode domNode) {
            this.iterator_ = new ChildElementsIterator(domNode);
        }

        @Override
        public Iterator<DomElement> iterator() {
            return this.iterator_;
        }
    }
}

